/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.google.common.primitives.Ints;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.MachineType;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.overclockdescriber.EUOverclockDescriber;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Massfabricator
extends GT_MetaTileEntity_BasicMachine {
    public static int sUUAperUUM = 1;
    public static int sUUASpeedBonus = 4;
    public static int sDurationMultiplier = 3215;
    public static boolean sRequiresUUA = false;
    public static int BASE_EUT = 256;
    public static GT_Recipe nonUUARecipe;
    public static GT_Recipe uuaRecipe;

    public GT_MetaTileEntity_Massfabricator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 8, MachineType.MATTER_FABRICATOR.tooltipDescription(), 1, 1, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_GLOW).glow().build()));
    }

    public GT_MetaTileEntity_Massfabricator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 8, aDescription, aTextures, 1, 1);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Massfabricator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    protected OverclockDescriber createOverclockDescriber() {
        return new MassfabricatorOverclockDescriber(this.mTier, this.mAmperage);
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        sDurationMultiplier = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUM_Duration_Multiplier", sDurationMultiplier);
        sUUAperUUM = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_per_UUM", sUUAperUUM);
        sUUASpeedBonus = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Speed_Bonus", sUUASpeedBonus);
        sRequiresUUA = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Requirement", sRequiresUUA);
        Materials.UUAmplifier.mChemicalFormula = "Mass Fabricator Eff/Speed Bonus: x" + sUUASpeedBonus;
    }

    @Override
    public long maxAmperesIn() {
        return 10L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 512L;
    }

    @Override
    public int checkRecipe() {
        FluidStack tFluid = this.getDrainableStack();
        if (tFluid == null || tFluid.amount < this.getCapacity()) {
            this.mOutputFluid = Materials.UUMatter.getFluid(1L);
            this.calculateCustomOverclock(this.containsUUA(this.getFillableStack()) ? uuaRecipe : nonUUARecipe);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            tFluid = this.getFillableStack();
            if (this.containsUUA(tFluid)) {
                tFluid.amount -= sUUAperUUM;
                return 2;
            }
            return sRequiresUUA || Arrays.stream(this.getAllInputs()).anyMatch(s -> ItemList.Circuit_Integrated.isStackEqual(s, true, true)) ? 1 : 2;
        }
        return 0;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.massFabFakeRecipes;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.isFluidEqual(Materials.UUAmplifier.getFluid(1L));
    }

    @Override
    public int getCapacity() {
        return Math.max(sUUAperUUM, 1000);
    }

    private boolean containsUUA(FluidStack aFluid) {
        return aFluid != null && aFluid.amount >= sUUAperUUM && aFluid.isFluidEqual(Materials.UUAmplifier.getFluid(1L));
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    protected class MassfabricatorOverclockDescriber
    extends EUOverclockDescriber {
        protected MassfabricatorOverclockDescriber(byte tier, int amperage) {
            super(tier, amperage);
        }

        @Override
        public GT_OverclockCalculator createCalculator(GT_OverclockCalculator template, GT_Recipe recipe) {
            return super.createCalculator(template, recipe).setEUt(Ints.saturatedCast((long)(GT_Values.V[this.tier] * (long)this.amperage))).setEUtIncreasePerOC(1).limitOverclockCount(this.tier - 1).setOneTickDiscount(false);
        }

        @Override
        protected boolean shouldShowAmperage(GT_OverclockCalculator calculator) {
            return true;
        }

        @Override
        protected String getVoltageString(GT_OverclockCalculator calculator) {
            return this.decorateWithOverclockLabel(GT_Utility.formatNumbers(GT_Values.V[GT_MetaTileEntity_Massfabricator.this.mTier]) + " EU/t", calculator) + GT_Utility.getTierNameWithParentheses(GT_Values.V[GT_MetaTileEntity_Massfabricator.this.mTier]);
        }

        @Override
        protected String getAmperageString(GT_OverclockCalculator calculator) {
            int amperage = this.amperage;
            int denominator = 1;
            for (int i = 1; i < GT_MetaTileEntity_Massfabricator.this.mTier; ++i) {
                if ((amperage >>= 1) != 0) continue;
                denominator <<= 1;
            }
            if (amperage > 0) {
                return GT_Utility.formatNumbers(amperage);
            }
            return "1/" + denominator;
        }
    }
}

