/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.GT_Mod;
import gregtech.api.interfaces.ITexture;
import gregtech.api.logic.ModelRenderLogic;
import gregtech.api.logic.interfaces.ModelRenderLogicHost;
import gregtech.api.multitileentity.MultiTileEntityBlockInternal;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.common.render.MultiTileBasicRender;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GT_MultiTile_Renderer
implements ISimpleBlockRenderingHandler {
    private final int renderID = RenderingRegistry.getNextAvailableRenderId();
    public static GT_MultiTile_Renderer INSTANCE;

    public GT_MultiTile_Renderer() {
        INSTANCE = this;
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof MultiTileEntityBlockInternal)) {
            return;
        }
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        MultiTileEntityBlockInternal mteBlock = (MultiTileEntityBlockInternal)block;
        MultiTileEntityRegistry registry = mteBlock.getRegistry();
        if (registry == null) {
            return;
        }
        MultiTileEntityClassContainer classContainer = registry.getClassContainer(metadata);
        if (classContainer == null) {
            return;
        }
        renderer.func_147775_a((Block)mteBlock);
        block8: for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            ITexture texture = classContainer.mCanonicalTileEntity.getTexture(side);
            if (texture == null) continue;
            switch (side) {
                case DOWN: {
                    GT_MultiTile_Renderer.renderYNegative(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case UP: {
                    GT_MultiTile_Renderer.renderYPositive(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case WEST: {
                    GT_MultiTile_Renderer.renderXNegative(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case EAST: {
                    GT_MultiTile_Renderer.renderXPositive(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case NORTH: {
                    GT_MultiTile_Renderer.renderZNegative(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case SOUTH: {
                    GT_MultiTile_Renderer.renderZPositive(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
            }
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IMultiBlockController controller;
        ModelRenderLogicHost modelEntity;
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity == null) {
            return false;
        }
        renderer.field_147863_w = Minecraft.func_71379_u() && GT_Mod.gregtechproxy.mRenderTileAmbientOcclusion;
        renderer.field_147844_c = false;
        if (entity instanceof ModelRenderLogicHost && (modelEntity = (ModelRenderLogicHost)entity).shouldRenderModel()) {
            ModelRenderLogic renderLogic = modelEntity.getRenderLogic();
            return true;
        }
        if (!(entity instanceof MultiTileBasicRender)) {
            return false;
        }
        if (entity instanceof MultiBlockPart && (controller = ((MultiBlockPart)entity).getTarget(false)) instanceof ModelRenderLogicHost && ((ModelRenderLogicHost)((Object)controller)).shouldRenderModel()) {
            return false;
        }
        MultiTileBasicRender renderedEntity = (MultiTileBasicRender)entity;
        block8: for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            ITexture texture = renderedEntity.getTexture(side);
            if (texture == null) continue;
            switch (side) {
                case DOWN: {
                    GT_MultiTile_Renderer.renderYNegative(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case UP: {
                    GT_MultiTile_Renderer.renderYPositive(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case WEST: {
                    GT_MultiTile_Renderer.renderXNegative(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case EAST: {
                    GT_MultiTile_Renderer.renderXPositive(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case NORTH: {
                    GT_MultiTile_Renderer.renderZNegative(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case SOUTH: {
                    GT_MultiTile_Renderer.renderZPositive(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }

    private static void renderYNegative(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y - 1, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y - 1, z));
        }
        texture.renderYNeg(renderer, block, x, y, z);
    }

    private static void renderZNegative(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y, z - 1, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z - 1));
        }
        texture.renderZNeg(renderer, block, x, y, z);
    }

    private static void renderXNegative(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x - 1, y, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x - 1, y, z));
        }
        texture.renderXNeg(renderer, block, x, y, z);
    }

    private static void renderYPositive(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y + 1, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y + 1, z));
        }
        texture.renderYPos(renderer, block, x, y, z);
    }

    private static void renderXPositive(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x + 1, y, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x + 1, y, z));
        }
        texture.renderXPos(renderer, block, x, y, z);
    }

    private static void renderZPositive(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y, z + 1, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z + 1));
        }
        texture.renderZPos(renderer, block, x, y, z);
    }
}

