/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.util.GT_Utility;
import gregtech.common.covers.CoverInfo;
import gregtech.common.covers.GT_Cover_Metrics_Transmitter;
import gregtech.common.events.MetricsCoverDataEvent;
import gregtech.common.events.MetricsCoverHostDeconstructedEvent;
import gregtech.common.events.MetricsCoverSelfDestructEvent;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalMetricsCoverDatabase
extends WorldSavedData {
    private static GlobalMetricsCoverDatabase INSTANCE;
    private static final Map<UUID, Data> DATABASE;
    private static final Map<Coordinates, Set<UUID>> REVERSE_LOOKUP;
    private static final String DATA_NAME = "GregTech_MetricsCoverDatabase";
    private static final String DECONSTRUCTED_KEY = "GregTech_MetricsCoverDatabase_Deconstructed";
    private static final String SELF_DESTRUCTED_KEY = "GregTech_MetricsCoverDatabase_SelfDestructed";

    public GlobalMetricsCoverDatabase() {
        this(DATA_NAME);
    }

    public GlobalMetricsCoverDatabase(String name) {
        super(name);
    }

    @SubscribeEvent
    public void receiveMetricsData(MetricsCoverDataEvent event) {
        Coordinates coordinates = event.getCoordinates();
        GlobalMetricsCoverDatabase.store(event.getFrequency(), State.OPERATIONAL, event.getPayload(), coordinates);
        if (!REVERSE_LOOKUP.containsKey(coordinates)) {
            REVERSE_LOOKUP.put(coordinates, new HashSet());
        }
        REVERSE_LOOKUP.get(coordinates).add(event.getFrequency());
    }

    @SubscribeEvent
    public void receiveHostDeconstructed(MetricsCoverHostDeconstructedEvent event) {
        GlobalMetricsCoverDatabase.cullReverseLookupEntry(event.getFrequency());
        GlobalMetricsCoverDatabase.store(event.getFrequency(), State.HOST_DECONSTRUCTED);
    }

    @SubscribeEvent
    public void receiveSelfDestruct(MetricsCoverSelfDestructEvent event) {
        GlobalMetricsCoverDatabase.cullReverseLookupEntry(event.getFrequency());
        GlobalMetricsCoverDatabase.store(event.getFrequency(), State.SELF_DESTRUCTED);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K || event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        DATABASE.clear();
        MapStorage storage = event.world.field_72988_C;
        INSTANCE = (GlobalMetricsCoverDatabase)storage.func_75742_a(GlobalMetricsCoverDatabase.class, DATA_NAME);
        if (INSTANCE == null) {
            INSTANCE = new GlobalMetricsCoverDatabase();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)INSTANCE);
        }
        INSTANCE.func_76185_a();
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Coordinates coords = new Coordinates(event.world.field_73011_w.func_80007_l(), event.x, event.y, event.z);
        Set<UUID> uuids = REVERSE_LOOKUP.get(coords);
        if (uuids != null) {
            uuids.forEach(uuid -> MinecraftForge.EVENT_BUS.post((Event)(ForgeHooks.canHarvestBlock((Block)event.block, (EntityPlayer)event.getPlayer(), (int)event.blockMetadata) && !event.getPlayer().field_71075_bZ.field_75098_d ? new MetricsCoverHostDeconstructedEvent((UUID)uuid) : new MetricsCoverSelfDestructEvent((UUID)uuid))));
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        String dimensionName = event.world.field_73011_w.func_80007_l();
        event.getAffectedBlocks().forEach(chunkPosition -> {
            Set<UUID> uuids = REVERSE_LOOKUP.get(new Coordinates(dimensionName, chunkPosition.field_151329_a, chunkPosition.field_151327_b, chunkPosition.field_151328_c));
            if (uuids != null) {
                uuids.forEach(uuid -> MinecraftForge.EVENT_BUS.post((Event)new MetricsCoverSelfDestructEvent((UUID)uuid)));
            }
        });
        event.getAffectedEntities().forEach(entity -> {
            if (entity instanceof EntityItem) {
                EntityItem entityItem = (EntityItem)entity;
                GlobalMetricsCoverDatabase.getCoverUUIDsFromItemStack(entityItem.func_92059_d()).forEach(uuid -> MinecraftForge.EVENT_BUS.post((Event)new MetricsCoverSelfDestructEvent((UUID)uuid)));
            }
        });
    }

    @SubscribeEvent
    public void onItemExpiration(ItemExpireEvent event) {
        GlobalMetricsCoverDatabase.getCoverUUIDsFromItemStack(event.entityItem.func_92059_d()).forEach(uuid -> MinecraftForge.EVENT_BUS.post((Event)new MetricsCoverSelfDestructEvent((UUID)uuid)));
    }

    @NotNull
    public static Optional<Data> getData(UUID frequency) {
        return Optional.ofNullable(DATABASE.get(frequency));
    }

    public static void clearSelfDestructedFrequency(UUID frequency) {
        GlobalMetricsCoverDatabase.getData(frequency).ifPresent(data -> {
            if (data.getState() == State.SELF_DESTRUCTED) {
                DATABASE.remove(frequency);
                GlobalMetricsCoverDatabase.tryMarkDirty();
            }
        });
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        NBTTagByteArray byteArray;
        int i;
        NBTTagList deconstructed = nbtTagCompound.func_150295_c(DECONSTRUCTED_KEY, 7);
        NBTTagList selfDestructed = nbtTagCompound.func_150295_c(SELF_DESTRUCTED_KEY, 7);
        for (i = 0; i < deconstructed.func_74745_c(); ++i) {
            byteArray = (NBTTagByteArray)deconstructed.func_74744_a(0);
            GlobalMetricsCoverDatabase.reconstituteUUID(byteArray.func_150292_c()).ifPresent(uuid -> DATABASE.put((UUID)uuid, new Data(State.HOST_DECONSTRUCTED)));
        }
        for (i = 0; i < selfDestructed.func_74745_c(); ++i) {
            byteArray = (NBTTagByteArray)selfDestructed.func_74744_a(0);
            GlobalMetricsCoverDatabase.reconstituteUUID(byteArray.func_150292_c()).ifPresent(uuid -> DATABASE.put((UUID)uuid, new Data(State.SELF_DESTRUCTED)));
        }
    }

    public void func_76187_b(NBTTagCompound nbtTagCompound) {
        NBTTagList deconstructed = new NBTTagList();
        NBTTagList selfDestructed = new NBTTagList();
        DATABASE.forEach((uuid, data) -> {
            switch (data.getState()) {
                case HOST_DECONSTRUCTED: {
                    deconstructed.func_74742_a((NBTBase)new NBTTagByteArray(GlobalMetricsCoverDatabase.dumpUUID(uuid)));
                    break;
                }
                case SELF_DESTRUCTED: {
                    selfDestructed.func_74742_a((NBTBase)new NBTTagByteArray(GlobalMetricsCoverDatabase.dumpUUID(uuid)));
                }
            }
        });
        if (deconstructed.func_74745_c() > 0) {
            nbtTagCompound.func_74782_a(DECONSTRUCTED_KEY, (NBTBase)deconstructed);
        }
        if (selfDestructed.func_74745_c() > 0) {
            nbtTagCompound.func_74782_a(SELF_DESTRUCTED_KEY, (NBTBase)selfDestructed);
        }
    }

    private static void store(@NotNull UUID frequency, @NotNull State state) {
        GlobalMetricsCoverDatabase.store(frequency, state, null, null);
    }

    private static void store(@NotNull UUID frequency, @NotNull State state, @Nullable List<String> payload, @Nullable Coordinates coordinates) {
        Data newData = new Data(state, payload, coordinates);
        Data oldData = DATABASE.put(frequency, newData);
        if (state != State.OPERATIONAL && (oldData == null || oldData != newData)) {
            GlobalMetricsCoverDatabase.tryMarkDirty();
        }
    }

    private static void tryMarkDirty() {
        if (INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    private static byte[] dumpUUID(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }

    @NotNull
    private static Optional<UUID> reconstituteUUID(byte[] bytes) throws IllegalArgumentException {
        if (bytes.length != 16) {
            return Optional.empty();
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return Optional.of(new UUID(buffer.getLong(), buffer.getLong()));
    }

    private static void cullReverseLookupEntry(UUID frequency) {
        GlobalMetricsCoverDatabase.getData(frequency).ifPresent(data -> {
            if (((Data)data).state == State.OPERATIONAL && REVERSE_LOOKUP.containsKey(((Data)data).coordinates)) {
                Set<UUID> set = REVERSE_LOOKUP.get(((Data)data).coordinates);
                set.remove(frequency);
                if (set.isEmpty()) {
                    REVERSE_LOOKUP.remove(((Data)data).coordinates);
                }
            }
        });
    }

    private static Stream<UUID> getCoverUUIDsFromItemStack(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("gt.covers", 10)) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c("gt.covers", 10);
            return IntStream.range(0, tagList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)tagList).func_150305_b(arg_0)).map(nbt -> new CoverInfo(null, (NBTTagCompound)nbt).getCoverData()).filter(serializableObject -> serializableObject instanceof GT_Cover_Metrics_Transmitter.MetricsTransmitterData).map(data -> ((GT_Cover_Metrics_Transmitter.MetricsTransmitterData)data).getFrequency());
        }
        return Stream.empty();
    }

    static {
        DATABASE = new ConcurrentHashMap<UUID, Data>();
        REVERSE_LOOKUP = new ConcurrentHashMap<Coordinates, Set<UUID>>();
    }

    public static class Coordinates {
        private final String dimension;
        private final int x;
        private final int y;
        private final int z;

        public Coordinates(String dimension, int x, int y, int z) {
            this.dimension = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public String getDimension() {
            return this.dimension;
        }

        public String getLocalizedCoordinates() {
            return StatCollector.func_74837_a((String)"gt.db.metrics_cover.coords", (Object[])new Object[]{GT_Utility.formatNumbers(this.x), GT_Utility.formatNumbers(this.y), GT_Utility.formatNumbers(this.z)});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Coordinates that = (Coordinates)o;
            return this.x == that.x && this.y == that.y && this.z == that.z && Objects.equals(this.dimension, that.dimension);
        }

        public int hashCode() {
            return Objects.hash(this.dimension, this.x, this.y, this.z);
        }
    }

    public static enum State {
        OPERATIONAL(1),
        HOST_DECONSTRUCTED(2),
        SELF_DESTRUCTED(3);

        private static final Map<Integer, State> VALID_TYPE_INTEGERS;
        private final int type;

        private State(int type) {
            if (type <= 0) {
                throw new IllegalArgumentException("A state must have a positive, nonzero type parameter.");
            }
            this.type = type;
        }

        @NotNull
        public static Optional<State> find(int candidate) {
            return Optional.ofNullable(VALID_TYPE_INTEGERS.get(candidate));
        }

        public int getType() {
            return this.type;
        }

        static {
            VALID_TYPE_INTEGERS = Arrays.stream(State.values()).collect(Collectors.toMap(State::getType, Function.identity()));
        }
    }

    public static class Data {
        @NotNull
        private final State state;
        @Nullable
        private final List<String> payload;
        @Nullable
        private final Coordinates coordinates;

        public Data(@NotNull State state) {
            this.state = state;
            this.payload = null;
            this.coordinates = null;
        }

        public Data(@NotNull State state, @Nullable List<String> payload) {
            this.state = state;
            this.payload = payload;
            this.coordinates = null;
        }

        public Data(@NotNull State state, @Nullable List<String> payload, @Nullable Coordinates coordinates) {
            this.state = state;
            this.payload = payload;
            this.coordinates = coordinates;
        }

        @NotNull
        public Optional<List<String>> getPayload() {
            return Optional.ofNullable(this.payload);
        }

        @NotNull
        public State getState() {
            return this.state;
        }

        @NotNull
        public Optional<Coordinates> getCoordinates() {
            return Optional.ofNullable(this.coordinates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return this.state == data.state && Objects.equals(this.payload, data.payload) && Objects.equals(this.coordinates, data.coordinates);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.payload, this.coordinates});
        }
    }
}

