/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.TabButton;
import com.gtnewhorizons.modularui.common.widget.TabContainer;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.InventoryType;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.GUIHost;
import gregtech.api.gui.GUIProvider;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.logic.MuTEProcessingLogic;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.FluidInventoryLogicHost;
import gregtech.api.logic.interfaces.ItemInventoryLogicHost;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.logic.interfaces.ProcessingLogicHost;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.StatCollector;

public class MachineGUIProvider<T extends GUIHost & ProcessingLogicHost<? extends MuTEProcessingLogic<?>>>
extends GUIProvider<T> {
    private static final int LOGO_SIZE = 17;
    @Nonnull
    protected static final Pos2d POWER_SWITCH_BUTTON_DEFAULT_POS = new Pos2d(144, 0);
    @Nonnull
    protected static final Pos2d VOIDING_MODE_BUTTON_DEFAULT_POS = new Pos2d(54, 0);
    @Nonnull
    protected static final Pos2d INPUT_SEPARATION_BUTTON_DEFAULT_POS = new Pos2d(36, 0);
    @Nonnull
    protected static final Pos2d BATCH_MODE_BUTTON_DEFAULT_POS = new Pos2d(18, 0);
    @Nonnull
    protected static final Pos2d RECIPE_LOCKING_BUTTON_DEFAULT_POS = new Pos2d(0, 0);
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public MachineGUIProvider(@Nonnull T host) {
        super(host);
    }

    @Override
    protected void attachSynchHandlers(@Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiContext) {
    }

    @Override
    protected void addWidgets(@Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiContext) {
        int page = 0;
        builder.setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        MultiChildWidget mainTab = new MultiChildWidget();
        mainTab.setSize(this.host.getWidth(), this.host.getHeight());
        this.createMainTab(mainTab, builder, uiContext);
        TabContainer tabs = new TabContainer().setButtonSize(20, 24);
        tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), new ItemDrawable(this.host.getAsItem()).withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), new ItemDrawable(this.host.getAsItem()).withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).addTooltip(this.host.getMachineName()).setPos(20 * (page - 1), -20)).addPage((Widget)mainTab);
        if (this.host.hasItemInput()) {
            MultiChildWidget itemInputTab = new MultiChildWidget();
            itemInputTab.setSize(this.host.getWidth(), this.host.getHeight());
            this.createItemInputTab(itemInputTab, builder, uiContext);
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_ITEM_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_ITEM_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).addTooltip("Item Input Inventory").setPos(20 * (page - 1), -20)).addPage((Widget)itemInputTab.addChild(this.getLogo().setPos(147, 86)));
        }
        if (this.host.hasItemOutput()) {
            MultiChildWidget itemOutputTab = new MultiChildWidget();
            itemOutputTab.setSize(this.host.getWidth(), this.host.getHeight());
            this.createItemOutputTab(itemOutputTab, builder, uiContext);
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_ITEM_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_ITEM_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).addTooltip("Item Output Inventory").setPos(20 * (page - 1), -20)).addPage((Widget)itemOutputTab.addChild(this.getLogo().setPos(147, 86)));
        }
        if (this.host.hasFluidInput()) {
            MultiChildWidget fluidInputTab = new MultiChildWidget();
            fluidInputTab.setSize(this.host.getWidth(), this.host.getHeight());
            this.createFluidInputTab(fluidInputTab, builder, uiContext);
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_FLUID_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_FLUID_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).addTooltip("Fluid Input Tanks").setPos(20 * (page - 1), -20)).addPage((Widget)fluidInputTab.addChild(this.getLogo().setPos(147, 86)));
        }
        if (this.host.hasFluidOutput()) {
            MultiChildWidget fluidOutputTab = new MultiChildWidget();
            fluidOutputTab.setSize(this.host.getWidth(), this.host.getHeight());
            this.createFluidOutputTab(fluidOutputTab, builder, uiContext);
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_FLUID_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_FLUID_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).addTooltip("Fluid Output Tanks").setPos(20 * (page - 1), -20)).addPage((Widget)fluidOutputTab.addChild(this.getLogo().setPos(147, 86)));
        }
        MultiChildWidget powerInfoTab = new MultiChildWidget();
        powerInfoTab.setSize(this.host.getWidth(), this.host.getHeight());
        this.createPowerTab(powerInfoTab, builder, uiContext);
        tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_FLUID_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_FLUID_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).addTooltip("Power Information").setPos(20 * (page - 1), -20)).addPage((Widget)powerInfoTab.addChild(this.getLogo().setPos(147, 86)));
        builder.widget((Widget)tabs);
    }

    protected void createMainTab(@Nonnull MultiChildWidget tab, @Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiBuildContext) {
        MultiChildWidget buttons = new MultiChildWidget();
        buttons.setSize(16, 167).setPos(7, 86);
        buttons.addChild((Widget)this.createPowerSwitchButton((IWidgetBuilder<?>)builder)).addChild((Widget)this.createVoidExcessButton((IWidgetBuilder<?>)builder)).addChild((Widget)this.createInputSeparationButton((IWidgetBuilder<?>)builder)).addChild((Widget)this.createBatchModeButton((IWidgetBuilder<?>)builder)).addChild((Widget)this.createLockToSingleRecipeButton((IWidgetBuilder<?>)builder));
        tab.addChild(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 4).setSize(160, 75)).addChild((Widget)buttons);
    }

    protected void createItemInputTab(@Nonnull MultiChildWidget tab, @Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiBuildContext) {
        tab.addChild(((ItemInventoryLogicHost)((Object)this.host)).getItemLogic(InventoryType.Input, null).getGuiPart().setSize(81, 90).setPos(this.host.getWidth() / 2 - 36, 10));
    }

    protected void createItemOutputTab(@Nonnull MultiChildWidget tab, @Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiBuildContext) {
        tab.addChild(((ItemInventoryLogicHost)((Object)this.host)).getItemLogic(InventoryType.Output, null).getGuiPart().setSize(81, 90).setPos(this.host.getWidth() / 2 - 36, 10));
    }

    protected void createFluidInputTab(@Nonnull MultiChildWidget tab, @Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiBuildContext) {
        tab.addChild(((FluidInventoryLogicHost)((Object)this.host)).getFluidLogic(InventoryType.Input, null).getGuiPart().setSize(81, 90).setPos(this.host.getWidth() / 2 - 36, 10));
    }

    protected void createFluidOutputTab(@Nonnull MultiChildWidget tab, @Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiBuildContext) {
        tab.addChild(((FluidInventoryLogicHost)((Object)this.host)).getFluidLogic(InventoryType.Output, null).getGuiPart().setSize(81, 90).setPos(this.host.getWidth() / 2 - 36, 10));
    }

    protected void createPowerTab(@Nonnull MultiChildWidget tab, @Nonnull ModularWindow.Builder builder, @Nonnull UIBuildContext uiBuildContext) {
        PowerLogic power = ((PowerLogicHost)((Object)this.host)).getPowerLogic();
        tab.addChild(new TextWidget().setStringSupplier(() -> numberFormat.format(power.getStoredEnergy()) + "/" + numberFormat.format(power.getCapacity()) + " EU").setPos(10, 30)).addChild(new TextWidget().setStringSupplier(() -> numberFormat.format(power.getVoltage()) + " EU/t(" + numberFormat.format(power.getMaxAmperage()) + " A)").setPos(10, 60));
    }

    @Nonnull
    protected Widget getLogo() {
        DrawableWidget logo = new DrawableWidget();
        logo.setDrawable((IDrawable)GUITextureSet.DEFAULT.getGregTechLogo()).setSize(17, 17);
        return logo;
    }

    protected Pos2d getPowerSwitchButtonPos() {
        return POWER_SWITCH_BUTTON_DEFAULT_POS;
    }

    protected ButtonWidget createPowerSwitchButton(IWidgetBuilder<?> builder) {
        ButtonWidget button = new ButtonWidget();
        button.setOnClick((clickData, widget) -> {
            if (((IMachineProgress)((Object)this.host)).isAllowedToWork()) {
                ((IMachineProgress)((Object)this.host)).disableWorking();
            } else {
                ((IMachineProgress)((Object)this.host)).enableWorking();
            }
        }).setPlayClickSoundResource(() -> ((IMachineProgress)((Object)this.host)).isAllowedToWork() ? SoundResource.GUI_BUTTON_UP.resourceLocation : SoundResource.GUI_BUTTON_DOWN.resourceLocation).setBackground(() -> {
            if (((IMachineProgress)((Object)this.host)).isAllowedToWork()) {
                return new IDrawable[]{GT_UITextures.BUTTON_STANDARD_PRESSED, GT_UITextures.OVERLAY_BUTTON_POWER_SWITCH_ON};
            }
            return new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_POWER_SWITCH_OFF};
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(((IMachineProgress)((Object)this.host))::isAllowedToWork, ((IMachineProgress)((Object)this.host))::setAllowedToWork), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.power_switch")).setTooltipShowUpDelay(5).setPos(this.getPowerSwitchButtonPos()).setSize(16, 16);
        return button;
    }

    @Nonnull
    protected Pos2d getVoidingModeButtonPos() {
        return VOIDING_MODE_BUTTON_DEFAULT_POS;
    }

    @Nonnull
    protected ButtonWidget createVoidExcessButton(IWidgetBuilder<?> builder) {
        ButtonWidget button = new ButtonWidget();
        button.setOnClick((clickData, widget) -> {
            if (((IVoidable)((Object)this.host)).supportsVoidProtection()) {
                Set<VoidingMode> allowed = ((IVoidable)((Object)this.host)).getAllowedVoidingModes();
                switch (clickData.mouseButton) {
                    case 0: {
                        ((IVoidable)((Object)this.host)).setVoidingMode(((IVoidable)((Object)this.host)).getVoidingMode().nextInCollection(allowed));
                        break;
                    }
                    case 1: {
                        ((IVoidable)((Object)this.host)).setVoidingMode(((IVoidable)((Object)this.host)).getVoidingMode().previousInCollection(allowed));
                    }
                }
                widget.notifyTooltipChange();
            }
        }).setPlayClickSound(((IVoidable)((Object)this.host)).supportsVoidProtection()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(((IVoidable)((Object)this.host)).getVoidingMode().buttonTexture);
            ret.add(((IVoidable)((Object)this.host)).getVoidingMode().buttonOverlay);
            if (!((IVoidable)((Object)this.host)).supportsVoidProtection()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> ((IVoidable)((Object)this.host)).getVoidingMode().ordinal(), val -> ((IVoidable)((Object)this.host)).setVoidingMode(VoidingMode.fromOrdinal(val))), builder).dynamicTooltip(() -> Arrays.asList(StatCollector.func_74838_a((String)"GT5U.gui.button.voiding_mode"), StatCollector.func_74838_a((String)((IVoidable)((Object)this.host)).getVoidingMode().getTransKey()))).setTooltipShowUpDelay(5).setPos(this.getVoidingModeButtonPos()).setSize(16, 16);
        if (!((IVoidable)((Object)this.host)).supportsVoidProtection()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return button;
    }

    @Nonnull
    protected Pos2d getInputSeparationButtonPos() {
        return INPUT_SEPARATION_BUTTON_DEFAULT_POS;
    }

    protected ButtonWidget createInputSeparationButton(IWidgetBuilder<?> builder) {
        ButtonWidget button = new ButtonWidget();
        button.setOnClick((clickData, widget) -> {
            if (((ProcessingLogicHost)((Object)this.host)).supportsInputSeparation()) {
                ((ProcessingLogicHost)((Object)this.host)).setInputSeparation(!((ProcessingLogicHost)((Object)this.host)).isInputSeparated());
            }
        }).setPlayClickSound(((ProcessingLogicHost)((Object)this.host)).supportsInputSeparation()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (((ProcessingLogicHost)((Object)this.host)).isInputSeparated()) {
                ret.add(GT_UITextures.BUTTON_STANDARD_PRESSED);
                if (((ProcessingLogicHost)((Object)this.host)).supportsInputSeparation()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON_DISABLED);
                }
            } else {
                ret.add(GT_UITextures.BUTTON_STANDARD);
                if (((ProcessingLogicHost)((Object)this.host)).supportsInputSeparation()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF_DISABLED);
                }
            }
            if (!((ProcessingLogicHost)((Object)this.host)).supportsInputSeparation()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(((ProcessingLogicHost)((Object)this.host))::isInputSeparated, ((ProcessingLogicHost)((Object)this.host))::setInputSeparation), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.input_separation")).setTooltipShowUpDelay(5).setPos(this.getInputSeparationButtonPos()).setSize(16, 16);
        if (!((ProcessingLogicHost)((Object)this.host)).supportsInputSeparation()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return button;
    }

    @Nonnull
    protected Pos2d getBatchModeButtonPos() {
        return BATCH_MODE_BUTTON_DEFAULT_POS;
    }

    protected ButtonWidget createBatchModeButton(IWidgetBuilder<?> builder) {
        ButtonWidget button = new ButtonWidget();
        button.setOnClick((clickData, widget) -> {
            if (((ProcessingLogicHost)((Object)this.host)).supportsBatchMode()) {
                ((ProcessingLogicHost)((Object)this.host)).setBatchMode(!((ProcessingLogicHost)((Object)this.host)).isBatchModeEnabled());
            }
        }).setPlayClickSound(((ProcessingLogicHost)((Object)this.host)).supportsBatchMode()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (((ProcessingLogicHost)((Object)this.host)).isBatchModeEnabled()) {
                ret.add(GT_UITextures.BUTTON_STANDARD_PRESSED);
                if (((ProcessingLogicHost)((Object)this.host)).supportsBatchMode()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_ON);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_ON_DISABLED);
                }
            } else {
                ret.add(GT_UITextures.BUTTON_STANDARD);
                if (((ProcessingLogicHost)((Object)this.host)).supportsBatchMode()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_OFF);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_OFF_DISABLED);
                }
            }
            if (!((ProcessingLogicHost)((Object)this.host)).supportsBatchMode()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(((ProcessingLogicHost)((Object)this.host))::isBatchModeEnabled, ((ProcessingLogicHost)((Object)this.host))::setBatchMode), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.batch_mode")).setTooltipShowUpDelay(5).setPos(this.getBatchModeButtonPos()).setSize(16, 16);
        if (!((ProcessingLogicHost)((Object)this.host)).supportsBatchMode()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return button;
    }

    @Nonnull
    protected Pos2d getRecipeLockingButtonPos() {
        return RECIPE_LOCKING_BUTTON_DEFAULT_POS;
    }

    protected ButtonWidget createLockToSingleRecipeButton(IWidgetBuilder<?> builder) {
        ButtonWidget button = new ButtonWidget();
        button.setOnClick((clickData, widget) -> {
            if (((ProcessingLogicHost)((Object)this.host)).supportsSingleRecipeLocking()) {
                ((ProcessingLogicHost)((Object)this.host)).setRecipeLocking(!((ProcessingLogicHost)((Object)this.host)).isRecipeLockingEnabled());
            }
        }).setPlayClickSound(((ProcessingLogicHost)((Object)this.host)).supportsSingleRecipeLocking()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (((ProcessingLogicHost)((Object)this.host)).isRecipeLockingEnabled()) {
                ret.add(GT_UITextures.BUTTON_STANDARD_PRESSED);
                if (((ProcessingLogicHost)((Object)this.host)).supportsSingleRecipeLocking()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_LOCKED);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_LOCKED_DISABLED);
                }
            } else {
                ret.add(GT_UITextures.BUTTON_STANDARD);
                if (((ProcessingLogicHost)((Object)this.host)).supportsSingleRecipeLocking()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED_DISABLED);
                }
            }
            if (!((ProcessingLogicHost)((Object)this.host)).supportsSingleRecipeLocking()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(((ProcessingLogicHost)((Object)this.host))::isRecipeLockingEnabled, ((ProcessingLogicHost)((Object)this.host))::setRecipeLocking), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.lock_recipe")).setTooltipShowUpDelay(5).setPos(this.getRecipeLockingButtonPos()).setSize(16, 16);
        if (!((ProcessingLogicHost)((Object)this.host)).supportsSingleRecipeLocking()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return button;
    }
}

