/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.redstone.GT_Cover_AdvancedWirelessRedstoneBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_Cover_AdvancedRedstoneTransmitterBase<T extends TransmitterData>
extends GT_Cover_AdvancedWirelessRedstoneBase<T> {
    public GT_Cover_AdvancedRedstoneTransmitterBase(Class<T> typeToken, ITexture coverTexture) {
        super(typeToken, coverTexture);
    }

    private static void unregisterSignal(ForgeDirection side, TransmitterData aCoverVariable, ICoverable aTileEntity) {
        long hash = GT_Cover_AdvancedRedstoneTransmitterBase.hashCoverCoords(aTileEntity, side);
        GT_Cover_AdvancedRedstoneTransmitterBase.removeSignalAt(aCoverVariable.uuid, aCoverVariable.frequency, hash);
    }

    @Override
    public boolean onCoverRemovalImpl(ForgeDirection side, int aCoverID, TransmitterData aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        GT_Cover_AdvancedRedstoneTransmitterBase.unregisterSignal(side, aCoverVariable, aTileEntity);
        return true;
    }

    @Override
    protected void onBaseTEDestroyedImpl(ForgeDirection side, int aCoverID, TransmitterData aCoverVariable, ICoverable aTileEntity) {
        GT_Cover_AdvancedRedstoneTransmitterBase.unregisterSignal(side, aCoverVariable, aTileEntity);
    }

    @Override
    protected T onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ((TransmitterData)aCoverVariable).invert = !((TransmitterData)aCoverVariable).invert;
        GT_Utility.sendChatToPlayer(aPlayer, ((TransmitterData)aCoverVariable).invert ? GT_Utility.trans("054", "Inverted") : GT_Utility.trans("055", "Normal"));
        return aCoverVariable;
    }

    @Override
    protected void preDataChangedImpl(ForgeDirection side, int aCoverID, int aNewCoverId, T aCoverVariable, T aNewCoverVariable, ICoverable aTileEntity) {
        if (((TransmitterData)aCoverVariable).frequency != ((TransmitterData)aNewCoverVariable).frequency || !Objects.equals(((TransmitterData)aCoverVariable).uuid, ((TransmitterData)aNewCoverVariable).uuid)) {
            GT_Cover_AdvancedRedstoneTransmitterBase.unregisterSignal(side, aCoverVariable, aTileEntity);
        }
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new AdvancedRedstoneTransmitterBaseUIFactory(buildContext).createWindow();
    }

    public static class TransmitterData
    extends GT_Cover_AdvancedWirelessRedstoneBase.WirelessData {
        protected boolean invert;

        public TransmitterData(int frequency, UUID uuid, boolean invert) {
            super(frequency, uuid);
            this.invert = invert;
        }

        public TransmitterData() {
            this(0, null, false);
        }

        public boolean isInvert() {
            return this.invert;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new TransmitterData(this.frequency, this.uuid, this.invert);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = (NBTTagCompound)super.saveDataToNBT();
            tag.func_74757_a("invert", this.invert);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            super.writeToByteBuf(aBuf);
            aBuf.writeBoolean(this.invert);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            super.loadDataFromNBT(aNBT);
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.invert = tag.func_74767_n("invert");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            super.readFromPacket(aBuf, aPlayer);
            this.invert = aBuf.readBoolean();
            return this;
        }
    }

    protected class AdvancedRedstoneTransmitterBaseUIFactory
    extends GT_Cover_AdvancedWirelessRedstoneBase.AdvancedWirelessRedstoneBaseUIFactory {
        public AdvancedRedstoneTransmitterBaseUIFactory(GT_CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected int getFrequencyRow() {
            return 0;
        }

        @Override
        protected int getButtonRow() {
            return 1;
        }

        @Override
        protected boolean isShiftPrivateLeft() {
            return true;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            super.addUIWidgets(builder);
            builder.widget(TextWidget.dynamicString(() -> {
                TransmitterData coverData = (TransmitterData)this.getCoverData();
                if (coverData != null) {
                    return ((TransmitterData)this.getCoverData()).invert ? GT_Utility.trans("INVERTED", "Inverted") : GT_Utility.trans("NORMAL", "Normal");
                }
                return "";
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(190, 29 + 18 * this.getButtonRow()));
        }

        @Override
        protected void addUIForDataController(CoverDataControllerWidget<T> controller) {
            super.addUIForDataController(controller);
            controller.addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofRedstone(), coverData -> coverData.invert, (coverData, state) -> {
                coverData.invert = state;
                return coverData;
            }, widget -> widget.addTooltip(0, GT_Utility.trans("NORMAL", "Normal")).addTooltip(1, GT_Utility.trans("INVERTED", "Inverted")).setPos(162, 18 * this.getButtonRow()));
        }
    }
}

