/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.GT_Mod;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.IRecipeMetadataStorage;
import gregtech.api.recipe.metadata.RecipeMetadataStorage;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_RecipeMapUtil;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

public class GT_RecipeBuilder {
    private static final boolean DEBUG_MODE_NULL;
    private static boolean PANIC_MODE_NULL;
    private static final boolean DEBUG_MODE_INVALID;
    private static final boolean PANIC_MODE_INVALID;
    private static final boolean DEBUG_MODE_COLLISION;
    private static final boolean PANIC_MODE_COLLISION;
    public static final int WILDCARD = Short.MAX_VALUE;
    public static final int HOURS = 72000;
    public static final int MINUTES = 1200;
    public static final int SECONDS = 20;
    public static final int TICKS = 1;
    public static final int INGOTS = 144;
    public static final int HALF_INGOT = 72;
    public static final int QUARTER_INGOT = 36;
    public static final int EIGHTH_INGOT = 18;
    public static final int NUGGETS = 16;
    public static final int BUCKETS = 1000;
    protected ItemStack[] inputsBasic = new ItemStack[0];
    protected Object[] inputsOreDict;
    protected ItemStack[] outputs = new ItemStack[0];
    protected ItemStack[][] alts;
    protected FluidStack[] fluidInputs = new FluidStack[0];
    protected FluidStack[] fluidOutputs = new FluidStack[0];
    protected int[] chances;
    protected Object special;
    protected int duration = -1;
    protected int eut = -1;
    protected int specialValue;
    protected boolean enabled = true;
    protected boolean hidden = false;
    protected boolean fakeRecipe = false;
    protected boolean mCanBeBuffered = true;
    protected boolean mNeedsEmptyOutput = false;
    protected boolean nbtSensitive = false;
    protected String[] neiDesc;
    protected RecipeCategory recipeCategory;
    protected boolean optimize = true;
    @Nullable
    protected IRecipeMetadataStorage metadataStorage;
    protected boolean checkForCollision = true;
    protected boolean skip = false;
    protected boolean valid = true;

    GT_RecipeBuilder() {
    }

    private GT_RecipeBuilder(ItemStack[] inputsBasic, Object[] inputsOreDict, ItemStack[] outputs, ItemStack[][] alts, FluidStack[] fluidInputs, FluidStack[] fluidOutputs, int[] chances, Object special, int duration, int eut, int specialValue, boolean enabled, boolean hidden, boolean fakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, boolean nbtSensitive, String[] neiDesc, RecipeCategory recipeCategory, boolean optimize, @Nullable IRecipeMetadataStorage metadataStorage, boolean checkForCollision, boolean skip, boolean valid) {
        this.inputsBasic = inputsBasic;
        this.inputsOreDict = inputsOreDict;
        this.outputs = outputs;
        this.alts = alts;
        this.fluidInputs = fluidInputs;
        this.fluidOutputs = fluidOutputs;
        this.chances = chances;
        this.special = special;
        this.duration = duration;
        this.eut = eut;
        this.specialValue = specialValue;
        this.enabled = enabled;
        this.hidden = hidden;
        this.fakeRecipe = fakeRecipe;
        this.mCanBeBuffered = mCanBeBuffered;
        this.mNeedsEmptyOutput = mNeedsEmptyOutput;
        this.nbtSensitive = nbtSensitive;
        this.neiDesc = neiDesc;
        this.recipeCategory = recipeCategory;
        this.optimize = optimize;
        this.metadataStorage = metadataStorage;
        if (this.metadataStorage != null) {
            this.metadataStorage = this.metadataStorage.copy();
        }
        this.checkForCollision = checkForCollision;
        this.skip = skip;
        this.valid = valid;
    }

    private static FluidStack[] fix(FluidStack[] fluidInputs) {
        return (FluidStack[])Arrays.stream(fluidInputs).filter(Objects::nonNull).map(FluidStack::copy).toArray(FluidStack[]::new);
    }

    private static ItemStack[] fix(ItemStack[] inputs) {
        return GT_OreDictUnificator.setStackArray(true, ArrayExt.withoutTrailingNulls(inputs, ItemStack[]::new));
    }

    public static GT_RecipeBuilder builder() {
        return new GT_RecipeBuilder();
    }

    public static GT_RecipeBuilder empty() {
        return new GT_RecipeBuilder().duration(0).eut(0);
    }

    private static boolean containsNull(Object[] arr) {
        return arr == null || Arrays.stream(arr).anyMatch(Objects::isNull);
    }

    private static void handleNullRecipeComponents(String componentType) {
        GT_Log.err.print("null detected in ");
        GT_Log.err.println(componentType);
        new NullPointerException().printStackTrace(GT_Log.err);
        if (PANIC_MODE_NULL) {
            throw new IllegalArgumentException("null in argument");
        }
    }

    private static boolean debugNull() {
        return DEBUG_MODE_NULL || PANIC_MODE_NULL;
    }

    public static void handleInvalidRecipe() {
        if (!DEBUG_MODE_INVALID && !PANIC_MODE_INVALID) {
            return;
        }
        GT_Log.err.print("invalid recipe");
        new IllegalArgumentException().printStackTrace(GT_Log.err);
        if (PANIC_MODE_INVALID) {
            throw new IllegalArgumentException("invalid recipe");
        }
    }

    public static void handleRecipeCollision(String details) {
        if (!DEBUG_MODE_COLLISION && !PANIC_MODE_COLLISION) {
            return;
        }
        GT_Log.err.print("Recipe collision resulting in recipe loss detected with ");
        GT_Log.err.println(details);
        if (PANIC_MODE_COLLISION) {
            throw new IllegalArgumentException("Recipe Collision");
        }
        new IllegalArgumentException().printStackTrace(GT_Log.err);
    }

    public static void onConfigLoad() {
        PANIC_MODE_NULL |= GT_Mod.gregtechproxy.crashOnNullRecipeInput;
    }

    public GT_RecipeBuilder itemInputsUnified(ItemStack ... inputs) {
        if (this.skip) {
            return this;
        }
        if (GT_RecipeBuilder.debugNull() && GT_RecipeBuilder.containsNull(inputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemInputUnified");
        }
        this.inputsBasic = ArrayExt.withoutTrailingNulls(inputs, ItemStack[]::new);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GT_RecipeBuilder itemInputs(ItemStack ... inputs) {
        if (this.skip) {
            return this;
        }
        if (GT_RecipeBuilder.debugNull() && GT_RecipeBuilder.containsNull(inputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemInputs");
        }
        this.inputsBasic = GT_RecipeBuilder.fix(inputs);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GT_RecipeBuilder itemInputs(Object ... inputs) {
        if (this.skip) {
            return this;
        }
        this.inputsOreDict = inputs;
        this.alts = new ItemStack[inputs.length][];
        int inputsLength = inputs.length;
        for (int i = 0; i < inputsLength; ++i) {
            Object input = inputs[i];
            if (input instanceof ItemStack) {
                this.alts[i] = new ItemStack[]{(ItemStack)input};
                continue;
            }
            if (input instanceof ItemStack[]) {
                this.alts[i] = (ItemStack[])((ItemStack[])input).clone();
                continue;
            }
            if (input instanceof Object[]) {
                ArrayList<ItemStack> ores;
                Object[] arr = (Object[])input;
                if (arr.length != 2 || (ores = GT_OreDictUnificator.getOres(arr[0])).isEmpty()) continue;
                int size = ((Number)arr[1]).intValue();
                this.alts[i] = (ItemStack[])ores.stream().map(s -> GT_Utility.copyAmount(size, s)).filter(GT_Utility::isStackValid).toArray(ItemStack[]::new);
                continue;
            }
            if (input == null) {
                GT_RecipeBuilder.handleNullRecipeComponents("recipe oredict input");
                this.alts[i] = new ItemStack[0];
                continue;
            }
            throw new IllegalArgumentException("index " + i + ", unexpected type: " + input.getClass());
        }
        this.inputsBasic = (ItemStack[])Arrays.stream(this.alts).map(ss -> ((ItemStack[])ss).length > 0 ? ss[0] : null).toArray(ItemStack[]::new);
        return this.noOptimize();
    }

    public GT_RecipeBuilder itemOutputs(ItemStack ... outputs) {
        if (this.skip) {
            return this;
        }
        if (GT_RecipeBuilder.debugNull() && GT_RecipeBuilder.containsNull(outputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemOutputs");
        }
        this.outputs = outputs;
        if (this.chances != null && this.chances.length != outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        return this;
    }

    public GT_RecipeBuilder itemOutputs(ItemStack[] outputs, int[] chances) {
        if (this.skip) {
            return this;
        }
        if (GT_RecipeBuilder.debugNull() && GT_RecipeBuilder.containsNull(outputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemOutputs");
        }
        this.outputs = outputs;
        this.chances = chances;
        if (chances != null && chances.length != outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        return this;
    }

    public GT_RecipeBuilder fluidInputs(FluidStack ... fluidInputs) {
        if (this.skip) {
            return this;
        }
        if (GT_RecipeBuilder.debugNull() && GT_RecipeBuilder.containsNull(fluidInputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("fluidInputs");
        }
        this.fluidInputs = GT_RecipeBuilder.fix(fluidInputs);
        return this;
    }

    public GT_RecipeBuilder fluidOutputs(FluidStack ... fluidOutputs) {
        if (this.skip) {
            return this;
        }
        if (GT_RecipeBuilder.debugNull() && GT_RecipeBuilder.containsNull(fluidOutputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("fluidOutputs");
        }
        this.fluidOutputs = GT_RecipeBuilder.fix(fluidOutputs);
        return this;
    }

    public GT_RecipeBuilder outputChances(int ... chances) {
        if (this.skip) {
            return this;
        }
        if (this.outputs != null && chances.length != this.outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        this.chances = chances;
        return this;
    }

    public GT_RecipeBuilder special(Object special) {
        this.special = special;
        return this;
    }

    public GT_RecipeBuilder specialItem(ItemStack specialItem) {
        return this.special(specialItem);
    }

    public GT_RecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public GT_RecipeBuilder duration(long duration) {
        this.duration = (int)duration;
        return this;
    }

    public GT_RecipeBuilder eut(int eut) {
        this.eut = eut;
        return this;
    }

    public GT_RecipeBuilder eut(long eut) {
        this.eut = (int)eut;
        return this;
    }

    public GT_RecipeBuilder specialValue(int specialValue) {
        this.specialValue = specialValue;
        return this;
    }

    public GT_RecipeBuilder disabled() {
        this.enabled = false;
        return this;
    }

    public GT_RecipeBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public GT_RecipeBuilder fake() {
        this.fakeRecipe = true;
        return this;
    }

    public GT_RecipeBuilder noBuffer() {
        this.mCanBeBuffered = false;
        return this;
    }

    public GT_RecipeBuilder needsEmptyOutput() {
        this.mNeedsEmptyOutput = true;
        return this;
    }

    public GT_RecipeBuilder nbtSensitive() {
        this.nbtSensitive = true;
        return this;
    }

    public GT_RecipeBuilder setNEIDesc(String ... neiDesc) {
        this.neiDesc = neiDesc;
        return this;
    }

    public GT_RecipeBuilder recipeCategory(RecipeCategory recipeCategory) {
        this.recipeCategory = recipeCategory;
        return this;
    }

    public GT_RecipeBuilder noOptimize() {
        this.optimize = false;
        return this;
    }

    public GT_RecipeBuilder ignoreCollision() {
        this.checkForCollision = false;
        return this;
    }

    public <T> GT_RecipeBuilder metadata(RecipeMetadataKey<T> key, T value) {
        if (this.skip) {
            return this;
        }
        if (this.metadataStorage == null) {
            this.metadataStorage = new RecipeMetadataStorage();
        }
        this.metadataStorage.store(key, value);
        return this;
    }

    @Nullable
    public <T> T getMetadata(RecipeMetadataKey<T> key) {
        if (this.metadataStorage == null) {
            return null;
        }
        return key.cast(this.metadataStorage.getMetadata(key));
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public <T> T getMetadataOrDefault(RecipeMetadataKey<T> key, T defaultValue) {
        if (this.metadataStorage == null) {
            return defaultValue;
        }
        return key.cast(this.metadataStorage.getMetadataOrDefault(key, defaultValue));
    }

    public GT_RecipeBuilder requireMods(Mods ... mods) {
        this.skip = Stream.of(mods).anyMatch(mod -> !mod.isModLoaded());
        return this;
    }

    public GT_RecipeBuilder requiresCleanRoom() {
        return this.metadata(GT_RecipeConstants.CLEANROOM, true);
    }

    public GT_RecipeBuilder requiresLowGravity() {
        return this.metadata(GT_RecipeConstants.LOW_GRAVITY, true);
    }

    private static <T> T[] copy(T[] arr) {
        return arr == null ? null : (Object[])arr.clone();
    }

    private static int[] copy(int[] arr) {
        return arr == null ? null : (int[])arr.clone();
    }

    public GT_RecipeBuilder copy() {
        return new GT_RecipeBuilder(GT_Utility.copyItemArray(this.inputsBasic), GT_RecipeBuilder.copy(this.inputsOreDict), GT_Utility.copyItemArray(this.outputs), (ItemStack[][])GT_RecipeBuilder.copy(this.alts), GT_Utility.copyFluidArray(this.fluidInputs), GT_Utility.copyFluidArray(this.fluidOutputs), GT_RecipeBuilder.copy(this.chances), this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, GT_RecipeBuilder.copy(this.neiDesc), this.recipeCategory, this.optimize, this.metadataStorage, this.checkForCollision, this.skip, this.valid);
    }

    public GT_RecipeBuilder copyNoMetadata() {
        return new GT_RecipeBuilder(GT_Utility.copyItemArray(this.inputsBasic), GT_RecipeBuilder.copy(this.inputsOreDict), GT_Utility.copyItemArray(this.outputs), (ItemStack[][])GT_RecipeBuilder.copy(this.alts), GT_Utility.copyFluidArray(this.fluidInputs), GT_Utility.copyFluidArray(this.fluidOutputs), GT_RecipeBuilder.copy(this.chances), this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, GT_RecipeBuilder.copy(this.neiDesc), this.recipeCategory, this.optimize, null, this.checkForCollision, this.skip, this.valid);
    }

    public ItemStack getItemInputBasic(int index) {
        return index < this.inputsBasic.length ? this.inputsBasic[index] : null;
    }

    public Object getItemInputOreDict(int index) {
        return index < this.inputsOreDict.length ? this.inputsOreDict[index] : null;
    }

    public ItemStack getItemOutput(int index) {
        return index < this.outputs.length ? this.outputs[index] : null;
    }

    public FluidStack getFluidInput(int index) {
        return index < this.fluidInputs.length ? this.fluidInputs[index] : null;
    }

    public FluidStack getFluidOutput(int index) {
        return index < this.fluidOutputs.length ? this.fluidOutputs[index] : null;
    }

    public ItemStack[] getItemInputsBasic() {
        return this.inputsBasic;
    }

    public Object[] getItemInputsOreDict() {
        return this.inputsOreDict;
    }

    public ItemStack[] getItemOutputs() {
        return this.outputs;
    }

    public FluidStack[] getFluidInputs() {
        return this.fluidInputs;
    }

    public FluidStack[] getFluidOutputs() {
        return this.fluidOutputs;
    }

    public int getDuration() {
        return this.duration;
    }

    public int[] getChances() {
        return this.chances;
    }

    public int getEUt() {
        return this.eut;
    }

    public RecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public boolean isCheckForCollision() {
        return this.checkForCollision;
    }

    public GT_RecipeBuilder clearInvalid() {
        this.valid = true;
        return this;
    }

    public GT_RecipeBuilder invalidate() {
        this.valid = false;
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    private static boolean isArrayValid(@Nonnull Object[] arr, int min, int max) {
        int count = 0;
        for (Object o : arr) {
            if (o == null) continue;
            ++count;
        }
        return min <= count && max >= count;
    }

    public GT_RecipeBuilder validateNoInput() {
        if (this.skip) {
            return this;
        }
        return GT_Utility.isArrayEmptyOrNull(this.inputsBasic) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateNoInputFluid() {
        if (this.skip) {
            return this;
        }
        return GT_Utility.isArrayEmptyOrNull(this.fluidInputs) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateNoOutput() {
        if (this.skip) {
            return this;
        }
        return GT_Utility.isArrayEmptyOrNull(this.outputs) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateNoOutputFluid() {
        if (this.skip) {
            return this;
        }
        return GT_Utility.isArrayEmptyOrNull(this.fluidOutputs) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateInputCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.inputsBasic == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.inputsBasic, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateInputFluidCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.fluidInputs == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.fluidInputs, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateOutputCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.outputs == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.outputs, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateOutputFluidCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.fluidOutputs == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.fluidOutputs, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateAnyInput() {
        if (this.skip) {
            return this;
        }
        if (this.fluidInputs != null && GT_RecipeBuilder.isArrayValid(this.fluidInputs, 1, Integer.MAX_VALUE)) {
            return this;
        }
        if (this.inputsBasic != null && GT_RecipeBuilder.isArrayValid(this.inputsBasic, 1, Integer.MAX_VALUE)) {
            return this;
        }
        return this.invalidate();
    }

    public GT_RecipeBuilder validateAnyOutput() {
        if (this.skip) {
            return this;
        }
        if (this.fluidOutputs != null && GT_RecipeBuilder.isArrayValid(this.fluidOutputs, 1, Integer.MAX_VALUE)) {
            return this;
        }
        if (this.outputs != null && GT_RecipeBuilder.isArrayValid(this.outputs, 1, Integer.MAX_VALUE)) {
            return this;
        }
        return this.invalidate();
    }

    public Optional<GT_Recipe> build() {
        if (this.skip) {
            return Optional.empty();
        }
        if (!this.valid) {
            GT_RecipeBuilder.handleInvalidRecipe();
            return Optional.empty();
        }
        this.preBuildChecks();
        this.optimize();
        return Optional.of(this.decorate(new GT_Recipe(this.inputsBasic, this.outputs, this.fluidInputs, this.fluidOutputs, this.chances, this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, this.neiDesc, this.metadataStorage, this.recipeCategory)));
    }

    public GT_RecipeBuilder forceOreDictInput() {
        if (this.inputsOreDict != null || this.inputsBasic == null) {
            return this;
        }
        return this.itemInputs((Object[])this.inputsBasic);
    }

    public Optional<GT_Recipe.GT_Recipe_WithAlt> buildWithAlt() {
        if (this.skip) {
            return Optional.empty();
        }
        if (this.inputsOreDict == null) {
            throw new UnsupportedOperationException();
        }
        if (!this.valid) {
            GT_RecipeBuilder.handleInvalidRecipe();
            return Optional.empty();
        }
        this.preBuildChecks();
        return Optional.of(this.decorate(new GT_Recipe.GT_Recipe_WithAlt(this.inputsBasic, this.outputs, this.fluidInputs, this.fluidOutputs, this.chances, this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, this.neiDesc, this.metadataStorage, this.recipeCategory, this.alts)));
    }

    private void preBuildChecks() {
        if (this.duration == -1) {
            throw new IllegalStateException("no duration");
        }
        if (this.eut == -1) {
            throw new IllegalStateException("no eut");
        }
    }

    private void optimize() {
        if (this.optimize) {
            int i;
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            l.addAll(Arrays.asList(this.inputsBasic));
            l.addAll(Arrays.asList(this.outputs));
            for (i = 0; i < l.size(); ++i) {
                if (l.get(i) != null) continue;
                l.remove(i--);
            }
            block1: for (i = (int)((byte)Math.min(64, this.duration / 16)); i > 1; i = (int)((byte)(i - 1))) {
                if (this.duration / i < 16) continue;
                for (ItemStack stack : l) {
                    if (stack.field_77994_a % i == 0) continue;
                    continue block1;
                }
                for (Object fluidInput : this.fluidInputs) {
                    if (fluidInput.amount % i != 0) continue block1;
                }
                for (Object fluidOutput : this.fluidOutputs) {
                    if (fluidOutput.amount % i != 0) continue block1;
                }
                for (ItemStack itemStack : l) {
                    itemStack.field_77994_a /= i;
                }
                for (Object fluidInput : this.fluidInputs) {
                    fluidInput.amount /= i;
                }
                for (Object fluidOutput : this.fluidOutputs) {
                    fluidOutput.amount /= i;
                }
                this.duration /= i;
            }
            this.optimize = false;
        }
    }

    private <T extends GT_Recipe> T decorate(T r) {
        r.mHidden = this.hidden;
        r.mCanBeBuffered = this.mCanBeBuffered;
        r.mNeedsEmptyOutput = this.mNeedsEmptyOutput;
        r.isNBTSensitive = this.nbtSensitive;
        r.mFakeRecipe = this.fakeRecipe;
        r.mEnabled = this.enabled;
        if (this.neiDesc != null) {
            r.setNeiDesc(this.neiDesc);
        }
        this.applyDefaultSpecialValues(r);
        return r;
    }

    private void applyDefaultSpecialValues(GT_Recipe recipe) {
        if (recipe.mSpecialValue != 0) {
            return;
        }
        int specialValue = 0;
        if (this.getMetadataOrDefault(GT_RecipeConstants.LOW_GRAVITY, false).booleanValue()) {
            specialValue -= 100;
        }
        if (this.getMetadataOrDefault(GT_RecipeConstants.CLEANROOM, false).booleanValue()) {
            specialValue -= 200;
        }
        for (RecipeMetadataKey<Integer> ident : GT_RecipeMapUtil.SPECIAL_VALUE_ALIASES) {
            Integer metadata = this.getMetadataOrDefault(ident, null);
            if (metadata == null) continue;
            specialValue = metadata;
            break;
        }
        recipe.mSpecialValue = specialValue;
    }

    public Collection<GT_Recipe> addTo(IRecipeMap recipeMap) {
        if (this.skip) {
            return Collections.emptyList();
        }
        return recipeMap.doAdd(this);
    }

    public GT_RecipeBuilder reset() {
        this.metadataStorage = null;
        this.alts = null;
        this.chances = null;
        this.duration = -1;
        this.enabled = true;
        this.eut = -1;
        this.fakeRecipe = false;
        this.fluidInputs = null;
        this.fluidOutputs = null;
        this.hidden = false;
        this.inputsBasic = null;
        this.inputsOreDict = null;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        this.nbtSensitive = false;
        this.neiDesc = null;
        this.recipeCategory = null;
        this.optimize = true;
        this.outputs = null;
        this.special = null;
        this.specialValue = 0;
        this.skip = false;
        this.valid = true;
        return this;
    }

    static {
        boolean debugAll = System.getProperties().containsKey("gt.recipebuilder.debug") ? Boolean.getBoolean("gt.recipebuilder.debug") : (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        DEBUG_MODE_NULL = debugAll || Boolean.getBoolean("gt.recipebuilder.debug.null");
        DEBUG_MODE_INVALID = debugAll || Boolean.getBoolean("gt.recipebuilder.debug.invalid");
        DEBUG_MODE_COLLISION = debugAll || Boolean.getBoolean("gt.recipebuilder.debug.collision");
        boolean panicAll = Boolean.getBoolean("gt.recipebuilder.panic");
        PANIC_MODE_NULL = panicAll || Boolean.getBoolean("gt.recipebuilder.panic.null");
        PANIC_MODE_INVALID = panicAll || Boolean.getBoolean("gt.recipebuilder.panic.invalid");
        PANIC_MODE_COLLISION = panicAll || Boolean.getBoolean("gt.recipebuilder.panic.collision");
    }
}

