/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import gregtech.api.enums.GT_Values;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SingleRecipeCheck {
    @Nonnull
    private final GT_Recipe recipe;
    @Nonnull
    private final RecipeMap<?> recipeMap;
    @Nonnull
    private final ImmutableMap<GT_Utility.ItemId, Integer> itemCost;
    @Nonnull
    private final ImmutableMap<Fluid, Integer> fluidCost;
    private final int totalItemCost;
    private final int totalFluidCost;

    private SingleRecipeCheck(@Nonnull GT_Recipe recipe, @Nonnull RecipeMap<?> recipeMap, @Nonnull ImmutableMap<GT_Utility.ItemId, Integer> itemCost, @Nonnull ImmutableMap<Fluid, Integer> fluidCost) {
        this.recipe = recipe;
        this.recipeMap = recipeMap;
        this.itemCost = itemCost;
        this.fluidCost = fluidCost;
        this.totalItemCost = itemCost.values().stream().mapToInt(Integer::intValue).sum();
        this.totalFluidCost = fluidCost.values().stream().mapToInt(Integer::intValue).sum();
    }

    @Nonnull
    public GT_Recipe getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public RecipeMap<?> getRecipeMap() {
        return this.recipeMap;
    }

    public int checkRecipeInputs(boolean consumeInputs, int maxParallel, ItemStack[] itemInputs, FluidStack[] fluidInputs) {
        int currentParallel = maxParallel;
        if (this.totalItemCost > 0) {
            HashMap<GT_Utility.ItemId, Integer> itemMap = new HashMap<GT_Utility.ItemId, Integer>();
            for (FluidStack fluidStack : itemInputs) {
                if (fluidStack == null) continue;
                itemMap.merge(GT_Utility.ItemId.createNoCopy((ItemStack)fluidStack), fluidStack.field_77994_a, Integer::sum);
            }
            for (Map.Entry costEntry : this.itemCost.entrySet()) {
                if ((currentParallel = Math.min(currentParallel, itemMap.getOrDefault(costEntry.getKey(), 0) / (Integer)costEntry.getValue())) > 0) continue;
                return 0;
            }
        }
        if (this.totalFluidCost > 0) {
            HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
            for (UnmodifiableIterator unmodifiableIterator : fluidInputs) {
                if (unmodifiableIterator == null) continue;
                fluidMap.merge(unmodifiableIterator.getFluid(), unmodifiableIterator.amount, Integer::sum);
            }
            for (Map.Entry costEntry : this.fluidCost.entrySet()) {
                if ((currentParallel = Math.min(currentParallel, fluidMap.getOrDefault(costEntry.getKey(), 0) / (Integer)costEntry.getValue())) > 0) continue;
                return 0;
            }
        }
        int finalParallel = currentParallel;
        if (consumeInputs) {
            int paid;
            int runningCost;
            GT_Utility.ItemId key;
            if (this.totalItemCost > 0) {
                int remainingItemCost = this.totalItemCost * finalParallel;
                Map<GT_Utility.ItemId, Integer> runningItemCost = this.itemCost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Integer)entry.getValue() * finalParallel));
                UnmodifiableIterator unmodifiableIterator = itemInputs;
                int n = ((UnmodifiableIterator)unmodifiableIterator).length;
                for (int i = 0; i < n; ++i) {
                    UnmodifiableIterator itemStack = unmodifiableIterator[i];
                    if (itemStack == null) continue;
                    key = GT_Utility.ItemId.createNoCopy((ItemStack)itemStack);
                    runningCost = runningItemCost.getOrDefault(key, 0);
                    paid = Math.min(itemStack.field_77994_a, runningCost);
                    itemStack.field_77994_a -= paid;
                    runningItemCost.put(key, runningCost - paid);
                    if ((remainingItemCost -= paid) <= 0) break;
                }
            }
            if (this.totalFluidCost > 0) {
                int remainingFluidCost = this.totalFluidCost * finalParallel;
                Map<Fluid, Integer> runningFluidCost = this.fluidCost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Integer)entry.getValue() * finalParallel));
                for (UnmodifiableIterator fluidStack : fluidInputs) {
                    if (fluidStack == null) continue;
                    key = fluidStack.getFluid();
                    runningCost = runningFluidCost.getOrDefault(key, 0);
                    paid = Math.min(fluidStack.amount, runningCost);
                    fluidStack.amount -= paid;
                    runningFluidCost.put((Fluid)key, runningCost - paid);
                    if ((remainingFluidCost -= paid) <= 0) break;
                }
            }
        }
        return finalParallel;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("recipemap", this.recipeMap.unlocalizedName);
        if (this.recipe.mInputs != null) {
            tag.func_74782_a("inputs", (NBTBase)SingleRecipeCheck.writeList(this.recipe.mInputs, GT_Utility::saveItem));
        }
        if (this.recipe.mOutputs != null) {
            tag.func_74782_a("outputs", (NBTBase)SingleRecipeCheck.writeList(this.recipe.mOutputs, GT_Utility::saveItem));
        }
        if (this.recipe.mChances != null) {
            tag.func_74783_a("chances", this.recipe.mChances);
        }
        if (this.recipe.mFluidInputs != null) {
            tag.func_74782_a("fInputs", (NBTBase)SingleRecipeCheck.writeList(this.recipe.mFluidInputs, (T s) -> s == null ? new NBTTagCompound() : s.writeToNBT(new NBTTagCompound())));
        }
        if (this.recipe.mFluidOutputs != null) {
            tag.func_74782_a("fOutputs", (NBTBase)SingleRecipeCheck.writeList(this.recipe.mFluidOutputs, (T s) -> s == null ? new NBTTagCompound() : s.writeToNBT(new NBTTagCompound())));
        }
        tag.func_74768_a("eut", this.recipe.mEUt);
        tag.func_74768_a("duration", this.recipe.mDuration);
        tag.func_74768_a("specialValue", this.recipe.mSpecialValue);
        tag.func_74782_a("itemCost", (NBTBase)SingleRecipeCheck.writeList(this.itemCost.entrySet(), (T e) -> {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74782_a("id", (NBTBase)((GT_Utility.ItemId)e.getKey()).writeToNBT());
            ret.func_74768_a("count", ((Integer)e.getValue()).intValue());
            return ret;
        }));
        tag.func_74782_a("fluidCost", (NBTBase)SingleRecipeCheck.writeList(this.fluidCost.entrySet(), (T e) -> {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74778_a("id", ((Fluid)e.getKey()).getName());
            ret.func_74768_a("count", ((Integer)e.getValue()).intValue());
            return ret;
        }));
        return tag;
    }

    private static <T, NBT extends NBTBase> NBTTagList writeList(T[] arr, Function<T, NBT> ser) {
        return SingleRecipeCheck.writeList(Arrays.asList(arr), ser);
    }

    private static <T, NBT extends NBTBase> NBTTagList writeList(Collection<T> arr, Function<T, NBT> ser) {
        NBTTagList l = new NBTTagList();
        for (T t : arr) {
            l.func_74742_a((NBTBase)ser.apply(t));
        }
        return l;
    }

    @Nullable
    public static SingleRecipeCheck tryLoad(RecipeMap<?> recipeMap, NBTTagCompound tag) {
        String mapName;
        RecipeMap<?> foundMap;
        if (tag == null || tag.func_82582_d()) {
            return null;
        }
        RecipeMap<?> mapToUse = tag.func_74764_b("recipemap") ? ((foundMap = RecipeMap.ALL_RECIPE_MAPS.get(mapName = tag.func_74779_i("recipemap"))) != null ? foundMap : recipeMap) : recipeMap;
        if (mapToUse == null) {
            return null;
        }
        GT_Recipe foundRecipe = SingleRecipeCheck.tryFindRecipe(mapToUse, tag);
        if (foundRecipe == null) {
            return null;
        }
        return new SingleRecipeCheck(foundRecipe, mapToUse, SingleRecipeCheck.loadItemCost(tag), SingleRecipeCheck.loadFluidCost(tag));
    }

    private static ImmutableMap<Fluid, Integer> loadFluidCost(NBTTagCompound tag) {
        return GT_Utility.streamCompounds(tag.func_150295_c("fluidCost", 10)).collect(GT_Utility.toImmutableMapSerial(t -> FluidRegistry.getFluid((String)t.func_74779_i("id")), t -> t.func_74762_e("count")));
    }

    private static ImmutableMap<GT_Utility.ItemId, Integer> loadItemCost(NBTTagCompound tag) {
        return GT_Utility.streamCompounds(tag.func_150295_c("itemCost", 10)).collect(GT_Utility.toImmutableMapSerial(t -> GT_Utility.ItemId.create(t.func_74775_l("id")), t -> t.func_74762_e("count")));
    }

    private static GT_Recipe tryFindRecipe(@Nonnull RecipeMap<?> recipeMap, NBTTagCompound tag) {
        ItemStack[] inputs = (ItemStack[])GT_Utility.streamCompounds(tag.func_150295_c("inputs", 10)).map(GT_Utility::loadItem).toArray(ItemStack[]::new);
        ItemStack[] outputs = (ItemStack[])GT_Utility.streamCompounds(tag.func_150295_c("outputs", 10)).map(GT_Utility::loadItem).toArray(ItemStack[]::new);
        Object[] fInputs = (FluidStack[])GT_Utility.streamCompounds(tag.func_150295_c("fInputs", 10)).map(FluidStack::loadFluidStackFromNBT).toArray(FluidStack[]::new);
        Object[] fOutputs = (FluidStack[])GT_Utility.streamCompounds(tag.func_150295_c("fOutputs", 10)).map(FluidStack::loadFluidStackFromNBT).toArray(FluidStack[]::new);
        int eut = tag.func_74762_e("eut");
        GT_Recipe found = recipeMap.findRecipe(null, false, GT_Values.V[GT_Utility.getTier(eut)], (FluidStack[])fInputs, inputs);
        int[] chances = tag.func_74759_k("chances");
        if (chances.length == 0) {
            chances = null;
        }
        if (!(found != null && GT_Utility.equals(inputs, found.mInputs) && Arrays.equals(fInputs, found.mFluidInputs) && GT_Utility.equals(outputs, found.mOutputs) && Arrays.equals(fOutputs, found.mFluidOutputs) && Arrays.equals(chances, found.mChances) && found.mDuration == tag.func_74762_e("duration") && found.mEUt == eut && found.mSpecialValue == tag.func_74762_e("specialValue"))) {
            return null;
        }
        return found;
    }

    private static ImmutableMap<GT_Utility.ItemId, Integer> buildItemMap(ItemStack[] inputs) {
        HashMap<GT_Utility.ItemId, Integer> itemMap = new HashMap<GT_Utility.ItemId, Integer>();
        for (ItemStack itemStack : inputs) {
            if (itemStack == null) continue;
            itemMap.merge(GT_Utility.ItemId.create(itemStack), itemStack.field_77994_a, Integer::sum);
        }
        return ImmutableMap.copyOf(itemMap);
    }

    private static ImmutableMap<Fluid, Integer> buildFluidMap(FluidStack[] fluids) {
        HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
        for (FluidStack fluidStack : fluids) {
            if (fluidStack == null) continue;
            fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
        }
        return ImmutableMap.copyOf(fluidMap);
    }

    public static Builder builder(@Nonnull RecipeMap<?> recipeMap) {
        return new Builder(Objects.requireNonNull(recipeMap));
    }

    public static class Builder {
        private final RecipeMap<?> recipeMap;
        private Map<GT_Utility.ItemId, Integer> beforeItems;
        private Map<Fluid, Integer> beforeFluids;
        private Map<GT_Utility.ItemId, Integer> afterItems;
        private Map<Fluid, Integer> afterFluids;
        private GT_Recipe recipe;

        private Builder(@Nonnull RecipeMap<?> recipeMap) {
            this.recipeMap = recipeMap;
        }

        public Builder setBefore(ItemStack[] inputs, FluidStack[] fluids) {
            this.beforeItems = SingleRecipeCheck.buildItemMap(inputs);
            this.beforeFluids = SingleRecipeCheck.buildFluidMap(fluids);
            return this;
        }

        public Builder setAfter(ItemStack[] inputs, FluidStack[] fluids) {
            this.afterItems = SingleRecipeCheck.buildItemMap(inputs);
            this.afterFluids = SingleRecipeCheck.buildFluidMap(fluids);
            return this;
        }

        public Builder setRecipe(@Nonnull GT_Recipe recipe) {
            this.recipe = recipe;
            return this;
        }

        private ImmutableMap<GT_Utility.ItemId, Integer> buildItemCost() {
            ImmutableMap.Builder itemCostBuilder = ImmutableMap.builder();
            for (Map.Entry<GT_Utility.ItemId, Integer> entry : this.beforeItems.entrySet()) {
                int cost = entry.getValue() - this.afterItems.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                itemCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            return itemCostBuilder.build();
        }

        private ImmutableMap<Fluid, Integer> buildFluidCost() {
            ImmutableMap.Builder fluidCostBuilder = ImmutableMap.builder();
            for (Map.Entry<Fluid, Integer> entry : this.beforeFluids.entrySet()) {
                int cost = entry.getValue() - this.afterFluids.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                fluidCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            return fluidCostBuilder.build();
        }

        public SingleRecipeCheck build() {
            if (this.recipe == null) {
                throw new IllegalStateException("recipe is not set");
            }
            return new SingleRecipeCheck(this.recipe, this.recipeMap, this.buildItemCost(), this.buildFluidCost());
        }
    }
}

