/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import codechicken.nei.PositionedStack;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GT_Mod;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.GT_GUIColorOverride;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipeProperties;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.IRecipeMetadataStorage;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeMapFrontend {
    protected final BasicUIProperties uiProperties;
    protected final NEIRecipeProperties neiProperties;
    protected final GT_GUIColorOverride colorOverride;

    public RecipeMapFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        this.colorOverride = GT_GUIColorOverride.get(GT_UITextures.BACKGROUND_NEI_SINGLE_RECIPE.location);
        this.uiProperties = uiPropertiesBuilder.itemInputPositionsGetter(this::getItemInputPositions).itemOutputPositionsGetter(this::getItemOutputPositions).specialItemPositionGetter(this::getSpecialItemPosition).fluidInputPositionsGetter(this::getFluidInputPositions).fluidOutputPositionsGetter(this::getFluidOutputPositions).build();
        this.neiProperties = neiPropertiesBuilder.build();
    }

    public BasicUIProperties getUIProperties() {
        return this.uiProperties;
    }

    public NEIRecipeProperties getNEIProperties() {
        return this.neiProperties;
    }

    public ModularWindow.Builder createNEITemplate(IItemHandlerModifiable itemInputsInventory, IItemHandlerModifiable itemOutputsInventory, IItemHandlerModifiable specialSlotInventory, IItemHandlerModifiable fluidInputsInventory, IItemHandlerModifiable fluidOutputsInventory, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        ModularWindow.Builder builder = ModularWindow.builder((Size)this.neiProperties.recipeBackgroundSize).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_NEI_SINGLE_RECIPE});
        UIHelper.forEachSlots((i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)itemInputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)itemOutputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> {
            if (this.uiProperties.useSpecialSlot) {
                builder.widget(SlotWidget.phantom((IItemHandlerModifiable)specialSlotInventory, (int)0).setBackground(backgrounds).setPos(pos).setSize(18, 18));
            }
        }, (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)fluidInputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)fluidOutputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (IDrawable)ModularUITextures.ITEM_SLOT, (IDrawable)ModularUITextures.FLUID_SLOT, this.uiProperties, this.uiProperties.maxItemInputs, this.uiProperties.maxItemOutputs, this.uiProperties.maxFluidInputs, this.uiProperties.maxFluidOutputs, SteamVariant.NONE, windowOffset);
        if (this.uiProperties.useProgressBar) {
            this.addProgressBar(builder, progressSupplier, windowOffset);
        }
        this.addGregTechLogo(builder, windowOffset);
        for (Pair<IDrawable, Pair<Size, Pos2d>> specialTexture : this.uiProperties.specialTextures) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)specialTexture.getLeft()).setSize((Size)((Pair)specialTexture.getRight()).getLeft()).setPos(((Pos2d)((Pair)specialTexture.getRight()).getRight()).add(windowOffset)));
        }
        return builder;
    }

    public void addProgressBar(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        assert (this.uiProperties.progressBarTexture != null);
        builder.widget(new ProgressBar().setTexture(this.uiProperties.progressBarTexture.get(), 20).setDirection(this.uiProperties.progressBarDirection).setProgress(progressSupplier).setSynced(false, false).setPos(this.uiProperties.progressBarPos.add(windowOffset)).setSize(this.uiProperties.progressBarSize));
    }

    public void addGregTechLogo(ModularWindow.Builder builder, Pos2d windowOffset) {
        builder.widget(new DrawableWidget().setDrawable(this.uiProperties.logo).setSize(this.uiProperties.logoSize).setPos(this.uiProperties.logoPos.add(windowOffset)));
    }

    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getItemInputPositions(itemInputCount);
    }

    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getItemOutputPositions(itemOutputCount);
    }

    public Pos2d getSpecialItemPosition() {
        return UIHelper.getSpecialItemPosition();
    }

    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getFluidInputPositions(fluidInputCount);
    }

    public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
        return UIHelper.getFluidOutputPositions(fluidOutputCount);
    }

    public void drawDescription(RecipeDisplayInfo recipeInfo) {
        this.drawEnergyInfo(recipeInfo);
        this.drawDurationInfo(recipeInfo);
        this.drawSpecialInfo(recipeInfo);
        this.drawMetadataInfo(recipeInfo);
        this.drawRecipeOwnerInfo(recipeInfo);
    }

    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        recipeInfo.overclockDescriber.drawEnergyInfo(recipeInfo);
    }

    protected void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
        recipeInfo.overclockDescriber.drawDurationInfo(recipeInfo);
    }

    protected void drawSpecialInfo(RecipeDisplayInfo recipeInfo) {
        String[] recipeDesc = recipeInfo.recipe.getNeiDesc();
        if (recipeDesc != null) {
            for (String s : recipeDesc) {
                recipeInfo.drawText(s);
            }
        } else {
            recipeInfo.drawTextMultipleLines(this.neiProperties.neiSpecialInfoFormatter.format(recipeInfo));
        }
    }

    protected void drawMetadataInfo(RecipeDisplayInfo recipeInfo) {
        IRecipeMetadataStorage metadataStorage = recipeInfo.recipe.getMetadataStorage();
        for (Map.Entry<RecipeMetadataKey<?>, Object> entry : metadataStorage.getEntries()) {
            entry.getKey().drawInfo(recipeInfo, entry.getValue());
        }
    }

    protected void drawRecipeOwnerInfo(RecipeDisplayInfo recipeInfo) {
        GT_Recipe recipe = recipeInfo.recipe;
        if (GT_Mod.gregtechproxy.mNEIRecipeOwner) {
            if (recipe.owners.size() > 1) {
                recipeInfo.drawText(EnumChatFormatting.ITALIC + GT_Utility.trans("273", "Original Recipe by: ") + recipe.owners.get(0).getName());
                for (int i = 1; i < recipe.owners.size(); ++i) {
                    recipeInfo.drawText(EnumChatFormatting.ITALIC + GT_Utility.trans("274", "Modified by: ") + recipe.owners.get(i).getName());
                }
            } else if (!recipe.owners.isEmpty()) {
                recipeInfo.drawText(EnumChatFormatting.ITALIC + GT_Utility.trans("272", "Recipe by: ") + recipe.owners.get(0).getName());
            }
        }
        if (GT_Mod.gregtechproxy.mNEIRecipeOwnerStackTrace && recipe.stackTraces != null && !recipe.stackTraces.isEmpty()) {
            recipeInfo.drawText("stackTrace:");
            for (String stackTrace : recipe.stackTraces.get(0)) {
                recipeInfo.drawText(stackTrace);
            }
        }
    }

    public List<String> handleNEIItemTooltip(ItemStack stack, List<String> currentTip, GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        for (PositionedStack pStack : neiCachedRecipe.mInputs) {
            if (stack != pStack.item) continue;
            if (!(pStack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) break;
            currentTip = this.handleNEIItemInputTooltip(currentTip, (GT_NEI_DefaultHandler.FixedPositionedStack)pStack);
            break;
        }
        for (PositionedStack pStack : neiCachedRecipe.mOutputs) {
            if (stack != pStack.item) continue;
            if (!(pStack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) break;
            currentTip = this.handleNEIItemOutputTooltip(currentTip, (GT_NEI_DefaultHandler.FixedPositionedStack)pStack);
            break;
        }
        return currentTip;
    }

    protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isNotConsumed()) {
            currentTip.add(EnumChatFormatting.GRAY + GT_Utility.trans("151", "Does not get consumed in the process"));
        }
        return currentTip;
    }

    protected List<String> handleNEIItemOutputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isChanceBased()) {
            currentTip.add(EnumChatFormatting.GRAY + GT_Utility.trans("150", "Chance: ") + pStack.getChanceText());
        }
        return currentTip;
    }

    public void drawNEIOverlays(GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        for (PositionedStack stack : neiCachedRecipe.mInputs) {
            if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) continue;
            this.drawNEIOverlayForInput((GT_NEI_DefaultHandler.FixedPositionedStack)stack);
        }
        for (PositionedStack stack : neiCachedRecipe.mOutputs) {
            if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) continue;
            this.drawNEIOverlayForOutput((GT_NEI_DefaultHandler.FixedPositionedStack)stack);
        }
    }

    protected void drawNEIOverlayForInput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
        if (stack.isNotConsumed()) {
            this.drawNEIOverlayText("NC", stack);
        }
    }

    protected void drawNEIOverlayForOutput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
        if (stack.isChanceBased()) {
            this.drawNEIOverlayText(stack.getChanceText(), stack);
        }
    }

    protected void drawNEIOverlayText(String text, PositionedStack stack, int color, float scale, boolean shadow, Alignment alignment) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontRenderer.func_78256_a(text);
        int x = (int)((float)(stack.relx + 8 + 8 * alignment.x) / scale) - width / 2 * (alignment.x + 1);
        int y = (int)((float)(stack.rely + 8 + 8 * alignment.y) / scale) - fontRenderer.field_78288_b / 2 * (alignment.y + 1) - (alignment.y - 1) / 2;
        GlStateManager.pushMatrix();
        GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_85187_a(text, x, y, color, shadow);
        GlStateManager.popMatrix();
    }

    protected void drawNEIOverlayText(String text, PositionedStack stack) {
        this.drawNEIOverlayText(text, stack, this.colorOverride.getTextColorOrDefault("nei_overlay_yellow", 16635957), 0.5f, false, Alignment.TopLeft);
    }

    public static List<Supplier<Float>> splitProgress(Supplier<Float> progress, int ... progressbarLengthArray) {
        float lengthSum = IntStream.of(progressbarLengthArray).sum();
        ArrayList<Supplier<Float>> ret = new ArrayList<Supplier<Float>>();
        float currentLengthSum = 0.0f;
        for (int progressbarLength : progressbarLengthArray) {
            float speed = lengthSum / (float)progressbarLength;
            float offset = currentLengthSum / lengthSum;
            ret.add(() -> {
                float current = ((Float)progress.get()).floatValue();
                return Float.valueOf((current - offset) * speed);
            });
            currentLengthSum += (float)progressbarLength;
        }
        return ret;
    }

    @FunctionalInterface
    public static interface FrontendCreator {
        public RecipeMapFrontend create(BasicUIPropertiesBuilder var1, NEIRecipePropertiesBuilder var2);
    }
}

