/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetricsExporter;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ValidationResult;
import gregtech.api.util.ValidationType;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnegative;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class GT_MetaTileEntity_OilDrillBase
extends GT_MetaTileEntity_DrillerBase
implements IMetricsExporter {
    private final ArrayList<Chunk> mOilFieldChunks = new ArrayList();
    private int mOilId = 0;
    private int mOilFlow = 0;
    private int chunkRangeConfig = this.getRangeInChunks();
    @NotNull
    private String clientFluidType = "";
    @NotNull
    private String clientPumpRate = "";
    @NotNull
    private String clientReservoirContents = "";

    public GT_MetaTileEntity_OilDrillBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_OilDrillBase(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex)};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mOilId", this.mOilId);
        aNBT.func_74768_a("chunkRangeConfig", this.chunkRangeConfig);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mOilId = aNBT.func_74762_e("mOilId");
        if (aNBT.func_74764_b("chunkRangeConfig")) {
            this.chunkRangeConfig = aNBT.func_74762_e("chunkRangeConfig");
        }
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Pump").addInfo("Controller Block for the Oil/Gas/Fluid Drilling Rig " + (tierSuffix != null ? tierSuffix : "")).addInfo("Works on " + this.getRangeInChunks() + "x" + this.getRangeInChunks() + " chunks").addInfo("Use a Screwdriver to configure range").addInfo("Use Programmed Circuits to ignore near exhausted oil field").addInfo("If total circuit # is greater than output amount it will halt. If it worked right.").addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch("1x " + GT_Values.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes or Circuits, optional, any base casing", 1).addOutputHatch("Any base casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    protected abstract int getRangeInChunks();

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        int oldChunkRange = this.chunkRangeConfig;
        if (aPlayer.func_70093_af()) {
            if (this.chunkRangeConfig > 0) {
                --this.chunkRangeConfig;
            }
            if (this.chunkRangeConfig == 0) {
                this.chunkRangeConfig = this.getRangeInChunks();
            }
        } else {
            if (this.chunkRangeConfig <= this.getRangeInChunks()) {
                ++this.chunkRangeConfig;
            }
            if (this.chunkRangeConfig > this.getRangeInChunks()) {
                this.chunkRangeConfig = 1;
            }
        }
        if (oldChunkRange != this.chunkRangeConfig) {
            this.mOilFieldChunks.clear();
        }
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workareaset") + " " + this.chunkRangeConfig + "x" + this.chunkRangeConfig + StatCollector.func_74838_a((String)"GT5U.machines.chunks"));
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mOutputHatches.isEmpty() && this.mEnergyHatches.size() == 1;
    }

    @Override
    protected List<IHatchElement<? super GT_MetaTileEntity_DrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)GT_HatchElement.InputBus, (Object)GT_HatchElement.OutputHatch, (Object)GT_HatchElement.Maintenance, (Object)GT_HatchElement.Energy);
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(0, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -7 << (tier << 1);
        this.mMaxProgresstime = Math.max(1, (this.workState == 1 ? 64 * (this.chunkRangeConfig * this.chunkRangeConfig) >> this.getMinTier() - 1 : 120) >> tier);
    }

    protected float computeSpeed() {
        return 0.5f + (float)(GT_Utility.getTier(this.getMaxInputVoltage()) - this.getMinTier()) * 0.25f;
    }

    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        switch (this.tryLowerPipeState(true)) {
            case 0: {
                this.workState = 0;
                this.setElectricityStats();
                return true;
            }
            case 3: {
                this.workState = 2;
                return true;
            }
        }
        if (this.reachingVoidOrBedrock() && this.tryFillChunkList()) {
            float speed;
            ValidationResult<FluidStack> pumpResult;
            if (this.mWorkChunkNeedsReload) {
                this.mCurrentChunk = new ChunkCoordIntPair(xDrill >> 4, zDrill >> 4);
                GT_ChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), null);
                this.mWorkChunkNeedsReload = false;
            }
            if ((pumpResult = this.tryPumpOil(speed = this.computeSpeed())).getType() != ValidationType.VALID) {
                this.mEUt = 0;
                this.mMaxProgresstime = 0;
                this.setRuntimeFailureReason(CheckRecipeResultRegistry.FLUID_OUTPUT_FULL);
                return false;
            }
            FluidStack tFluid = pumpResult.getResult();
            if (tFluid != null && tFluid.amount > this.getTotalConfigValue()) {
                this.mOutputFluids = new FluidStack[]{tFluid};
                return true;
            }
        }
        GT_ChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
        this.workState = 2;
        this.setShutdownReason(StatCollector.func_74838_a((String)"GT5U.gui.text.drill_exhausted"));
        return true;
    }

    private boolean tryFillChunkList() {
        FluidStack tFluid;
        if (this.mOilId <= 0) {
            tFluid = GT_UndergroundOil.undergroundOilReadInformation(this.getBaseMetaTileEntity());
            if (tFluid == null) {
                return false;
            }
            this.mOilId = tFluid.getFluidID();
        }
        if (GT_Values.debugDriller) {
            GT_Log.out.println(" Driller on  fluid = " + this.mOilId);
        }
        FluidStack tOil = new FluidStack(FluidRegistry.getFluid((int)this.mOilId), 0);
        if (this.mOilFieldChunks.isEmpty()) {
            Chunk tChunk = this.getBaseMetaTileEntity().getWorld().func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
            int range = this.chunkRangeConfig;
            int xChunk = Math.floorDiv(tChunk.field_76635_g, range) * range;
            int zChunk = Math.floorDiv(tChunk.field_76647_h, range) * range;
            if (GT_Values.debugDriller) {
                GT_Log.out.println("tChunk.xPosition = " + tChunk.field_76635_g + " tChunk.zPosition = " + tChunk.field_76647_h + " xChunk = " + xChunk + " zChunk = " + zChunk);
            }
            for (int i = 0; i < range; ++i) {
                for (int j = 0; j < range; ++j) {
                    if (GT_Values.debugDriller) {
                        GT_Log.out.println(" getChunkX = " + (xChunk + i) + " getChunkZ = " + (zChunk + j));
                    }
                    tChunk = this.getBaseMetaTileEntity().getWorld().func_72964_e(xChunk + i, zChunk + j);
                    tFluid = GT_UndergroundOil.undergroundOilReadInformation(tChunk);
                    if (GT_Values.debugDriller) {
                        GT_Log.out.println(" Fluid in chunk = " + tFluid.getFluid().getID());
                    }
                    if (!tOil.isFluidEqual(tFluid) || tFluid.amount <= 0) continue;
                    this.mOilFieldChunks.add(tChunk);
                    if (!GT_Values.debugDriller) continue;
                    GT_Log.out.println(" Matching fluid, quantity = " + tFluid.amount);
                }
            }
        }
        if (GT_Values.debugDriller) {
            GT_Log.out.println("mOilFieldChunks.size = " + this.mOilFieldChunks.size());
        }
        return !this.mOilFieldChunks.isEmpty();
    }

    protected ValidationResult<FluidStack> tryPumpOil(float speed) {
        FluidStack simulatedOil;
        if (this.mOilId <= 0) {
            return null;
        }
        if (GT_Values.debugDriller) {
            GT_Log.out.println(" pump speed = " + speed);
        }
        if (this.protectsExcessFluid() && !this.canOutputAll(new FluidStack[]{simulatedOil = this.pumpOil(speed, true)})) {
            return ValidationResult.of(ValidationType.INVALID, null);
        }
        FluidStack pumpedOil = this.pumpOil(speed, false);
        this.mOilFlow = pumpedOil.amount;
        return ValidationResult.of(ValidationType.VALID, pumpedOil.amount == 0 ? null : pumpedOil);
    }

    protected FluidStack pumpOil(@Nonnegative float speed, boolean simulate) {
        if (speed < 0.0f) {
            throw new IllegalArgumentException("Don't pass negative speed");
        }
        ArrayList<Chunk> emptyChunks = new ArrayList<Chunk>();
        FluidStack returnOil = new FluidStack(FluidRegistry.getFluid((int)this.mOilId), 0);
        for (Chunk tChunk : this.mOilFieldChunks) {
            FluidStack pumped = GT_UndergroundOil.undergroundOil(tChunk, simulate ? -speed : speed);
            if (GT_Values.debugDriller) {
                GT_Log.out.println(" chunkX = " + tChunk.func_76632_l().field_77276_a + " chunkZ = " + tChunk.func_76632_l().field_77275_b);
                if (pumped != null) {
                    GT_Log.out.println("     Fluid pumped = " + pumped.amount);
                } else {
                    GT_Log.out.println("     No fluid pumped ");
                }
            }
            if (pumped == null || pumped.amount < 1) {
                emptyChunks.add(tChunk);
                continue;
            }
            if (!returnOil.isFluidEqual(pumped)) continue;
            returnOil.amount += pumped.amount;
        }
        for (Chunk tChunk : emptyChunks) {
            this.mOilFieldChunks.remove(tChunk);
        }
        return returnOil;
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_PUMP_OP;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.oilfluidpump") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.chunkRangeConfig) + " x " + GT_Utility.formatNumbers(this.chunkRangeConfig) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.chunks"), "Drilling fluid: " + EnumChatFormatting.GREEN + this.getFluidName() + EnumChatFormatting.RESET, "Drilling flow: " + EnumChatFormatting.GREEN + this.getFlowRatePerTick() + EnumChatFormatting.RESET + " L/t"));
        l.addAll(Arrays.asList(super.getInfoData()));
        return l.toArray(new String[0]);
    }

    @Override
    @NotNull
    public List<String> reportMetrics() {
        boolean machineIsActive = this.getBaseMetaTileEntity().isActive();
        String failureReason = this.getFailureReason().map(reason -> StatCollector.func_74837_a((String)"GT5U.gui.text.drill_offline_reason", (Object[])new Object[]{reason})).orElseGet(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.drill_offline_generic", (Object[])new Object[0]));
        if (this.workState == 1) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)StatCollector.func_74837_a((String)"GT5U.gui.text.pump_fluid_type", (Object[])new Object[]{this.getFluidName()}));
            if (machineIsActive) {
                builder.add((Object[])new String[]{StatCollector.func_74837_a((String)"GT5U.gui.text.pump_rate.1", (Object[])new Object[]{EnumChatFormatting.AQUA + this.getFlowRatePerTick()}) + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_rate.2"), this.getReservoirContents() + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_recovery.2")});
            } else {
                builder.add((Object)failureReason);
            }
            return builder.build();
        }
        if (machineIsActive) {
            ImmutableList immutableList;
            switch (this.workState) {
                case 0: {
                    immutableList = ImmutableList.of((Object)StatCollector.func_74838_a((String)"GT5U.gui.text.deploying_pipe"));
                    break;
                }
                case 2: 
                case 3: {
                    immutableList = ImmutableList.of((Object)StatCollector.func_74838_a((String)"GT5U.gui.text.retracting_pipe"));
                    break;
                }
                default: {
                    immutableList = ImmutableList.of();
                }
            }
            return immutableList;
        }
        return ImmutableList.of((Object)failureReason);
    }

    @NotNull
    protected String getFlowRatePerTick() {
        return GT_Utility.formatNumbers(this.mMaxProgresstime > 0 ? (long)(this.mOilFlow / this.mMaxProgresstime) : 0L);
    }

    @NotNull
    private String getFluidName() {
        if (this.mOilId > 0) {
            Fluid fluid = FluidRegistry.getFluid((int)this.mOilId);
            return fluid.getLocalizedName(new FluidStack(fluid, 0));
        }
        return "None";
    }

    @NotNull
    private String getReservoirContents() {
        int amount = 0;
        for (Chunk chunk : this.mOilFieldChunks) {
            FluidStack fluidStack = GT_UndergroundOil.undergroundOil(chunk, -1.0f);
            if (fluidStack == null) continue;
            amount += fluidStack.amount;
        }
        return StatCollector.func_74837_a((String)"GT5U.gui.text.pump_recovery.1", (Object[])new Object[]{GT_Utility.formatNumbers(amount)});
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.pump_fluid_type", (Object[])new Object[]{this.clientFluidType})).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 1))).widget(TextWidget.dynamicString(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.pump_rate.1", (Object[])new Object[]{EnumChatFormatting.AQUA + this.clientPumpRate}) + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_rate.2")).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 1))).widget(TextWidget.dynamicString(() -> EnumChatFormatting.GRAY + this.clientReservoirContents + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_recovery.2")).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 1))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.workState, newInt -> {
            this.workState = newInt;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getFluidName, newString -> {
            this.clientFluidType = newString;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getFlowRatePerTick, newString -> {
            this.clientPumpRate = newString;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getReservoirContents, newString -> {
            this.clientReservoirContents = newString;
        }));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }
}

