/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_DieselEngine
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_DieselEngine>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<GT_MetaTileEntity_DieselEngine>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_DieselEngine>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_DieselEngine> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GT_MetaTileEntity_DieselEngine.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"---", "iii", "chc", "chc", "ccc"}, {"---", "i~i", "hgh", "hgh", "cdc"}, {"---", "iii", "chc", "chc", "ccc"}})).addElement('i', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getIntakeBlock(), (int)t.getIntakeMeta()))).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))).addElement('g', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getGearboxBlock(), (int)t.getGearboxMeta()))).addElement('d', (IStructureElement)StructureUtility.lazy(t -> GT_HatchElement.Dynamo.newAny(t.getCasingTextureIndex(), 2))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_DieselEngine.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.Muffler, GT_HatchElement.Maintenance).casingIndex(t.getCasingTextureIndex()).dot(1).buildAndChain(t.getCasingBlock(), t.getCasingMeta()))).build();
        }
    };
    protected int fuelConsumption = 0;
    protected int fuelValue = 0;
    protected int fuelRemaining = 0;
    protected boolean boostEu = false;

    public GT_MetaTileEntity_DieselEngine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_DieselEngine(String aName) {
        super(aName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Combustion Generator").addInfo("Controller block for the Large Combustion Engine").addInfo("Supply Diesel Fuels and 1000L of Lubricant per hour to run").addInfo("Supply 40L/s of Oxygen to boost output (optional)").addInfo("Default: Produces 2048EU/t at 100% fuel efficiency").addInfo("Boosted: Produces 6144EU/t at 150% fuel efficiency").addInfo("You need to wait for it to reach 300% to output full power").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 4, false).addController("Front center").addCasingInfoRange("Stable Titanium Machine Casing", 16, 22, false).addOtherStructurePart("Titanium Gear Box Machine Casing", "Inner 2 blocks").addOtherStructurePart("Engine Intake Machine Casing", "8x, ring around controller").addStructureInfo("Engine Intake Casings must not be obstructed in front (only air blocks)").addDynamoHatch("Back center", 2).addMaintenanceHatch("One of the casings next to a Gear Box", 1).addMufflerHatch("Top middle back, above the rear Gear Box", 1).addInputHatch("Diesel Fuel, next to a Gear Box", 1).addInputHatch("Lubricant, next to a Gear Box", 1).addInputHatch("Oxygen, optional, next to a Gear Box", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50]};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    public RecipeMap<FuelBackend> getRecipeMap() {
        return RecipeMaps.dieselFuels;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    protected int getNominalOutput() {
        return 2048;
    }

    protected Materials getBooster() {
        return Materials.Oxygen;
    }

    protected int getBoostFactor() {
        return 2;
    }

    protected int getAdditiveFactor() {
        return 1;
    }

    protected int getEfficiencyIncrease() {
        return 15;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        if (!tFluids.isEmpty()) {
            double boostedFuelValue = 0.0;
            double boostedOutput = 0.0;
            double extraFuelFraction = 0.0;
            for (FluidStack tFluid : tFluids) {
                GT_Recipe tRecipe = this.getRecipeMap().getBackend().findFuel(tFluid);
                if (tRecipe == null) continue;
                this.fuelValue = tRecipe.mSpecialValue;
                FluidStack tLiquid = tFluid.copy();
                if (this.boostEu) {
                    boostedFuelValue = GT_Utility.safeInt((long)((double)this.fuelValue * 1.5));
                    boostedOutput = this.getNominalOutput() * 3;
                    tLiquid.amount = this.getBoostFactor() * this.getNominalOutput() / this.fuelValue;
                    this.fuelConsumption = tLiquid.amount++;
                    if (boostedFuelValue * 2.0 > boostedOutput) {
                        extraFuelFraction = boostedOutput / boostedFuelValue;
                        extraFuelFraction -= (double)((int)extraFuelFraction);
                        double rand = Math.random();
                        if (rand < extraFuelFraction) {
                            // empty if block
                        }
                    }
                } else {
                    this.fuelConsumption = tLiquid.amount = this.getNominalOutput() / this.fuelValue;
                }
                if (!this.depleteInput(tLiquid)) {
                    return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                }
                this.boostEu = this.depleteInput(this.getBooster().getGas(2L * (long)this.getAdditiveFactor()));
                if (!this.boostEu && this.fuelValue > this.getNominalOutput()) {
                    return SimpleCheckRecipeResult.ofFailure("fuel_quality_too_high");
                }
                if (!(this.mRuntime % 72 != 0 && this.mRuntime != 0 || this.depleteInput(Materials.Lubricant.getFluid((this.boostEu ? 2L : 1L) * (long)this.getAdditiveFactor())))) {
                    return SimpleCheckRecipeResult.ofFailure("no_lubricant");
                }
                this.fuelRemaining = tFluid.amount;
                this.mEUt = this.mEfficiency < 2000 ? 0 : this.getNominalOutput();
                this.mProgresstime = 1;
                this.mMaxProgresstime = 1;
                this.mEfficiencyIncrease = this.getEfficiencyIncrease();
                return CheckRecipeResultRegistry.GENERATING;
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_DieselEngine> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 1) && !this.mMufflerHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    public byte getCasingMeta() {
        return 2;
    }

    public Block getIntakeBlock() {
        return GregTech_API.sBlockCasings4;
    }

    public byte getIntakeMeta() {
        return 13;
    }

    public Block getGearboxBlock() {
        return GregTech_API.sBlockCasings2;
    }

    public byte getGearboxMeta() {
        return 4;
    }

    public byte getCasingTextureIndex() {
        return 50;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DieselEngine(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return this.boostEu ? 30000 : 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GT_Mod.gregtechproxy.mPollutionLargeCombustionEnginePerSecond;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : GT_Utility.filterValidMTEs(this.mMufflerHatches)) {
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : GT_Utility.filterValidMTEs(this.mDynamoHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{EnumChatFormatting.BLUE + "Diesel Engine" + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.engine.output") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.mEUt * (long)this.mEfficiency / 10000L) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.engine.consumption") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.fuelConsumption) + EnumChatFormatting.RESET + " L/t", StatCollector.func_74838_a((String)"GT5U.engine.value") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.fuelValue) + EnumChatFormatting.RESET + " EU/L", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + GT_Utility.formatNumbers(this.fuelRemaining) + EnumChatFormatting.RESET + " L", StatCollector.func_74838_a((String)"GT5U.engine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.YELLOW + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 1, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 1, elementBudget, env, false, true);
    }
}

