/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.MachineType;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Boxinator
extends GT_MetaTileEntity_BasicMachine {
    ItemStack aInputCache;
    ItemStack aOutputCache;
    int aTypeCache = 0;

    public GT_MetaTileEntity_Boxinator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, MachineType.PACKAGER.tooltipDescription(), 2, 1, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_BOXINATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_BOXINATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_BOXINATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_BOXINATOR_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_BOXINATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_BOXINATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_BOXINATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_BOXINATOR_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_BOXINATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_BOXINATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_BOXINATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_BOXINATOR_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_BOXINATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_BOXINATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_BOXINATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_BOXINATOR_GLOW).glow().build()));
    }

    public GT_MetaTileEntity_Boxinator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 1);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boxinator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.packagerRecipes;
    }

    private boolean hasValidCache(ItemStack mItem, int mType, boolean mClearOnFailure) {
        if (this.aInputCache != null && this.aOutputCache != null && this.aTypeCache == mType && this.aInputCache.func_77969_a(mItem) && ItemStack.func_77970_a((ItemStack)mItem, (ItemStack)this.aInputCache)) {
            return true;
        }
        if (mClearOnFailure) {
            this.aInputCache = null;
            this.aOutputCache = null;
            this.aTypeCache = 0;
        }
        return false;
    }

    private void cacheItem(ItemStack mInputItem, ItemStack mOutputItem, int mType) {
        this.aTypeCache = mType;
        this.aOutputCache = mOutputItem.func_77946_l();
        this.aInputCache = mInputItem.func_77946_l();
    }

    @Override
    public int checkRecipe() {
        int tCheck = super.checkRecipe();
        if (tCheck != 0) {
            return tCheck;
        }
        ItemStack tSlot0 = this.getInputAt(0);
        ItemStack tSlot1 = this.getInputAt(1);
        if (GT_Utility.isStackValid(tSlot0) && GT_Utility.isStackValid(tSlot1) && GT_Utility.getContainerItem(tSlot0, true) == null) {
            if (ItemList.Schematic_1by1.isStackEqual(tSlot1) && tSlot0.field_77994_a >= 1) {
                boolean tIsCached = this.hasValidCache(tSlot0, 1, true);
                ItemStack itemStack = this.mOutputItems[0] = tIsCached ? this.aOutputCache.func_77946_l() : GT_ModHandler.getRecipeOutput(tSlot0);
                if (this.mOutputItems[0] != null && this.canOutput(this.mOutputItems[0])) {
                    --tSlot0.field_77994_a;
                    this.calculateOverclockedNess(30, 16);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    if (!tIsCached) {
                        this.cacheItem(tSlot0, this.mOutputItems[0], 1);
                    }
                    return 2;
                }
                return 0;
            }
            if (ItemList.Schematic_2by2.isStackEqual(tSlot1) && this.getInputAt((int)0).field_77994_a >= 4) {
                boolean tIsCached = this.hasValidCache(tSlot0, 2, true);
                ItemStack itemStack = this.mOutputItems[0] = tIsCached ? this.aOutputCache.func_77946_l() : GT_ModHandler.getRecipeOutput(tSlot0, tSlot0, null, tSlot0, tSlot0);
                if (this.mOutputItems[0] != null && this.canOutput(this.mOutputItems[0])) {
                    this.getInputAt((int)0).field_77994_a -= 4;
                    this.calculateOverclockedNess(30, 32);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    if (!tIsCached) {
                        this.cacheItem(tSlot0, this.mOutputItems[0], 2);
                    }
                    return 2;
                }
                return 0;
            }
            if (ItemList.Schematic_3by3.isStackEqual(tSlot1) && this.getInputAt((int)0).field_77994_a >= 9) {
                boolean tIsCached = this.hasValidCache(tSlot0, 3, true);
                ItemStack itemStack = this.mOutputItems[0] = tIsCached ? this.aOutputCache.func_77946_l() : GT_ModHandler.getRecipeOutput(tSlot0, tSlot0, tSlot0, tSlot0, tSlot0, tSlot0, tSlot0, tSlot0, tSlot0);
                if (this.mOutputItems[0] != null && this.canOutput(this.mOutputItems[0])) {
                    this.getInputAt((int)0).field_77994_a -= 9;
                    this.calculateOverclockedNess(30, 64);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    if (!tIsCached) {
                        this.cacheItem(tSlot0, this.mOutputItems[0], 3);
                    }
                    return 2;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack)) {
            return false;
        }
        ItemStack tInput1 = this.getInputAt(1);
        if (ItemList.Schematic_1by1.isStackEqual(tInput1) || ItemList.Schematic_2by2.isStackEqual(tInput1) || ItemList.Schematic_3by3.isStackEqual(tInput1)) {
            if (this.hasValidCache(aStack, this.aTypeCache, false)) {
                return true;
            }
            if (RecipeMaps.packagerRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), true, GT_Values.V[this.mTier], null, GT_Utility.copyAmount(64, aStack), tInput1) != null) {
                return true;
            }
            if (ItemList.Schematic_1by1.isStackEqual(this.getInputAt(1)) && GT_ModHandler.getRecipeOutput(aStack) != null) {
                return true;
            }
            if (ItemList.Schematic_2by2.isStackEqual(this.getInputAt(1)) && GT_ModHandler.getRecipeOutput(aStack, aStack, null, aStack, aStack) != null) {
                return true;
            }
            return ItemList.Schematic_3by3.isStackEqual(this.getInputAt(1)) && GT_ModHandler.getRecipeOutput(aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack) != null;
        }
        return RecipeMaps.packagerRecipes.containsInput(aStack);
    }
}

