/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.modularui.SteamTexture;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class UIHelper {
    public static void forEachSlots(ForEachSlot forEachItemInputSlot, ForEachSlot forEachItemOutputSlot, ForEachSlot forEachSpecialSlot, ForEachSlot forEachFluidInputSlot, ForEachSlot forEachFluidOutputSlot, IDrawable itemSlotBackground, IDrawable fluidSlotBackground, BasicUIProperties uiProperties, int itemInputCount, int itemOutputCount, int fluidInputCount, int fluidOutputCount, SteamVariant steamVariant, Pos2d offset) {
        List itemInputPositions = uiProperties.itemInputPositionsGetter.apply(itemInputCount).stream().map(p -> p.add(offset)).collect(Collectors.toList());
        for (int i = 0; i < itemInputPositions.size(); ++i) {
            forEachItemInputSlot.accept(i, UIHelper.getBackgroundsForSlot(itemSlotBackground, uiProperties, false, false, i, false, steamVariant), (Pos2d)itemInputPositions.get(i));
        }
        List itemOutputPositions = uiProperties.itemOutputPositionsGetter.apply(itemOutputCount).stream().map(p -> p.add(offset)).collect(Collectors.toList());
        for (int i = 0; i < itemOutputPositions.size(); ++i) {
            forEachItemOutputSlot.accept(i, UIHelper.getBackgroundsForSlot(itemSlotBackground, uiProperties, false, true, i, false, steamVariant), (Pos2d)itemOutputPositions.get(i));
        }
        forEachSpecialSlot.accept(0, UIHelper.getBackgroundsForSlot(itemSlotBackground, uiProperties, false, false, 0, true, steamVariant), uiProperties.specialItemPositionGetter.get().add(offset));
        List fluidInputPositions = uiProperties.fluidInputPositionsGetter.apply(fluidInputCount).stream().map(p -> p.add(offset)).collect(Collectors.toList());
        for (int i = 0; i < fluidInputPositions.size(); ++i) {
            forEachFluidInputSlot.accept(i, UIHelper.getBackgroundsForSlot(fluidSlotBackground, uiProperties, true, false, i, false, steamVariant), (Pos2d)fluidInputPositions.get(i));
        }
        List fluidOutputPositions = uiProperties.fluidOutputPositionsGetter.apply(fluidOutputCount).stream().map(p -> p.add(offset)).collect(Collectors.toList());
        for (int i = 0; i < fluidOutputPositions.size(); ++i) {
            forEachFluidOutputSlot.accept(i, UIHelper.getBackgroundsForSlot(fluidSlotBackground, uiProperties, true, true, i, false, steamVariant), (Pos2d)fluidOutputPositions.get(i));
        }
    }

    public static List<Pos2d> getItemInputPositions(int itemInputCount) {
        List<Pos2d> list;
        switch (itemInputCount) {
            case 0: {
                list = Collections.emptyList();
                break;
            }
            case 1: {
                list = UIHelper.getGridPositions(itemInputCount, 52, 24, 1, 1);
                break;
            }
            case 2: {
                list = UIHelper.getGridPositions(itemInputCount, 34, 24, 2, 1);
                break;
            }
            case 3: {
                list = UIHelper.getGridPositions(itemInputCount, 16, 24, 3, 1);
                break;
            }
            case 4: {
                list = UIHelper.getGridPositions(itemInputCount, 34, 15, 2, 2);
                break;
            }
            case 5: 
            case 6: {
                list = UIHelper.getGridPositions(itemInputCount, 16, 15, 3, 2);
                break;
            }
            default: {
                list = UIHelper.getGridPositions(itemInputCount, 16, 6, 3);
            }
        }
        return list;
    }

    public static List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        List<Pos2d> list;
        switch (itemOutputCount) {
            case 0: {
                list = Collections.emptyList();
                break;
            }
            case 1: {
                list = UIHelper.getGridPositions(itemOutputCount, 106, 24, 1, 1);
                break;
            }
            case 2: {
                list = UIHelper.getGridPositions(itemOutputCount, 106, 24, 2, 1);
                break;
            }
            case 3: {
                list = UIHelper.getGridPositions(itemOutputCount, 106, 24, 3, 1);
                break;
            }
            case 4: {
                list = UIHelper.getGridPositions(itemOutputCount, 106, 15, 2, 2);
                break;
            }
            case 5: 
            case 6: {
                list = UIHelper.getGridPositions(itemOutputCount, 106, 15, 3, 2);
                break;
            }
            default: {
                list = UIHelper.getGridPositions(itemOutputCount, 106, 6, 3);
            }
        }
        return list;
    }

    public static Pos2d getSpecialItemPosition() {
        return new Pos2d(124, 62);
    }

    public static List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        ArrayList<Pos2d> results = new ArrayList<Pos2d>();
        int x = 52;
        for (int i = 0; i < fluidInputCount; ++i) {
            results.add(new Pos2d(x, 62));
            x -= 18;
        }
        return results;
    }

    public static List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
        ArrayList<Pos2d> results = new ArrayList<Pos2d>();
        int x = 106;
        for (int i = 0; i < fluidOutputCount; ++i) {
            results.add(new Pos2d(x, 62));
            x += 18;
        }
        return results;
    }

    public static List<Pos2d> getGridPositions(int totalCount, int xOrigin, int yOrigin, int xDirMaxCount, int yDirMaxCount) {
        int distance = 18;
        ArrayList<Pos2d> results = new ArrayList<Pos2d>();
        int count = 0;
        block0: for (int j = 0; j < yDirMaxCount; ++j) {
            for (int i = 0; i < xDirMaxCount; ++i) {
                if (count >= totalCount) break block0;
                results.add(new Pos2d(xOrigin + i * distance, yOrigin + j * distance));
                ++count;
            }
        }
        return results;
    }

    public static List<Pos2d> getGridPositions(int totalCount, int xOrigin, int yOrigin, int xDirMaxCount) {
        return UIHelper.getGridPositions(totalCount, xOrigin, yOrigin, xDirMaxCount, 100);
    }

    @Deprecated
    public static List<Pos2d> getItemGridPositions(int itemCount, int xOrigin, int yOrigin, int xDirMaxCount, int yDirMaxCount) {
        return UIHelper.getGridPositions(itemCount, xOrigin, yOrigin, xDirMaxCount, yDirMaxCount);
    }

    private static IDrawable[] getBackgroundsForSlot(IDrawable base, BasicUIProperties uiProperties, boolean isFluid, boolean isOutput, int index, boolean isSpecial, SteamVariant steamVariant) {
        IDrawable overlay = UIHelper.getOverlay(uiProperties, isFluid, isOutput, index, isSpecial, steamVariant);
        if (overlay != null) {
            return new IDrawable[]{base, overlay};
        }
        return new IDrawable[]{base};
    }

    @Nullable
    private static IDrawable getOverlay(BasicUIProperties uiProperties, boolean isFluid, boolean isOutput, int index, boolean isSpecial, SteamVariant steamVariant) {
        if (isSpecial && !uiProperties.useSpecialSlot) {
            return null;
        }
        if (steamVariant != SteamVariant.NONE) {
            SteamTexture steamTexture = uiProperties.getOverlayForSlotSteam(index, isFluid, isOutput, isSpecial);
            if (steamTexture != null) {
                return steamTexture.get(steamVariant);
            }
            return null;
        }
        return uiProperties.getOverlayForSlot(index, isFluid, isOutput, isSpecial);
    }

    @FunctionalInterface
    public static interface ForEachSlot {
        public void accept(int var1, IDrawable[] var2, Pos2d var3);
    }
}

