/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Log;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.io.FileUtils;

@ParametersAreNonnullByDefault
public abstract class GT_ChunkAssociatedData<T extends IData> {
    private static final Map<String, GT_ChunkAssociatedData<?>> instances = new ConcurrentHashMap();
    private static final int IO_PARALLELISM = Math.min(8, Math.max(1, Runtime.getRuntime().availableProcessors() * 2 / 3));
    private static final ExecutorService IO_WORKERS = Executors.newWorkStealingPool(IO_PARALLELISM);
    private static final Pattern FILE_PATTERN = Pattern.compile("(.+)\\.(-?\\d+)\\.(-?\\d+)\\.dat");
    protected final String mId;
    protected final Class<T> elementtype;
    private final int regionLength;
    private final int version;
    private final boolean saveDefaults;
    private final Map<Integer, Map<ChunkCoordIntPair, SuperRegion>> masterMap = new ConcurrentHashMap<Integer, Map<ChunkCoordIntPair, SuperRegion>>();

    protected GT_ChunkAssociatedData(String aId, Class<T> elementType, int regionLength, byte version, boolean saveDefaults) {
        if (regionLength * regionLength > Short.MAX_VALUE || regionLength <= 0) {
            throw new IllegalArgumentException("Region invalid: " + regionLength);
        }
        if (!IData.class.isAssignableFrom(elementType)) {
            throw new IllegalArgumentException("Data type invalid");
        }
        if (aId.contains(".")) {
            throw new IllegalArgumentException("ID cannot contains dot");
        }
        this.mId = aId;
        this.elementtype = elementType;
        this.regionLength = regionLength;
        this.version = version;
        this.saveDefaults = saveDefaults;
        if (instances.putIfAbsent(aId, this) != null) {
            throw new IllegalArgumentException("Duplicate GT_ChunkAssociatedData: " + aId);
        }
    }

    private ChunkCoordIntPair getRegionID(int aChunkX, int aChunkZ) {
        return new ChunkCoordIntPair(Math.floorDiv(aChunkX, this.regionLength), Math.floorDiv(aChunkZ, this.regionLength));
    }

    public final T get(IGregTechTileEntity tileEntity) {
        return this.get(tileEntity.getWorld(), tileEntity.getXCoord() >> 4, tileEntity.getZCoord() >> 4);
    }

    public final T get(Chunk chunk) {
        return this.get(chunk.field_76637_e, chunk.field_76635_g, chunk.field_76647_h);
    }

    public final T get(World world, ChunkCoordIntPair coord) {
        return this.get(world, coord.field_77276_a, coord.field_77275_b);
    }

    public final T get(World world, int chunkX, int chunkZ) {
        SuperRegion region = this.masterMap.computeIfAbsent(world.field_73011_w.field_76574_g, ignored -> new ConcurrentHashMap()).computeIfAbsent(this.getRegionID(chunkX, chunkZ), c -> new SuperRegion(world, (ChunkCoordIntPair)c));
        return region.get(Math.floorMod(chunkX, this.regionLength), Math.floorMod(chunkZ, this.regionLength));
    }

    protected final void set(World world, int chunkX, int chunkZ, T data) {
        SuperRegion region = this.masterMap.computeIfAbsent(world.field_73011_w.field_76574_g, ignored -> new ConcurrentHashMap()).computeIfAbsent(this.getRegionID(chunkX, chunkZ), c -> new SuperRegion(world, (ChunkCoordIntPair)c));
        region.set(Math.floorMod(chunkX, this.regionLength), Math.floorMod(chunkZ, this.regionLength), data);
    }

    protected final boolean isCreated(int dimId, int chunkX, int chunkZ) {
        Map dimData = this.masterMap.getOrDefault(dimId, null);
        if (dimData == null) {
            return false;
        }
        SuperRegion region = dimData.getOrDefault(this.getRegionID(chunkX, chunkZ), null);
        if (region == null) {
            return false;
        }
        return region.isCreated(Math.floorMod(chunkX, this.regionLength), Math.floorMod(chunkZ, this.regionLength));
    }

    public void clear() {
        long dirtyRegionCount;
        if (GT_Values.debugWorldData && (dirtyRegionCount = this.masterMap.values().stream().flatMap(m -> m.values().stream()).filter(SuperRegion::isDirty).count()) > 0L) {
            GT_Log.out.println("Clearing ChunkAssociatedData with " + dirtyRegionCount + " regions dirty. Data might have been lost!");
        }
        this.masterMap.clear();
    }

    public void save() {
        this.saveRegions(this.masterMap.values().stream().flatMap(m -> m.values().stream()));
    }

    public void save(World world) {
        Map<ChunkCoordIntPair, SuperRegion> map = this.masterMap.get(world.field_73011_w.field_76574_g);
        if (map != null) {
            this.saveRegions(map.values().stream());
        }
    }

    private void saveRegions(Stream<SuperRegion> stream) {
        stream.filter(SuperRegion::isDirty).map(c -> c::save).map(r -> CompletableFuture.runAsync(r, IO_WORKERS)).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(f -> {
            try {
                f.get();
            }
            catch (Exception e) {
                GT_Log.err.println("Data save error: " + this.mId);
                e.printStackTrace(GT_Log.err);
            }
        });
    }

    protected abstract void writeElement(DataOutput var1, T var2, World var3, int var4, int var5) throws IOException;

    protected abstract T readElement(DataInput var1, int var2, World var3, int var4, int var5) throws IOException;

    protected abstract T createElement(World var1, int var2, int var3);

    public static void clearAll() {
        for (GT_ChunkAssociatedData<?> d : instances.values()) {
            d.clear();
        }
    }

    public static void saveAll() {
        for (GT_ChunkAssociatedData<?> d : instances.values()) {
            d.save();
        }
    }

    protected void loadAll(World w) {
        if (GT_Values.debugWorldData && this.masterMap.containsKey(w.field_73011_w.field_76574_g)) {
            GT_Log.err.println("Reloading ChunkAssociatedData " + this.mId + " for world " + w.field_73011_w.field_76574_g + " discards old data!");
        }
        if (!this.getSaveDirectory(w).isDirectory()) {
            return;
        }
        try (Stream<Path> stream = Files.list(this.getSaveDirectory(w).toPath());){
            Map worldData = stream.map(f -> {
                Matcher matcher = FILE_PATTERN.matcher(f.getFileName().toString());
                return matcher.matches() ? matcher : null;
            }).filter(Objects::nonNull).filter(m -> this.mId.equals(m.group(1))).map(m -> CompletableFuture.supplyAsync(() -> new SuperRegion(w, Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3))), IO_WORKERS)).map(f -> {
                try {
                    return (SuperRegion)f.get();
                }
                catch (Exception e) {
                    GT_Log.err.println("Error loading region");
                    e.printStackTrace(GT_Log.err);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(SuperRegion::getCoord, Function.identity()));
            this.masterMap.put(w.field_73011_w.field_76574_g, worldData);
        }
        catch (IOException | UncheckedIOException e) {
            GT_Log.err.println("Error loading all region");
            e.printStackTrace(GT_Log.err);
        }
    }

    protected File getSaveDirectory(World w) {
        File base = w.field_73011_w.getSaveFolder() == null ? w.func_72860_G().func_75765_b() : new File(w.func_72860_G().func_75765_b(), w.field_73011_w.getSaveFolder());
        return new File(base, Mods.GregTech.ID);
    }

    static {
        new EventHandler();
    }

    public static interface IData {
        public boolean isSameAsDefault();
    }

    protected final class SuperRegion {
        private final T[] data = this.createData();
        private final File backingStorage;
        private final WeakReference<World> world;
        private final ChunkCoordIntPair coord;

        private SuperRegion(World world, int regionX, int regionZ) {
            this.world = new WeakReference<World>(world);
            this.coord = new ChunkCoordIntPair(regionX, regionZ);
            this.backingStorage = new File(GT_ChunkAssociatedData.this.getSaveDirectory(world), String.format("%s.%d.%d.dat", GT_ChunkAssociatedData.this.mId, regionX, regionZ));
            if (this.backingStorage.isFile()) {
                this.load();
            }
        }

        private SuperRegion(World world, ChunkCoordIntPair regionCoord) {
            this.world = new WeakReference<World>(world);
            this.coord = regionCoord;
            this.backingStorage = new File(GT_ChunkAssociatedData.this.getSaveDirectory(world), String.format("%s.%d.%d.dat", GT_ChunkAssociatedData.this.mId, regionCoord.field_77276_a, regionCoord.field_77275_b));
            if (this.backingStorage.isFile()) {
                this.load();
            }
        }

        private T[] createData() {
            return (IData[])Array.newInstance(GT_ChunkAssociatedData.this.elementtype, GT_ChunkAssociatedData.this.regionLength * GT_ChunkAssociatedData.this.regionLength);
        }

        public T get(int subRegionX, int subRegionZ) {
            int index = this.getIndex(subRegionX, subRegionZ);
            Object datum = this.data[index];
            if (datum == null) {
                World world = Objects.requireNonNull((World)this.world.get());
                Object newElem = GT_ChunkAssociatedData.this.createElement(world, this.coord.field_77276_a * GT_ChunkAssociatedData.this.regionLength + subRegionX, this.coord.field_77275_b * GT_ChunkAssociatedData.this.regionLength + subRegionZ);
                this.data[index] = newElem;
                return newElem;
            }
            return datum;
        }

        public void set(int subRegionX, int subRegionZ, T data) {
            this.data[this.getIndex((int)subRegionX, (int)subRegionZ)] = data;
        }

        public boolean isCreated(int subRegionX, int subRegionZ) {
            return this.data[this.getIndex(subRegionX, subRegionZ)] != null;
        }

        public ChunkCoordIntPair getCoord() {
            return this.coord;
        }

        private int getIndex(int subRegionX, int subRegionY) {
            return subRegionX * GT_ChunkAssociatedData.this.regionLength + subRegionY;
        }

        private int getChunkX(int index) {
            return index / GT_ChunkAssociatedData.this.regionLength + this.coord.field_77276_a * GT_ChunkAssociatedData.this.regionLength;
        }

        private int getChunkZ(int index) {
            return index % GT_ChunkAssociatedData.this.regionLength + this.coord.field_77275_b * GT_ChunkAssociatedData.this.regionLength;
        }

        public boolean isDirty() {
            for (Object datum : this.data) {
                if (datum == null || datum.isSameAsDefault()) continue;
                return true;
            }
            return false;
        }

        public void save() {
            try {
                this.save0();
            }
            catch (IOException e) {
                GT_Log.err.println("Error saving data " + this.backingStorage.getPath());
                e.printStackTrace(GT_Log.err);
            }
        }

        private void save0() throws IOException {
            this.backingStorage.getParentFile().mkdirs();
            File tmpFile = this.getTmpFile();
            World world = Objects.requireNonNull((World)this.world.get(), "Attempting to save region of another world!");
            try (DataOutputStream output = new DataOutputStream(new FileOutputStream(tmpFile));){
                int ptr = 0;
                boolean nullRange = this.data[0] == null;
                output.writeByte(0);
                output.writeByte(GT_ChunkAssociatedData.this.version);
                output.writeBoolean(nullRange);
                while (ptr < this.data.length) {
                    int rangeStart = ptr;
                    while (ptr < this.data.length && (this.data[ptr] == null || !GT_ChunkAssociatedData.this.saveDefaults && this.data[ptr].isSameAsDefault()) == nullRange) {
                        ++ptr;
                    }
                    output.writeShort(ptr - rangeStart);
                    if (!nullRange) {
                        for (int i = rangeStart; i < ptr; ++i) {
                            GT_ChunkAssociatedData.this.writeElement(output, this.data[i], world, this.getChunkX(ptr), this.getChunkZ(ptr));
                        }
                    }
                    nullRange = !nullRange;
                }
            }
            try {
                Files.move(tmpFile.toPath(), this.backingStorage.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ignored) {
                FileUtils.copyFile((File)tmpFile, (File)this.backingStorage);
            }
        }

        public void load() {
            try {
                this.loadFromFile(this.backingStorage);
            }
            catch (IOException | RuntimeException e) {
                GT_Log.err.println("Primary storage file broken in " + this.backingStorage.getPath());
                e.printStackTrace(GT_Log.err);
                try {
                    this.loadFromFile(this.getTmpFile());
                }
                catch (IOException | RuntimeException e2) {
                    GT_Log.err.println("Backup storage file broken in " + this.backingStorage.getPath());
                    e2.printStackTrace(GT_Log.err);
                }
            }
        }

        private void loadFromFile(File file) throws IOException {
            World world = Objects.requireNonNull((World)this.world.get(), "Attempting to load region of another world!");
            try (DataInputStream input = new DataInputStream(new FileInputStream(file));){
                byte b = input.readByte();
                if (b == 0) {
                    this.loadV0(input, world);
                } else {
                    GT_Log.err.printf("Unknown ChunkAssociatedData version %d\n", b);
                }
            }
        }

        private void loadV0(DataInput input, World world) throws IOException {
            byte version = input.readByte();
            boolean nullRange = input.readBoolean();
            int ptr = 0;
            while (ptr != this.data.length) {
                int rangeEnd = ptr + input.readUnsignedShort();
                if (!nullRange) {
                    while (ptr < rangeEnd) {
                        this.data[ptr] = GT_ChunkAssociatedData.this.readElement(input, version, world, this.getChunkX(ptr), this.getChunkZ(ptr));
                        ++ptr;
                    }
                } else {
                    Arrays.fill(this.data, ptr, rangeEnd, null);
                    ptr = rangeEnd;
                }
                nullRange = !nullRange;
            }
        }

        private File getTmpFile() {
            return new File(this.backingStorage.getParentFile(), this.backingStorage.getName() + ".tmp");
        }
    }

    public static class EventHandler {
        private EventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save e) {
            for (GT_ChunkAssociatedData d : instances.values()) {
                d.save(e.world);
            }
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload e) {
            for (GT_ChunkAssociatedData d : instances.values()) {
                d.masterMap.remove(e.world.field_73011_w.field_76574_g);
            }
        }
    }
}

