/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class FindRecipeQuery {
    private static final Predicate<GT_Recipe> ALWAYS = r -> true;
    private final RecipeMap<?> recipeMap;
    @Nullable
    private ItemStack[] items;
    @Nullable
    private FluidStack[] fluids;
    @Nullable
    private ItemStack specialSlot;
    private Predicate<GT_Recipe> filter = ALWAYS;
    private long voltage = Integer.MAX_VALUE;
    @Nullable
    private GT_Recipe cachedRecipe;
    private boolean notUnificated;
    private boolean dontCheckStackSizes;
    private boolean forCollisionCheck;

    FindRecipeQuery(RecipeMap<?> recipeMap) {
        this.recipeMap = recipeMap;
    }

    @Nullable
    public GT_Recipe find() {
        return this.findAll().findFirst().orElse(null);
    }

    public Stream<GT_Recipe> findAll() {
        if (this.items == null) {
            this.items = new ItemStack[0];
        }
        if (this.fluids == null) {
            this.fluids = new FluidStack[0];
        }
        return ((RecipeMapBackend)this.recipeMap.getBackend()).matchRecipeStream(this.items, this.fluids, this.specialSlot, this.cachedRecipe, this.notUnificated, this.dontCheckStackSizes, this.forCollisionCheck).filter((? super T recipe) -> this.voltage * (long)this.recipeMap.getAmperage() >= (long)recipe.mEUt && this.filter.test((GT_Recipe)recipe));
    }

    public boolean checkCollision() {
        this.dontCheckStackSizes = true;
        this.forCollisionCheck = true;
        return this.findAll().findAny().isPresent();
    }

    public FindRecipeQuery items(ItemStack ... items) {
        this.items = items;
        return this;
    }

    public FindRecipeQuery fluids(FluidStack ... fluids) {
        this.fluids = fluids;
        return this;
    }

    public FindRecipeQuery specialSlot(@Nullable ItemStack specialSlot) {
        this.specialSlot = specialSlot;
        return this;
    }

    public FindRecipeQuery filter(Predicate<GT_Recipe> filter) {
        this.filter = filter;
        return this;
    }

    public FindRecipeQuery voltage(long voltage) {
        this.voltage = voltage;
        return this;
    }

    public FindRecipeQuery cachedRecipe(@Nullable GT_Recipe cachedRecipe) {
        this.cachedRecipe = cachedRecipe;
        return this;
    }

    public FindRecipeQuery notUnificated(boolean notUnificated) {
        this.notUnificated = notUnificated;
        return this;
    }

    public FindRecipeQuery dontCheckStackSizes(boolean dontCheckStackSizes) {
        this.dontCheckStackSizes = dontCheckStackSizes;
        return this;
    }
}

