/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.multitileentity.multiblock.base.PowerController;
import net.minecraft.item.ItemStack;

public abstract class StackableController<T extends StackableController<T>>
extends PowerController<T> {
    protected static String STACKABLE_TOP = "STACKABLE_TOP";
    protected static String STACKABLE_MIDDLE = "STACKABLE_MIDDLE";
    protected static String STACKABLE_BOTTOM = "STACKABLE_BOTTOM";

    public void construct(ItemStack trigger, boolean hintsOnly) {
        int blueprintCount = trigger.field_77994_a - 1 + this.getMinStacks();
        int stackCount = Math.min(blueprintCount, this.getMaxStacks());
        this.buildState.startBuilding(this.getStartingStructureOffset());
        this.buildPiece(STACKABLE_BOTTOM, trigger, hintsOnly, this.buildState.getCurrentOffset());
        this.buildState.addOffset(this.getStartingStackOffset());
        for (int i = 0; i < stackCount; ++i) {
            this.buildPiece(STACKABLE_MIDDLE, trigger, hintsOnly, this.buildState.getCurrentOffset());
            this.buildState.addOffset(this.getPerStackOffset());
        }
        if (this.hasTop()) {
            this.buildState.addOffset(this.getAfterLastStackOffset());
            this.buildPiece(STACKABLE_TOP, trigger, hintsOnly, this.buildState.stopBuilding());
        } else {
            this.buildState.stopBuilding();
        }
    }

    public abstract int getMinStacks();

    public abstract int getMaxStacks();

    public abstract Vec3Impl getStartingStackOffset();

    public abstract Vec3Impl getPerStackOffset();

    public boolean hasTop() {
        return true;
    }

    public Vec3Impl getAfterLastStackOffset() {
        return new Vec3Impl(0, 0, 0);
    }

    @Override
    public boolean checkMachine() {
        int stackCount = 0;
        this.buildState.startBuilding(this.getStartingStructureOffset());
        if (!this.checkPiece(STACKABLE_BOTTOM, this.buildState.getCurrentOffset())) {
            return this.buildState.failBuilding();
        }
        this.buildState.addOffset(this.getStartingStackOffset());
        for (int i = 0; i < this.getMaxStacks() && this.checkPiece(STACKABLE_MIDDLE, this.buildState.getCurrentOffset()); ++i) {
            this.buildState.addOffset(this.getPerStackOffset());
            ++stackCount;
        }
        if (stackCount < this.getMinStacks()) {
            return this.buildState.failBuilding();
        }
        this.buildState.addOffset(this.getAfterLastStackOffset());
        if (!this.checkPiece(STACKABLE_TOP, this.buildState.stopBuilding())) {
            return this.buildState.failBuilding();
        }
        return super.checkMachine();
    }
}

