/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.common.covers.CoverInfo;
import java.util.List;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class GT_CoverTickRateButton
extends ButtonWidget {
    private static final UITexture BACKGROUND = GT_UITextures.BUTTON_COVER_NORMAL.getSubArea(0.0f, 0.0f, 1.0f, 0.5f);
    private final CoverInfo coverInfo;
    private int clientTickRate;
    private int tickRateAddition;

    public GT_CoverTickRateButton(@NotNull CoverInfo coverInfo, @NotNull IWidgetBuilder<?> builder) {
        this.coverInfo = coverInfo;
        this.clientTickRate = coverInfo.getTickRate();
        this.tickRateAddition = coverInfo.getTickRateAddition();
        super.setBackground(new IDrawable[]{BACKGROUND, GT_UITextures.OVERLAY_BUTTON_HOURGLASS});
        super.setOnClick(this::onClick);
        super.dynamicTooltip(this::dynamicTooltip);
        super.attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this.coverInfo::getTickRate, integer -> {
            this.clientTickRate = integer;
        }), builder, (widget, aInt) -> this.notifyTooltipChange()).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this.coverInfo::getTickRateAddition, integer -> {
            this.tickRateAddition = integer;
        }), builder);
    }

    private void onClick(@NotNull Widget.ClickData clickData, @NotNull Widget widget) {
        int iterations = clickData.ctrl ? 5 : 1;
        boolean isDecreasing = clickData.mouseButton == 1;
        for (int i = 0; i < iterations; ++i) {
            this.coverInfo.adjustTickRateMultiplier(isDecreasing);
        }
    }

    private List<String> dynamicTooltip() {
        String boundsNotification = this.tickRateAddition == 0 ? StatCollector.func_74838_a((String)"gt.cover.info.button.bounds_notification.minimum") : (this.tickRateAddition >= 1199 ? StatCollector.func_74838_a((String)"gt.cover.info.button.bounds_notification.maximum") : "");
        return ImmutableList.of((Object)StatCollector.func_74837_a((String)"gt.cover.info.button.tick_rate.1", (Object[])new Object[]{new CoverInfo.ClientTickRateFormatter(this.clientTickRate), boundsNotification}), (Object)StatCollector.func_74838_a((String)"gt.cover.info.button.tick_rate.2"), (Object)StatCollector.func_74838_a((String)"gt.cover.info.button.tick_rate.3"));
    }
}

