/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GT_ExoticEnergyInputHelper {
    private static final List<Class<? extends GT_MetaTileEntity_Hatch>> sExoticEnergyHatchType = new ArrayList<Class<? extends GT_MetaTileEntity_Hatch>>();

    public static void register(Class<? extends GT_MetaTileEntity_Hatch> clazz) {
        if (!GT_MetaTileEntity_Hatch.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a subclass of " + GT_MetaTileEntity_Hatch.class.getName());
        }
        sExoticEnergyHatchType.add(clazz);
    }

    public static void tryRegister(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!GT_MetaTileEntity_Hatch.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a subclass of " + GT_MetaTileEntity_Hatch.class.getName());
        }
        sExoticEnergyHatchType.add(clazz);
    }

    public static boolean drainEnergy(long aEU, Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            long tDrain = Math.min(gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getStoredEU(), aEU);
            gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            aEU -= tDrain;
        }
        return aEU <= 0L;
    }

    public static boolean isExoticEnergyInput(IMetaTileEntity aHatch) {
        for (Class<? extends GT_MetaTileEntity_Hatch> clazz : sExoticEnergyHatchType) {
            if (!clazz.isInstance(aHatch)) continue;
            return true;
        }
        return false;
    }

    public static long getTotalEuMulti(Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        long rEU = 0L;
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
            rEU += gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getInputVoltage() * gT_MetaTileEntity_Hatch.maxWorkingAmperesIn();
        }
        return rEU;
    }

    public static long getMaxInputVoltageMulti(Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        long rVoltage = 0L;
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
            rVoltage += gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage;
    }

    public static long getAverageInputVoltageMulti(Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        long rVoltage = 0L;
        if (hatches.size() == 0) {
            return rVoltage;
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
            rVoltage += gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage / (long)hatches.size();
    }

    public static long getMaxInputAmpsMulti(Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        long rAmp = 0L;
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
            rAmp += gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rAmp;
    }

    public static long getMaxWorkingInputAmpsMulti(Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        long rAmp = 0L;
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
            rAmp += gT_MetaTileEntity_Hatch.maxWorkingAmperesIn();
        }
        return rAmp;
    }

    public static List<Class<? extends GT_MetaTileEntity_Hatch>> getAllClasses() {
        return Collections.unmodifiableList(sExoticEnergyHatchType);
    }

    static {
        GT_ExoticEnergyInputHelper.tryRegister("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti");
        GT_ExoticEnergyInputHelper.tryRegister("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel");
    }
}

