/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Assemblyline_Server;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidStack;

public class GT_AssemblyLineUtils {
    private static final HashMap<GT_ItemStack, GT_Recipe.GT_Recipe_AssemblyLine> sRecipeCacheByOutput = new HashMap();
    private static final HashMap<String, GT_Recipe.GT_Recipe_AssemblyLine> sRecipeCacheByRecipeHash = new HashMap();

    public static GT_Recipe.GT_Recipe_AssemblyLine processDataStick(ItemStack aDataStick) {
        GT_Recipe.GT_Recipe_AssemblyLine aIntendedRecipe;
        ItemStack aStickOutput;
        if (!GT_AssemblyLineUtils.isItemDataStick(aDataStick)) {
            return null;
        }
        if (GT_AssemblyLineUtils.doesDataStickNeedUpdate(aDataStick) && (aStickOutput = GT_AssemblyLineUtils.getDataStickOutput(aDataStick)) != null && (aIntendedRecipe = GT_AssemblyLineUtils.findAssemblyLineRecipeByOutput(aStickOutput)) != null && GT_AssemblyLineUtils.setAssemblyLineRecipeOnDataStick(aDataStick, aIntendedRecipe)) {
            return aIntendedRecipe;
        }
        return null;
    }

    public static GT_Recipe.GT_Recipe_AssemblyLine findAssemblyLineRecipeFromDataStick(ItemStack aDataStick) {
        return GT_AssemblyLineUtils.findAssemblyLineRecipeFromDataStick(aDataStick, false).getRecipe();
    }

    @Nonnull
    public static LookupResult findAssemblyLineRecipeFromDataStick(ItemStack aDataStick, boolean aReturnBuiltRecipe) {
        int i;
        GT_Recipe.GT_Recipe_AssemblyLine aRecipeFromCache;
        if (!GT_AssemblyLineUtils.isItemDataStick(aDataStick) || !GT_AssemblyLineUtils.doesDataStickHaveOutput(aDataStick)) {
            return LookupResultType.INVALID_STICK.getResult();
        }
        ArrayList<ItemStack> aInputs = new ArrayList<ItemStack>(15);
        ItemStack aOutput = GT_AssemblyLineUtils.getDataStickOutput(aDataStick);
        ArrayList<List<ItemStack>> mOreDictAlt = new ArrayList<List<ItemStack>>(15);
        ArrayList<FluidStack> aFluidInputs = new ArrayList<FluidStack>(4);
        NBTTagCompound aTag = aDataStick.func_77978_p();
        if (aTag == null) {
            return LookupResultType.INVALID_STICK.getResult();
        }
        if (GT_AssemblyLineUtils.doesDataStickHaveRecipeHash(aDataStick) && (aRecipeFromCache = sRecipeCacheByRecipeHash.get(GT_AssemblyLineUtils.getHashFromDataStack(aDataStick))) != null && GT_Utility.areStacksEqual(aOutput, aRecipeFromCache.mOutput)) {
            return LookupResultType.VALID_STACK_AND_VALID_HASH.getResult(aRecipeFromCache);
        }
        for (i = 0; i < 15; ++i) {
            int count = aTag.func_74762_e("a" + i);
            if (!aTag.func_74764_b("" + i) && count <= 0) continue;
            ArrayList<ItemStack> tAltCurrent = new ArrayList<ItemStack>();
            for (int j = 0; j < count; ++j) {
                ItemStack tLoaded = GT_Utility.loadItem(aTag, "a" + i + ":" + j);
                if (tLoaded == null) continue;
                tAltCurrent.add(tLoaded);
                if (!GT_Values.D1) continue;
                GT_Mod.GT_FML_LOGGER.info("Item Alt " + i + " : " + tLoaded.func_77977_a());
            }
            mOreDictAlt.add(tAltCurrent);
            ItemStack tLoaded = GT_Utility.loadItem(aTag, "" + i);
            if (tLoaded == null) continue;
            aInputs.add(tLoaded);
            if (!GT_Values.D1) continue;
            GT_Mod.GT_FML_LOGGER.info("Item " + i + " : " + tLoaded.func_77977_a());
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("All Items done, start fluid check");
        }
        for (i = 0; i < 4; ++i) {
            FluidStack tLoaded;
            if (!aTag.func_74764_b("f" + i) || (tLoaded = GT_Utility.loadFluid(aTag, "f" + i)) == null) continue;
            aFluidInputs.add(tLoaded);
            if (!GT_Values.D1) continue;
            GT_Mod.GT_FML_LOGGER.info("Fluid " + i + " " + tLoaded.getUnlocalizedName());
        }
        if (!(aTag.func_74764_b("output") && aTag.func_74764_b("time") && aTag.func_74762_e("time") > 0 && aTag.func_74764_b("eu") && GT_Utility.isStackValid(aOutput))) {
            return LookupResultType.INVALID_STICK.getResult();
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Found Data Stick recipe");
        }
        int aTime = aTag.func_74762_e("time");
        int aEU = aTag.func_74762_e("eu");
        if (aReturnBuiltRecipe) {
            return LookupResultType.VALID_STACK_AND_VALID_HASH.getResult(new GT_Recipe.GT_Recipe_AssemblyLine(null, 0, aInputs.toArray(new ItemStack[0]), aFluidInputs.toArray(new FluidStack[0]), aOutput, aTime, aEU));
        }
        for (GT_Recipe.GT_Recipe_AssemblyLine aRecipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
            String aStickHash;
            if (aRecipe.mEUt != aEU || aRecipe.mDuration != aTime || !GT_Utility.areStacksEqual(aOutput, aRecipe.mOutput, true) || !GT_Utility.areStackListsEqual(Arrays.asList(aRecipe.mInputs), aInputs, false, true) || !Objects.equals(Arrays.asList(aRecipe.mFluidInputs), aFluidInputs) || !GT_AssemblyLineUtils.areStacksEqual(aRecipe.mOreDictAlt, mOreDictAlt)) continue;
            String aRecipeHash = GT_AssemblyLineUtils.generateRecipeHash(aRecipe);
            sRecipeCacheByRecipeHash.put(aRecipeHash, aRecipe);
            sRecipeCacheByOutput.put(new GT_ItemStack(aRecipe.mOutput), aRecipe);
            if (GT_AssemblyLineUtils.doesDataStickHaveRecipeHash(aDataStick) && aRecipeHash.equals(aStickHash = GT_AssemblyLineUtils.getHashFromDataStack(aDataStick))) {
                return LookupResultType.VALID_STACK_AND_VALID_HASH.getResult(aRecipe);
            }
            return LookupResultType.VALID_STACK_AND_VALID_RECIPE.getResult(aRecipe);
        }
        return LookupResultType.VALID_STACK_BUT_INVALID_RECIPE.getResult();
    }

    private static boolean areStacksEqual(ItemStack[][] lhs, List<List<ItemStack>> rhs) {
        for (int i = 0; i < lhs.length; ++i) {
            if (GT_AssemblyLineUtils.areStacksEqual(lhs[i], rhs.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areStacksEqual(ItemStack[] lhs, List<ItemStack> rhs) {
        return lhs == null ? rhs.isEmpty() : !rhs.isEmpty() && GT_Utility.areStackListsEqual(Arrays.asList(lhs), rhs, false, true);
    }

    public static GT_Recipe.GT_Recipe_AssemblyLine findAssemblyLineRecipeByOutput(ItemStack aOutput) {
        if (aOutput == null) {
            return null;
        }
        GT_ItemStack aCacheStack = new GT_ItemStack(aOutput);
        GT_Recipe.GT_Recipe_AssemblyLine aRecipeFromCache = sRecipeCacheByOutput.get(aCacheStack);
        if (aRecipeFromCache != null) {
            return aRecipeFromCache;
        }
        for (GT_Recipe.GT_Recipe_AssemblyLine aRecipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
            ItemStack aRecipeOutput = aRecipe.mOutput;
            if (!GT_Utility.areStacksEqual(aRecipeOutput, aOutput)) continue;
            sRecipeCacheByOutput.put(aCacheStack, aRecipe);
            sRecipeCacheByRecipeHash.put(GT_AssemblyLineUtils.generateRecipeHash(aRecipe), aRecipe);
            return aRecipe;
        }
        return null;
    }

    public static String generateRecipeHash(GT_Recipe.GT_Recipe_AssemblyLine aRecipe) {
        String aHash = "Invalid.Recipe.Hash";
        if (aRecipe != null) {
            aHash = "Hash." + aRecipe.getPersistentHash();
        }
        return aHash;
    }

    public static void addRecipeToCache(GT_Recipe.GT_Recipe_AssemblyLine aRecipe) {
        if (aRecipe != null) {
            String aHash = "Hash." + aRecipe.getPersistentHash();
            GT_Recipe.GT_Recipe_AssemblyLine existing = sRecipeCacheByOutput.put(new GT_ItemStack(aRecipe.mOutput), aRecipe);
            if (existing != null) {
                throw new IllegalArgumentException("Duplicate assline recipe for " + aRecipe.mOutput);
            }
            existing = sRecipeCacheByRecipeHash.put(aHash, aRecipe);
            if (existing != null && !existing.equals(aRecipe)) {
                throw new IllegalArgumentException("Recipe hash collision for " + aRecipe + " and " + existing);
            }
        }
    }

    public static boolean isValidHash(String aHash) {
        if (aHash != null && aHash.length() > 0) {
            return !aHash.equals("Invalid.Recipe.Hash") && !aHash.equals("Hash.0");
        }
        return false;
    }

    public static boolean isItemDataStick(ItemStack aStack) {
        return GT_Utility.isStackValid(aStack) && ItemList.Tool_DataStick.isStackEqual(aStack, false, true);
    }

    public static boolean doesDataStickHaveOutput(ItemStack aDataStick) {
        return GT_AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o() && aDataStick.func_77978_p().func_74764_b("output");
    }

    public static boolean doesDataStickNeedUpdate(ItemStack aDataStick) {
        String aStickHash;
        if (GT_AssemblyLineUtils.isItemDataStick(aDataStick) && GT_AssemblyLineUtils.doesDataStickHaveRecipeHash(aDataStick) && GT_AssemblyLineUtils.isValidHash(aStickHash = GT_AssemblyLineUtils.getHashFromDataStack(aDataStick)) && GT_AssemblyLineUtils.doesDataStickHaveOutput(aDataStick)) {
            ItemStack aStickOutput = GT_AssemblyLineUtils.getDataStickOutput(aDataStick);
            GT_Recipe.GT_Recipe_AssemblyLine aIntendedRecipe = GT_AssemblyLineUtils.findAssemblyLineRecipeByOutput(aStickOutput);
            return !aStickHash.equals(GT_AssemblyLineUtils.generateRecipeHash(aIntendedRecipe));
        }
        return true;
    }

    public static boolean doesDataStickHaveRecipeHash(ItemStack aDataStick) {
        if (GT_AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o()) {
            NBTTagCompound aNBT = aDataStick.func_77978_p();
            return aNBT.func_74764_b("Data.Recipe.Hash") && !aNBT.func_74779_i("Data.Recipe.Hash").equals("Hash.0");
        }
        return false;
    }

    public static ItemStack getDataStickOutput(ItemStack aDataStick) {
        if (GT_AssemblyLineUtils.doesDataStickHaveOutput(aDataStick)) {
            return GT_Utility.loadItem(aDataStick.func_77978_p(), "output");
        }
        return null;
    }

    public static String getHashFromDataStack(ItemStack aDataStick) {
        String hash;
        NBTTagCompound aNBT;
        if (GT_AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o() && (aNBT = aDataStick.func_77978_p()).func_150297_b("Data.Recipe.Hash", 8) && GT_AssemblyLineUtils.isValidHash(hash = aNBT.func_74779_i("Data.Recipe.Hash"))) {
            return hash;
        }
        return "Invalid.Recipe.Hash";
    }

    public static boolean setRecipeHashOnDataStick(ItemStack aDataStick, String aRecipeHash) {
        if (GT_AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o()) {
            NBTTagCompound aNBT = aDataStick.func_77978_p();
            aNBT.func_74778_a("Data.Recipe.Hash", aRecipeHash);
            aDataStick.func_77982_d(aNBT);
            return true;
        }
        return false;
    }

    public static boolean setAssemblyLineRecipeOnDataStick(ItemStack aDataStick, GT_Recipe.GT_Recipe_AssemblyLine aNewRecipe) {
        if (GT_AssemblyLineUtils.isItemDataStick(aDataStick)) {
            int i;
            int i2;
            String s = aNewRecipe.mOutput.func_82833_r();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = GT_Assemblyline_Server.lServerNames.get(aNewRecipe.mOutput.func_82833_r())) == null) {
                s = aNewRecipe.mOutput.func_82833_r();
            }
            String aHash = GT_AssemblyLineUtils.generateRecipeHash(aNewRecipe);
            if (GT_Values.D1) {
                GT_Recipe.GT_Recipe_AssemblyLine aOldRecipe = GT_AssemblyLineUtils.findAssemblyLineRecipeFromDataStick(aDataStick, true).recipe;
                GT_Mod.GT_FML_LOGGER.info("Updating data stick: " + aDataStick.func_82833_r() + " | Old Recipe Hash: " + GT_AssemblyLineUtils.generateRecipeHash(aOldRecipe) + ", New Recipe Hash: " + aHash);
            }
            String author = "Assembling Line Recipe Generator";
            String displayName = null;
            if (aDataStick.func_77942_o()) {
                NBTTagCompound displayTag;
                NBTTagCompound tag = aDataStick.func_77978_p();
                if (tag.func_150297_b("author", 8)) {
                    author = tag.func_74779_i("author");
                }
                if (tag.func_150297_b("display", 10) && (displayTag = tag.func_74775_l("display")).func_150297_b("Name", 8)) {
                    displayName = displayTag.func_74779_i("Name");
                }
            }
            aDataStick.func_77982_d(new NBTTagCompound());
            if (displayName != null) {
                aDataStick.func_151001_c(displayName);
            }
            if (GT_Values.D1) {
                GT_Utility.ItemNBT.setBookTitle(aDataStick, s + " Construction Data (" + aHash + ")");
            } else {
                GT_Utility.ItemNBT.setBookTitle(aDataStick, s + " Construction Data");
            }
            NBTTagCompound tNBT = aDataStick.func_77978_p();
            if (tNBT == null) {
                tNBT = new NBTTagCompound();
            }
            tNBT.func_74782_a("output", (NBTBase)aNewRecipe.mOutput.func_77955_b(new NBTTagCompound()));
            tNBT.func_74768_a("time", aNewRecipe.mDuration);
            tNBT.func_74768_a("eu", aNewRecipe.mEUt);
            for (i2 = 0; i2 < aNewRecipe.mInputs.length; ++i2) {
                tNBT.func_74782_a("" + i2, (NBTBase)aNewRecipe.mInputs[i2].func_77955_b(new NBTTagCompound()));
            }
            for (i2 = 0; i2 < aNewRecipe.mOreDictAlt.length; ++i2) {
                if (aNewRecipe.mOreDictAlt[i2] == null || aNewRecipe.mOreDictAlt[i2].length <= 0) continue;
                tNBT.func_74768_a("a" + i2, aNewRecipe.mOreDictAlt[i2].length);
                for (int j = 0; j < aNewRecipe.mOreDictAlt[i2].length; ++j) {
                    tNBT.func_74782_a("a" + i2 + ":" + j, (NBTBase)aNewRecipe.mOreDictAlt[i2][j].func_77955_b(new NBTTagCompound()));
                }
            }
            for (i2 = 0; i2 < aNewRecipe.mFluidInputs.length; ++i2) {
                tNBT.func_74782_a("f" + i2, (NBTBase)aNewRecipe.mFluidInputs[i2].writeToNBT(new NBTTagCompound()));
            }
            tNBT.func_74778_a("author", author);
            NBTTagList tNBTList = new NBTTagList();
            s = aNewRecipe.mOutput.func_82833_r();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = GT_Assemblyline_Server.lServerNames.get(aNewRecipe.mOutput.func_82833_r())) == null) {
                s = aNewRecipe.mOutput.func_82833_r();
            }
            tNBTList.func_74742_a((NBTBase)new NBTTagString("Construction plan for " + aNewRecipe.mOutput.field_77994_a + " " + s + ". Needed EU/t: " + aNewRecipe.mEUt + " Production time: " + aNewRecipe.mDuration / 20));
            for (i = 0; i < aNewRecipe.mInputs.length; ++i) {
                if (aNewRecipe.mOreDictAlt[i] != null) {
                    int count = 0;
                    StringBuilder tBuilder = new StringBuilder("Input Bus " + (i + 1) + ": ");
                    for (ItemStack tStack : aNewRecipe.mOreDictAlt[i]) {
                        if (tStack == null) continue;
                        s = tStack.func_82833_r();
                        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = GT_Assemblyline_Server.lServerNames.get(tStack.func_82833_r())) == null) {
                            s = tStack.func_82833_r();
                        }
                        tBuilder.append(count == 0 ? "" : "\nOr ").append(tStack.field_77994_a).append(" ").append(s);
                        ++count;
                    }
                    if (count <= 0) continue;
                    tNBTList.func_74742_a((NBTBase)new NBTTagString(tBuilder.toString()));
                    continue;
                }
                if (aNewRecipe.mInputs[i] == null) continue;
                s = aNewRecipe.mInputs[i].func_82833_r();
                if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = GT_Assemblyline_Server.lServerNames.get(aNewRecipe.mInputs[i].func_82833_r())) == null) {
                    s = aNewRecipe.mInputs[i].func_82833_r();
                }
                tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Bus " + (i + 1) + ": " + aNewRecipe.mInputs[i].field_77994_a + " " + s));
            }
            for (i = 0; i < aNewRecipe.mFluidInputs.length; ++i) {
                if (aNewRecipe.mFluidInputs[i] == null) continue;
                s = aNewRecipe.mFluidInputs[i].getLocalizedName();
                if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = GT_Assemblyline_Server.lServerNames.get(aNewRecipe.mFluidInputs[i].getLocalizedName())) == null) {
                    s = aNewRecipe.mFluidInputs[i].getLocalizedName();
                }
                tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Hatch " + (i + 1) + ": " + aNewRecipe.mFluidInputs[i].amount + "L " + s));
            }
            tNBT.func_74782_a("pages", (NBTBase)tNBTList);
            tNBT.func_74772_a("lastUpdate", System.currentTimeMillis());
            aDataStick.func_77982_d(tNBT);
            GT_AssemblyLineUtils.setRecipeHashOnDataStick(aDataStick, aHash);
            return true;
        }
        return false;
    }

    public static class LookupResult {
        private final GT_Recipe.GT_Recipe_AssemblyLine recipe;
        private final LookupResultType type;

        LookupResult(GT_Recipe.GT_Recipe_AssemblyLine recipe, LookupResultType type) {
            this.recipe = recipe;
            this.type = type;
        }

        public GT_Recipe.GT_Recipe_AssemblyLine getRecipe() {
            return this.recipe;
        }

        public LookupResultType getType() {
            return this.type;
        }
    }

    public static enum LookupResultType {
        INVALID_STICK(true),
        VALID_STACK_BUT_INVALID_RECIPE(true),
        VALID_STACK_AND_VALID_RECIPE(false),
        VALID_STACK_AND_VALID_HASH(false);

        private final boolean recipeNull;
        private LookupResult singletonResult;

        private LookupResultType(boolean recipeNull) {
            this.recipeNull = recipeNull;
        }

        public LookupResult getResult() {
            if (!this.recipeNull) {
                throw new IllegalArgumentException("This result type require a nonnull recipe");
            }
            if (this.singletonResult == null) {
                this.singletonResult = new LookupResult(null, this);
            }
            return this.singletonResult;
        }

        public LookupResult getResult(GT_Recipe.GT_Recipe_AssemblyLine recipe) {
            if (recipe == null != this.recipeNull) {
                throw new IllegalArgumentException("This result type does not allow given input");
            }
            return new LookupResult(recipe, this);
        }
    }
}

