/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IGuiIcon;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public enum GT_GuiIcon implements IGuiIcon
{
    BUTTON_NORMAL(0, 0, 0),
    BUTTON_DOWN(0, 32, 0),
    BUTTON_HIGHLIGHT(0, 64, 0),
    BUTTON_HIGHLIGHT_DOWN(0, 96, 0),
    BUTTON_DISABLED(0, 128, 0),
    DISABLE(0, 0, 32),
    REDSTONE_OFF(0, 32, 32),
    REDSTONE_ON(0, 64, 32),
    CHECKMARK(0, 96, 32),
    CROSS(0, 128, 32),
    WHITELIST(0, 160, 32),
    BLACKLIST(0, 192, 32),
    PROGRESS(0, 224, 32),
    EXPORT(0, 0, 64),
    IMPORT(0, 32, 64),
    ALLOW_INPUT(0, 64, 64),
    BLOCK_INPUT(0, 96, 64),
    GREEN_ARROW_UP(0, 128, 64),
    GREEN_ARROW_DOWN(0, 160, 64),
    CYCLIC(0, 192, 64),
    AND_GATE(0, 0, 96),
    NAND_GATE(0, 32, 96),
    OR_GATE(0, 64, 96),
    NOR_GATE(0, 96, 96),
    ANALOG_MODE(0, 128, 96),
    SLOT_DARKGRAY(1, 176, 0, 18, 18),
    SLOT_GRAY(1, 176, 18, 18, 18),
    TAB_NORMAL(2, 0, 0, 18, 20),
    TAB_HIGHLIGHT(2, 18, 0, 18, 20),
    TAB_DISABLED(2, 36, 0, 18, 20),
    TAB_NORMAL_BRONZE(2, 0, 20, 18, 20),
    TAB_HIGHLIGHT_BRONZE(2, 18, 20, 18, 20),
    TAB_DISABLED_BRONZE(2, 36, 20, 18, 20),
    TAB_NORMAL_STEEL(2, 0, 40, 18, 20),
    TAB_HIGHLIGHT_STEEL(2, 18, 40, 18, 20),
    TAB_DISABLED_STEEL(2, 36, 40, 18, 20),
    TAB_NORMAL_BRICK(2, 0, 60, 18, 20),
    TAB_HIGHLIGHT_BRICK(2, 18, 60, 18, 20),
    TAB_DISABLED_BRICK(2, 36, 60, 18, 20),
    TAB_INFO_GRAY(2, 220, 0, 18, 20),
    TAB_INFO_BLUE(2, 238, 0, 18, 20);

    private static final int T_SIZE = 256;
    private static ResourceLocation[] TEXTURES;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final IGuiIcon overlay;
    private final int texID;

    private GT_GuiIcon(int texID, int x, int y, int width, int height, IGuiIcon overlay) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
        this.texID = texID;
    }

    private GT_GuiIcon(int texID, int x, int y) {
        this(texID, x, y, 32, 32, null);
    }

    private GT_GuiIcon(int texID, int x, int y, int width, int height) {
        this(texID, x, y, width, height, null);
    }

    public static void render(IGuiIcon icon, double x, double y, double width, double height, double zLevel, boolean doDraw) {
        GT_GuiIcon.render(icon, x, y, width, height, zLevel, doDraw, false);
    }

    public static void render(IGuiIcon icon, double x, double y, double width, double height, double zLevel, boolean doDraw, boolean flipHoritontally) {
        Tessellator tess = Tessellator.field_78398_a;
        if (doDraw) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES[icon.getTexId()]);
            tess.func_78382_b();
        }
        double minU = (double)(icon.getX() + (flipHoritontally ? icon.getWidth() : 0)) / 256.0;
        double maxU = (double)(icon.getX() + (flipHoritontally ? 0 : icon.getWidth())) / 256.0;
        double minV = (double)icon.getY() / 256.0;
        double maxV = (double)(icon.getY() + icon.getHeight()) / 256.0;
        tess.func_78374_a(x, y + height, zLevel, minU, maxV);
        tess.func_78374_a(x + width, y + height, zLevel, maxU, maxV);
        tess.func_78374_a(x + width, y + 0.0, zLevel, maxU, minV);
        tess.func_78374_a(x, y + 0.0, zLevel, minU, minV);
        if (icon.getOverlay() != null) {
            GT_GuiIcon.render(icon.getOverlay(), x, y, width, height, zLevel, false);
        }
        if (doDraw) {
            tess.func_78381_a();
        }
    }

    public static void addTextures(ResourceLocation ... location) {
        if (location == null || location.length == 0) {
            return;
        }
        int startIndex = TEXTURES.length;
        TEXTURES = Arrays.copyOf(TEXTURES, location.length);
        System.arraycopy(location, 0, TEXTURES, startIndex, location.length);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTexId() {
        return this.texID;
    }

    @Override
    public IGuiIcon getOverlay() {
        return this.overlay;
    }

    static {
        TEXTURES = new ResourceLocation[]{new ResourceLocation(Mods.GregTech.ID, "textures/gui/GuiButtons.png"), new ResourceLocation(Mods.GregTech.ID, "textures/gui/GuiCover.png"), new ResourceLocation(Mods.GregTech.ID, "textures/gui/GuiTabs.png")};
    }
}

