/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.item.ItemStack;

public class ProcessingRotor
implements IOreRecipeRegistrator {
    public ProcessingRotor() {
        OrePrefixes.rotor.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_WORKING)) {
            ItemStack tPlate = GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L);
            ItemStack tRing = GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L);
            if (GT_Utility.isStackValid(tPlate) && GT_Utility.isStackValid(tRing)) {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('R'), OrePrefixes.ring.get(aMaterial), Character.valueOf('S'), OrePrefixes.screw.get(aMaterial)});
                }
                GT_Values.RA.addAssemblerRecipe(new ItemStack[]{tPlate.func_77946_l(), tRing.func_77946_l(), GT_Utility.getIntegratedCircuit(4)}, Materials.Tin.getMolten(32L), GT_OreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L), (int)Math.max(aMaterial.getMass(), 1L), GT_Utility.calculateRecipeEU(aMaterial, 24));
                GT_Values.RA.addAssemblerRecipe(new ItemStack[]{tPlate.func_77946_l(), tRing.func_77946_l(), GT_Utility.getIntegratedCircuit(4)}, Materials.Lead.getMolten(48L), GT_OreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L), (int)Math.max(aMaterial.getMass(), 1L), GT_Utility.calculateRecipeEU(aMaterial, 24));
                GT_Values.RA.addAssemblerRecipe(new ItemStack[]{tPlate.func_77946_l(), tRing.func_77946_l(), GT_Utility.getIntegratedCircuit(4)}, Materials.SolderingAlloy.getMolten(16L), GT_OreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L), (int)Math.max(aMaterial.getMass(), 1L), GT_Utility.calculateRecipeEU(aMaterial, 24));
            }
            GT_Values.RA.addExtruderRecipe(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 5L), ItemList.Shape_Extruder_Rotor.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L), (int)Math.max(aMaterial.getMass(), 1L), GT_Utility.calculateRecipeEU(aMaterial, 24));
            if (aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
                GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Rotor.get(0L, new Object[0]), aMaterial.getMolten(612L), GT_OreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L), (int)Math.max(aMaterial.getMass(), 1L), GT_Utility.calculateRecipeEU(aMaterial, 24));
            }
        }
    }
}

