/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.common.tools.GT_Tool_Saw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_Chainsaw_LV
extends GT_Tool_Saw {
    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 800;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 2.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public String getCraftingSound() {
        return SoundResource.IC2_TOOLS_CHAINSAW_CHAINSAW_USE_ONE.toString();
    }

    @Override
    public String getEntityHitSound() {
        return SoundResource.IC2_TOOLS_CHAINSAW_CHAINSAW_USE_TWO.toString();
    }

    @Override
    public String getMiningSound() {
        return SoundResource.IC2_TOOLS_CHAINSAW_CHAINSAW_USE_ONE.toString();
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean isChainsaw() {
        return true;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        try {
            GT_Mod.achievements.issueAchievement(aPlayer, "brrrr");
            GT_Mod.achievements.issueAchievement(aPlayer, "buildChainsaw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rAmount = 0;
        if (aBlock.func_149688_o() == Material.field_151584_j && aBlock instanceof IShearable) {
            aPlayer.field_70170_p.func_147465_d(aX, aY, aZ, aBlock, (int)aMetaData, 0);
            if (((IShearable)aBlock).isShearable(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ)) {
                ArrayList tDrops = ((IShearable)aBlock).onSheared(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ, aFortune);
                aDrops.clear();
            }
            aPlayer.field_70170_p.func_147465_d(aX, aY, aZ, Blocks.field_150350_a, 0, 0);
        } else if ((aBlock.func_149688_o() == Material.field_151588_w || aBlock.func_149688_o() == Material.field_151598_x) && aDrops.isEmpty()) {
            aDrops.add(new ItemStack(aBlock, 1, (int)aMetaData));
            aPlayer.field_70170_p.func_147468_f(aX, aY, aZ);
            aEvent.dropChance = 1.0f;
            return 1;
        }
        if (GregTech_API.sTimber && !aPlayer.func_70093_af() && OrePrefixes.log.contains(new ItemStack(aBlock, 1, (int)aMetaData))) {
            int tH = aPlayer.field_70170_p.func_72800_K();
            for (int tY = aY + 1; tY < tH && aPlayer.field_70170_p.func_147439_a(aX, tY, aZ) == aBlock && aPlayer.field_70170_p.func_147480_a(aX, tY, aZ, true); ++tY) {
                ++rAmount;
            }
        }
        return rAmount;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        if (aBlock.isWood((IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ) && OrePrefixes.log.contains(new ItemStack(aBlock, 1, (int)aMetaData))) {
            float rAmount = 1.0f;
            float tIncrement = 1.0f;
            if (GregTech_API.sTimber && !aPlayer.func_70093_af()) {
                int tH = aPlayer.field_70170_p.func_72800_K();
                for (int tY = aY + 1; tY < tH && aPlayer.field_70170_p.func_147439_a(aX, tY, aZ) == aBlock; ++tY) {
                    rAmount += (tIncrement += 0.1f);
                }
            }
            return 2.0f * aDefault / rAmount;
        }
        return aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151582_l || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151572_C ? aDefault / 4.0f : aDefault;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mIconSet.mTextures[OrePrefixes.toolHeadChainsaw.mTextureIndex] : Textures.ItemIcons.POWER_UNIT_LV;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mRGBa : GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " was massacred by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

