/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IFluidAccess;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IFluidLockable;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.modularui.widget.FluidDisplaySlotWidget;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class GT_MetaTileEntity_DigitalTankBase
extends GT_MetaTileEntity_BasicTank
implements IFluidLockable,
IAddUIWidgets {
    public boolean mOutputFluid = false;
    public boolean mVoidFluidPart = false;
    public boolean mVoidFluidFull = false;
    public boolean mLockFluid = false;
    protected String lockedFluidName = null;
    public boolean mAllowInputFromOutputSide = false;

    public GT_MetaTileEntity_DigitalTankBase(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{StatCollector.func_74837_a((String)"GT5U.machines.digitaltank.tooltip", (Object[])new Object[]{GT_Utility.formatNumbers(GT_MetaTileEntity_DigitalTankBase.commonSizeCompute(aTier))}), StatCollector.func_74838_a((String)"GT5U.machines.digitaltank.tooltip1")}, new ITexture[0]);
    }

    protected static int commonSizeCompute(int tier) {
        switch (tier) {
            case 1: {
                return 4000000;
            }
            case 2: {
                return 8000000;
            }
            case 3: {
                return 16000000;
            }
            case 4: {
                return 32000000;
            }
            case 5: {
                return 64000000;
            }
            case 6: {
                return 128000000;
            }
            case 7: {
                return 256000000;
            }
            case 8: {
                return 512000000;
            }
            case 9: {
                return 1024000000;
            }
            case 10: {
                return 0x7FFFFFF8;
            }
        }
        return 0;
    }

    private static int tierPump(int tier) {
        switch (tier) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 7;
            }
            case 10: {
                return 8;
            }
        }
        return 0;
    }

    public GT_MetaTileEntity_DigitalTankBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_DigitalTankBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.mFluid != null && this.mFluid.amount >= 0) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.mOutputFluid) {
            aNBT.func_74757_a("mOutputFluid", true);
        }
        if (this.mVoidFluidPart) {
            aNBT.func_74757_a("mVoidOverflow", true);
        }
        if (this.mVoidFluidFull) {
            aNBT.func_74757_a("mVoidFluidFull", true);
        }
        if (this.mLockFluid) {
            aNBT.func_74757_a("mLockFluid", true);
        }
        if (GT_Utility.isStringValid(this.lockedFluidName)) {
            aNBT.func_74778_a("lockedFluidName", this.lockedFluidName);
        }
        if (this.mAllowInputFromOutputSide) {
            aNBT.func_74757_a("mAllowInputFromOutputSide", true);
        }
        super.setItemNBT(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mOutputFluid", this.mOutputFluid);
        aNBT.func_74757_a("mVoidOverflow", this.mVoidFluidPart);
        aNBT.func_74757_a("mVoidFluidFull", this.mVoidFluidFull);
        aNBT.func_74757_a("mLockFluid", this.mLockFluid);
        if (GT_Utility.isStringValid(this.lockedFluidName)) {
            aNBT.func_74778_a("lockedFluidName", this.lockedFluidName);
        } else {
            aNBT.func_82580_o("lockedFluidName");
        }
        aNBT.func_74757_a("mAllowInputFromOutputSide", this.mAllowInputFromOutputSide);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mOutputFluid = aNBT.func_74767_n("mOutputFluid");
        this.mVoidFluidPart = aNBT.func_74767_n("mVoidOverflow");
        this.mVoidFluidFull = aNBT.func_74767_n("mVoidFluidFull");
        this.mLockFluid = aNBT.func_74767_n("mLockFluid");
        this.lockedFluidName = aNBT.func_74779_i("lockedFluidName");
        this.lockedFluidName = GT_Utility.isStringInvalid(this.lockedFluidName) ? null : this.lockedFluidName;
        this.mAllowInputFromOutputSide = aNBT.func_74767_n("mAllowInputFromOutputSide");
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return !this.mLockFluid || this.lockedFluidName == null || this.lockedFluidName.equals(aFluid.getFluid().getName());
    }

    @Override
    public boolean isFluidChangingAllowed() {
        return !this.mLockFluid || this.lockedFluidName == null;
    }

    @Override
    public void onEmptyingContainerWhenEmpty() {
        if (this.lockedFluidName == null && this.mFluid != null) {
            this.lockedFluidName = this.mFluid.getFluid().getName();
        }
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public void setLockedFluidName(String lockedFluidName) {
        Fluid fluid;
        this.lockedFluidName = lockedFluidName;
        if (lockedFluidName != null && (fluid = FluidRegistry.getFluid((String)lockedFluidName)) != null) {
            this.setFillableStack(new FluidStack(fluid, this.getFluidAmount()));
            this.mLockFluid = true;
        }
    }

    @Override
    public String getLockedFluidName() {
        return this.lockedFluidName;
    }

    @Override
    public void lockFluid(boolean lock) {
        this.mLockFluid = lock;
    }

    @Override
    public boolean isFluidLocked() {
        return this.mLockFluid;
    }

    @Override
    public boolean allowChangingLockedFluid(String name) {
        return this.getFluidAmount() == 0;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide != ForgeDirection.UP.ordinal()) {
            if (aSide == aBaseMetaTileEntity.getFrontFacing()) {
                return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
            }
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_QTANK), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_QTANK_GLOW).glow().build()};
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mAllowInputFromOutputSide = !this.mAllowInputFromOutputSide;
            GT_Utility.sendChatToPlayer(aPlayer, this.mAllowInputFromOutputSide ? GT_Utility.getTrans("095") : GT_Utility.getTrans("096"));
        }
    }

    @Override
    public FluidStack setFillableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        if (this.mFluid != null) {
            this.mFluid.amount = Math.min(this.mFluid.amount, this.getRealCapacity());
        }
        return this.mFluid;
    }

    @Override
    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        if (this.mFluid != null) {
            this.mFluid.amount = Math.min(this.mFluid.amount, this.getRealCapacity());
        }
        return this.mFluid;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack tOutput;
            FluidStack tFluid;
            if (this.isFluidChangingAllowed() && this.getFillableStack() != null && this.getFillableStack().amount <= 0) {
                this.setFillableStack(null);
            }
            if (this.mVoidFluidFull && this.getFillableStack() != null) {
                this.mVoidFluidPart = false;
                this.mLockFluid = false;
                this.setFillableStack(null);
            }
            if (this.mOpenerCount > 0) {
                this.updateFluidDisplayItem();
            }
            if (this.doesEmptyContainers() && (tFluid = GT_Utility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true)) != null && this.isFluidInputAllowed(tFluid)) {
                if (this.getFillableStack() == null) {
                    if (this.isFluidInputAllowed(tFluid) && (tFluid.amount <= this.getRealCapacity() || this.mVoidFluidPart)) {
                        tFluid = tFluid.copy();
                        if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerForFilledItem(this.mInventory[this.getInputSlot()], true), 1)) {
                            this.setFillableStack(tFluid);
                            this.onEmptyingContainerWhenEmpty();
                            aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                        }
                    }
                } else if (tFluid.isFluidEqual(this.getFillableStack()) && ((long)tFluid.amount + (long)this.getFillableStack().amount <= (long)this.getRealCapacity() || this.mVoidFluidPart || this.mVoidFluidFull) && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerForFilledItem(this.mInventory[this.getInputSlot()], true), 1)) {
                    this.getFillableStack().amount += Math.min(tFluid.amount, this.getRealCapacity() - this.getFillableStack().amount);
                    aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                }
            }
            if (this.doesFillContainers() && (tOutput = GT_Utility.fillFluidContainer(this.getDrainableStack(), this.mInventory[this.getInputSlot()], false, true)) != null && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tOutput, 1)) {
                FluidStack tFluid2 = GT_Utility.getFluidForFilledItem(tOutput, true);
                aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                if (tFluid2 != null) {
                    this.getDrainableStack().amount -= tFluid2.amount;
                }
                if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                    this.setDrainableStack(null);
                }
            }
        }
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (this.getFillableStack() != null && !this.getFillableStack().isFluidEqual(aFluid)) {
            return 0;
        }
        FluidStack fillableStack = this.getFillableStack();
        if (fillableStack == null) {
            fillableStack = aFluid.copy();
            fillableStack.amount = 0;
        }
        int amount = Math.min(aFluid.amount, this.getRealCapacity() - fillableStack.amount);
        if (doFill) {
            fillableStack.amount += amount;
            if (this.getFillableStack() == null) {
                this.setFillableStack(fillableStack);
            }
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return this.mVoidFluidPart || this.mVoidFluidFull ? aFluid.amount : amount;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        int tFilledAmount;
        FluidStack tDrained;
        IFluidHandler tTank;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mOutputFluid && this.getDrainableStack() != null && aTick % 20L == 0L && (tTank = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing())) != null && (tDrained = this.drain(20 * (1 << 3 + 2 * GT_MetaTileEntity_DigitalTankBase.tierPump(this.mTier)), false)) != null && (tFilledAmount = tTank.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), tDrained, false)) > 0) {
            tTank.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), this.drain(tFilledAmount, true), true);
        }
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return this.mAllowInputFromOutputSide || aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    public int getCapacity() {
        return this.mVoidFluidPart || this.mVoidFluidFull ? Integer.MAX_VALUE : this.getRealCapacity();
    }

    public int getRealCapacity() {
        return GT_MetaTileEntity_DigitalTankBase.commonSizeCompute(this.mTier);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        FluidStack fluid;
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        FluidStack fluidStack = fluid = tag.func_74764_b("mFluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("mFluid")) : null;
        if (fluid != null && fluid.amount > 0) {
            currenttip.remove(0);
            currenttip.add(0, String.format("%d / %d mB %s", fluid.amount, this.getRealCapacity(), fluid.getLocalizedName()));
        } else {
            currenttip.add(0, "Tank Empty");
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        FluidStack fluid = this.getFluid();
        if (fluid != null) {
            tag.func_74782_a("mFluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        } else if (tag.func_74764_b("mFluid")) {
            tag.func_82580_o("mFluid");
        }
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getInputSlot()).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getOutputSlot()).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_OUT}).setPos(79, 43))).widget(new FluidDisplaySlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getStackDisplaySlot()).setFluidAccessConstructor(() -> this.constructFluidAccess(false)).setIHasFluidDisplay(this).setCanDrain(true).setCanFill(!this.isDrainableStackSeparate()).setActionRealClick(FluidDisplaySlotWidget.Action.TRANSFER).setActionDragAndDrop(FluidDisplaySlotWidget.Action.LOCK).setBeforeRealClick((clickData, widget) -> {
            if (NetworkUtils.isClient()) {
                this.setDrainableStack(GT_Utility.getFluidFromDisplayStack(widget.getMcSlot().func_75211_c()));
            }
            return true;
        }).setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT}).setPos(58, 41))).widget(new TextWidget("Liquid Amount").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(TextWidget.dynamicString(() -> GT_Utility.parseNumberToString(this.mFluid != null ? this.mFluid.amount : 0)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30))).widget(new CycleButtonWidget().setToggle(() -> this.mOutputFluid, val -> {
            this.mOutputFluid = val;
            if (!this.mOutputFluid) {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.trans("262", "Fluid Auto Output Disabled"));
            } else {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.trans("263", "Fluid Auto Output Enabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_AUTOOUTPUT_FLUID).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.autooutput.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(7, 63).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mLockFluid, val -> {
            this.mLockFluid = val;
            if (this.mLockFluid) {
                String inBrackets;
                if (this.mFluid == null) {
                    this.setLockedFluidName(null);
                    inBrackets = GT_Utility.trans("264", "currently none, will be locked to the next that is put in");
                } else {
                    this.setLockedFluidName(this.getDrainableStack().getFluid().getName());
                    inBrackets = this.getDrainableStack().getLocalizedName();
                }
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), String.format("%s (%s)", GT_Utility.trans("265", "1 specific Fluid"), inBrackets));
            } else {
                this.setLockedFluidName(null);
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.trans("266", "Lock Fluid Mode Disabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_LOCK).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.lockfluid.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(25, 63).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mAllowInputFromOutputSide, val -> {
            this.mAllowInputFromOutputSide = val;
            if (!this.mAllowInputFromOutputSide) {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.getTrans("096"));
            } else {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.getTrans("095"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_INPUT_FROM_OUTPUT_SIDE).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.inputfromoutput.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(43, 63).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mVoidFluidPart, val -> {
            this.mVoidFluidPart = val;
            if (!this.mVoidFluidPart) {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.trans("267", "Overflow Voiding Mode Disabled"));
            } else {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.trans("268", "Overflow Voiding Mode Enabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_VOID_EXCESS).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.voidoverflow.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(151, 7).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mVoidFluidFull, val -> {
            this.mVoidFluidFull = val;
            if (!this.mVoidFluidFull) {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.trans("269", "Void Full Mode Disabled"));
            } else {
                GT_Utility.sendChatToPlayer(buildContext.getPlayer(), GT_Utility.trans("270", "Void Full Mode Enabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_VOID_ALL).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.voidfull.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(151, 25).setSize(18, 18));
    }

    @Override
    protected IFluidAccess constructFluidAccess(boolean aIsFillableStack) {
        return new DigitalTankFluidAccess(this, aIsFillableStack);
    }

    static class DigitalTankFluidAccess
    extends GT_MetaTileEntity_BasicTank.BasicTankFluidAccess {
        public DigitalTankFluidAccess(GT_MetaTileEntity_BasicTank aTank, boolean aIsFillableStack) {
            super(aTank, aIsFillableStack);
        }

        @Override
        public void set(FluidStack stack) {
            super.set(stack);
            ((GT_MetaTileEntity_DigitalTankBase)this.mTank).onEmptyingContainerWhenEmpty();
        }

        @Override
        public int getRealCapacity() {
            return ((GT_MetaTileEntity_DigitalTankBase)this.mTank).getRealCapacity();
        }

        @Override
        public void verifyFluidStack() {
        }
    }
}

