/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_CubicMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ExoticEnergyInputHelper;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ProcessingArray_Manager;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Single_Recipe_Check;
import gregtech.api.util.GT_Single_Recipe_Check_Processing_Array;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Item_Machines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_ProcessingArray
extends GT_MetaTileEntity_CubicMultiBlockBase<GT_MetaTileEntity_ProcessingArray> {
    private GT_Recipe.GT_Recipe_Map mLastRecipeMap;
    private GT_Recipe mLastRecipe;
    private int tTier = 0;
    private int mMult = 0;
    private boolean downtierUEV = true;
    private String mMachineName = "";
    private long mEUPerTick = 0L;

    public GT_MetaTileEntity_ProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ProcessingArray(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ProcessingArray(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Processing Array").addInfo("Runs supplied machines as if placed in the world").addInfo("Place up to 64 singleblock GT machines into the controller").addInfo("Note that you still need to supply power to them all").addInfo("Use a screwdriver to enable separate input busses").addInfo("Use a wire cutter to disable UEV+ downtiering").addInfo("Doesn't work on certain machines, deal with it").addInfo("Use it if you hate GT++, or want even more speed later on").addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfoRange("Robust Tungstensteel Machine Casing", 14, 24, false).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).addInputBus("Any casing", 1).addInputHatch("Any casing", 1).addOutputBus("Any casing", 1).addOutputHatch("Any casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48]};
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.isCorrectMachinePart(this.mInventory[1])) {
            int length = this.mInventory[1].func_77977_a().length();
            String aMachineName = this.mInventory[1].func_77977_a().substring(17, length - 8);
            return GT_ProcessingArray_Manager.giveRecipeMap(aMachineName);
        }
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77977_a().startsWith("gt.blockmachines.");
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        SoundResource sound = SoundResource.get(aIndex < 0 ? aIndex + 256 : 0);
        if (sound != null) {
            GT_Utility.doSoundAtClient(sound, this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
        }
    }

    @Override
    protected boolean checkRecipe() {
        this.startRecipeProcessing();
        boolean result = this.checkRecipe(this.mInventory[1]);
        if (result) {
            int length = this.mInventory[1].func_77977_a().length();
            String aMachineName = this.mInventory[1].func_77977_a().substring(17, length - 8);
            SoundResource sound = GT_ProcessingArray_Manager.getSoundResource(aMachineName);
            if (sound != null) {
                this.sendLoopStart((byte)sound.id);
            }
        }
        this.endRecipeProcessing();
        return result;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (this.mLockedToSingleRecipe && this.mSingleRecipeCheck != null) {
            return this.processLockedRecipe();
        }
        if (!this.isCorrectMachinePart(this.mInventory[1])) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map map = this.getRecipeMap();
        if (map == null) {
            return false;
        }
        if (!this.mMachineName.equals(this.mInventory[1].func_77977_a())) {
            this.mLastRecipe = null;
            this.mMachineName = this.mInventory[1].func_77977_a();
        }
        if (this.mLastRecipe == null) {
            this.setTierAndMult();
        }
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (this.inputSeparation) {
            ArrayList<ItemStack> tInputList = new ArrayList<ItemStack>();
            for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
                IGregTechTileEntity tInputBus = tHatch.getBaseMetaTileEntity();
                for (int i = tInputBus.func_70302_i_() - 1; i >= 0; --i) {
                    if (tInputBus.func_70301_a(i) == null) continue;
                    tInputList.add(tInputBus.func_70301_a(i));
                }
                ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
                if (this.processRecipe(tInputs, tFluids, map)) {
                    return true;
                }
                tInputList.clear();
            }
        } else {
            ArrayList<ItemStack> tInputList = this.getStoredInputs();
            ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
            return this.processRecipe(tInputs, tFluids, map);
        }
        return false;
    }

    private void setTierAndMult() {
        IMetaTileEntity aMachine = GT_Item_Machines.getMetaTileEntity(this.mInventory[1]);
        if (aMachine != null) {
            this.tTier = ((GT_MetaTileEntity_TieredMachineBlock)aMachine).mTier;
        }
        this.mMult = 0;
        if (this.downtierUEV && this.tTier > 9) {
            --this.tTier;
            this.mMult = 2;
        }
    }

    public boolean processLockedRecipe() {
        GT_Single_Recipe_Check_Processing_Array tSingleRecipeCheck = (GT_Single_Recipe_Check_Processing_Array)this.mSingleRecipeCheck;
        if (this.mLastRecipe == null) {
            this.setTierAndMult();
            this.mLastRecipe = tSingleRecipeCheck.getRecipe();
        }
        int machines = this.mInventory[1].field_77994_a << this.mMult;
        int parallel = tSingleRecipeCheck.checkRecipeInputs(true, machines);
        return this.processRecipeOutputs(tSingleRecipeCheck.getRecipe(), tSingleRecipeCheck.getRecipeAmperage(), parallel, 1);
    }

    public boolean processRecipe(ItemStack[] tInputs, FluidStack[] tFluids, GT_Recipe.GT_Recipe_Map map) {
        int multiplier;
        int i;
        if (tInputs.length <= 0 && tFluids.length <= 0) {
            return false;
        }
        GT_Recipe tRecipe = map.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[this.tTier], tFluids, tInputs);
        if (tRecipe == null) {
            return false;
        }
        if (GT_Mod.gregtechproxy.mLowGravProcessing && tRecipe.mSpecialValue == -100 && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(tRecipe, this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
            return false;
        }
        GT_Single_Recipe_Check_Processing_Array.Builder tSingleRecipeCheckBuilder = null;
        if (this.mLockedToSingleRecipe) {
            tSingleRecipeCheckBuilder = GT_Single_Recipe_Check_Processing_Array.processingArrayBuilder(this).setBefore(tInputs, tFluids);
        }
        boolean recipeLocked = false;
        this.mLastRecipe = tRecipe;
        int machines = this.mInventory[1].field_77994_a << this.mMult;
        for (i = 0; i < machines && tRecipe.isRecipeInputEqual(true, tFluids, tInputs); ++i) {
            if (!this.mLockedToSingleRecipe || recipeLocked) continue;
            this.mSingleRecipeCheck = tSingleRecipeCheckBuilder.setAfter(tInputs, tFluids).setRecipe(tRecipe).setRecipeAmperage(map.mAmperage).build();
            recipeLocked = true;
        }
        if (this.batchMode && i == machines) {
            for (multiplier = 1; multiplier < 128 && tRecipe.isRecipeInputEqual(true, false, machines, tFluids, tInputs); ++multiplier) {
            }
        }
        return this.processRecipeOutputs(tRecipe, map.mAmperage, i, multiplier);
    }

    public boolean processRecipeOutputs(GT_Recipe aRecipe, int aAmperage, int parallel, int multiplier) {
        this.mEUPerTick = 0L;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        if (parallel == 0) {
            return false;
        }
        this.mMaxProgresstime = aRecipe.mDuration * multiplier;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.ProcessingArrayCalculateOverclock(aRecipe.mEUt, aRecipe.mDuration * multiplier, aAmperage, GT_Values.V[this.tTier], false);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUPerTick == 0x7FFFFFFFFFFFFFFEL) {
            return false;
        }
        this.mEUPerTick *= (long)parallel;
        if (this.mEUPerTick == 0x7FFFFFFFFFFFFFFEL) {
            return false;
        }
        if (this.mEUPerTick > 0L) {
            this.mEUPerTick = -this.mEUPerTick;
        }
        ItemStack[] tOut = new ItemStack[aRecipe.mOutputs.length];
        for (int h = 0; h < aRecipe.mOutputs.length; ++h) {
            if (aRecipe.getOutput(h) == null) continue;
            tOut[h] = aRecipe.getOutput(h).func_77946_l();
            tOut[h].field_77994_a = 0;
        }
        FluidStack[] tFOut = new FluidStack[aRecipe.mFluidOutputs.length];
        for (int i = 0; i < aRecipe.mFluidOutputs.length; ++i) {
            if (aRecipe.getFluidOutput(i) == null) continue;
            tFOut[i] = aRecipe.getFluidOutput(i).copy();
        }
        for (int f = 0; f < tOut.length; ++f) {
            if (aRecipe.mOutputs[f] == null || tOut[f] == null) continue;
            for (int g = 0; g < parallel * multiplier; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= aRecipe.getOutputChance(f)) continue;
                tOut[f].field_77994_a += aRecipe.mOutputs[f].field_77994_a;
            }
        }
        int oNumber = 0;
        for (FluidStack fluidStack : tFOut) {
            if (fluidStack != null) {
                int tSize = fluidStack.amount;
                tFOut[oNumber].amount = tSize * parallel * multiplier;
            }
            oNumber = (byte)(oNumber + 1);
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.mOutputItems = (ItemStack[])Arrays.stream(tOut).filter(Objects::nonNull).flatMap(GT_MetaTileEntity_ProcessingArray::splitOversizedStack).filter(is -> is.field_77994_a > 0).toArray(ItemStack[]::new);
        this.mOutputFluids = tFOut;
        this.updateSlots();
        return true;
    }

    private static Stream<ItemStack> splitOversizedStack(ItemStack aStack) {
        int tMaxStackSize = aStack.func_77976_d();
        if (aStack.field_77994_a <= tMaxStackSize) {
            return Stream.of(aStack);
        }
        int tRepeat = aStack.field_77994_a / tMaxStackSize;
        aStack.field_77994_a %= tMaxStackSize;
        Stream.Builder<ItemStack> tBuilder = Stream.builder();
        tBuilder.add(aStack);
        for (int i = 0; i < tRepeat; ++i) {
            ItemStack rStack = aStack.func_77946_l();
            rStack.field_77994_a = tMaxStackSize;
            tBuilder.add(rStack);
        }
        return tBuilder.build();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        GT_Recipe.GT_Recipe_Map tCurrentMap;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mMachine && aTick % 20L == 0L && (tCurrentMap = this.getRecipeMap()) != this.mLastRecipeMap) {
            for (GT_MetaTileEntity_Hatch_InputBus tInputBus : this.mInputBusses) {
                tInputBus.mRecipeMap = tCurrentMap;
            }
            for (GT_MetaTileEntity_Hatch_Input tInputHatch : this.mInputHatches) {
                tInputHatch.mRecipeMap = tCurrentMap;
            }
            this.mLastRecipeMap = tCurrentMap;
        }
    }

    @Override
    protected IStructureElement<GT_MetaTileEntity_CubicMultiBlockBase<?>> getCasingElement() {
        return StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0);
    }

    @Override
    protected int getHatchTextureIndex() {
        return 48;
    }

    @Override
    protected int getRequiredCasingCount() {
        return 14;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("downtierUEV", this.downtierUEV);
        aNBT.func_74772_a("mEUPerTick", this.mEUPerTick);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (!aNBT.func_74764_b(INPUT_SEPARATION_NBT_KEY)) {
            this.inputSeparation = aNBT.func_74767_n("mSeparate");
        }
        if (!aNBT.func_74764_b(BATCH_MODE_NBT_KEY)) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
        this.downtierUEV = aNBT.func_74767_n("downtierUEV");
        this.mEUPerTick = aNBT.func_74763_f("mEUPerTick");
    }

    @Override
    protected GT_Single_Recipe_Check loadSingleRecipeChecker(NBTTagCompound aNBT) {
        return GT_Single_Recipe_Check_Processing_Array.tryLoad(this, this.getRecipeMap(), aNBT, this.mInventory[1]);
    }

    @Override
    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        } else {
            this.inputSeparation = !this.inputSeparation;
            GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
        }
    }

    @Override
    public boolean onWireCutterRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GT_Utility.sendChatToPlayer(aPlayer, "Batch recipes");
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, "Don't batch recipes");
            }
            return true;
        }
        this.downtierUEV = !this.downtierUEV;
        this.mLastRecipe = null;
        GT_Utility.sendChatToPlayer(aPlayer, "Treat UEV+ machines as multiple UHV " + this.downtierUEV);
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    protected List<IHatchElement<? super GT_MetaTileEntity_CubicMultiBlockBase<?>>> getAllowedHatches() {
        return ImmutableList.of((Object)GT_HatchElement.InputHatch, (Object)GT_HatchElement.OutputHatch, (Object)GT_HatchElement.InputBus, (Object)GT_HatchElement.OutputBus, (Object)GT_HatchElement.Muffler, (Object)GT_HatchElement.Maintenance, (Object)GT_HatchElement.Energy, (Object)GT_HatchElement.ExoticEnergy);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mExoticEnergyHatches.clear();
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    public boolean drainEnergyInput(long aEU) {
        return GT_ExoticEnergyInputHelper.drainEnergy(aEU, this.getExoticAndNormalEnergyHatchList());
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.mExoticEnergyHatches) {
            if (!GT_MetaTileEntity_ProcessingArray.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(-this.mEUPerTick) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(GT_ExoticEnergyInputHelper.getMaxInputVoltageMulti(this.getExoticAndNormalEnergyHatchList())) + EnumChatFormatting.RESET + " EU/t(*" + GT_Utility.formatNumbers(GT_ExoticEnergyInputHelper.getMaxInputAmpsMulti(this.getExoticAndNormalEnergyHatchList())) + "A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(GT_ExoticEnergyInputHelper.getMaxInputVoltageMulti(this.getExoticAndNormalEnergyHatchList()))] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.PA.machinetier") + ": " + EnumChatFormatting.GREEN + this.tTier + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.PA.discount") + ": " + EnumChatFormatting.GREEN + 1 + EnumChatFormatting.RESET + " x", StatCollector.func_74838_a((String)"GT5U.PA.parallel") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mInventory[1] != null ? (long)(this.mInventory[1].field_77994_a << this.mMult) : 0L) + EnumChatFormatting.RESET};
    }

    public List<GT_MetaTileEntity_Hatch> getExoticAndNormalEnergyHatchList() {
        ArrayList<GT_MetaTileEntity_Hatch> tHatches = new ArrayList<GT_MetaTileEntity_Hatch>();
        tHatches.addAll(this.mExoticEnergyHatches);
        tHatches.addAll(this.mEnergyHatches);
        return tHatches;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUPerTick < 0L && !this.drainEnergyInput(-this.mEUPerTick)) {
            this.mEUPerTick = 0L;
            this.criticalStopMachine();
            return false;
        }
        return true;
    }

    protected void ProcessingArrayCalculateOverclock(long aEUt, int aDuration, int mAmperage, long maxInputVoltage, boolean perfectOC) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier(maxInputVoltage));
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUPerTick = 0x7FFFFFFFFFFFFFFEL;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUPerTick = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            int ocTimeShift;
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            int n = ocTimeShift = perfectOC ? 2 : 1;
            while (tempEUt <= GT_Values.V[mTier - 1] * (long)mAmperage) {
                tempEUt <<= 2;
                int oldTime = this.mMaxProgresstime;
                this.mMaxProgresstime >>= ocTimeShift;
                if (this.mMaxProgresstime < 1) {
                    if (oldTime == 1) break;
                    xEUt *= (long)(oldTime * (perfectOC ? 1 : 2));
                    break;
                }
                xEUt <<= 2;
            }
            if (xEUt > 0x7FFFFFFFFFFFFFFEL) {
                this.mEUPerTick = 0x7FFFFFFFFFFFFFFEL;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUPerTick = xEUt;
                if (this.mEUPerTick == 0L) {
                    this.mEUPerTick = 1L;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
    }

    @Override
    protected boolean isInputSeparationButtonEnabled() {
        return true;
    }

    @Override
    protected boolean isBatchModeButtonEnabled() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.downtierUEV = !this.downtierUEV;
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.downtierUEV) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_DOWN_TIERING_ON);
            } else {
                ret.add(GT_UITextures.OVERLAY_BUTTON_DOWN_TIERING_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(80, 91).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.down_tier")).setTooltipShowUpDelay(5))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.downtierUEV, val -> {
            this.downtierUEV = val;
        }));
    }
}

