/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import appeng.util.ReadableNumberConverter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.common.items.GT_FluidDisplayItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GT_FluidDisplayStackRenderer
implements IItemRenderer {
    public GT_FluidDisplayStackRenderer() {
        MinecraftForgeClient.registerItemRenderer((Item)ItemList.Display_Fluid.getItem(), (IItemRenderer)this);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (!item.func_77942_o()) {
            return false;
        }
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (item == null || item.func_77973_b() == null || !(item.func_77973_b() instanceof GT_FluidDisplayItem)) {
            return;
        }
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        Materials associatedFluidMaterial = Materials.get(item.field_77990_d.func_74779_i("mFluidMaterialName"));
        if (associatedFluidMaterial.renderer == null || !associatedFluidMaterial.renderer.renderFluidDisplayItem(type, item, data)) {
            IIcon icon = item.func_77973_b().func_77617_a(item.func_77960_j());
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            float x_min = icon.func_94209_e();
            float x_max = icon.func_94212_f();
            float y_min = icon.func_94206_g();
            float y_max = icon.func_94210_h();
            tess.func_78374_a(0.0, 16.0, 0.0, (double)x_min, (double)y_max);
            tess.func_78374_a(16.0, 16.0, 0.0, (double)x_max, (double)y_max);
            tess.func_78374_a(16.0, 0.0, 0.0, (double)x_max, (double)y_min);
            tess.func_78374_a(0.0, 0.0, 0.0, (double)x_min, (double)y_min);
            tess.func_78381_a();
        }
        if (item.func_77978_p() == null) {
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3008);
            return;
        }
        long fluidAmount = item.func_77978_p().func_74763_f("mFluidDisplayAmount");
        if (fluidAmount > 0L && !item.func_77978_p().func_74767_n("mHideStackSize")) {
            String amountString = fluidAmount < 10000L ? "" + fluidAmount + "L" : ReadableNumberConverter.INSTANCE.toWideReadableForm(fluidAmount) + "L";
            FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
            float smallTextScale = fontRender.func_82883_a() ? 0.75f : 0.5f;
            GL11.glDisable((int)3042);
            GL11.glPushMatrix();
            GL11.glScalef((float)smallTextScale, (float)smallTextScale, (float)1.0f);
            fontRender.func_85187_a(amountString, 0, (int)(16.0f / smallTextScale) - fontRender.field_78288_b + 1, 0xFFFFFF, true);
            GL11.glPopMatrix();
            GL11.glDisable((int)3008);
        }
    }
}

