/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.io.ByteArrayDataInput;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;

public interface ISerializableObject {
    @Nonnull
    public ISerializableObject copy();

    @Nonnull
    public NBTBase saveDataToNBT();

    public void writeToByteBuf(ByteBuf var1);

    public void loadDataFromNBT(NBTBase var1);

    @Nonnull
    public ISerializableObject readFromPacket(ByteArrayDataInput var1, @Nullable EntityPlayerMP var2);

    public static NBTTagCompound readCompoundTagFromGreggyByteBuf(ByteArrayDataInput aBuf) {
        short size = aBuf.readShort();
        if (size < 0) {
            return null;
        }
        byte[] buf = new byte[size];
        aBuf.readFully(buf);
        try {
            return CompressedStreamTools.func_152457_a((byte[])buf, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemStack readItemStackFromGreggyByteBuf(ByteArrayDataInput aBuf) {
        ItemStack stack = null;
        short id = aBuf.readShort();
        if (id >= 0) {
            byte size = aBuf.readByte();
            short meta = aBuf.readShort();
            stack = new ItemStack(Item.func_150899_d((int)id), (int)size, (int)meta);
            stack.field_77990_d = ISerializableObject.readCompoundTagFromGreggyByteBuf(aBuf);
        }
        return stack;
    }

    public static final class LegacyCoverData
    implements ISerializableObject {
        private int mData;

        public LegacyCoverData() {
        }

        public LegacyCoverData(int mData) {
            this.mData = mData;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new LegacyCoverData(this.mData);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            return new NBTTagInt(this.mData);
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeInt(this.mData);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            this.mData = aNBT instanceof NBTTagInt ? ((NBTTagInt)aNBT).func_150287_d() : 0;
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.mData = aBuf.readInt();
            return this;
        }

        public int get() {
            return this.mData;
        }

        public void set(int mData) {
            this.mData = mData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LegacyCoverData that = (LegacyCoverData)o;
            return this.mData == that.mData;
        }

        public int hashCode() {
            return this.mData;
        }

        public String toString() {
            return String.valueOf(this.mData);
        }
    }
}

