/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import ic2.api.reactor.IReactorComponent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GT_RecipeRegistrator {
    public static final List<Materials> sRodMaterialList = new ArrayList<Materials>();
    private static final ItemStack sMt1 = new ItemStack(Blocks.field_150346_d, 1, 0);
    private static final ItemStack sMt2 = new ItemStack(Blocks.field_150346_d, 1, 0);
    private static final String s_H = "h";
    private static final String s_F = "f";
    private static final String s_I = "I";
    private static final String s_P = "P";
    private static final String s_R = "R";
    private static final RecipeShape[] sShapes = new RecipeShape[]{new RecipeShape(sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1, null), new RecipeShape(sMt1, null, sMt1, sMt1, null, sMt1, sMt1, sMt1, sMt1), new RecipeShape(null, sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, null, sMt1, null, null, null), new RecipeShape(sMt1, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, null, sMt1, sMt1, null, sMt1), new RecipeShape(null, null, null, sMt1, null, sMt1, sMt1, null, sMt1), new RecipeShape(null, sMt1, null, null, sMt1, null, null, sMt2, null), new RecipeShape(sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, null, null, sMt2, null, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, sMt1, null, sMt2, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, sMt1, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, null, sMt1, null, null, null, sMt1, sMt2), new RecipeShape(null, sMt1, null, null, null, sMt1, sMt2, sMt1, null), new RecipeShape(null, sMt1, null, sMt1, null, sMt1, null, null, sMt2), new RecipeShape(null, sMt1, null, sMt1, null, sMt1, sMt2, null, null), new RecipeShape(null, sMt2, null, null, sMt1, null, null, sMt1, null), new RecipeShape(null, sMt2, null, null, sMt2, null, sMt1, sMt1, sMt1), new RecipeShape(null, sMt2, null, null, sMt2, null, null, sMt1, null), new RecipeShape(null, sMt2, null, sMt1, sMt2, null, sMt1, sMt1, null), new RecipeShape(null, sMt2, null, null, sMt2, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, null, sMt2, null, sMt1, sMt1, null), new RecipeShape(sMt1, null, null, null, sMt2, null, null, null, sMt2), new RecipeShape(null, null, sMt1, null, sMt2, null, sMt2, null, null), new RecipeShape(sMt1, null, null, null, sMt2, null, null, null, null), new RecipeShape(null, null, sMt1, null, sMt2, null, null, null, null), new RecipeShape(sMt1, sMt2, null, null, null, null, null, null, null), new RecipeShape(sMt2, sMt1, null, null, null, null, null, null, null), new RecipeShape(sMt1, null, null, sMt2, null, null, null, null, null), new RecipeShape(sMt2, null, null, sMt1, null, null, null, null, null), new RecipeShape(sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt1, sMt2, sMt1, sMt1, null), new RecipeShape(null, sMt1, sMt1, sMt2, sMt1, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, sMt2, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt2, sMt2, sMt1, sMt1, null), new RecipeShape(null, sMt1, sMt1, sMt2, sMt2, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, sMt1, sMt2, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, null, null, null, sMt1, null, null, null, null), new RecipeShape(null, sMt1, null, sMt1, null, null, null, null, null), new RecipeShape(sMt1, sMt1, null, sMt2, null, sMt1, sMt2, null, null), new RecipeShape(null, sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2)};
    public static final Field SHAPED_ORE_RECIPE_WIDTH = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"width"});
    public static final Field SHAPED_ORE_RECIPE_HEIGHT = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"height"});
    private static volatile Map<RecipeShape, List<IRecipe>> indexedRecipeListCache;
    private static final String[][] sShapesA;
    public static volatile int VERSION;
    private static final Materials[] VANILLA_MATS;

    public static void registerMaterialRecycling(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByproduct) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        if (aByproduct != null) {
            aByproduct = aByproduct.clone();
            aByproduct.mAmount /= (long)aStack.field_77994_a;
        }
        GT_OreDictUnificator.addItemData(GT_Utility.copyAmount(1L, aStack), new ItemData(aMaterial, aMaterialAmount / (long)aStack.field_77994_a, aByproduct));
    }

    public static void registerMaterialRecycling(ItemStack aStack, ItemData aData) {
        if (GT_Utility.isStackInvalid(aStack) || GT_Utility.areStacksEqual(new ItemStack(Items.field_151072_bj), aStack) || aData == null || !aData.hasValidMaterialData() || !aData.mMaterial.mMaterial.mAutoGenerateRecycleRecipes || aData.mMaterial.mAmount <= 0L || GT_Utility.getFluidForFilledItem(aStack, false) != null || aData.mMaterial.mMaterial.mSubTags.contains(SubTag.NO_RECIPES)) {
            return;
        }
        GT_RecipeRegistrator.registerReverseMacerating(GT_Utility.copyAmount(1L, aStack), aData, aData.mPrefix == null);
        GT_RecipeRegistrator.registerReverseSmelting(GT_Utility.copyAmount(1L, aStack), aData.mMaterial.mMaterial, aData.mMaterial.mAmount, true);
        GT_RecipeRegistrator.registerReverseFluidSmelting(GT_Utility.copyAmount(1L, aStack), aData.mMaterial.mMaterial, aData.mMaterial.mAmount, aData.getByProduct(0));
        GT_RecipeRegistrator.registerReverseArcSmelting(GT_Utility.copyAmount(1L, aStack), aData);
    }

    public static void registerReverseFluidSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByproduct) {
        boolean tHide;
        if (aStack == null || aMaterial == null || aMaterial.mSmeltInto.mStandardMoltenFluid == null || !aMaterial.contains(SubTag.SMELTING_TO_FLUID) || 144L * aMaterialAmount / (3628800L * (long)aStack.field_77994_a) <= 0L) {
            return;
        }
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        boolean bl = tHide = aStack.func_77977_a().startsWith("gt.blockmachines") && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        if (GT_Mod.gregtechproxy.mHideRecyclingRecipes && tData != null && tData.hasValidPrefixData() && tData.mPrefix != OrePrefixes.dust && tData.mPrefix != OrePrefixes.ingot && !(tData.mPrefix == OrePrefixes.block | tData.mPrefix == OrePrefixes.plate)) {
            tHide = true;
        }
        GT_Values.RA.addFluidSmelterRecipe(GT_Utility.copyAmount(1L, aStack), (ItemStack)(aByproduct == null || tData != null && tData.hasValidPrefixData() && tData.mPrefix == OrePrefixes.toolHeadDrill ? null : (aByproduct.mMaterial.contains(SubTag.NO_SMELTING) || !aByproduct.mMaterial.contains(SubTag.METAL) ? (aByproduct.mMaterial.contains(SubTag.FLAMMABLE) ? GT_OreDictUnificator.getDust(Materials.Ash, aByproduct.mAmount / 2L) : (aByproduct.mMaterial.contains(SubTag.UNBURNABLE) ? GT_OreDictUnificator.getDustOrIngot(aByproduct.mMaterial.mSmeltInto, aByproduct.mAmount) : null)) : GT_OreDictUnificator.getIngotOrDust(aByproduct.mMaterial.mSmeltInto, aByproduct.mAmount))), aMaterial.mSmeltInto.getMolten(144L * aMaterialAmount / (3628800L * (long)aStack.field_77994_a)), 10000, (int)Math.max(1L, 24L * aMaterialAmount / 3628800L), Math.max(8, (int)Math.sqrt(2 * aMaterial.mSmeltInto.mStandardMoltenFluid.getTemperature())), tHide);
    }

    public static void registerReverseSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, boolean aAllowAlloySmelter) {
        boolean tHide;
        if (aStack == null || aMaterial == null || aMaterialAmount <= 0L || aMaterial.contains(SubTag.NO_SMELTING) || aMaterialAmount > 3628800L && aMaterial.contains(SubTag.METAL) || (long)aMaterial.getProcessingMaterialTierEU() > TierEU.IV) {
            return;
        }
        if (aMaterial == Materials.Naquadah || aMaterial == Materials.NaquadahEnriched) {
            return;
        }
        aMaterialAmount /= (long)aStack.field_77994_a;
        boolean bl = tHide = aMaterial != Materials.Iron && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        if (aAllowAlloySmelter) {
            GT_ModHandler.addSmeltingAndAlloySmeltingRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.getIngot(aMaterial.mSmeltInto, aMaterialAmount), tHide);
        } else {
            GT_ModHandler.addSmeltingRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.getIngot(aMaterial.mSmeltInto, aMaterialAmount));
        }
    }

    public static void registerReverseArcSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByProduct01, MaterialStack aByProduct02, MaterialStack aByProduct03) {
        GT_RecipeRegistrator.registerReverseArcSmelting(aStack, new ItemData(aMaterial == null ? null : new MaterialStack(aMaterial, aMaterialAmount), aByProduct01, aByProduct02, aByProduct03));
    }

    public static void registerReverseArcSmelting(ItemStack aStack, ItemData aData) {
        boolean tHide;
        if (aStack == null || aData == null) {
            return;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        boolean tIron = false;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            if (tMaterial.mMaterial == Materials.Iron || tMaterial.mMaterial == Materials.Copper || tMaterial.mMaterial == Materials.WroughtIron || tMaterial.mMaterial == Materials.AnnealedCopper) {
                tIron = true;
            }
            if (tMaterial.mMaterial.contains(SubTag.UNBURNABLE)) {
                tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mArcSmeltInto;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                tMaterial.mMaterial = Materials.Ash;
                tMaterial.mAmount /= 16L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.FLAMMABLE)) {
                tMaterial.mMaterial = Materials.Ash;
                tMaterial.mAmount /= 8L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.NO_SMELTING)) {
                tMaterial.mAmount = 0L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.METAL)) {
                if (GT_Mod.gregtechproxy.mArcSmeltIntoAnnealed) {
                    tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mArcSmeltInto;
                    continue;
                }
                tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mSmeltInto;
                continue;
            }
            tMaterial.mAmount = 0L;
        }
        aData = new ItemData(aData);
        if (aData.mByProducts.length > 3) {
            for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
                if (tMaterial.mMaterial != Materials.Ash) continue;
                tMaterial.mAmount = 0L;
            }
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        long tAmount = 0L;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tAmount += tMaterial.mAmount * tMaterial.mMaterial.getMass();
        }
        boolean bl = tHide = !tIron && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        if (aData.mPrefix == OrePrefixes.toolHeadDrill) {
            GT_Values.RA.addArcFurnaceRecipe(aStack, new ItemStack[]{GT_OreDictUnificator.getIngotOrDust(aData.mMaterial)}, null, 90, (int)Math.max(16L, tAmount / 3628800L), tHide);
        } else {
            GT_Values.RA.addArcFurnaceRecipe(aStack, new ItemStack[]{GT_OreDictUnificator.getIngotOrDust(aData.mMaterial), GT_OreDictUnificator.getIngotOrDust(aData.getByProduct(0)), GT_OreDictUnificator.getIngotOrDust(aData.getByProduct(1)), GT_OreDictUnificator.getIngotOrDust(aData.getByProduct(2))}, null, (int)Math.max(16L, tAmount / 3628800L), 90, tHide);
        }
    }

    public static void registerReverseMacerating(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByProduct01, MaterialStack aByProduct02, MaterialStack aByProduct03, boolean aAllowHammer) {
        GT_RecipeRegistrator.registerReverseMacerating(aStack, new ItemData(aMaterial == null ? null : new MaterialStack(aMaterial, aMaterialAmount), aByProduct01, aByProduct02, aByProduct03), aAllowHammer);
    }

    public static void registerReverseMacerating(ItemStack aStack, ItemData aData, boolean aAllowHammer) {
        boolean tHide;
        if (aStack == null || aData == null) {
            return;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tMaterial.mMaterial = tMaterial.mMaterial.mMacerateInto;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        long tAmount = 0L;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tAmount += tMaterial.mAmount * tMaterial.mMaterial.getMass();
        }
        boolean bl = tHide = aData.mMaterial.mMaterial != Materials.Iron && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        if (aData.mPrefix == OrePrefixes.toolHeadDrill) {
            GT_Values.RA.addPulveriserRecipe(aStack, new ItemStack[]{GT_OreDictUnificator.getDust(aData.mMaterial)}, null, aData.mMaterial.mMaterial == Materials.Marble ? 1 : (int)Math.max(16L, tAmount / 3628800L), 4, tHide);
        } else {
            GT_Values.RA.addPulveriserRecipe(aStack, new ItemStack[]{GT_OreDictUnificator.getDust(aData.mMaterial), GT_OreDictUnificator.getDust(aData.getByProduct(0)), GT_OreDictUnificator.getDust(aData.getByProduct(1)), GT_OreDictUnificator.getDust(aData.getByProduct(2))}, null, aData.mMaterial.mMaterial == Materials.Marble ? 1 : (int)Math.max(16L, tAmount / 3628800L), 4, tHide);
        }
        if (aAllowHammer) {
            for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
                if (!tMaterial.mMaterial.contains(SubTag.CRYSTAL) || tMaterial.mMaterial.contains(SubTag.METAL) || tMaterial.mMaterial == Materials.Glass || !GT_Values.RA.addForgeHammerRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.getDust(aData.mMaterial), 200, 30)) continue;
                break;
            }
        }
    }

    public static synchronized void registerUsagesForMaterials(String aPlate, boolean aRecipeReplacing, ItemStack ... aMats) {
        for (ItemStack aMat : aMats) {
            if ((aMat = GT_Utility.copyOrNull(aMat)) == null) continue;
            ItemData aItemData = GT_OreDictUnificator.getItemData(aMat);
            if (aItemData == null || aItemData.mPrefix != OrePrefixes.ingot) {
                aPlate = null;
            }
            if (aPlate != null && GT_OreDictUnificator.getFirstOre(aPlate, 1L) == null) {
                aPlate = null;
            }
            sMt1.func_150996_a(aMat.func_77973_b());
            GT_RecipeRegistrator.sMt1.field_77994_a = 1;
            Items.field_151008_G.setDamage(sMt1, Items.field_151008_G.getDamage(aMat));
            sMt2.func_150996_a(new ItemStack(Blocks.field_150346_d).func_77973_b());
            GT_RecipeRegistrator.sMt2.field_77994_a = 1;
            Items.field_151008_G.setDamage(sMt2, 0);
            if (aItemData != null && aItemData.hasValidPrefixMaterialData()) {
                for (RecipeShape tRecipe : sShapes) {
                    for (ItemStack tCrafted : GT_ModHandler.getRecipeOutputsBuffered(tRecipe.shape)) {
                        GT_OreDictUnificator.addItemData(tCrafted, new ItemData(aItemData.mMaterial.mMaterial, aItemData.mMaterial.mAmount * (long)tRecipe.amount1, new MaterialStack[0]));
                    }
                }
            }
            GT_RecipeRegistrator.registerStickStuff(aPlate, aItemData, aRecipeReplacing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<IRecipe> getRecipeList(RecipeShape shape) {
        boolean force;
        boolean bl = force = !GregTech_API.sPostloadStarted || GregTech_API.sPostloadFinished;
        if (!force && indexedRecipeListCache != null) return indexedRecipeListCache.get(shape);
        Class<GT_RecipeRegistrator> clazz = GT_RecipeRegistrator.class;
        synchronized (GT_RecipeRegistrator.class) {
            if (indexedRecipeListCache != null && !force) return indexedRecipeListCache.get(shape);
            indexedRecipeListCache = GT_RecipeRegistrator.createIndexedRecipeListCache();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return indexedRecipeListCache.get(shape);
        }
    }

    private static Map<RecipeShape, List<IRecipe>> createIndexedRecipeListCache() {
        IdentityHashMap<RecipeShape, List<IRecipe>> result = new IdentityHashMap<RecipeShape, List<IRecipe>>();
        ArrayList allRecipeList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        HashMultimap filter = HashMultimap.create();
        for (RecipeShape shape : sShapes) {
            for (List<Integer> list : shape.getEmptySlotsAllVariants()) {
                filter.put(list, (Object)shape);
            }
        }
        ArrayList<Integer> buffer = new ArrayList<Integer>(9);
        for (IRecipe tRecipe : allRecipeList) {
            ShapedOreRecipe tShapedRecipe;
            if (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) continue;
            buffer.clear();
            ItemStack tStack = tRecipe.func_77571_b();
            if (!GT_Utility.isStackValid(tStack) || tStack.func_77976_d() != 1 || tStack.func_77958_k() <= 0 || tStack.func_77973_b() instanceof ItemBlock || tStack.func_77973_b() instanceof IReactorComponent || GT_ModHandler.isElectricItem(tStack) || GT_Utility.isStackInList(tStack, GT_ModHandler.sNonReplaceableItems)) continue;
            if (tRecipe instanceof ShapedOreRecipe) {
                tShapedRecipe = (ShapedOreRecipe)tRecipe;
                if (!GT_RecipeRegistrator.checkRecipeShape(buffer, tShapedRecipe.getInput(), GT_RecipeRegistrator.getRecipeWidth(tShapedRecipe), GT_RecipeRegistrator.getRecipeHeight(tShapedRecipe))) continue;
                for (RecipeShape s : filter.get(buffer)) {
                    result.computeIfAbsent(s, k -> new ArrayList()).add(tRecipe);
                }
                continue;
            }
            if (tRecipe instanceof ShapedRecipes) {
                tShapedRecipe = (ShapedRecipes)tRecipe;
                if (!GT_RecipeRegistrator.checkRecipeShape(buffer, tShapedRecipe.field_77574_d, GT_RecipeRegistrator.getRecipeWidth((ShapedRecipes)tShapedRecipe), GT_RecipeRegistrator.getRecipeHeight((ShapedRecipes)tShapedRecipe))) continue;
                for (RecipeShape s : filter.get(buffer)) {
                    result.computeIfAbsent(s, k -> new ArrayList()).add(tRecipe);
                }
                continue;
            }
            for (RecipeShape s : sShapes) {
                result.computeIfAbsent(s, k -> new ArrayList()).add(tRecipe);
            }
        }
        return result;
    }

    private static boolean checkRecipeShape(List<Integer> emptySlotIndexesBuffer, Object[] input, int tRecipeWidth, int tRecipeHeight) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (x >= tRecipeWidth || y >= tRecipeHeight) {
                    emptySlotIndexesBuffer.add(x + y * 3);
                    continue;
                }
                Object tObject = input[x + y * tRecipeWidth];
                if (tObject == null) {
                    emptySlotIndexesBuffer.add(x + y * 3);
                    continue;
                }
                if (tObject instanceof ItemStack && (((ItemStack)tObject).func_77973_b() == null || ((ItemStack)tObject).func_77976_d() < 2 || ((ItemStack)tObject).func_77958_k() > 0 || ((ItemStack)tObject).func_77973_b() instanceof ItemBlock)) {
                    return false;
                }
                if (!(tObject instanceof List) || !((List)tObject).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private static synchronized void registerStickStuff(String aPlate, ItemData aItemData, boolean aRecipeReplacing) {
        for (Materials tMaterial : sRodMaterialList) {
            ItemStack tMt2 = GT_OreDictUnificator.get(OrePrefixes.stick, tMaterial, 1L);
            if (tMt2 == null) continue;
            sMt2.func_150996_a(tMt2.func_77973_b());
            GT_RecipeRegistrator.sMt2.field_77994_a = 1;
            Items.field_151008_G.setDamage(sMt2, Items.field_151008_G.getDamage(tMt2));
            for (int i = 0; i < sShapes.length; ++i) {
                RecipeShape tRecipe = sShapes[i];
                block6: for (ItemStack tCrafted : GT_ModHandler.getRecipeOutputs(GT_RecipeRegistrator.getRecipeList(tRecipe), true, tRecipe.shape)) {
                    ItemStack tStack;
                    if (aItemData != null && aItemData.hasValidPrefixMaterialData()) {
                        GT_OreDictUnificator.addItemData(tCrafted, new ItemData(aItemData.mMaterial.mMaterial, aItemData.mMaterial.mAmount * (long)tRecipe.amount1, new MaterialStack(tMaterial, OrePrefixes.stick.mMaterialAmount * (long)tRecipe.amount2)));
                    }
                    if (!aRecipeReplacing || aPlate == null || sShapesA[i] == null || sShapesA[i].length <= 1) continue;
                    assert (aItemData != null);
                    if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.recipereplacements, aItemData.mMaterial.mMaterial + "." + sShapesA[i][0], true) || null == (tStack = GT_ModHandler.removeRecipe(tRecipe.shape))) continue;
                    switch (sShapesA[i].length) {
                        case 2: {
                            GT_ModHandler.addCraftingRecipe(tStack, GT_ModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                            continue block6;
                        }
                        case 3: {
                            GT_ModHandler.addCraftingRecipe(tStack, GT_ModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], sShapesA[i][2], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                            continue block6;
                        }
                    }
                    GT_ModHandler.addCraftingRecipe(tStack, GT_ModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], sShapesA[i][2], sShapesA[i][3], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                }
            }
        }
    }

    public static void registerWiremillRecipes(Materials aMaterial, int baseDuration, int aEUt) {
        GT_RecipeRegistrator.registerWiremillRecipes(aMaterial, baseDuration, GT_Utility.calculateRecipeEU(aMaterial, aEUt), OrePrefixes.ingot, OrePrefixes.stick, 2);
    }

    public static void registerWiremillRecipes(Materials aMaterial, int baseDuration, int aEUt, OrePrefixes prefix1, OrePrefixes prefix2, int multiplier) {
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix1, aMaterial, 1L), GT_Utility.getIntegratedCircuit(1), GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, (long)multiplier), baseDuration, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix1, aMaterial, 2L / (long)multiplier), GT_Utility.getIntegratedCircuit(2), GT_OreDictUnificator.get(OrePrefixes.wireGt02, aMaterial, 1L), (int)((float)baseDuration * 1.5f), aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix1, aMaterial, 4L / (long)multiplier), GT_Utility.getIntegratedCircuit(4), GT_OreDictUnificator.get(OrePrefixes.wireGt04, aMaterial, 1L), baseDuration * 2, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix1, aMaterial, 8L / (long)multiplier), GT_Utility.getIntegratedCircuit(8), GT_OreDictUnificator.get(OrePrefixes.wireGt08, aMaterial, 1L), (int)((float)baseDuration * 2.5f), aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix1, aMaterial, 12L / (long)multiplier), GT_Utility.getIntegratedCircuit(12), GT_OreDictUnificator.get(OrePrefixes.wireGt12, aMaterial, 1L), baseDuration * 3, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix1, aMaterial, 16L / (long)multiplier), GT_Utility.getIntegratedCircuit(16), GT_OreDictUnificator.get(OrePrefixes.wireGt16, aMaterial, 1L), (int)((float)baseDuration * 3.5f), aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix2, aMaterial, 2L / (long)multiplier), GT_Utility.getIntegratedCircuit(1), GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 1L), baseDuration / 2, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix2, aMaterial, 4L / (long)multiplier), GT_Utility.getIntegratedCircuit(2), GT_OreDictUnificator.get(OrePrefixes.wireGt02, aMaterial, 1L), baseDuration, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix2, aMaterial, 8L / (long)multiplier), GT_Utility.getIntegratedCircuit(4), GT_OreDictUnificator.get(OrePrefixes.wireGt04, aMaterial, 1L), (int)((float)baseDuration * 1.5f), aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix2, aMaterial, 16L / (long)multiplier), GT_Utility.getIntegratedCircuit(8), GT_OreDictUnificator.get(OrePrefixes.wireGt08, aMaterial, 1L), baseDuration * 2, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix2, aMaterial, 24L / (long)multiplier), GT_Utility.getIntegratedCircuit(12), GT_OreDictUnificator.get(OrePrefixes.wireGt12, aMaterial, 1L), (int)((float)baseDuration * 2.5f), aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix2, aMaterial, 32L / (long)multiplier), GT_Utility.getIntegratedCircuit(16), GT_OreDictUnificator.get(OrePrefixes.wireGt16, aMaterial, 1L), baseDuration * 3, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix1, aMaterial, 1L), GT_Utility.getIntegratedCircuit(3), GT_OreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 4L * (long)multiplier), baseDuration, aEUt);
        GT_Values.RA.addWiremillRecipe(GT_OreDictUnificator.get(prefix2, aMaterial, 1L), GT_Utility.getIntegratedCircuit(3), GT_OreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 2L * (long)multiplier), baseDuration / 2, aEUt);
    }

    public static boolean hasVanillaRecipes(Materials materials) {
        return Arrays.stream(VANILLA_MATS).anyMatch(mat -> mat == materials);
    }

    private static int getRecipeWidth(ShapedOreRecipe r) {
        try {
            return (Integer)SHAPED_ORE_RECIPE_WIDTH.get(r);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getRecipeHeight(ShapedOreRecipe r) {
        try {
            return (Integer)SHAPED_ORE_RECIPE_HEIGHT.get(r);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getRecipeHeight(ShapedRecipes r) {
        return r.field_77577_c;
    }

    private static int getRecipeWidth(ShapedRecipes r) {
        return r.field_77576_b;
    }

    static {
        sShapesA = new String[][]{null, null, null, {"Helmet", "PPP", "PhP"}, {"ChestPlate", "PhP", "PPP", "PPP"}, {"Pants", "PPP", "PhP", "P P"}, {"Boots", "P P", "PhP"}, {"Sword", " P ", "fPh", " R "}, {"Pickaxe", "PII", "fRh", " R "}, {"Shovel", "fPh", " R ", " R "}, {"Axe", "PIh", "PR ", "fR "}, {"Axe", "PIh", "PR ", "fR "}, {"Hoe", "PIh", "fR ", " R "}, {"Hoe", "PIh", "fR ", " R "}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sword", " R ", "fPh", " P "}, {"Pickaxe", " R ", "fRh", "PII"}, {"Shovel", " R ", " R ", "fPh"}, {"Axe", "fR ", "PR ", "PIh"}, {"Axe", "fR ", "PR ", "PIh"}, {"Hoe", " R ", "fR ", "PIh"}, {"Hoe", " R ", "fR ", "PIh"}, {"Spear", "Ph ", "fR ", "  R"}, {"Spear", "Ph ", "fR ", "  R"}, {"Knive", "hP", "Rf"}, {"Knive", "fh", "PR"}, {"Knive", "fh", "PR"}, {"Knive", "Pf", "Rh"}, {"Knive", "Pf", "Rh"}, null, null, null, null, {"WarAxe", "PPP", "PRP", "fRh"}, null, null, null, {"Shears", "hP", "Pf"}, {"Shears", "hP", "Pf"}, {"Scythe", "IPh", "RfP", "R  "}, {"Scythe", "hPI", "PfR", "  R"}};
        VERSION = 509;
        GregTech_API.sAfterGTPostload.add(() -> {
            indexedRecipeListCache = null;
        });
        VANILLA_MATS = new Materials[]{Materials.Cobalt, Materials.Gold, Materials.Iron, Materials.Lead, Materials.FierySteel, Materials.Void, Materials.Bronze, Materials.Diamond, Materials.Ruby, Materials.Sapphire, Materials.Steel, Materials.IronWood, Materials.Steeleaf, Materials.Knightmetal, Materials.Thaumium, Materials.DarkSteel};
    }

    private static class RecipeShape {
        private final ItemStack[] shape;
        private int amount1;
        private int amount2;

        public RecipeShape(ItemStack ... shape) {
            this.shape = shape;
            for (ItemStack stack : shape) {
                if (stack == sMt1) {
                    ++this.amount1;
                }
                if (stack != sMt2) continue;
                ++this.amount2;
            }
        }

        public List<List<Integer>> getEmptySlotsAllVariants() {
            ImmutableList.Builder b = ImmutableList.builder();
            for (int i = -1; i < 2; ++i) {
                if (i != 0 && !this.isColClear(i + 1)) continue;
                for (int j = -1; j < 2; ++j) {
                    if (j != 0 && !this.isRowClear(j + 1)) continue;
                    b.add(this.getEmptySlots(i, j));
                }
            }
            return b.build();
        }

        private boolean isRowClear(int row) {
            for (int i = 0; i < 3; ++i) {
                if (this.shape[i + row * 3] == null) continue;
                return false;
            }
            return true;
        }

        private boolean isColClear(int col) {
            for (int i = 0; i < 3; ++i) {
                if (this.shape[col + i * 3] == null) continue;
                return false;
            }
            return true;
        }

        private List<Integer> getEmptySlots(int offsetX, int offsetY) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (int i = 0; i < this.shape.length; ++i) {
                int mappedIndex = i - offsetX - offsetY * 3;
                if (mappedIndex >= 0 && mappedIndex <= 8 && this.shape[mappedIndex] != null) continue;
                b.add((Object)i);
            }
            return b.build();
        }
    }
}

