/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.util.ColorsMetadataSection;
import gregtech.api.util.GT_Util;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.data.BaseMetadataSectionSerializer;
import net.minecraft.util.JsonUtils;

@SideOnly(value=Side.CLIENT)
public class ColorsMetadataSectionSerializer
extends BaseMetadataSectionSerializer
implements JsonSerializer {
    public ColorsMetadataSection deserialize(JsonElement metadataColors, Type type, JsonDeserializationContext context) {
        boolean enableGuiTint = GregTech_API.sColoredGUI;
        HashMap<String, String> hexGuiTintMap = new HashMap<String, String>();
        HashMap<String, String> hexTextColorMap = new HashMap<String, String>();
        JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)metadataColors, (String)"metadata section");
        if (jsonObject.has("textColor")) {
            JsonObject textColors = JsonUtils.func_152754_s((JsonObject)jsonObject, (String)"textColor");
            for (Map.Entry entry : textColors.entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    hexTextColorMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    continue;
                }
                GT_Mod.GT_FML_LOGGER.warn("ColorOverride expects primitive value for key `textColor`");
            }
        }
        if (jsonObject.has("guiTint")) {
            JsonObject guiTints = JsonUtils.func_152754_s((JsonObject)jsonObject, (String)"guiTint");
            enableGuiTint = JsonUtils.func_151209_a((JsonObject)guiTints, (String)"enableGuiTintWhenPainted", (boolean)true);
            for (Dyes dye : Dyes.values()) {
                hexGuiTintMap.put(dye.mName, GT_Util.toHexString(dye.getRGBA()));
            }
            for (String key : hexGuiTintMap.keySet()) {
                if (enableGuiTint) {
                    hexGuiTintMap.replace(key, JsonUtils.func_151219_a((JsonObject)guiTints, (String)key, (String)((String)hexGuiTintMap.get(key))));
                    continue;
                }
                hexGuiTintMap.replace(key, GT_Util.toHexString(Dyes.dyeWhite.getRGBA()));
            }
        }
        return new ColorsMetadataSection(hexTextColorMap, hexGuiTintMap, enableGuiTint);
    }

    public JsonElement serialize(ColorsMetadataSection colorsMetaSection, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        return jsonObject;
    }

    public String func_110483_a() {
        return "colors";
    }

    public JsonElement serialize(Object object, Type type, JsonSerializationContext context) {
        return this.serialize((ColorsMetadataSection)object, type, context);
    }
}

