/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_Cleanroom;

public abstract class GT_MetaTileEntity_TieredMachineBlock
extends MetaTileEntity {
    public final byte mTier;
    @Deprecated
    public final String mDescription;
    public final String[] mDescriptionArray;
    public final ITexture[][][] mTextures;

    public GT_MetaTileEntity_TieredMachineBlock(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aInvSlotCount);
        String[] stringArray;
        this.mTier = (byte)Math.max(0, Math.min(aTier, 14));
        if (aDescription == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = aDescription;
        }
        this.mDescriptionArray = stringArray;
        this.mDescription = this.mDescriptionArray.length > 0 ? this.mDescriptionArray[0] : "";
        this.mTextures = GT_Values.GT.isClientSide() ? this.getTextureSet(aTextures) : (ITexture[][][])null;
    }

    public GT_MetaTileEntity_TieredMachineBlock(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aInvSlotCount);
        this.mTier = (byte)Math.max(0, Math.min(aTier, 15));
        this.mDescriptionArray = aDescription == null ? new String[]{} : aDescription;
        this.mDescription = this.mDescriptionArray.length > 0 ? this.mDescriptionArray[0] : "";
        this.mTextures = GT_Values.GT.isClientSide() ? this.getTextureSet(aTextures) : (ITexture[][][])null;
    }

    @Override
    public Class<?> getType() {
        return GT_MetaTileEntity_Cleanroom.class;
    }

    public GT_MetaTileEntity_TieredMachineBlock(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aInvSlotCount);
        String[] stringArray;
        this.mTier = (byte)aTier;
        if (aDescription == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = aDescription;
        }
        this.mDescriptionArray = stringArray;
        this.mDescription = this.mDescriptionArray.length > 0 ? this.mDescriptionArray[0] : "";
        this.mTextures = aTextures;
    }

    public GT_MetaTileEntity_TieredMachineBlock(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aInvSlotCount);
        this.mTier = (byte)aTier;
        this.mDescriptionArray = aDescription == null ? new String[]{} : aDescription;
        this.mDescription = this.mDescriptionArray.length > 0 ? this.mDescriptionArray[0] : "";
        this.mTextures = aTextures;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)Math.min(3, this.mTier <= 0 ? 0 : 1 + (this.mTier - 1) / 4);
    }

    @Override
    public long getInputTier() {
        return this.mTier;
    }

    @Override
    public long getOutputTier() {
        return this.mTier;
    }

    @Override
    public String[] getDescription() {
        return this.mDescriptionArray;
    }

    public abstract ITexture[][][] getTextureSet(ITexture[] var1);

    protected SlotWidget createChargerSlot(int x, int y) {
        Object[] batterySlotTooltipArgs;
        String batterySlotTooltipKey;
        String pTier1 = GT_Utility.getColoredTierNameFromTier(this.mTier);
        if (this.mTier == GT_Values.VN.length - 1) {
            batterySlotTooltipKey = "GT5U.machines.battery_slot.tooltip.alternative";
            batterySlotTooltipArgs = new String[]{pTier1};
        } else {
            batterySlotTooltipKey = "GT5U.machines.battery_slot.tooltip";
            batterySlotTooltipArgs = new String[]{pTier1, GT_Utility.getColoredTierNameFromTier((byte)(this.mTier + 1))};
        }
        return this.createChargerSlot(x, y, batterySlotTooltipKey, batterySlotTooltipArgs);
    }

    protected SlotWidget createChargerSlot(int x, int y, String tooltipKey, Object[] tooltipArgs) {
        return (SlotWidget)new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.rechargerSlotStartIndex()).disableShiftInsert().setGTTooltip(() -> this.mTooltipCache.getData(tooltipKey, tooltipArgs)).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_CHARGER}).setPos(x, y);
    }
}

