/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregtechWailaProvider;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.net.GT_Packet_RequestCoverData;
import gregtech.api.net.GT_Packet_SendCoverData;
import gregtech.api.net.GT_Packet_TileEntityCoverGUI;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.ISerializableObject;
import gregtech.common.GT_Client;
import gregtech.common.covers.CoverInfo;
import gregtech.common.covers.GT_Cover_Fluidfilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class CoverableTileEntity
extends BaseTileEntity
implements ICoverable,
IGregtechWailaProvider {
    public static final String[] COVER_DATA_NBT_KEYS = (String[])Arrays.stream(ForgeDirection.VALID_DIRECTIONS).mapToInt(Enum::ordinal).mapToObj(i -> "mCoverData" + i).toArray(String[]::new);
    protected final CoverInfo[] coverInfos = new CoverInfo[]{null, null, null, null, null, null};
    protected byte[] mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
    protected boolean mRedstone = false;
    protected byte mStrongRedstone = 0;
    @Deprecated
    protected final GT_CoverBehaviorBase<?>[] mCoverBehaviors = new GT_CoverBehaviorBase[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    @Deprecated
    protected int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    @Deprecated
    protected ISerializableObject[] mCoverData = new ISerializableObject[6];
    @Deprecated
    protected final boolean[] mCoverNeedUpdate = new boolean[]{false, false, false, false, false, false};
    protected short mID = 0;
    public long mTickTimer = 0L;
    protected static final int COVER_WINDOW_ID_START = 1;

    protected void writeCoverNBT(NBTTagCompound aNBT, boolean isDrop) {
        NBTTagList tList = new NBTTagList();
        int[] coverSides = new int[]{0, 0, 0, 0, 0, 0};
        for (byte i = 0; i < this.coverInfos.length; i = (byte)(i + 1)) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(i);
            if (!coverInfo.isValid()) continue;
            tList.func_74742_a((NBTBase)coverInfo.writeToNBT(new NBTTagCompound()));
            aNBT.func_74782_a(COVER_DATA_NBT_KEYS[i], coverInfo.getCoverData().saveDataToNBT());
        }
        if (tList.func_74745_c() > 0) {
            aNBT.func_74782_a("gt.covers", (NBTBase)tList);
            aNBT.func_74783_a("mCoverSides", coverSides);
        }
        if (this.mStrongRedstone > 0) {
            aNBT.func_74774_a("mStrongRedstone", this.mStrongRedstone);
        }
        if (!isDrop) {
            aNBT.func_74773_a("mRedstoneSided", this.mSidedRedstone);
            aNBT.func_74757_a("mRedstone", this.mRedstone);
        }
    }

    protected void readCoverNBT(NBTTagCompound aNBT) {
        byte[] byArray;
        this.mRedstone = aNBT.func_74767_n("mRedstone");
        if (aNBT.func_74764_b("mRedstoneSided")) {
            byArray = aNBT.func_74770_j("mRedstoneSided");
        } else {
            byte[] byArray2 = new byte[6];
            byArray2[0] = 15;
            byArray2[1] = 15;
            byArray2[2] = 15;
            byArray2[3] = 15;
            byArray2[4] = 15;
            byArray = byArray2;
            byArray2[5] = 15;
        }
        this.mSidedRedstone = byArray;
        this.mStrongRedstone = aNBT.func_74771_c("mStrongRedstone");
        if (aNBT.func_74764_b("gt.covers")) {
            this.readCoverInfoNBT(aNBT);
        } else if (aNBT.func_74764_b("mCoverSides")) {
            this.readLegacyCoverInfoNBT(aNBT);
        }
    }

    public void readCoverInfoNBT(NBTTagCompound aNBT) {
        NBTTagList tList = aNBT.func_150295_c("gt.covers", 10);
        for (byte i = 0; i < tList.func_74745_c(); i = (byte)(i + 1)) {
            NBTTagCompound tNBT = tList.func_150305_b((int)i);
            CoverInfo coverInfo = new CoverInfo(this, tNBT);
            this.setCoverInfoAtSide(coverInfo.getSide(), coverInfo);
            if (!coverInfo.isDataNeededOnClient()) continue;
            this.issueCoverUpdate(i);
        }
    }

    public void readLegacyCoverInfoNBT(NBTTagCompound aNBT) {
        int[] nArray;
        if (aNBT.func_74764_b("mCoverSides")) {
            nArray = aNBT.func_74759_k("mCoverSides");
        } else {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            nArray = nArray2;
            nArray2[5] = 0;
        }
        int[] coverIDs = nArray;
        boolean hasOldCoverData = aNBT.func_150297_b("mCoverData", 11) && aNBT.func_74759_k("mCoverData").length == 6;
        int[] tOldData = hasOldCoverData ? aNBT.func_74759_k("mCoverData") : new int[]{};
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            CoverInfo coverInfo;
            GT_CoverBehaviorBase<?> coverBehavior;
            if (coverIDs[i] == 0 || (coverBehavior = (coverInfo = new CoverInfo(i, coverIDs[i], this, null)).getCoverBehavior()) == GregTech_API.sNoBehavior) continue;
            ISerializableObject coverData = null;
            if (hasOldCoverData) {
                if (coverBehavior instanceof GT_Cover_Fluidfilter) {
                    String filterKey = String.format("fluidFilter%d", i);
                    if (aNBT.func_74764_b(filterKey)) {
                        coverData = (ISerializableObject)coverInfo.getCoverBehavior().createDataObject(tOldData[i] & 7 | FluidRegistry.getFluidID((String)aNBT.func_74779_i(filterKey)) << 3);
                    }
                } else {
                    coverData = (ISerializableObject)coverBehavior.createDataObject(tOldData[i]);
                }
            } else if (aNBT.func_74764_b(COVER_DATA_NBT_KEYS[i])) {
                coverData = (ISerializableObject)coverBehavior.createDataObject(aNBT.func_74781_a(COVER_DATA_NBT_KEYS[i]));
            }
            if (coverData != null) {
                coverInfo.setCoverData(coverData);
            }
            this.setCoverInfoAtSide(i, coverInfo);
            if (!coverInfo.isDataNeededOnClient()) continue;
            this.issueCoverUpdate(i);
        }
    }

    public abstract boolean isStillValid();

    protected boolean doCoverThings() {
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            if (this.tickCoverAtSide(i)) continue;
            return false;
        }
        return true;
    }

    public boolean tickCoverAtSide(byte aSide) {
        return this.tickCoverAtSide(aSide, this.mTickTimer);
    }

    public boolean tickCoverAtSide(byte aSide, long aTickTimer) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(aSide);
        if (!coverInfo.isValid()) {
            return true;
        }
        int tCoverTickRate = coverInfo.getTickRate();
        if (tCoverTickRate > 0 && aTickTimer % (long)tCoverTickRate == 0L) {
            byte tRedstone = coverInfo.isRedstoneSensitive(aTickTimer) ? this.getInputRedstoneSignal(aSide) : (byte)0;
            coverInfo.setCoverData(coverInfo.doCoverThings(aTickTimer, tRedstone));
            return this.isStillValid();
        }
        return true;
    }

    public abstract boolean allowCoverOnSide(byte var1, GT_ItemStack var2);

    protected void checkDropCover() {
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            int coverId = this.getCoverIDAtSide(i);
            if (coverId == 0 || this.allowCoverOnSide(i, new GT_ItemStack(coverId))) continue;
            this.dropCover(i, i, true);
        }
    }

    protected void updateCoverBehavior() {
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(i);
            if (!coverInfo.isValid()) continue;
            coverInfo.updateCoverBehavior();
        }
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(aSide);
        if (this.field_145850_b == null || this.isServerSide() && coverInfo.isDataNeededOnClient()) {
            coverInfo.setNeedsUpdate(true);
        }
    }

    public final ITexture getCoverTexture(byte aSide) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(aSide);
        if (!coverInfo.isValid()) {
            return null;
        }
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return Textures.BlockIcons.HIDDEN_TEXTURE[0];
        }
        ITexture coverTexture = !(this instanceof BaseMetaPipeEntity) ? coverInfo.getSpecialCoverFGTexture() : coverInfo.getSpecialCoverTexture();
        return coverTexture != null ? coverTexture : GregTech_API.sCovers.get(new GT_ItemStack(this.getCoverIDAtSide(aSide)));
    }

    protected void requestCoverDataIfNeeded() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(i);
            if (!coverInfo.isDataNeededOnClient()) continue;
            GT_Values.NW.sendToServer(new GT_Packet_RequestCoverData(coverInfo, this));
        }
    }

    @Override
    public void setCoverIdAndDataAtSide(byte aSide, int aId, ISerializableObject aData) {
        if (this.setCoverIDAtSideNoUpdate(aSide, aId, aData)) {
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setCoverIDAtSide(byte aSide, int aID) {
        this.setCoverIdAndDataAtSide(aSide, aID, null);
    }

    @Override
    public boolean setCoverIDAtSideNoUpdate(byte aSide, int aID) {
        return this.setCoverIDAtSideNoUpdate(aSide, aID, null);
    }

    public boolean setCoverIDAtSideNoUpdate(byte aSide, int aID, ISerializableObject aData) {
        CoverInfo oldCoverInfo = this.getCoverInfoAtSide(aSide);
        if (aSide >= 0 && aSide < 6 && oldCoverInfo.getCoverID() != aID) {
            if (aID == 0 && this.isClientSide()) {
                oldCoverInfo.onDropped();
            }
            this.setCoverInfoAtSide(aSide, new CoverInfo(aSide, aID, this, aData));
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void setCoverDataAtSide(byte aSide, int aData) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(aSide);
        if (coverInfo.isValid() && coverInfo.getCoverData() instanceof ISerializableObject.LegacyCoverData) {
            coverInfo.setCoverData(new ISerializableObject.LegacyCoverData(aData));
        }
    }

    @Override
    public void setCoverDataAtSide(byte aSide, ISerializableObject aData) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(aSide);
        if (coverInfo.isValid() && coverInfo.getCoverBehavior().cast(aData) != null) {
            coverInfo.setCoverData(aData);
        }
    }

    @Override
    @Deprecated
    public GT_CoverBehavior getCoverBehaviorAtSide(byte aSide) {
        GT_CoverBehaviorBase<?> behavior = this.getCoverInfoAtSide(aSide).getCoverBehavior();
        if (behavior instanceof GT_CoverBehavior) {
            return (GT_CoverBehavior)behavior;
        }
        return GregTech_API.sNoBehavior;
    }

    @Override
    public void setCoverItemAtSide(byte aSide, ItemStack aCover) {
        GregTech_API.getCoverBehaviorNew(aCover).placeCover(aSide, aCover, this);
    }

    @Override
    public int getCoverIDAtSide(byte aSide) {
        return this.getCoverInfoAtSide(aSide).getCoverID();
    }

    @Override
    public ItemStack getCoverItemAtSide(byte aSide) {
        return this.getCoverInfoAtSide(aSide).getDisplayStack();
    }

    @Override
    public boolean canPlaceCoverIDAtSide(byte aSide, int aID) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public boolean canPlaceCoverItemAtSide(byte aSide, ItemStack aCover) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    @Deprecated
    public int getCoverDataAtSide(byte aSide) {
        ISerializableObject coverData = this.getCoverInfoAtSide(aSide).getCoverData();
        if (coverData instanceof ISerializableObject.LegacyCoverData) {
            return ((ISerializableObject.LegacyCoverData)coverData).get();
        }
        return 0;
    }

    @Override
    public ISerializableObject getComplexCoverDataAtSide(byte aSide) {
        return this.getCoverInfoAtSide(aSide).getCoverData();
    }

    @Override
    public GT_CoverBehaviorBase<?> getCoverBehaviorAtSideNew(byte aSide) {
        return this.getCoverInfoAtSide(aSide).getCoverBehavior();
    }

    public void setCoverInfoAtSide(byte aSide, CoverInfo coverInfo) {
        if (aSide >= 0 && aSide < 6) {
            this.coverInfos[aSide] = coverInfo;
        }
    }

    @Override
    public CoverInfo getCoverInfoAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            if (this.coverInfos[aSide] == null) {
                this.coverInfos[aSide] = new CoverInfo(aSide, this);
            }
            return this.coverInfos[aSide];
        }
        return CoverInfo.EMPTY_INFO;
    }

    public void clearCoverInfoAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            this.setCoverIDAtSide(aSide, 0);
        }
    }

    @Override
    public boolean dropCover(byte aSide, byte aDroppedSide, boolean aForced) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(aSide);
        if (!coverInfo.isValid()) {
            return false;
        }
        if (!coverInfo.onCoverRemoval(aForced) && !aForced) {
            return false;
        }
        ItemStack tStack = coverInfo.getDrop();
        if (tStack != null) {
            coverInfo.onDropped();
            EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(aDroppedSide, 1) + 0.5, (double)this.getOffsetY(aDroppedSide, 1) + 0.5, (double)this.getOffsetZ(aDroppedSide, 1) + 0.5, tStack);
            tEntity.field_70159_w = 0.0;
            tEntity.field_70181_x = 0.0;
            tEntity.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)tEntity);
        }
        this.clearCoverInfoAtSide(aSide);
        this.updateOutputRedstoneSignal(aSide);
        return true;
    }

    protected void onBaseTEDestroyed() {
        for (byte side : GT_Values.ALL_VALID_SIDES) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isValid()) continue;
            coverInfo.onBaseTEDestroyed();
        }
    }

    @Override
    public void setOutputRedstoneSignal(byte aSide, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (aSide >= 0 && aSide < 6 && this.mSidedRedstone[aSide] != aStrength) {
            this.mSidedRedstone[aSide] = aStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setStrongOutputRedstoneSignal(byte aSide, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << aSide);
        this.setOutputRedstoneSignal(aSide, aStrength);
    }

    @Override
    public void setInternalOutputRedstoneSignal(byte aSide, byte aStrength) {
        if (!this.getCoverBehaviorAtSideNew(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this)) {
            this.setOutputRedstoneSignal(aSide, aStrength);
        }
    }

    @Override
    public boolean getRedstone() {
        return IntStream.range(1, 6).anyMatch(i -> this.getRedstone((byte)i));
    }

    @Override
    public boolean getRedstone(byte aSide) {
        return this.getInternalInputRedstoneSignal(aSide) > 0;
    }

    @Override
    public byte getStrongestRedstone() {
        return (byte)IntStream.range(1, 6).map(i -> this.getInternalInputRedstoneSignal((byte)i)).max().orElse(0);
    }

    @Override
    public byte getStrongOutputRedstoneSignal(byte aSide) {
        return aSide >= 0 && aSide < 6 && (this.mStrongRedstone & 1 << aSide) != 0 ? (byte)(this.mSidedRedstone[aSide] & 0xF) : (byte)0;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    @Override
    public byte getInternalInputRedstoneSignal(byte aSide) {
        return (byte)(this.getCoverBehaviorAtSideNew(aSide).getRedstoneInput(aSide, this.getInputRedstoneSignal(aSide), this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(byte aSide) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(aSide, 1), (int)this.getOffsetY(aSide, 1), this.getOffsetZ(aSide, 1), (int)aSide) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(byte aSide) {
        return this.getCoverBehaviorAtSideNew(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this) ? this.mSidedRedstone[aSide] : this.getGeneralRS(aSide);
    }

    protected void updateOutputRedstoneSignal(byte aSide) {
        this.setOutputRedstoneSignal(aSide, (byte)0);
    }

    @Override
    public void receiveCoverData(byte aCoverSide, int aCoverID, int aCoverData) {
        if (aCoverSide < 0 || aCoverSide >= 6) {
            return;
        }
        CoverInfo oldCoverInfo = this.getCoverInfoAtSide(aCoverSide);
        if (!oldCoverInfo.isValid()) {
            return;
        }
        this.setCoverIDAtSideNoUpdate(aCoverSide, aCoverID);
        this.setCoverDataAtSide(aCoverSide, aCoverData);
    }

    @Override
    public void receiveCoverData(byte aCoverSide, int aCoverID, ISerializableObject aCoverData, EntityPlayerMP aPlayer) {
        if (aCoverSide < 0 || aCoverSide >= 6) {
            return;
        }
        CoverInfo oldCoverInfo = this.getCoverInfoAtSide(aCoverSide);
        if (!oldCoverInfo.isValid()) {
            return;
        }
        oldCoverInfo.preDataChanged(aCoverID, aCoverData);
        this.setCoverIDAtSideNoUpdate(aCoverSide, aCoverID, aCoverData);
        this.setCoverDataAtSide(aCoverSide, aCoverData);
        if (this.isClientSide()) {
            this.getCoverInfoAtSide(aCoverSide).onDataChanged();
        }
    }

    protected void sendCoverDataIfNeeded() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(i);
            if (!coverInfo.needsUpdate()) continue;
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_SendCoverData(coverInfo, this), this.field_145851_c, this.field_145849_e);
            coverInfo.setNeedsUpdate(false);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        byte currentFacing = (byte)accessor.getSide().ordinal();
        NBTTagList tList = tag.func_150295_c("gt.covers", 10);
        for (int i = 0; i < tList.func_74745_c(); i = (int)((byte)(i + 1))) {
            ItemStack coverStack;
            NBTTagCompound tNBT = tList.func_150305_b(i);
            CoverInfo coverInfo = new CoverInfo(this, tNBT);
            if (!coverInfo.isValid() || coverInfo.getCoverBehavior() == GregTech_API.sNoBehavior || (coverStack = coverInfo.getDisplayStack()) == null) continue;
            currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.cover", (Object[])new Object[]{currentFacing == coverInfo.getSide() ? StatCollector.func_74838_a((String)"GT5U.waila.cover.current_facing") : StatCollector.func_74838_a((String)("GT5U.interface.coverTabs." + ForgeDirection.getOrientation((int)coverInfo.getSide()).toString().toLowerCase())), coverStack.func_82833_r()}));
            String behaviorDesc = coverInfo.getBehaviorDescription();
            if (Objects.equals(behaviorDesc, "")) continue;
            currenttip.add(behaviorDesc);
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        this.writeCoverNBT(tag, false);
    }

    public static void addInstalledCoversInformation(NBTTagCompound aNBT, List<String> aList) {
        int[] mCoverSides;
        NBTTagList tList = aNBT.func_150295_c("gt.covers", 10);
        for (int i = 0; i < tList.func_74745_c(); i = (int)((byte)(i + 1))) {
            ItemStack coverStack;
            NBTTagCompound tNBT = tList.func_150305_b(i);
            CoverInfo coverInfo = new CoverInfo(null, tNBT);
            if (!coverInfo.isValid() || coverInfo.getCoverBehavior() == GregTech_API.sNoBehavior || (coverStack = coverInfo.getDisplayStack()) == null) continue;
            aList.add(String.format("Cover on %s side: %s", GT_LanguageManager.getTranslation(GT_LanguageManager.FACES[coverInfo.getSide()]), coverStack.func_82833_r()));
        }
        if (aNBT.func_74764_b("mCoverSides") && (mCoverSides = aNBT.func_74759_k("mCoverSides")) != null && mCoverSides.length == 6) {
            for (byte tSide : GT_Values.ALL_VALID_SIDES) {
                Object dataObject;
                ItemStack coverStack;
                GT_CoverBehaviorBase<?> behavior;
                int coverId = mCoverSides[tSide];
                if (coverId == 0 || (behavior = GregTech_API.getCoverBehaviorNew(coverId)) == null || behavior == GregTech_API.sNoBehavior || !aNBT.func_74764_b(COVER_DATA_NBT_KEYS[tSide]) || (coverStack = behavior.getDisplayStack(coverId, (ISerializableObject)(dataObject = behavior.createDataObject(aNBT.func_74781_a(COVER_DATA_NBT_KEYS[tSide]))))) == null) continue;
                aList.add(String.format("Cover on %s side: %s", GT_LanguageManager.getTranslation(GT_LanguageManager.FACES[tSide]), coverStack.func_82833_r()));
            }
        }
    }

    protected ModularWindow createCoverWindow(EntityPlayer player, byte side) {
        return this.getCoverInfoAtSide(side).createWindow(player);
    }

    @Override
    public void addCoverTabs(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int xPos;
        int COVER_TAB_LEFT = -16;
        boolean COVER_TAB_TOP = true;
        int COVER_TAB_HEIGHT = 20;
        int COVER_TAB_WIDTH = 18;
        int COVER_TAB_SPACING = 2;
        int ICON_SIZE = 16;
        final boolean flipHorizontally = GT_Mod.gregtechproxy.mCoverTabsFlipped;
        Column columnWidget = new Column();
        builder.widget((Widget)columnWidget);
        int n = xPos = flipHorizontally ? this.getGUIWidth() - -16 - 18 : -16;
        if (GT_Mod.gregtechproxy.mCoverTabsVisible) {
            columnWidget.setPos(xPos, 1).setEnabled(widget -> ((Column)widget).getChildren().stream().anyMatch(Widget::isEnabled));
        } else {
            columnWidget.setEnabled(false);
        }
        columnWidget.setAlignment(MainAxisAlignment.SPACE_BETWEEN).setSpace(2);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            final byte side = (byte)direction.ordinal();
            buildContext.addSyncedWindow(side + 1, player -> this.createCoverWindow(player, side));
            columnWidget.addChild(new MultiChildWidget().addChild(new ButtonWidget(){

                public IDrawable[] getBackground() {
                    ArrayList<UITexture> backgrounds = new ArrayList<UITexture>();
                    GUITextureSet tabIconSet = CoverableTileEntity.this.getGUITextureSet();
                    if (CoverableTileEntity.this.getCoverBehaviorAtSideNew(side).hasCoverGUI()) {
                        if (this.isHovering()) {
                            backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabHighlightFlipped() : tabIconSet.getCoverTabHighlight());
                        } else {
                            backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabNormalFlipped() : tabIconSet.getCoverTabNormal());
                        }
                    } else {
                        backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabDisabledFlipped() : tabIconSet.getCoverTabDisabled());
                    }
                    return backgrounds.toArray(new IDrawable[0]);
                }
            }.setOnClick((clickData, widget) -> this.onTabClicked((Widget.ClickData)clickData, (Widget)widget, side)).dynamicTooltip(() -> this.getCoverTabTooltip(side)).setSize(18, 20)).addChild(new ItemDrawable(() -> this.getCoverItemAtSide(side)).asWidget().setPos(1 + (flipHorizontally ? -1 : 1), 2)).setEnabled(widget -> this.getCoverItemAtSide(side) != null));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected List<String> getCoverTabTooltip(byte side) {
        String[] SIDE_TOOLTIPS = new String[]{"GT5U.interface.coverTabs.down", "GT5U.interface.coverTabs.up", "GT5U.interface.coverTabs.north", "GT5U.interface.coverTabs.south", "GT5U.interface.coverTabs.west", "GT5U.interface.coverTabs.east"};
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        ItemStack coverItem = coverInfo.getDisplayStack();
        if (coverItem == null) {
            return Collections.emptyList();
        }
        boolean coverHasGUI = coverInfo.hasCoverGUI();
        List tooltip = coverItem.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true);
        for (int i = 0; i < tooltip.size(); ++i) {
            if (i == 0) {
                tooltip.set(0, (coverHasGUI ? EnumChatFormatting.UNDERLINE : EnumChatFormatting.DARK_GRAY) + StatCollector.func_74838_a((String)SIDE_TOOLTIPS[side]) + (coverHasGUI ? EnumChatFormatting.RESET + ": " : ": " + EnumChatFormatting.RESET) + (String)tooltip.get(0));
                continue;
            }
            tooltip.set(i, EnumChatFormatting.GRAY + (String)tooltip.get(i));
        }
        return tooltip;
    }

    protected void onTabClicked(Widget.ClickData clickData, Widget widget, byte side) {
        if (this.isClientSide()) {
            return;
        }
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (coverInfo.useModularUI()) {
            widget.getContext().openSyncedWindow(side + 1);
        } else {
            GT_Packet_TileEntityCoverGUI packet = new GT_Packet_TileEntityCoverGUI(coverInfo, this.getWorld().field_73011_w.field_76574_g, widget.getContext().getPlayer().func_145782_y(), 0);
            GT_Values.NW.sendToPlayer(packet, (EntityPlayerMP)widget.getContext().getPlayer());
        }
    }
}

