/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IBindPlayerInventoryUI;
import gregtech.api.interfaces.modularui.IGetTitleColor;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;

public abstract class CommonMetaTileEntity
extends CoverableTileEntity
implements IGregTechTileEntity {
    protected boolean mNeedsBlockUpdate = true;
    protected boolean mNeedsUpdate = true;
    protected boolean mSendClientData = false;
    protected boolean mInventoryChanged = false;

    protected boolean createNewMetatileEntity(short aID) {
        if (aID > 0 && aID < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aID] != null) {
            if (this.hasValidMetaTileEntity()) {
                this.getMetaTileEntity().setBaseMetaTileEntity(null);
            }
            GregTech_API.METATILEENTITIES[aID].newMetaEntity(this).setBaseMetaTileEntity(this);
            this.mTickTimer = 0L;
            this.mID = aID;
            return true;
        }
        GT_Log.err.println("MetaID " + aID + " not loadable => locking TileEntity!");
        return false;
    }

    protected void saveMetaTileNBT(NBTTagCompound aNBT) {
        try {
            if (this.hasValidMetaTileEntity()) {
                NBTTagList tItemList = new NBTTagList();
                for (int i = 0; i < this.getMetaTileEntity().getRealInventory().length; ++i) {
                    ItemStack tStack = this.getMetaTileEntity().getRealInventory()[i];
                    if (tStack == null) continue;
                    NBTTagCompound tTag = new NBTTagCompound();
                    tTag.func_74768_a("IntSlot", i);
                    tStack.func_77955_b(tTag);
                    tItemList.func_74742_a((NBTBase)tTag);
                }
                aNBT.func_74782_a("Inventory", (NBTBase)tItemList);
                try {
                    this.getMetaTileEntity().saveNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
                    GT_Mod.logStackTrace(e);
                }
            }
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
            GT_Mod.logStackTrace(e);
        }
    }

    protected void loadMetaTileNBT(NBTTagCompound aNBT) {
        int nbtVersion = aNBT.func_74762_e("nbtVersion");
        if (this.mID != 0 && this.createNewMetatileEntity(this.mID)) {
            NBTTagList tItemList = aNBT.func_150295_c("Inventory", 10);
            for (int i = 0; i < tItemList.func_74745_c(); ++i) {
                NBTTagCompound tTag = tItemList.func_150305_b(i);
                int tSlot = this.migrateInventoryIndex(tTag.func_74762_e("IntSlot"), nbtVersion);
                if (tSlot < 0 || tSlot >= this.getMetaTileEntity().getRealInventory().length) continue;
                this.getMetaTileEntity().getRealInventory()[tSlot] = GT_Utility.loadItem(tTag);
            }
            try {
                this.getMetaTileEntity().loadNBTData(aNBT);
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("Encountered Exception while loading MetaTileEntity.");
                GT_Mod.logStackTrace(e);
            }
        }
    }

    protected int migrateInventoryIndex(int slotIndex, int nbtVersion) {
        return slotIndex;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.mInventoryChanged = true;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().isValidSlot(aIndex);
        }
        return false;
    }

    public Packet func_145844_m() {
        this.issueClientUpdate();
        return null;
    }

    @Override
    public void issueTextureUpdate() {
        this.mNeedsUpdate = true;
    }

    @Override
    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    @Override
    public void issueBlockUpdate() {
        this.mNeedsBlockUpdate = true;
    }

    @Override
    public boolean isValidFacing(byte aSide) {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().isFacingValid(aSide);
        }
        return false;
    }

    protected boolean canAccessData() {
        return !this.isDead && this.hasValidMetaTileEntity();
    }

    protected abstract boolean hasValidMetaTileEntity();

    @Override
    public String[] getDescription() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getDescription();
        }
        return new String[0];
    }

    @Override
    public boolean isStillValid() {
        return this.hasValidMetaTileEntity();
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return this.hasValidMetaTileEntity() && this.getMetaTileEntity().allowCoverOnSide(aSide, aCoverID);
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        super.issueCoverUpdate(aSide);
        this.issueClientUpdate();
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        IMetaTileEntity meta = this.getMetaTileEntity();
        return meta != null && meta.shouldJoinIc2Enet();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IAddUIWidgets) {
            ((IAddUIWidgets)((Object)this.getMetaTileEntity())).addUIWidgets(builder, buildContext);
            return;
        }
        super.addUIWidgets(builder, buildContext);
    }

    @Override
    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IBindPlayerInventoryUI) {
            ((IBindPlayerInventoryUI)((Object)this.getMetaTileEntity())).bindPlayerInventoryUI(builder, buildContext);
            return;
        }
        super.bindPlayerInventoryUI(builder, buildContext);
    }

    @Override
    public IConfigurationCircuitSupport getConfigurationCircuitSupport() {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IConfigurationCircuitSupport) {
            return (IConfigurationCircuitSupport)((Object)this.getMetaTileEntity());
        }
        return null;
    }

    @Override
    public ItemStackHandler getInventoryHandler() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getInventoryHandler();
        }
        return null;
    }

    @Override
    public boolean useModularUI() {
        return this.hasValidMetaTileEntity() && this.getMetaTileEntity().useModularUI();
    }

    @Override
    public String getLocalName() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getLocalName();
        }
        return super.getLocalName();
    }

    @Override
    protected int getGUIWidth() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUIWidth();
        }
        return super.getGUIWidth();
    }

    @Override
    protected int getGUIHeight() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUIHeight();
        }
        return super.getGUIHeight();
    }

    @Override
    protected boolean doesBindPlayerInventory() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().doesBindPlayerInventory();
        }
        return super.doesBindPlayerInventory();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IAddGregtechLogo) {
            ((IAddGregtechLogo)((Object)this.getMetaTileEntity())).addGregTechLogo(builder);
            return;
        }
        super.addGregTechLogo(builder);
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getStackForm(aAmount);
        }
        return super.getStackForm(aAmount);
    }

    @Override
    public int getTitleColor() {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IGetTitleColor) {
            return ((IGetTitleColor)((Object)this.getMetaTileEntity())).getTitleColor();
        }
        return super.getTitleColor();
    }

    @Override
    public int getGUIColorization() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUIColorization();
        }
        return super.getGUIColorization();
    }

    @Override
    protected int getTextColorOrDefault(String textType, int defaultColor) {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getTextColorOrDefault(textType, defaultColor);
        }
        return defaultColor;
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUITextureSet();
        }
        return super.getGUITextureSet();
    }
}

