/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.GT_Mod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddInventorySlots;
import gregtech.api.interfaces.modularui.IGetGUITextureSet;
import gregtech.api.interfaces.tileentity.IGTEnet;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.interfaces.tileentity.IIC2Enet;
import gregtech.api.metatileentity.TileIC2EnergySink;
import gregtech.api.net.GT_Packet_Block_Event;
import gregtech.api.net.GT_Packet_SetConfigurationCircuit;
import gregtech.api.util.GT_TooltipDataCache;
import gregtech.api.util.GT_Util;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.modularui.uifactory.SelectItemUIFactory;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class BaseTileEntity
extends TileEntity
implements IHasWorldObjectAndCoords,
IIC2Enet,
IGTEnet,
ITileWithModularUI,
IAddGregtechLogo,
IGetGUITextureSet,
IAddInventorySlots {
    protected boolean mInventoryChanged = false;
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];
    public boolean ignoreUnloadedChunks = true;
    public boolean isDead = false;
    private final ChunkCoordinates mReturnedCoordinates = new ChunkCoordinates();
    protected TileIC2EnergySink ic2EnergySink = null;
    protected boolean joinedIc2Enet = false;
    protected GT_TooltipDataCache mTooltipCache = new GT_TooltipDataCache();
    public static final String BATTERY_SLOT_TOOLTIP = "GT5U.machines.battery_slot.tooltip";
    public static final String BATTERY_SLOT_TOOLTIP_ALT = "GT5U.machines.battery_slot.tooltip.alternative";
    public static final String UNUSED_SLOT_TOOLTIP = "GT5U.machines.unused_slot.tooltip";
    public static final String SPECIAL_SLOT_TOOLTIP = "GT5U.machines.special_slot.tooltip";
    public static final String FLUID_INPUT_TOOLTIP = "GT5U.machines.fluid_input_slot.tooltip";
    public static final String FLUID_OUTPUT_TOOLTIP = "GT5U.machines.fluid_output_slot.tooltip";
    public static final String STALLED_STUTTERING_TOOLTIP = "GT5U.machines.stalled_stuttering.tooltip";
    public static final String STALLED_VENT_TOOLTIP = "GT5U.machines.stalled_vent.tooltip";
    public static final String FLUID_TRANSFER_TOOLTIP = "GT5U.machines.fluid_transfer.tooltip";
    public static final String ITEM_TRANSFER_TOOLTIP = "GT5U.machines.item_transfer.tooltip";
    public static final String POWER_SOURCE_KEY = "GT5U.machines.powersource.";
    public static final String NEI_TRANSFER_STEAM_TOOLTIP = "GT5U.machines.nei_transfer.steam.tooltip";
    public static final String NEI_TRANSFER_VOLTAGE_TOOLTIP = "GT5U.machines.nei_transfer.voltage.tooltip";
    public static final int TOOLTIP_DELAY = 5;
    protected Supplier<Integer> COLOR_TITLE = () -> this.getTextColorOrDefault("title", 0x404040);
    protected Supplier<Integer> COLOR_TITLE_WHITE = () -> this.getTextColorOrDefault("title_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_WHITE = () -> this.getTextColorOrDefault("text_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_GRAY = () -> this.getTextColorOrDefault("text_gray", 0x404040);
    protected Supplier<Integer> COLOR_TEXT_RED = () -> this.getTextColorOrDefault("text_red", 0xFF0000);

    public static byte getSideForPlayerPlacing(Entity aPlayer, byte aDefaultFacing, boolean[] aAllowedFacings) {
        if (aPlayer != null) {
            if (aPlayer.field_70125_A >= 65.0f && aAllowedFacings[1]) {
                return 1;
            }
            if (aPlayer.field_70125_A <= -65.0f && aAllowedFacings[0]) {
                return 0;
            }
            byte rFacing = GT_Values.COMPASS_DIRECTIONS[MathHelper.func_76128_c((double)(0.5 + (double)(4.0f * aPlayer.field_70177_z / 360.0f))) & 3];
            if (aAllowedFacings[rFacing]) {
                return rFacing;
            }
        }
        for (byte tSide : GT_Values.ALL_VALID_SIDES) {
            if (!aAllowedFacings[tSide]) continue;
            return tSide;
        }
        return aDefaultFacing;
    }

    private void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    protected final void clearTileEntityBuffer() {
        Arrays.fill(this.mBufferedTileEntities, null);
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public final short getYCoord() {
        return (short)this.field_145848_d;
    }

    @Override
    public final int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public ChunkCoordinates getCoords() {
        this.mReturnedCoordinates.field_71574_a = this.field_145851_c;
        this.mReturnedCoordinates.field_71572_b = this.field_145848_d;
        this.mReturnedCoordinates.field_71573_c = this.field_145849_e;
        return this.mReturnedCoordinates;
    }

    @Override
    public final int getOffsetX(byte aSide, int aMultiplier) {
        return this.field_145851_c + ForgeDirection.getOrientation((int)aSide).offsetX * aMultiplier;
    }

    @Override
    public final short getOffsetY(byte aSide, int aMultiplier) {
        return (short)(this.field_145848_d + ForgeDirection.getOrientation((int)aSide).offsetY * aMultiplier);
    }

    @Override
    public final int getOffsetZ(byte aSide, int aMultiplier) {
        return this.field_145849_e + ForgeDirection.getOrientation((int)aSide).offsetZ * aMultiplier;
    }

    @Override
    public final boolean isServerSide() {
        return !this.field_145850_b.field_72995_K;
    }

    @Override
    public final boolean isClientSide() {
        return this.field_145850_b.field_72995_K;
    }

    @Override
    @Deprecated
    public final boolean openGUI(EntityPlayer aPlayer) {
        return this.openGUI(aPlayer, 0);
    }

    @Override
    @Deprecated
    public final boolean openGUI(EntityPlayer aPlayer, int aID) {
        if (aPlayer == null) {
            return false;
        }
        aPlayer.openGui((Object)GT_Values.GT, aID, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public boolean isInvalidTileEntity() {
        return this.func_145837_r();
    }

    @Override
    public int getRandomNumber(int aRange) {
        return ThreadLocalRandom.current().nextInt(aRange);
    }

    @Override
    public final BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    @Override
    public final BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public final Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    @Override
    public final Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final byte getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final byte getMetaIDAtSide(byte aSide) {
        return this.getMetaIDAtSideAndDistance(aSide, 1);
    }

    @Override
    public final byte getMetaIDAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaID(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final byte getLightLevelAtSide(byte aSide) {
        return this.getLightLevelAtSideAndDistance(aSide, 1);
    }

    @Override
    public final byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getOpacityAtSide(byte aSide) {
        return this.getOpacityAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getSkyAtSide(byte aSide) {
        return this.getSkyAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        if (aDistance == 1) {
            return this.getTileEntityAtSide(aSide);
        }
        return this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final IInventory getIInventory(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final Block getBlock(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return Blocks.field_150350_a;
        }
        return this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    public Block getBlock(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return Blocks.field_150350_a;
        }
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return Blocks.field_150350_a;
        }
        return this.field_145850_b.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public final byte getMetaID(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return 0;
        }
        return (byte)this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    @Override
    public final byte getLightLevel(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return 0;
        }
        return (byte)(this.field_145850_b.func_72801_o(aX, aY, aZ) * 15.0f);
    }

    @Override
    public final boolean getSky(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return true;
        }
        return this.field_145850_b.func_72937_j(aX, aY, aZ);
    }

    @Override
    public final boolean getOpacity(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return false;
        }
        return GT_Utility.isOpaqueBlock(this.field_145850_b, aX, aY, aZ);
    }

    @Override
    public final boolean getAir(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return true;
        }
        return GT_Utility.isBlockAir(this.field_145850_b, aX, aY, aZ);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return null;
        }
        return this.field_145850_b.func_147438_o(aX, aY, aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSide(byte aSide) {
        if (aSide < 0 || aSide >= 6 || this.mBufferedTileEntities[aSide] == this) {
            return null;
        }
        int tX = this.getOffsetX(aSide, 1);
        short tY = this.getOffsetY(aSide, 1);
        int tZ = this.getOffsetZ(aSide, 1);
        if (this.crossedChunkBorder(tX, tZ)) {
            this.mBufferedTileEntities[aSide] = null;
            if (this.ignoreUnloadedChunks && !this.field_145850_b.func_72899_e(tX, (int)tY, tZ)) {
                return null;
            }
        }
        if (this.mBufferedTileEntities[aSide] == null) {
            this.mBufferedTileEntities[aSide] = this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
            if (this.mBufferedTileEntities[aSide] == null) {
                this.mBufferedTileEntities[aSide] = this;
                return null;
            }
            return this.mBufferedTileEntities[aSide];
        }
        if (this.mBufferedTileEntities[aSide].func_145837_r()) {
            this.mBufferedTileEntities[aSide] = null;
            return this.getTileEntityAtSide(aSide);
        }
        if (this.mBufferedTileEntities[aSide].field_145851_c == tX && this.mBufferedTileEntities[aSide].field_145848_d == tY && this.mBufferedTileEntities[aSide].field_145849_e == tZ) {
            return this.mBufferedTileEntities[aSide];
        }
        return null;
    }

    public void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
    }

    @Override
    public boolean isDead() {
        return this.isDead || this.isInvalidTileEntity();
    }

    public void func_145829_t() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.leaveEnet();
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.leaveEnet();
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
        this.isDead = true;
    }

    public void func_145845_h() {
        this.isDead = false;
    }

    public final void onAdjacentBlockChange(int aX, int aY, int aZ) {
        this.clearNullMarkersFromTileEntityBuffer();
    }

    public void updateNeighbours(int mStrongRedstone, int oStrongRedstone) {
        Block thisBlock = this.getBlockOffset(0, 0, 0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int x1 = this.field_145851_c + dir.offsetX;
            int y1 = this.field_145848_d + dir.offsetY;
            int z1 = this.field_145849_e + dir.offsetZ;
            if (!this.field_145850_b.func_72899_e(x1, y1, z1)) continue;
            this.field_145850_b.func_147460_e(x1, y1, z1, thisBlock);
            if (((mStrongRedstone | oStrongRedstone) >>> dir.ordinal() & 1) == 0 || !this.getBlock(x1, y1, z1).func_149721_r()) continue;
            int skipUpdateSide = dir.getOpposite().ordinal();
            for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                int x2 = x1 + dir2.offsetX;
                int y2 = y1 + dir2.offsetY;
                int z2 = z1 + dir2.offsetZ;
                if (dir2.ordinal() == skipUpdateSide || !this.field_145850_b.func_72899_e(x2, y2, z2)) continue;
                this.field_145850_b.func_147460_e(x2, y2, z2, thisBlock);
            }
        }
    }

    @Override
    public final void sendBlockEvent(byte aID, byte aValue) {
        GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_Block_Event(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, aID, aValue), this.field_145851_c, this.field_145849_e);
    }

    protected boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.field_145851_c >> 4 || aZ >> 4 != this.field_145849_e >> 4;
    }

    public final boolean crossedChunkBorder(ChunkCoordinates aCoords) {
        return aCoords.field_71574_a >> 4 != this.field_145851_c >> 4 || aCoords.field_71573_c >> 4 != this.field_145849_e >> 4;
    }

    public final void setOnFire() {
        GT_Utility.setCoordsOnFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    public final void setToFire() {
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
    }

    public void func_70296_d() {
        Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e);
        if (chunk != null) {
            chunk.func_76630_e();
        }
    }

    @Deprecated
    public String trans(String aKey, String aEnglish) {
        return GT_Utility.trans(aKey, aEnglish);
    }

    protected Supplier<Boolean> getValidator() {
        return () -> !this.isDead();
    }

    public boolean useModularUI() {
        return false;
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        if (!this.useModularUI()) {
            return null;
        }
        buildContext.setValidator(this.getValidator());
        ModularWindow.Builder builder = ModularWindow.builder((int)this.getGUIWidth(), (int)this.getGUIHeight());
        builder.setBackground(new IDrawable[]{this.getGUITextureSet().getMainBackground()});
        builder.setGuiTint(this.getGUIColorization());
        if (this.doesBindPlayerInventory()) {
            this.bindPlayerInventoryUI(builder, buildContext);
        }
        this.addUIWidgets(builder, buildContext);
        this.addTitleToUI(builder);
        this.addCoverTabs(builder, buildContext);
        IConfigurationCircuitSupport csc = this.getConfigurationCircuitSupport();
        if (csc != null && csc.allowSelectCircuit()) {
            this.addConfigurationCircuitSlot(builder);
        } else {
            this.addGregTechLogo(builder);
        }
        return builder.build();
    }

    protected void createIc2Sink() {
        if (this.ic2EnergySink == null && this.isServerSide() && this.shouldJoinIc2Enet()) {
            this.ic2EnergySink = new TileIC2EnergySink((IGregTechTileEntity)((Object)this));
        }
    }

    @Override
    public void doEnetUpdate() {
        this.leaveEnet();
        this.joinEnet();
    }

    protected void joinEnet() {
        if (this.joinedIc2Enet || !this.shouldJoinIc2Enet()) {
            return;
        }
        if (this.ic2EnergySink == null) {
            this.createIc2Sink();
        }
        if (this.ic2EnergySink != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.ic2EnergySink));
            this.joinedIc2Enet = true;
        }
    }

    protected void leaveEnet() {
        if (this.joinedIc2Enet && this.ic2EnergySink != null && this.isServerSide()) {
            this.joinedIc2Enet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.ic2EnergySink));
        }
    }

    public ItemStackHandler getInventoryHandler() {
        return null;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
    }

    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.bindPlayerInventory(buildContext.getPlayer(), 7, (IDrawable)this.getGUITextureSet().getItemSlot());
    }

    public String getLocalName() {
        return "Unknown";
    }

    protected void addTitleToUI(ModularWindow.Builder builder) {
        this.addTitleToUI(builder, this.getLocalName());
    }

    protected void addTitleToUI(ModularWindow.Builder builder, String title) {
        if (GT_Mod.gregtechproxy.mTitleTabStyle == 2) {
            this.addTitleItemIconStyle(builder, title);
        } else {
            this.addTitleTextStyle(builder, title);
        }
    }

    protected void addTitleTextStyle(ModularWindow.Builder builder, String title) {
        int TAB_PADDING = 3;
        int TITLE_PADDING = 2;
        int titleWidth = 0;
        int titleHeight = 0;
        if (NetworkUtils.isClient()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List titleLines = fontRenderer.func_78271_c(title, this.getGUIWidth() - 10);
            titleWidth = titleLines.size() > 1 ? this.getGUIWidth() - 10 : fontRenderer.func_78256_a(title);
            titleHeight = titleLines.size() * fontRenderer.field_78288_b + (titleLines.size() - 1) * 1;
        }
        DrawableWidget tab = new DrawableWidget();
        TextWidget text = new TextWidget(title).setDefaultColor(this.getTitleColor()).setTextAlignment(Alignment.CenterLeft).setMaxWidth(titleWidth);
        if (GT_Mod.gregtechproxy.mTitleTabStyle == 1) {
            tab.setDrawable((IDrawable)this.getGUITextureSet().getTitleTabAngular()).setPos(0, -(titleHeight + 3) + 1).setSize(this.getGUIWidth(), titleHeight + 6);
            text.setPos(5, -titleHeight + 3);
        } else {
            tab.setDrawable((IDrawable)this.getGUITextureSet().getTitleTabDark()).setPos(0, -(titleHeight + 6) + 1).setSize(titleWidth + 10, titleHeight + 6 - 1);
            text.setPos(5, -titleHeight);
        }
        ((ModularWindow.Builder)builder.widget((Widget)tab)).widget((Widget)text);
    }

    protected void addTitleItemIconStyle(ModularWindow.Builder builder, String title) {
        builder.widget(new MultiChildWidget().addChild(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getTitleTabNormal()).setPos(0, 0).setSize(24, 24)).addChild(new ItemDrawable(this.getStackForm(1L)).asWidget().setPos(4, 4)).addTooltip(title).setTooltipShowUpDelay(5).setPos(0, -21));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.DEFAULT;
    }

    protected int getTitleColor() {
        return this.COLOR_TITLE.get();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 63));
    }

    protected int getGUIWidth() {
        return 176;
    }

    protected int getGUIHeight() {
        return 166;
    }

    protected boolean doesBindPlayerInventory() {
        return true;
    }

    @Override
    public void add1by1Slot(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)1).startFromSlot(0).endAtSlot(0).background(background).build().setPos(79, 34));
    }

    @Override
    public void add2by2Slots(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)2).startFromSlot(0).endAtSlot(3).background(background).build().setPos(70, 25));
    }

    @Override
    public void add3by3Slots(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)3).startFromSlot(0).endAtSlot(8).background(background).build().setPos(61, 16));
    }

    @Override
    public void add4by4Slots(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).background(background).build().setPos(52, 7));
    }

    public void addCoverTabs(ModularWindow.Builder builder, UIBuildContext buildContext) {
    }

    public IConfigurationCircuitSupport getConfigurationCircuitSupport() {
        if (!(this instanceof IConfigurationCircuitSupport)) {
            return null;
        }
        return (IConfigurationCircuitSupport)((Object)this);
    }

    protected void addConfigurationCircuitSlot(ModularWindow.Builder builder) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (!(this instanceof IInventory)) {
            return;
        }
        final IInventory inv = (IInventory)this;
        final IConfigurationCircuitSupport ccs = this.getConfigurationCircuitSupport();
        if (ccs == null) {
            return;
        }
        final AtomicBoolean dialogOpened = new AtomicBoolean(false);
        builder.widget(new SlotWidget(new BaseSlot((IItemHandlerModifiable)inventoryHandler, ccs.getCircuitSlot(), true)){

            protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                ItemStack newCircuit;
                if (clickData.shift) {
                    if (clickData.mouseButton == 0) {
                        if (NetworkUtils.isClient() && !dialogOpened.get()) {
                            BaseTileEntity.this.openSelectCircuitDialog(this.getContext(), dialogOpened);
                        }
                        return;
                    }
                    newCircuit = null;
                } else {
                    List<ItemStack> tCircuits = ccs.getConfigurationCircuits();
                    int index = GT_Utility.findMatchingStackInList(tCircuits, cursorStack);
                    if (index < 0) {
                        int curIndex = GT_Utility.findMatchingStackInList(tCircuits, inv.func_70301_a(ccs.getCircuitSlot())) + 1;
                        curIndex = clickData.mouseButton == 0 ? ++curIndex : --curIndex;
                        curIndex = Math.floorMod(curIndex, tCircuits.size() + 1) - 1;
                        newCircuit = curIndex < 0 ? null : tCircuits.get(curIndex);
                    } else {
                        newCircuit = tCircuits.get(index);
                    }
                }
                inv.func_70299_a(ccs.getCircuitSlot(), newCircuit);
            }

            protected void phantomScroll(int direction) {
                this.phantomClick(new Widget.ClickData(direction > 0 ? 1 : 0, false, false, false));
            }

            public List<String> getExtraTooltip() {
                return Arrays.asList(EnumChatFormatting.DARK_GRAY + EnumChatFormatting.func_110646_a((String)StatCollector.func_74838_a((String)"GT5U.machines.select_circuit.tooltip.1")), EnumChatFormatting.DARK_GRAY + EnumChatFormatting.func_110646_a((String)StatCollector.func_74838_a((String)"GT5U.machines.select_circuit.tooltip.2")), EnumChatFormatting.DARK_GRAY + EnumChatFormatting.func_110646_a((String)StatCollector.func_74838_a((String)"GT5U.machines.select_circuit.tooltip.3")));
            }
        }.setOverwriteItemStackTooltip(list -> {
            list.removeIf(line -> line.contains(StatCollector.func_74838_a((String)"gt.integrated_circuit.tooltip.0")) || line.contains(StatCollector.func_74838_a((String)"gt.integrated_circuit.tooltip.1")));
            return list;
        }).disableShiftInsert().setHandlePhantomActionClient(true).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_INT_CIRCUIT}).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.select_circuit.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(ccs.getCircuitSlotX() - 1, ccs.getCircuitSlotY() - 1));
    }

    protected void openSelectCircuitDialog(ModularUIContext uiContext, AtomicBoolean dialogOpened) {
        IConfigurationCircuitSupport ccs = this.getConfigurationCircuitSupport();
        if (ccs == null) {
            return;
        }
        if (!(this instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)this;
        List<ItemStack> circuits = ccs.getConfigurationCircuits();
        uiContext.openClientWindow(player -> new SelectItemUIFactory(StatCollector.func_74838_a((String)"GT5U.machines.select_circuit"), this.getStackForm(0L), this::onCircuitSelected, circuits, GT_Utility.findMatchingStackInList(circuits, inv.func_70301_a(ccs.getCircuitSlot()))).setAnotherWindow(true, dialogOpened).setGuiTint(this.getGUIColorization()).setCurrentGetter(() -> inv.func_70301_a(ccs.getCircuitSlot())).createWindow(new UIBuildContext(player)));
    }

    protected void onCircuitSelected(ItemStack selected) {
        IConfigurationCircuitSupport ccs = this.getConfigurationCircuitSupport();
        if (ccs == null) {
            return;
        }
        if (!(this instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)this;
        GT_Values.NW.sendToServer(new GT_Packet_SetConfigurationCircuit(this, selected));
        inv.func_70299_a(ccs.getCircuitSlot(), selected);
    }

    protected int getTextColorOrDefault(String textType, int defaultColor) {
        return defaultColor;
    }

    public int getGUIColorization() {
        return GT_Util.getRGBaInt(Dyes.dyeWhite.getRGBA());
    }

    public ItemStack getStackForm(long aAmount) {
        return null;
    }
}

