/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.modularui;

import com.gtnewhorizons.modularui.api.drawable.AdaptableUITexture;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import gregtech.api.enums.SteamVariant;

public class SteamTexture {
    private final UITexture bronzeTexture;
    private final UITexture steelTexture;
    private final UITexture primitiveTexture;

    private SteamTexture(UITexture bronzeTexture, UITexture steelTexture, UITexture primitiveTexture) {
        this.bronzeTexture = bronzeTexture;
        this.steelTexture = steelTexture;
        this.primitiveTexture = primitiveTexture;
    }

    public static SteamTexture fullImage(String mod, String location) {
        return new SteamTexture(UITexture.fullImage((String)mod, (String)String.format(location, new Object[]{SteamVariant.BRONZE})), UITexture.fullImage((String)mod, (String)String.format(location, new Object[]{SteamVariant.STEEL})), UITexture.fullImage((String)mod, (String)String.format(location, new Object[]{SteamVariant.PRIMITIVE})));
    }

    public static SteamTexture adaptableTexture(String mod, String location, int imageWidth, int imageHeight, int borderWidthPixel) {
        return new SteamTexture((UITexture)AdaptableUITexture.of((String)mod, (String)String.format(location, new Object[]{SteamVariant.BRONZE}), (int)imageWidth, (int)imageHeight, (int)borderWidthPixel), (UITexture)AdaptableUITexture.of((String)mod, (String)String.format(location, new Object[]{SteamVariant.STEEL}), (int)imageWidth, (int)imageHeight, (int)borderWidthPixel), (UITexture)AdaptableUITexture.of((String)mod, (String)String.format(location, new Object[]{SteamVariant.PRIMITIVE}), (int)imageWidth, (int)imageHeight, (int)borderWidthPixel));
    }

    public UITexture get(SteamVariant variant) {
        switch (variant) {
            case BRONZE: {
                return this.bronzeTexture;
            }
            case STEEL: {
                return this.steelTexture;
            }
            case PRIMITIVE: {
                return this.primitiveTexture;
            }
        }
        return null;
    }

    public AdaptableUITexture getAdaptable(SteamVariant variant) {
        switch (variant) {
            case BRONZE: {
                return (AdaptableUITexture)this.bronzeTexture;
            }
            case STEEL: {
                return (AdaptableUITexture)this.steelTexture;
            }
            case PRIMITIVE: {
                return (AdaptableUITexture)this.primitiveTexture;
            }
        }
        return null;
    }

    public UITexture get(boolean isHighPressure) {
        return isHighPressure ? this.steelTexture : this.bronzeTexture;
    }
}

