/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.modularui.widget.AESlotWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_InputBus_ME
extends GT_MetaTileEntity_Hatch_InputBus
implements IConfigurationCircuitSupport,
IAddGregtechLogo,
IAddUIWidgets,
IPowerChannelState {
    private static final int SLOT_COUNT = 16;
    private BaseActionSource requestSource = null;
    private AENetworkProxy gridProxy = null;
    private final ItemStack[] shadowInventory = new ItemStack[16];
    private final int[] savedStackSizes = new int[16];
    private boolean processingRecipe = false;
    private boolean autoPullItemList = false;
    private int minAutoPullStackSize = 1;
    private static final int CONFIG_WINDOW_ID = 10;

    public GT_MetaTileEntity_Hatch_InputBus_ME(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 1, 33, new String[]{"Advanced item input for Multiblocks", "Retrieves directly from ME", "Keeps 16 item types in stock", "Auto-Pull from ME mode will automatically stock the first 16 items in the ME system, updated every 5 seconds.", "Toggle by right-clicking with screwdriver, or use the GUI.", "Use the GUI to limit the minimum stack size for Auto-Pulling.", "Configuration data can be copy+pasted using a data stick."});
        this.disableSort = true;
    }

    public GT_MetaTileEntity_Hatch_InputBus_ME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 33, aDescription, aTextures);
        this.disableSort = true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_InputBus_ME(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_HATCH)};
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aTimer % 100L == 0L && this.autoPullItemList) {
            this.refreshItemList();
        }
        super.onPostTick(aBaseMetaTileEntity, aTimer);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing((byte)forgeDirection.ordinal()) ? AECableType.SMART : AECableType.NONE;
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", ItemList.Hatch_Output_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    @Override
    public void gridChanged() {
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        int[] sizes = new int[16];
        for (int i = 0; i < 16; ++i) {
            sizes[i] = this.mInventory[i + 16] == null ? 0 : this.mInventory[i + 16].field_77994_a;
        }
        aNBT.func_74783_a("sizes", sizes);
        aNBT.func_74757_a("autoStock", this.autoPullItemList);
        aNBT.func_74768_a("minAutoPullStackSize", this.minAutoPullStackSize);
        if (GregTech_API.mAE2) {
            this.gridProxy.writeToNBT(aNBT);
        }
    }

    private void setAutoPullItemList(boolean pullItemList) {
        this.autoPullItemList = pullItemList;
        if (!this.autoPullItemList) {
            for (int i = 0; i < 16; ++i) {
                this.mInventory[i] = null;
            }
        } else {
            this.refreshItemList();
        }
        this.updateAllInformationSlots();
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int[] sizes;
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("sizes") && (sizes = aNBT.func_74759_k("sizes")).length == 16) {
            for (int i = 0; i < 16; ++i) {
                if (sizes[i] == 0 || this.mInventory[i] == null) continue;
                ItemStack s = this.mInventory[i].func_77946_l();
                s.field_77994_a = sizes[i];
                this.mInventory[i + 16] = s;
            }
        }
        this.autoPullItemList = aNBT.func_74767_n("autoStock");
        this.minAutoPullStackSize = aNBT.func_74762_e("minAutoPullStackSize");
        if (GregTech_API.mAE2) {
            this.getProxy().readFromNBT(aNBT);
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (GregTech_API.mAE2) {
            return new String[]{"The bus is " + (this.getProxy() != null && this.getProxy().isActive() ? EnumChatFormatting.GREEN + "online" : EnumChatFormatting.RED + "offline" + this.getAEDiagnostics()) + EnumChatFormatting.RESET};
        }
        return new String[0];
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.setAutoPullItemList(!this.autoPullItemList);
        GT_Utility.sendChatToPlayer(aPlayer, "Automatic Item Pull " + this.autoPullItemList);
    }

    @Override
    public void updateSlots() {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, aSide, aX, aY, aZ);
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, true, true)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, aSide, aX, aY, aZ);
        }
        if (!dataStick.func_77942_o() || !"stockingBus".equals(dataStick.field_77990_d.func_74779_i("type"))) {
            return false;
        }
        NBTTagCompound nbt = dataStick.field_77990_d;
        ItemStack circuit = GT_Utility.loadItem(dataStick.field_77990_d, "circuit");
        if (GT_Utility.isStackInvalid(circuit)) {
            circuit = null;
        }
        this.setAutoPullItemList(nbt.func_74767_n("autoPull"));
        this.minAutoPullStackSize = nbt.func_74762_e("minStackSize");
        if (!this.autoPullItemList) {
            NBTTagList stockingItems = nbt.func_150295_c("itemsToStock", 10);
            for (int i = 0; i < stockingItems.func_74745_c(); ++i) {
                this.mInventory[i] = GT_Utility.loadItem(stockingItems.func_150305_b(i));
            }
        }
        this.func_70299_a(this.getCircuitSlot(), circuit);
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Loaded Config From Data Stick"));
        return true;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, true, true)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", "stockingBus");
        tag.func_74757_a("autoPull", this.autoPullItemList);
        tag.func_74768_a("minStackSize", this.minAutoPullStackSize);
        tag.func_74782_a("circuit", (NBTBase)GT_Utility.saveItem(this.func_70301_a(this.getCircuitSlot())));
        NBTTagList stockingItems = new NBTTagList();
        if (!this.autoPullItemList) {
            for (int index = 0; index < 16; ++index) {
                stockingItems.func_74742_a((NBTBase)GT_Utility.saveItem(this.mInventory[index]));
            }
            tag.func_74782_a("itemsToStock", (NBTBase)stockingItems);
        }
        dataStick.field_77990_d = tag;
        dataStick.func_151001_c("Stocking Input Bus Configuration");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Saved Config to Data Stick"));
    }

    @Override
    public int getCircuitSlot() {
        return 32;
    }

    @Override
    public int getCircuitSlotX() {
        return 80;
    }

    @Override
    public int getCircuitSlotY() {
        return 63;
    }

    @Override
    public boolean setStackToZeroInsteadOfNull(int aIndex) {
        return true;
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        if (!this.processingRecipe) {
            return super.func_70301_a(aIndex);
        }
        if (aIndex < 0 || aIndex > this.mInventory.length) {
            return null;
        }
        if (aIndex >= 16 && aIndex < 32) {
            return null;
        }
        if (aIndex == this.getCircuitSlot()) {
            return this.mInventory[aIndex];
        }
        if (GregTech_API.mAE2 && this.mInventory[aIndex] != null) {
            AENetworkProxy proxy = this.getProxy();
            if (proxy == null) {
                return null;
            }
            try {
                IMEMonitor sg = proxy.getStorage().getItemInventory();
                AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[aIndex]);
                request.setStackSize(Integer.MAX_VALUE);
                IAEItemStack result = (IAEItemStack)sg.extractItems((IAEStack)request, Actionable.SIMULATE, this.getRequestSource());
                if (result != null) {
                    this.shadowInventory[aIndex] = result.getItemStack();
                    this.savedStackSizes[aIndex] = this.shadowInventory[aIndex].field_77994_a;
                    this.func_70299_a(aIndex + 16, this.shadowInventory[aIndex]);
                    return this.shadowInventory[aIndex];
                }
                this.func_70299_a(aIndex + 16, null);
                return null;
            }
            catch (GridAccessException gridAccessException) {
                return null;
            }
        }
        this.func_70299_a(aIndex + 16, null);
        return this.mInventory[aIndex];
    }

    private BaseActionSource getRequestSource() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    public void onExplosion() {
        for (int i = 0; i < 16; ++i) {
            this.mInventory[i] = null;
        }
    }

    @Override
    public void startRecipeProcessing() {
        this.processingRecipe = true;
    }

    private void refreshItemList() {
        if (GregTech_API.mAE2) {
            AENetworkProxy proxy = this.getProxy();
            try {
                IMEMonitor sg = proxy.getStorage().getItemInventory();
                Iterator iterator = sg.getStorageList().iterator();
                int index = 0;
                while (iterator.hasNext() && index < 16) {
                    ItemStack itemstack;
                    IAEItemStack currItem = (IAEItemStack)iterator.next();
                    if (currItem.getStackSize() < (long)this.minAutoPullStackSize) continue;
                    this.mInventory[index] = itemstack = GT_Utility.copyAmount(1L, currItem.getItemStack());
                    ++index;
                }
                for (int i = index; i < 16; ++i) {
                    this.mInventory[i] = null;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private void updateAllInformationSlots() {
        for (int index = 0; index < 16; ++index) {
            this.updateInformationSlot(index, this.mInventory[index]);
        }
    }

    @Override
    public void endRecipeProcessing() {
        if (GregTech_API.mAE2) {
            for (int i = 0; i < 16; ++i) {
                if (this.savedStackSizes[i] == 0) continue;
                ItemStack oldStack = this.shadowInventory[i];
                if (oldStack == null || oldStack.field_77994_a < this.savedStackSizes[i]) {
                    AENetworkProxy proxy = this.getProxy();
                    try {
                        IMEMonitor sg = proxy.getStorage().getItemInventory();
                        AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[i]);
                        request.setStackSize((long)(this.savedStackSizes[i] - (oldStack == null ? 0 : oldStack.field_77994_a)));
                        sg.extractItems((IAEStack)request, Actionable.MODULATE, this.getRequestSource());
                        proxy.getEnergy().extractAEPower((double)request.getStackSize(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                        this.func_70299_a(i + 16, oldStack);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                this.savedStackSizes[i] = 0;
                this.shadowInventory[i] = null;
            }
        }
        this.processingRecipe = false;
    }

    public ItemStack updateInformationSlot(int aIndex, ItemStack aStack) {
        if (GregTech_API.mAE2 && aIndex >= 0 && aIndex < 16) {
            if (aStack == null) {
                super.func_70299_a(aIndex + 16, null);
            } else {
                AENetworkProxy proxy = this.getProxy();
                if (!proxy.isActive()) {
                    super.func_70299_a(aIndex + 16, null);
                    return null;
                }
                try {
                    IMEMonitor sg = proxy.getStorage().getItemInventory();
                    AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[aIndex]);
                    request.setStackSize(Integer.MAX_VALUE);
                    IAEItemStack result = (IAEItemStack)sg.extractItems((IAEStack)request, Actionable.SIMULATE, this.getRequestSource());
                    ItemStack s = result != null ? result.getItemStack() : null;
                    this.func_70299_a(aIndex + 16, s);
                    return s;
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        final SlotWidget[] aeSlotWidgets = new SlotWidget[16];
        buildContext.addSyncedWindow(10, this::createStackSizeConfigurationWindow);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).phantom(true).background(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_ARROW_ME}).widgetCreator(slot -> new SlotWidget((BaseSlot)slot){

            protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                if (clickData.mouseButton != 0 || GT_MetaTileEntity_Hatch_InputBus_ME.this.autoPullItemList) {
                    return;
                }
                int aSlotIndex = this.getMcSlot().getSlotIndex();
                if (cursorStack == null) {
                    this.getMcSlot().func_75215_d(null);
                } else {
                    if (this.containsSuchStack(cursorStack)) {
                        return;
                    }
                    this.getMcSlot().func_75215_d(GT_Utility.copyAmount(1L, cursorStack));
                }
                if (GT_MetaTileEntity_Hatch_InputBus_ME.this.getBaseMetaTileEntity().isServerSide()) {
                    ItemStack newInfo = GT_MetaTileEntity_Hatch_InputBus_ME.this.updateInformationSlot(aSlotIndex, cursorStack);
                    aeSlotWidgets[this.getMcSlot().getSlotIndex()].getMcSlot().func_75215_d(newInfo);
                }
            }

            private boolean containsSuchStack(ItemStack tStack) {
                for (int i = 0; i < 16; ++i) {
                    if (!GT_Utility.areStacksEqual(GT_MetaTileEntity_Hatch_InputBus_ME.this.mInventory[i], tStack, false)) continue;
                    return true;
                }
                return false;
            }
        }).build().setPos(7, 9))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(16).endAtSlot(31).phantom(true).background(new IDrawable[]{GT_UITextures.SLOT_DARK_GRAY}).widgetCreator(slot -> {
            SlotWidget slotWidget = new AESlotWidget((BaseSlot)slot).disableInteraction();
            aeSlotWidgets[slot.getSlotIndex() - 16] = slotWidget;
            return slotWidget;
        }).build().setPos(97, 9))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_ARROW_DOUBLE).setPos(82, 40).setSize(12, 12))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (clickData.mouseButton == 0) {
                this.setAutoPullItemList(!this.autoPullItemList);
            } else if (clickData.mouseButton == 1 && !widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.autoPullItemList) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_AUTOPULL_ME);
            } else {
                ret.add(GT_UITextures.OVERLAY_BUTTON_AUTOPULL_ME_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).addTooltips((List)ImmutableList.of((Object)"Click to toggle automatic item pulling from ME.", (Object)"Right-Click to edit minimum stack size for item pulling.")).setSize(16, 16).setPos(80, 10))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.autoPullItemList, this::setAutoPullItemList));
    }

    protected ModularWindow createStackSizeConfigurationWindow(EntityPlayer player) {
        int WIDTH = 78;
        int HEIGHT = 40;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)78, (int)40);
        builder.setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(78, 40)).add(75, 0)));
        ((ModularWindow.Builder)builder.widget(new TextWidget("Min Stack Size").setPos(3, 2).setSize(74, 14))).widget(new TextFieldWidget().setSetterInt(val -> {
            this.minAutoPullStackSize = val;
        }).setGetterInt(() -> this.minAutoPullStackSize).setNumbers(1, Integer.MAX_VALUE).setOnScrollNumbers(1, 4, 64).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(36, 18).setPos(19, 18).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}));
        return builder.build();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(80, 63));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        boolean autopull = tag.func_74767_n("autoPull");
        int minSize = tag.func_74762_e("minStackSize");
        currenttip.add(String.format("Auto-Pull from ME: %s", autopull ? "Enabled" : "Disabled"));
        if (autopull) {
            currenttip.add(String.format("Minimum Stack Size: %d", minSize));
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        tag.func_74757_a("autoPull", this.autoPullItemList);
        tag.func_74768_a("minStackSize", this.minAutoPullStackSize);
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }
}

