/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.generators;

import com.google.common.base.Enums;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicGenerator;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.tileentities.generators.MagicalEnergyBBListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectSourceHelper;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.visnet.VisNetHandler;

public class GT_MetaTileEntity_MagicalEnergyAbsorber
extends GT_MetaTileEntity_BasicGenerator
implements MagicalEnergyBBListener {
    private static final boolean THAUMCRAFT_LOADED = Loader.isModLoaded((String)"Thaumcraft");
    private static final ConcurrentHashMap<UUID, GT_MetaTileEntity_MagicalEnergyAbsorber> sSubscribedCrystals = new ConcurrentHashMap(4);
    private static final List<Aspect> sPrimalAspects = THAUMCRAFT_LOADED ? Aspect.getPrimalAspects() : new ArrayList();
    private static final Map<Aspect, Integer> sAspectsEnergy = new HashMap<Aspect, Integer>();
    private static boolean sAllowMultipleEggs = false;
    private static GT_MetaTileEntity_MagicalEnergyAbsorber sActiveSiphon = null;
    private static int sEnergyPerEndercrystal = 512;
    private static int sEnergyFromVis = 20;
    private static int sEnergyPerEssentia = 320;
    private static int sDragonEggEnergyPerTick = 2048;
    private static int sCreeperEggEnergyPerTick = 512;
    private final MagicalEnergyBB mMagicalEnergyBB;
    private int mEfficiency;
    private int mMaxVisPerDrain;
    private long mNextGenerateTickRate;
    private int mNoGenerationTicks;
    private boolean mUsingEssentia;

    public GT_MetaTileEntity_MagicalEnergyAbsorber(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Feasts on magic close to it:", new ITexture[0]);
        this.mMagicalEnergyBB = new MagicalEnergyBB(this, this.mTier, this.mTier + 2);
        this.mNextGenerateTickRate = 1L;
        this.mNoGenerationTicks = 0;
        this.mUsingEssentia = true;
        this.onConfigLoad(GregTech_API.sMachineFile);
    }

    private GT_MetaTileEntity_MagicalEnergyAbsorber(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.mMagicalEnergyBB = new MagicalEnergyBB(this, this.mTier, this.mTier + 2);
        this.mNextGenerateTickRate = 1L;
        this.mNoGenerationTicks = 0;
        this.mUsingEssentia = true;
        this.onConfigLoad(GregTech_API.sMachineFile);
    }

    private static void sharedConfigLoad(GT_Config aConfig) {
        sAllowMultipleEggs = aConfig.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.AllowMultipleEggs", false);
        sDragonEggEnergyPerTick = aConfig.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerTick.DragonEgg", 2048);
        sCreeperEggEnergyPerTick = aConfig.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerTick.CreeperEgg", 512);
        sEnergyPerEndercrystal = aConfig.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerTick.EnderCrystal", 512);
        if (THAUMCRAFT_LOADED) {
            sEnergyFromVis = aConfig.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerVis", 20);
            sEnergyPerEssentia = aConfig.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerEssentia", 320);
            for (Aspect tAspect : Aspect.aspects.values()) {
                sAspectsEnergy.put(tAspect, ((TC_Aspects)((Object)Enums.getIfPresent(TC_Aspects.class, (String)tAspect.getTag().toUpperCase((Locale)Locale.ENGLISH)).or((Object)((Object)TC_Aspects.AER)))).mValue * sEnergyPerEssentia);
            }
        }
    }

    private static void setActiveSiphon(GT_MetaTileEntity_MagicalEnergyAbsorber aSiphon) {
        sActiveSiphon = aSiphon;
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        GT_MetaTileEntity_MagicalEnergyAbsorber.sharedConfigLoad(aConfig);
        this.mEfficiency = aConfig.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.efficiency.tier." + this.mTier, 100 - this.mTier * 10);
        this.mMaxVisPerDrain = (int)Math.round(Math.sqrt((double)(GT_Values.V[this.mTier] * 10000L) / (double)(sEnergyFromVis * (this.getEfficiency() != 0 ? this.getEfficiency() : 100))));
        double d = Math.pow(this.mMaxVisPerDrain, 2.0) * (double)sEnergyFromVis;
        int n = this.getEfficiency() != 0 ? this.getEfficiency() : 100;
        if (d * (double)n < (double)GT_Values.V[this.mTier]) {
            ++this.mMaxVisPerDrain;
        }
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.mMagicalEnergyBB.decreaseTier();
        } else {
            this.mMagicalEnergyBB.increaseTier();
        }
        GT_Utility.sendChatToPlayer(aPlayer, String.format(GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_MagicalEnergyAbsorber_Screwdriver", "Absorption range: %s blocks"), this.mMagicalEnergyBB.getRange(), true));
        this.mMagicalEnergyBB.update();
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        this.mMagicalEnergyBB.update();
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        this.releaseEgg();
        this.unsubscribeCrystals();
    }

    private void releaseEgg() {
        if (sActiveSiphon == this) {
            GT_MetaTileEntity_MagicalEnergyAbsorber.setActiveSiphon(null);
        }
    }

    private void unsubscribeCrystals() {
        for (UUID tCrystalID : sSubscribedCrystals.keySet()) {
            sSubscribedCrystals.remove(tCrystalID, this);
        }
    }

    @Override
    public void onMagicalEnergyBBUpdate() {
        List<UUID> tCrystalIDsInRange = this.mMagicalEnergyBB.getLivingCrystalIDs();
        for (UUID tSubscribedCrystalID : sSubscribedCrystals.keySet()) {
            if (tCrystalIDsInRange.contains(tSubscribedCrystalID)) continue;
            sSubscribedCrystals.remove(tSubscribedCrystalID, this);
        }
        for (UUID tCrystalID : tCrystalIDsInRange) {
            sSubscribedCrystals.putIfAbsent(tCrystalID, this);
        }
    }

    @Override
    public String[] getDescription() {
        String LI = "- %%%";
        String EU_PER = "%%%EU per ";
        ArrayList<String> description = new ArrayList<String>();
        description.add(EnumChatFormatting.UNDERLINE + "Feasts on " + EnumChatFormatting.LIGHT_PURPLE + EnumChatFormatting.UNDERLINE + "magic" + EnumChatFormatting.GRAY + EnumChatFormatting.UNDERLINE + " close to it:");
        description.add("- %%%" + (sAllowMultipleEggs ? "A " : "An " + EnumChatFormatting.YELLOW + EnumChatFormatting.UNDERLINE + "EXCLUSIVE" + EnumChatFormatting.RESET) + EnumChatFormatting.GRAY + " " + EnumChatFormatting.LIGHT_PURPLE + "Dragon Egg" + EnumChatFormatting.GRAY + " atop");
        if (sEnergyPerEndercrystal > 0) {
            description.add("- %%%" + sEnergyPerEndercrystal + "%%%EU per " + EnumChatFormatting.LIGHT_PURPLE + "Ender Crystal" + EnumChatFormatting.GRAY + " in range");
        }
        if (THAUMCRAFT_LOADED) {
            description.add("- %%%" + this.mMaxVisPerDrain + "%%%CV/t from an " + EnumChatFormatting.LIGHT_PURPLE + "Energised Node" + EnumChatFormatting.GRAY);
            description.add("- %%%" + sEnergyPerEssentia * this.getEfficiency() / 100 + "%%%EU per " + EnumChatFormatting.LIGHT_PURPLE + "Essentia" + EnumChatFormatting.GRAY + " Aspect-Value from containers in range");
        }
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "Lookup range (Use Screwdriver to change):");
        description.add("Default: %%%" + EnumChatFormatting.GREEN + this.mMagicalEnergyBB.getDefaultRange());
        description.add("Max: %%%" + EnumChatFormatting.GREEN + this.mMagicalEnergyBB.getMaxRange());
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "Fuels on " + EnumChatFormatting.LIGHT_PURPLE + EnumChatFormatting.UNDERLINE + "enchantments" + EnumChatFormatting.GRAY + EnumChatFormatting.UNDERLINE + " input:");
        description.add("- Item: %%%" + 10000 * this.getEfficiency() / 100 + "%%%EU per " + EnumChatFormatting.LIGHT_PURPLE + "enchant" + EnumChatFormatting.GRAY + " weight \u00d7 level / max");
        description.add("- Book: %%%10000%%%EU per " + EnumChatFormatting.LIGHT_PURPLE + "enchant" + EnumChatFormatting.GRAY + " weight \u00d7 level / max");
        description.add(" ");
        description.add("Efficiency: %%%" + EnumChatFormatting.GREEN + this.getEfficiency() + "%");
        return description.toArray(new String[0]);
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).glow().build(), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_DRAGONEGG)};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).glow().build(), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_DRAGONEGG), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_DRAGONEGG_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public long maxEUStore() {
        return Math.max(this.getEUVar(), GT_Values.V[this.mTier] * 16000L + this.getMinimumStoredEU());
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            return;
        }
        if (aBaseMetaTileEntity.getUniversalEnergyStored() >= aBaseMetaTileEntity.getEUCapacity()) {
            return;
        }
        if (aTick % 100L == 0L && this.mUsingEssentia) {
            this.mMagicalEnergyBB.update();
        }
        if (aTick % this.mNextGenerateTickRate == 0L) {
            long tGeneratedEU = this.generateEU();
            if (tGeneratedEU > 0L) {
                this.mNoGenerationTicks = 0;
                this.mNextGenerateTickRate = tGeneratedEU >= 2L * GT_Values.V[this.mTier] ? (long)(1.0 / (2.0 * (double)GT_Values.V[this.mTier] / (double)tGeneratedEU)) : 1L;
                this.mInventory[this.getStackDisplaySlot()] = new ItemStack((Block)Blocks.field_150480_ab, 1);
                this.mInventory[this.getStackDisplaySlot()].func_151001_c("Generating: " + tGeneratedEU + " EU");
            } else {
                this.mInventory[this.getStackDisplaySlot()] = null;
                ++this.mNoGenerationTicks;
            }
            if (this.mNoGenerationTicks > 20) {
                this.mNoGenerationTicks = 0;
                this.mNextGenerateTickRate = 20L;
            }
            aBaseMetaTileEntity.increaseStoredEnergyUnits(tGeneratedEU, true);
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        byte topFacing;
        if (aBaseMetaTileEntity.isActive() && this.isEgg(aBaseMetaTileEntity.getBlockAtSide(topFacing = (byte)ForgeDirection.UP.ordinal()))) {
            double oX = (double)aBaseMetaTileEntity.getXCoord() + 0.5;
            double oY = (double)aBaseMetaTileEntity.getYCoord() + 0.53125;
            double oZ = (double)aBaseMetaTileEntity.getZCoord() + 0.5;
            WorldSpawnedEventBuilder.StringIdentifierPositionedWorldSpawnedEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setWorld(this.getBaseMetaTileEntity().getWorld()).setIdentifier((Enum)ParticleFX.PORTAL);
            for (int i = 0; i < 9; ++i) {
                double dX = ((double)XSTR.XSTR_INSTANCE.nextFloat() - 0.5) / 2.0;
                double dY = (double)XSTR.XSTR_INSTANCE.nextFloat() * 1.5;
                double dZ = ((double)XSTR.XSTR_INSTANCE.nextFloat() - 0.5) / 2.0;
                double x = oX + dX;
                double y = oY + dY;
                double z = oZ + dZ;
                double mX = dX * 4.0;
                double dXZ = Math.sqrt(dX * dX + dZ * dZ);
                double mY = -(dXZ * dY) / 4.0;
                double mZ = dZ * 4.0;
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder).setMotion(mX, mY, mZ).setPosition(x, y, z).run();
            }
        }
    }

    @Override
    public int getPollution() {
        return 0;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipes() {
        return GT_Recipe.GT_Recipe_Map.sMagicFuels;
    }

    @Override
    public int getEfficiency() {
        return this.mEfficiency;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return this.isDisenchantableItem(aStack) || this.isEnchantedBook(aStack);
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    private boolean isDisenchantableItem(ItemStack aStack) {
        return aStack.func_77948_v() && aStack.func_77973_b().func_77619_b() > 0;
    }

    private boolean isEnchantedBook(ItemStack aStack) {
        return aStack.func_77973_b() instanceof ItemEnchantedBook;
    }

    private long generateEU() {
        this.mUsingEssentia = false;
        long tEU = this.absorbFromEgg();
        if (tEU > 0L) {
            return tEU;
        }
        tEU = this.absorbFromEnderCrystals();
        if (tEU > 0L) {
            return tEU;
        }
        tEU = this.absorbFromEnchantedItems();
        if (tEU > 0L) {
            return tEU;
        }
        tEU = this.absorbFromVisNet();
        if (tEU > 0L) {
            return tEU;
        }
        this.mUsingEssentia = true;
        tEU = this.absorbFromEssentiaContainers();
        if (tEU > 0L) {
            return tEU;
        }
        return 0L;
    }

    private long absorbFromEnchantedItems() {
        ItemStack tStack = this.getBaseMetaTileEntity().func_70301_a(this.getInputSlot());
        if (tStack == null) {
            return 0L;
        }
        if (tStack.field_77994_a == 0) {
            return 0L;
        }
        if (!this.isDisenchantableItem(tStack) && !this.isEnchantedBook(tStack)) {
            return 0L;
        }
        long tEU = 0L;
        Map tMap = EnchantmentHelper.func_82781_a((ItemStack)tStack);
        for (Map.Entry e : tMap.entrySet()) {
            if ((Integer)e.getKey() >= Enchantment.field_77331_b.length) continue;
            Enchantment tEnchantment = Enchantment.field_77331_b[(Integer)e.getKey()];
            Integer tLevel = (Integer)e.getValue();
            tEU += 1000000L * (long)tLevel.intValue() / (long)tEnchantment.func_77325_b() / (long)tEnchantment.func_77324_c();
        }
        ItemStack tOutputStack = GT_Utility.copyAmount(1L, tStack);
        if (tOutputStack != null) {
            if (this.isDisenchantableItem(tOutputStack)) {
                tEU = tEU * (long)this.getEfficiency() / 100L;
                EnchantmentHelper.func_82782_a(new HashMap(), (ItemStack)tOutputStack);
            } else if (this.isEnchantedBook(tOutputStack)) {
                tOutputStack = new ItemStack(Items.field_151122_aG, 1);
            }
        }
        if (this.getBaseMetaTileEntity().getStoredEU() + tEU < this.getBaseMetaTileEntity().getEUCapacity() && this.getBaseMetaTileEntity().addStackToSlot(this.getOutputSlot(), tOutputStack)) {
            this.func_70298_a(this.getInputSlot(), 1);
        } else {
            tEU = 0L;
        }
        return tEU;
    }

    private boolean hasEgg() {
        Block above = this.getBaseMetaTileEntity().getBlockOffset(0, 1, 0);
        return this.isEgg(above);
    }

    private long absorbFromEgg() {
        Block egg;
        if (!this.hasEgg()) {
            return 0L;
        }
        if (!sAllowMultipleEggs) {
            if (sActiveSiphon != null && sActiveSiphon != this && sActiveSiphon.getBaseMetaTileEntity() != null && !sActiveSiphon.getBaseMetaTileEntity().isInvalidTileEntity() && sActiveSiphon.isChunkLoaded() && sActiveSiphon.hasEgg()) {
                this.getBaseMetaTileEntity().doExplosion(Integer.MAX_VALUE);
            } else {
                GT_MetaTileEntity_MagicalEnergyAbsorber.setActiveSiphon(this);
            }
        }
        if ((egg = this.getBaseMetaTileEntity().getBlockOffset(0, 1, 0)) == Blocks.field_150380_bt) {
            return sDragonEggEnergyPerTick;
        }
        if (egg.func_149739_a().contains("creeperEgg")) {
            return sCreeperEggEnergyPerTick;
        }
        return 0L;
    }

    private long absorbFromEnderCrystals() {
        if (sEnergyPerEndercrystal <= 0) {
            return 0L;
        }
        long tEU = 0L;
        for (GT_MetaTileEntity_MagicalEnergyAbsorber tSubscriber : sSubscribedCrystals.values()) {
            if (tSubscriber != this) continue;
            tEU += (long)sEnergyPerEndercrystal;
        }
        return tEU;
    }

    private long absorbFromVisNet() {
        if (!THAUMCRAFT_LOADED) {
            return 0L;
        }
        IGregTechTileEntity tBaseMetaTileEntity = this.getBaseMetaTileEntity();
        World tWorld = tBaseMetaTileEntity.getWorld();
        int tX = tBaseMetaTileEntity.getXCoord();
        short tY = tBaseMetaTileEntity.getYCoord();
        int tZ = tBaseMetaTileEntity.getZCoord();
        int toDrain = this.mMaxVisPerDrain;
        for (int i = sPrimalAspects.size() - 1; i >= 0 && toDrain > 0; toDrain -= VisNetHandler.drainVis((World)tWorld, (int)tX, (int)tY, (int)tZ, (Aspect)sPrimalAspects.get(i), (int)toDrain), --i) {
        }
        int drained = this.mMaxVisPerDrain - toDrain;
        long tEU = (long)Math.min((double)this.maxEUOutput(), Math.pow(drained, 2.0) * (double)sEnergyFromVis * (double)this.getEfficiency() / 10000.0);
        return tEU;
    }

    private long absorbFromEssentiaContainers() {
        if (!THAUMCRAFT_LOADED) {
            return 0L;
        }
        long tEU = 0L;
        long tEUtoGen = this.getBaseMetaTileEntity().getEUCapacity() - this.getBaseMetaTileEntity().getUniversalEnergyStored();
        List<Aspect> mAvailableEssentiaAspects = this.mMagicalEnergyBB.getAvailableAspects();
        for (int i = mAvailableEssentiaAspects.size() - 1; i >= 0 && tEUtoGen > 0L; --i) {
            Aspect aspect = mAvailableEssentiaAspects.get(i);
            long tAspectEU = (long)sAspectsEnergy.get(aspect).intValue() * (long)this.getEfficiency() / 100L;
            if (tAspectEU > tEUtoGen || !AspectSourceHelper.drainEssentia((TileEntity)((TileEntity)this.getBaseMetaTileEntity()), (Aspect)aspect, (ForgeDirection)ForgeDirection.UNKNOWN, (int)this.mMagicalEnergyBB.getRange())) continue;
            tEUtoGen -= tAspectEU;
            tEU += tAspectEU;
        }
        return tEU;
    }

    private boolean isEgg(Block aBlock) {
        if (aBlock == null) {
            return false;
        }
        if (aBlock == Blocks.field_150350_a) {
            return false;
        }
        if (aBlock == Blocks.field_150380_bt) {
            return true;
        }
        if (aBlock instanceof BlockDragonEgg) {
            return true;
        }
        return aBlock.func_149739_a().equals("tile.dragonEgg");
    }

    private boolean isChunkLoaded() {
        IGregTechTileEntity tBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int tX = tBaseMetaTileEntity.getXCoord();
        short tY = tBaseMetaTileEntity.getYCoord();
        World tWorld = tBaseMetaTileEntity.getWorld();
        Chunk tChunk = tWorld.func_72938_d(tX, (int)tY);
        return tChunk.field_76636_d;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MagicalEnergyAbsorber(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mMagicalEnergyBBTier", this.mMagicalEnergyBB.getTier());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mMagicalEnergyBB.setTier(aNBT.func_74762_e("mMagicalEnergyBBTier"));
    }

    static class MagicalEnergyBB {
        private final GT_MetaTileEntity_MagicalEnergyAbsorber mAbsorber;
        private final MagicalEnergyBBListener mListener;
        private final int mDefaultTier;
        private int mTier;
        private final int mMaxTier;
        private final List<UUID> mLivingCrystalIDs = new ArrayList<UUID>();
        private List<Aspect> mAvailableAspects;

        MagicalEnergyBB(GT_MetaTileEntity_MagicalEnergyAbsorber aAbsorber, int aDefaultTier, int aMaxTier) {
            this.mAbsorber = aAbsorber;
            this.mListener = aAbsorber;
            this.mMaxTier = Math.max(aMaxTier > 0 ? aMaxTier : 0, aDefaultTier > 0 ? aDefaultTier : 0);
            this.mTier = this.mDefaultTier = Math.min(aDefaultTier, this.mMaxTier);
            if (THAUMCRAFT_LOADED) {
                this.mAvailableAspects = new ArrayList<Aspect>(Aspect.aspects.size());
            }
        }

        int getTier() {
            return this.mTier;
        }

        int setTier(int aTier) {
            this.mTier = aTier >= 0 ? (aTier <= this.mMaxTier ? aTier : this.mMaxTier) : 0;
            return this.mTier;
        }

        int getRange() {
            return this.getRange(this.mTier);
        }

        int getRange(int aTier) {
            return 1 << aTier;
        }

        int getDefaultTier() {
            return this.mDefaultTier;
        }

        int getDefaultRange() {
            return this.getRange(this.getDefaultTier());
        }

        int getMaxTier() {
            return this.mMaxTier;
        }

        int getMaxRange() {
            return this.getRange(this.getMaxTier());
        }

        private AxisAlignedBB getAxisAlignedBB() {
            double tRange = this.getRange();
            IGregTechTileEntity tBaseMetaTileEntity = this.mAbsorber.getBaseMetaTileEntity();
            double tX = tBaseMetaTileEntity.getXCoord();
            double tY = tBaseMetaTileEntity.getYCoord();
            double tZ = tBaseMetaTileEntity.getZCoord();
            return AxisAlignedBB.func_72330_a((double)(tX - tRange), (double)(tY - tRange), (double)(tZ - tRange), (double)(tX + tRange), (double)(tY + tRange), (double)(tZ + tRange));
        }

        private void scanLivingCrystals() {
            World tWorld = this.mAbsorber.getBaseMetaTileEntity().getWorld();
            this.mLivingCrystalIDs.clear();
            for (Object o : tWorld.func_72872_a(EntityEnderCrystal.class, this.getAxisAlignedBB())) {
                if (!((EntityEnderCrystal)o).func_70089_S()) continue;
                this.mLivingCrystalIDs.add(((EntityEnderCrystal)o).getPersistentID());
            }
        }

        private void scanAvailableAspects() {
            if (!THAUMCRAFT_LOADED) {
                return;
            }
            IGregTechTileEntity tBaseMetaTileEntity = this.mAbsorber.getBaseMetaTileEntity();
            if (tBaseMetaTileEntity.isInvalidTileEntity()) {
                return;
            }
            int tRange = this.getRange();
            short tY = tBaseMetaTileEntity.getYCoord();
            int tMaxY = tBaseMetaTileEntity.getWorld().func_72800_K() - 1;
            int rYMin = tY - tRange >= 0 ? -tRange : (int)(-tY);
            int rYMax = tY + tRange <= tMaxY ? tRange : tMaxY - tY;
            this.mAvailableAspects.clear();
            for (int rX = -tRange; rX <= tRange; ++rX) {
                for (int rZ = -tRange; rZ <= tRange; ++rZ) {
                    for (int rY = rYMin; rY < rYMax; ++rY) {
                        AspectList tAspectList;
                        TileEntity tTile = tBaseMetaTileEntity.getTileEntityOffset(rX, rY, rZ);
                        if (!(tTile instanceof IAspectContainer) || (tAspectList = ((IAspectContainer)tTile).getAspects()) == null || tAspectList.aspects.isEmpty()) continue;
                        Set tAspects = tAspectList.aspects.keySet();
                        this.mAvailableAspects.addAll(tAspects);
                    }
                }
            }
        }

        List<UUID> getLivingCrystalIDs() {
            return this.mLivingCrystalIDs;
        }

        List<Aspect> getAvailableAspects() {
            return this.mAvailableAspects;
        }

        void update() {
            if (this.mAbsorber == null) {
                return;
            }
            if (this.mAbsorber.getBaseMetaTileEntity() == null) {
                return;
            }
            if (this.mAbsorber.getBaseMetaTileEntity().isInvalidTileEntity()) {
                return;
            }
            if (this.mAbsorber.getBaseMetaTileEntity().getWorld() == null) {
                return;
            }
            this.scanLivingCrystals();
            this.scanAvailableAspects();
            if (this.mListener != null) {
                this.mListener.onMagicalEnergyBBUpdate();
            }
        }

        void increaseTier() {
            this.offsetTier(1);
        }

        void decreaseTier() {
            this.offsetTier(-1);
        }

        void offsetTier(int aOffset) {
            int tNumTiers = this.mMaxTier + 1;
            int tTier = (this.mTier + aOffset + tNumTiers) % tNumTiers;
            int tTrueTier = this.setTier(tTier);
            if (tTier != tTrueTier) {
                GT_Log.out.format("Absorber's BB Tier set to %d was capped to %d", tTier, tTrueTier);
            }
        }
    }
}

