/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.common.render.GT_Renderer_Block;
import gregtech.common.render.IRenderedBlockSideCheck;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public interface IRenderedBlock {
    @SideOnly(value=Side.CLIENT)
    public ITexture[] getTexture(Block var1, byte var2, int var3, boolean[] var4);

    @SideOnly(value=Side.CLIENT)
    public ITexture[] getTexture(Block var1, byte var2, boolean var3, int var4);

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(Block var1);

    @SideOnly(value=Side.CLIENT)
    public boolean usesRenderPass(int var1);

    @SideOnly(value=Side.CLIENT)
    public boolean setBlockBounds(Block var1, int var2);

    @SideOnly(value=Side.CLIENT)
    default public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlock passRenderingToObject(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlock passRenderingToObject(IBlockAccess var1, int var2, int var3, int var4);

    public static class ErrorRenderer
    implements IRenderedBlockSideCheck,
    IRenderedBlock {
        public static final ErrorRenderer INSTANCE = new ErrorRenderer();
        public ITexture[] mErrorTexture = Textures.BlockIcons.ERROR_RENDERING;

        @Override
        public ITexture[] getTexture(Block aBlock, byte aSide, int aRenderPass, boolean[] aShouldSideBeRendered) {
            return this.mErrorTexture;
        }

        @Override
        public ITexture[] getTexture(Block aBlock, byte aSide, boolean isActive, int aRenderPass) {
            return this.mErrorTexture;
        }

        @Override
        public int getRenderPasses(Block aBlock) {
            return 1;
        }

        @Override
        public boolean usesRenderPass(int aRenderPass) {
            return true;
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass) {
            aBlock.func_149676_a(-0.25f, -0.25f, -0.25f, 1.25f, 1.25f, 1.25f);
            return true;
        }

        @Override
        public boolean renderFullBlockSide(Block aBlock, RenderBlocks aRenderer, byte aSide) {
            return true;
        }

        @Override
        public IRenderedBlock passRenderingToObject(ItemStack aStack) {
            return this;
        }

        @Override
        public IRenderedBlock passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
            return this;
        }

        @Override
        public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
            aBlock.func_149676_a(-0.25f, -0.25f, -0.25f, 1.25f, 1.25f, 1.25f);
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.mErrorTexture, false);
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.mErrorTexture, false);
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.mErrorTexture, false);
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.mErrorTexture, false);
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.mErrorTexture, false);
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.mErrorTexture, false);
            return true;
        }
    }
}

