/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.power;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Utility;
import gregtech.common.power.Power;

public class EUPower
extends Power {
    protected final int amperage;
    protected int originalVoltage;

    public EUPower(byte tier, int amperage) {
        super(tier);
        this.amperage = amperage;
    }

    public EUPower(byte tier, int amperage, int specialValue) {
        super(tier, specialValue);
        this.amperage = amperage;
    }

    @Override
    public void computePowerUsageAndDuration(int euPerTick, int duration) {
        this.originalVoltage = this.computeVoltageForEuRate(euPerTick);
        this.recipeEuPerTick = euPerTick;
        this.recipeDuration = duration;
    }

    @Override
    public String getTierString() {
        return GT_Utility.getColoredTierNameFromTier(this.tier);
    }

    @Override
    public String getTotalPowerString() {
        return GT_Utility.formatNumbers((long)this.recipeDuration * (long)this.recipeEuPerTick) + " EU";
    }

    @Override
    public String getPowerUsageString() {
        return GT_Utility.formatNumbers(this.recipeEuPerTick) + " EU/t";
    }

    @Override
    public String getVoltageString() {
        String voltageDescription = GT_Utility.formatNumbers(this.originalVoltage) + " EU/t";
        byte recipeTier = GT_Utility.getTier(this.originalVoltage);
        if (recipeTier >= 0 && recipeTier < 16) {
            voltageDescription = voltageDescription + " (" + GT_Values.VN[recipeTier] + ")";
        }
        return voltageDescription;
    }

    @Override
    public String getAmperageString() {
        return GT_Utility.formatNumbers(this.amperage);
    }

    protected int computeVoltageForEuRate(int euPerTick) {
        return this.amperage != 0 ? euPerTick / this.amperage : euPerTick;
    }
}

