/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects.enums;

import com.gtnewhorizons.modularui.api.drawable.UITexture;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.enums.SpaceBodyType;
import gregtech.common.misc.spaceprojects.enums.StarType;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;

public enum SolarSystem implements ISpaceBody
{
    Sol(SpaceBodyType.Star, StarType.GClass),
    Overworld(SpaceBodyType.Planet),
    Moon(SpaceBodyType.NaturalSatellite),
    Mars(SpaceBodyType.Planet),
    Deimos(SpaceBodyType.NaturalSatellite),
    Phobos(SpaceBodyType.NaturalSatellite),
    Mercury(SpaceBodyType.Planet),
    Venus(SpaceBodyType.Planet),
    Jupiter(SpaceBodyType.GasGiant),
    Io(SpaceBodyType.NaturalSatellite),
    Ganymede(SpaceBodyType.NaturalSatellite),
    Europa(SpaceBodyType.NaturalSatellite),
    Callisto(SpaceBodyType.NaturalSatellite),
    Saturn(SpaceBodyType.GasGiant),
    Mimas(SpaceBodyType.NaturalSatellite),
    Enceladus(SpaceBodyType.NaturalSatellite),
    Tethys(SpaceBodyType.NaturalSatellite),
    Rhea(SpaceBodyType.NaturalSatellite),
    Titan(SpaceBodyType.NaturalSatellite),
    Hyperion(SpaceBodyType.NaturalSatellite),
    Iapetus(SpaceBodyType.NaturalSatellite),
    Phoebe(SpaceBodyType.NaturalSatellite),
    Uranus(SpaceBodyType.IceGiant),
    Miranda(SpaceBodyType.NaturalSatellite),
    Ariel(SpaceBodyType.NaturalSatellite),
    Umbriel(SpaceBodyType.NaturalSatellite),
    Titania(SpaceBodyType.NaturalSatellite),
    Oberon(SpaceBodyType.NaturalSatellite),
    Neptune(SpaceBodyType.IceGiant),
    Proteus(SpaceBodyType.NaturalSatellite),
    Triton(SpaceBodyType.NaturalSatellite),
    Nereid(SpaceBodyType.NaturalSatellite),
    Ceres(SpaceBodyType.DwarfPlanet),
    Pluto(SpaceBodyType.DwarfPlanet),
    Arrokoth(SpaceBodyType.DwarfPlanet),
    MakeMake(SpaceBodyType.DwarfPlanet),
    KuiperBelt(SpaceBodyType.AsteroidBelt),
    NONE(SpaceBodyType.NONE);

    private SpaceBodyType spaceBody;
    private StarType star;
    private UITexture texture;

    private SolarSystem(SpaceBodyType aType) {
        this(aType, StarType.NotAStar);
    }

    private SolarSystem(SpaceBodyType aType, StarType aStarType) {
        this.star = aStarType;
        this.spaceBody = aType;
        this.texture = UITexture.fullImage((String)"gregtech", (String)("solarsystem/" + this.getName()));
        SpaceProjectManager.addLocation(this);
    }

    @Override
    public StarType getStarType() {
        return this.star;
    }

    @Override
    public SpaceBodyType getType() {
        return this.spaceBody;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public UITexture getTexture() {
        return this.texture;
    }

    @Override
    public String getUnlocalizedName() {
        return "gt.solar.system." + this.getName().toLowerCase();
    }
}

