/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.MathExpression;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.IItemWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.VanillaButtonWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.BaseTextFieldWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.util.GT_Utility;
import ic2.core.util.LiquidUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_VolumetricFlask
extends GT_Generic_Item
implements IFluidContainerItem,
IItemWithModularUI {
    private final int maxCapacity;
    private final String unlocalFlaskName;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconWindow;

    public GT_VolumetricFlask(String unlocalized, String english, int maxCapacity) {
        super(unlocalized, english, null);
        this.maxCapacity = maxCapacity;
        this.unlocalFlaskName = unlocalized;
        this.func_77625_d(64);
        this.setNoRepair();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.isEmpty(stack) && this.func_77621_a(world, player, true) == null) {
            GT_UIInfos.openPlayerHeldItemUI(player);
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (player instanceof FakePlayer) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        if (this.interactWithTank(stack, player, world, x, y, z, side)) {
            return true;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        if (mop == null) {
            return false;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            x = mop.field_72311_b;
            y = mop.field_72312_c;
            z = mop.field_72309_d;
            if (!world.func_72962_a(player, x, y, z) || !player.func_82247_a(x, y, z, mop.field_72310_e, stack)) {
                return false;
            }
            if (this.collectFluidBlock(stack, player, world, x, y, z)) {
                return true;
            }
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[mop.field_72310_e];
            FluidStack fluidStack = LiquidUtil.drainContainerStack((ItemStack)stack, (EntityPlayer)player, (int)1000, (boolean)true);
            if (LiquidUtil.placeFluid((FluidStack)fluidStack, (World)world, (int)x, (int)y, (int)z) || player.func_82247_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, mop.field_72310_e, stack) && LiquidUtil.placeFluid((FluidStack)fluidStack, (World)world, (int)(x + dir.offsetX), (int)(y + dir.offsetY), (int)(z + dir.offsetZ))) {
                if (!player.field_71075_bZ.field_75098_d) {
                    LiquidUtil.drainContainerStack((ItemStack)stack, (EntityPlayer)player, (int)1000, (boolean)false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty(ItemStack stack) {
        return this.getFluid(stack) == null;
    }

    public int getFreeSpace(ItemStack stack) {
        int capacity = this.getCapacity(stack);
        if (capacity > 0) {
            FluidStack fluidStack = this.getFluid(stack);
            return fluidStack == null ? capacity : capacity - fluidStack.amount;
        }
        return 0;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public int getCapacity(ItemStack stack) {
        NBTTagCompound nbt;
        int capacity = 1000;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_150297_b("Capacity", 3)) {
            capacity = nbt.func_74762_e("Capacity");
        }
        return Math.min(this.getMaxCapacity(), capacity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        super.func_94581_a(aIconRegister);
        this.iconWindow = aIconRegister.func_94245_a("gregtech:gt." + this.unlocalFlaskName + ".window");
    }

    public void setCapacity(ItemStack stack, int capacity) {
        capacity = Math.min(capacity, this.getMaxCapacity());
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74768_a("Capacity", capacity);
    }

    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public void setFluid(ItemStack stack, FluidStack fluidStack) {
        boolean removeFluid = fluidStack == null || fluidStack.amount <= 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            if (removeFluid) {
                return;
            }
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (removeFluid) {
            nbt.func_82580_o("Fluid");
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        } else {
            nbt.func_74782_a("Fluid", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            fluidStack = new FluidStack(resource, 0);
        } else if (!fluidStack.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(this.getCapacity(stack) - fluidStack.amount, resource.amount);
        if (doFill && amount > 0) {
            fluidStack.amount += amount;
            this.setFluid(stack, fluidStack);
        }
        return amount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        if (stack.field_77994_a != 1) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return null;
        }
        maxDrain = Math.min(fluidStack.amount, maxDrain);
        if (doDrain) {
            fluidStack.amount -= maxDrain;
            this.setFluid(stack, fluidStack);
        }
        return new FluidStack(fluidStack, maxDrain);
    }

    @Override
    protected void addAdditionalToolTips(List<String> info, ItemStack stack, EntityPlayer aPlayer) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            info.add(String.format("< %s, %s mB >", GT_Utility.getFluidName(fs, true), GT_Utility.formatNumbers(fs.amount)));
        } else {
            info.add(String.format("< Empty, %s mB >", GT_Utility.formatNumbers(this.getCapacity(stack))));
        }
        info.add("Rightclick on air to set volume (only while empty)");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List itemList) {
        itemList.add(new ItemStack((Item)this));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid == null) continue;
            ItemStack stack = new ItemStack((Item)this);
            this.setCapacity(stack, this.getMaxCapacity());
            this.fill(stack, new FluidStack(fluid, Integer.MAX_VALUE), true);
            itemList.add(stack);
        }
    }

    private boolean interactWithTank(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        FluidStack fs = this.getFluid(stack);
        int capacity = this.getCapacity(stack);
        if (!(fs == null || player.func_70093_af() && fs.amount < capacity)) {
            int amount = handler.fill(dir, fs, false);
            if (amount > 0 && (fs = LiquidUtil.drainContainerStack((ItemStack)stack, (EntityPlayer)player, (int)amount, (boolean)false)) != null && fs.amount > 0) {
                handler.fill(dir, fs, true);
            }
        } else {
            int amount = fs == null ? capacity : capacity - fs.amount;
            FluidStack input = handler.drain(dir, amount, false);
            if (input != null && input.amount > 0 && (amount = LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)player, (FluidStack)input, (boolean)false)) > 0) {
                handler.drain(dir, amount, true);
            }
        }
        return true;
    }

    private boolean collectFluidBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IFluidBlock) {
            FluidStack fluid;
            int amount;
            IFluidBlock liquid = (IFluidBlock)block;
            if (liquid.canDrain(world, x, y, z) && (amount = LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)player, (FluidStack)(fluid = liquid.drain(world, x, y, z, false)), (boolean)true)) == fluid.amount) {
                LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)player, (FluidStack)fluid, (boolean)false);
                liquid.drain(world, x, y, z, true);
                return true;
            }
        } else if (world.func_72805_g(x, y, z) == 0) {
            int amount;
            FluidStack fluid = null;
            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                    fluid = new FluidStack(FluidRegistry.LAVA, 1000);
                }
            } else {
                fluid = new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (fluid != null && (amount = LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)player, (FluidStack)fluid, (boolean)true)) == fluid.amount) {
                LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)player, (FluidStack)fluid, (boolean)false);
                world.func_147468_f(x, y, z);
                return true;
            }
        }
        return false;
    }

    public ModularWindow createWindow(UIBuildContext buildContext, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof GT_VolumetricFlask)) {
            return null;
        }
        return new VolumetricFlaskUIFactory(buildContext, stack).createWindow();
    }

    private class VolumetricFlaskUIFactory {
        private final UIBuildContext buildContext;
        private final int maxCapacity;
        private TextFieldWidget textField;

        public VolumetricFlaskUIFactory(UIBuildContext buildContext, ItemStack flask) {
            this.buildContext = buildContext;
            this.maxCapacity = ((GT_VolumetricFlask)flask.func_77973_b()).getMaxCapacity();
        }

        public ModularWindow createWindow() {
            ModularWindow.Builder builder = ModularWindow.builder((int)176, (int)107);
            builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
            this.textField = new TextFieldWidget(){

                public void onDestroy() {
                    if (this.isClient()) {
                        return;
                    }
                    GT_VolumetricFlask.this.setCapacity(VolumetricFlaskUIFactory.this.getCurrentItem(), (int)MathExpression.parseMathExpression((String)this.getText(), (double)1.0));
                    this.getContext().onWidgetUpdate();
                }
            };
            this.textField.setText(String.valueOf(((GT_VolumetricFlask)this.getCurrentItem().func_77973_b()).getCapacity(this.getCurrentItem())));
            builder.widget(this.textField.setNumbers(() -> 1, () -> this.maxCapacity).setPattern(BaseTextFieldWidget.NATURAL_NUMS).setTextAlignment(Alignment.CenterLeft).setTextColor(Color.WHITE.dark(1)).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD_LIGHT_GRAY.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(60, 55).setSize(59, 12));
            this.addChangeAmountButton(builder, "+1", new Pos2d(20, 26), new Size(22, 20), val -> val + 1);
            this.addChangeAmountButton(builder, "+10", new Pos2d(48, 26), new Size(28, 20), val -> val + 10);
            this.addChangeAmountButton(builder, "+100", new Pos2d(82, 26), new Size(32, 20), val -> val + 100);
            this.addChangeAmountButton(builder, "+1000", new Pos2d(120, 26), new Size(38, 20), val -> val + 1000);
            this.addChangeAmountButton(builder, "-1", new Pos2d(20, 75), new Size(22, 20), val -> val - 1);
            this.addChangeAmountButton(builder, "-10", new Pos2d(48, 75), new Size(28, 20), val -> val - 10);
            this.addChangeAmountButton(builder, "-100", new Pos2d(82, 75), new Size(32, 20), val -> val - 100);
            this.addChangeAmountButton(builder, "-1000", new Pos2d(120, 75), new Size(38, 20), val -> val - 1000);
            builder.widget(new VanillaButtonWidget().setDisplayString("Accept").setClickableGetter(() -> MathExpression.parseMathExpression((String)this.textField.getText()) > 0.0).setOnClick((clickData, widget) -> {
                if (widget.isClient()) {
                    this.textField.onRemoveFocus();
                } else {
                    widget.getWindow().tryClose();
                }
            }).setPos(128, 51).setSize(38, 20));
            return builder.build();
        }

        private void addChangeAmountButton(ModularWindow.Builder builder, String text, Pos2d pos, Size size, Function<Integer, Integer> function) {
            builder.widget(new VanillaButtonWidget().setDisplayString(text).setOnClick((clickData, widget) -> {
                String currentText = this.textField.getText();
                int amount = (int)MathExpression.parseMathExpression((String)currentText, (double)1.0);
                amount = Math.min(this.maxCapacity, Math.max(1, (Integer)function.apply(amount)));
                this.textField.setText(String.valueOf(amount));
            }).setPos(pos).setSize(size));
        }

        private ItemStack getCurrentItem() {
            return this.buildContext.getPlayer().field_71071_by.func_70448_g();
        }
    }
}

