/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GT_Mod;
import gregtech.api.interfaces.IFluidAccess;
import gregtech.api.interfaces.IHasFluidDisplayItem;
import gregtech.api.interfaces.metatileentity.IFluidLockable;
import gregtech.api.util.GT_Utility;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidDisplaySlotWidget
extends SlotWidget {
    private IHasFluidDisplayItem iHasFluidDisplay;
    private Supplier<IFluidAccess> fluidAccessConstructor;
    private Supplier<Boolean> canDrainGetter;
    private Supplier<Boolean> canFillGetter;
    private Predicate<Fluid> canFillFilter;
    private Action actionRealClick = Action.NONE;
    private Action actionDragAndDrop = Action.NONE;
    private BiFunction<Widget.ClickData, FluidDisplaySlotWidget, Boolean> beforeRealClick;
    private BiFunction<Widget.ClickData, FluidDisplaySlotWidget, Boolean> beforeDragAndDrop;
    private Runnable updateFluidDisplayItem = () -> {
        if (this.iHasFluidDisplay != null) {
            this.iHasFluidDisplay.updateFluidDisplayItem();
        }
    };

    public FluidDisplaySlotWidget(BaseSlot slot) {
        super(slot);
        this.setAccess(false, false);
        this.disableShiftInsert();
    }

    public FluidDisplaySlotWidget(IItemHandlerModifiable handler, int index) {
        this(new BaseSlot(handler, index, true));
    }

    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (this.actionRealClick == Action.NONE) {
            return Interactable.ClickResult.REJECT;
        }
        if (this.interactionDisabled) {
            return Interactable.ClickResult.REJECT;
        }
        Widget.ClickData clickData = Widget.ClickData.create((int)buttonId, (boolean)doubleClick);
        ItemStack verifyToken = this.executeRealClick(clickData);
        this.syncToServer(2, buffer -> {
            clickData.writeToPacket(buffer);
            try {
                buffer.func_150788_a(verifyToken);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return Interactable.ClickResult.ACCEPT;
    }

    public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
        if (this.actionDragAndDrop == Action.NONE || this.actionDragAndDrop == Action.TRANSFER) {
            return false;
        }
        if (this.interactionDisabled) {
            return false;
        }
        Widget.ClickData clickData = Widget.ClickData.create((int)button, (boolean)false);
        this.executeDragAndDrop(clickData, draggedStack);
        this.syncToServer(5, buffer -> {
            try {
                clickData.writeToPacket(buffer);
                buffer.func_150788_a(draggedStack);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        draggedStack.field_77994_a = 0;
        return true;
    }

    public List<String> getExtraTooltip() {
        return Collections.emptyList();
    }

    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.getMcSlot().field_75223_e = buf.func_150792_a();
            this.getMcSlot().field_75221_f = buf.func_150792_a();
        } else if (id == 2) {
            this.onClickServer(Widget.ClickData.readPacket((PacketBuffer)buf), buf.func_150791_c());
        } else if (id == 3) {
            this.phantomScroll(buf.func_150792_a());
        } else if (id == 4) {
            this.setEnabled(buf.readBoolean());
        } else if (id == 5) {
            this.executeDragAndDrop(Widget.ClickData.readPacket((PacketBuffer)buf), buf.func_150791_c());
            if (this.onDragAndDropComplete != null) {
                this.onDragAndDropComplete.accept(this);
            }
        }
        this.markForUpdate();
    }

    private void onClickServer(Widget.ClickData clickData, ItemStack clientVerifyToken) {
        ItemStack serverVerifyToken = this.executeRealClick(clickData);
        if (!ItemStack.func_77989_b((ItemStack)clientVerifyToken, (ItemStack)serverVerifyToken)) {
            ((EntityPlayerMP)this.getContext().getPlayer()).func_71120_a((Container)this.getContext().getContainer());
        }
    }

    private ItemStack executeRealClick(Widget.ClickData clickData) {
        if (this.actionRealClick == Action.NONE) {
            return null;
        }
        if (this.beforeRealClick != null && !this.beforeRealClick.apply(clickData, this).booleanValue()) {
            return null;
        }
        ItemStack ret = null;
        if (this.actionRealClick == Action.TRANSFER) {
            if (this.fluidAccessConstructor == null) {
                GT_Mod.GT_FML_LOGGER.warn("FluidDisplaySlotWidget is asked to transfer fluid, but fluidAccessConstructor is null!");
                return null;
            }
            ret = this.transferFluid(this.fluidAccessConstructor.get(), this.getContext().getPlayer(), clickData.mouseButton == 0, this.canDrainGetter != null ? this.canDrainGetter.get() : true, this.canFillGetter != null ? this.canFillGetter.get() : true);
        } else if (this.actionRealClick == Action.LOCK) {
            this.lockFluid(this.getContext().getPlayer().field_71071_by.func_70445_o());
        }
        this.updateFluidDisplayItem.run();
        return ret;
    }

    protected ItemStack transferFluid(IFluidAccess aFluidAccess, EntityPlayer aPlayer, boolean aProcessFullStack, boolean aCanDrain, boolean aCanFill) {
        ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null || tStackHeld.field_77994_a == 0) {
            return null;
        }
        FluidStack tInputFluid = aFluidAccess.get();
        FluidStack tFluidHeld = GT_Utility.getFluidForFilledItem(tStackSizedOne, true);
        if (tFluidHeld != null && tFluidHeld.amount <= 0) {
            tFluidHeld = null;
        }
        if (tInputFluid == null) {
            if (!aCanFill) {
                return null;
            }
            if (tFluidHeld == null) {
                return null;
            }
            if (this.canFillFilter != null && !this.canFillFilter.test(tFluidHeld.getFluid())) {
                return null;
            }
            return FluidDisplaySlotWidget.fillFluid(aFluidAccess, aPlayer, tFluidHeld, aProcessFullStack);
        }
        if (tFluidHeld != null && tInputFluid.amount < aFluidAccess.getCapacity()) {
            if (aCanFill) {
                return FluidDisplaySlotWidget.fillFluid(aFluidAccess, aPlayer, tFluidHeld, aProcessFullStack);
            }
            if (!aCanDrain) {
                return null;
            }
            return FluidDisplaySlotWidget.drainFluid(aFluidAccess, aPlayer, aProcessFullStack);
        }
        if (!aCanDrain) {
            return null;
        }
        return FluidDisplaySlotWidget.drainFluid(aFluidAccess, aPlayer, aProcessFullStack);
    }

    protected static ItemStack drainFluid(IFluidAccess aFluidAccess, EntityPlayer aPlayer, boolean aProcessFullStack) {
        IFluidContainerItem tContainerItem;
        int tFilledAmount;
        FluidStack tTankStack = aFluidAccess.get();
        if (tTankStack == null) {
            return null;
        }
        ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null || tStackHeld.field_77994_a == 0) {
            return null;
        }
        int tOriginalFluidAmount = tTankStack.amount;
        ItemStack tFilledContainer = GT_Utility.fillFluidContainer(tTankStack, tStackSizedOne, true, false);
        if (tFilledContainer == null && tStackSizedOne.func_77973_b() instanceof IFluidContainerItem && (tFilledAmount = (tContainerItem = (IFluidContainerItem)tStackSizedOne.func_77973_b()).fill(tStackSizedOne, tTankStack, true)) > 0) {
            tFilledContainer = tStackSizedOne;
            tTankStack.amount -= tFilledAmount;
        }
        if (tFilledContainer != null) {
            if (aProcessFullStack) {
                int tFilledAmount2 = tOriginalFluidAmount - tTankStack.amount;
                int tAdditionalParallel = Math.min(tStackHeld.field_77994_a - 1, tTankStack.amount / tFilledAmount2);
                tTankStack.amount -= tFilledAmount2 * tAdditionalParallel;
                tFilledContainer.field_77994_a += tAdditionalParallel;
            }
            FluidDisplaySlotWidget.replaceCursorItemStack(aPlayer, tFilledContainer);
        }
        aFluidAccess.verifyFluidStack();
        return tFilledContainer;
    }

    protected static ItemStack fillFluid(IFluidAccess aFluidAccess, EntityPlayer aPlayer, FluidStack aFluidHeld, boolean aProcessFullStack) {
        int tParallel;
        IFluidContainerItem container;
        FluidStack tDrained;
        if (aFluidAccess.get() != null && !aFluidAccess.get().isFluidEqual(aFluidHeld)) {
            return null;
        }
        ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null) {
            return null;
        }
        int tFreeSpace = aFluidAccess.getCapacity() - (aFluidAccess.get() != null ? aFluidAccess.get().amount : 0);
        if (tFreeSpace <= 0) {
            return null;
        }
        ItemStack tStackEmptied = null;
        int tAmountTaken = 0;
        if (tFreeSpace >= aFluidHeld.amount) {
            tStackEmptied = GT_Utility.getContainerForFilledItem(tStackSizedOne, false);
            tAmountTaken = aFluidHeld.amount;
        }
        if (tStackEmptied == null && tStackSizedOne.func_77973_b() instanceof IFluidContainerItem && (tDrained = (container = (IFluidContainerItem)tStackSizedOne.func_77973_b()).drain(tStackSizedOne, tFreeSpace, true)) != null && tDrained.amount > 0) {
            tStackEmptied = tStackSizedOne;
            tAmountTaken = tDrained.amount;
        }
        if (tStackEmptied == null) {
            return null;
        }
        int n = tParallel = aProcessFullStack ? Math.min(tFreeSpace / tAmountTaken, tStackHeld.field_77994_a) : 1;
        if (aFluidAccess.get() == null) {
            FluidStack tNewFillableStack = aFluidHeld.copy();
            tNewFillableStack.amount = tAmountTaken * tParallel;
            aFluidAccess.set(tNewFillableStack);
        } else {
            aFluidAccess.addAmount(tAmountTaken * tParallel);
        }
        tStackEmptied.field_77994_a = tParallel;
        FluidDisplaySlotWidget.replaceCursorItemStack(aPlayer, tStackEmptied);
        return tStackEmptied;
    }

    protected static void replaceCursorItemStack(EntityPlayer aPlayer, ItemStack tStackResult) {
        int tStackResultMaxStackSize = tStackResult.func_77976_d();
        while (tStackResult.field_77994_a > tStackResultMaxStackSize) {
            aPlayer.field_71071_by.func_70445_o().field_77994_a -= tStackResultMaxStackSize;
            GT_Utility.addItemToPlayerInventory(aPlayer, tStackResult.func_77979_a(tStackResultMaxStackSize));
        }
        if (aPlayer.field_71071_by.func_70445_o().field_77994_a == tStackResult.field_77994_a) {
            aPlayer.field_71071_by.func_70437_b(tStackResult);
        } else {
            ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
            tStackHeld.field_77994_a -= tStackResult.field_77994_a;
            GT_Utility.addItemToPlayerInventory(aPlayer, tStackResult);
        }
    }

    protected void executeDragAndDrop(Widget.ClickData clickData, ItemStack draggedStack) {
        if (this.actionDragAndDrop == Action.NONE || this.actionDragAndDrop == Action.TRANSFER) {
            return;
        }
        if (this.beforeDragAndDrop != null && !this.beforeDragAndDrop.apply(clickData, this).booleanValue()) {
            return;
        }
        if (this.actionDragAndDrop == Action.LOCK) {
            this.lockFluid(draggedStack);
        }
        this.updateFluidDisplayItem.run();
    }

    protected void lockFluid(ItemStack cursorStack) {
        if (!(this.iHasFluidDisplay instanceof IFluidLockable)) {
            return;
        }
        IFluidLockable mteToLock = (IFluidLockable)((Object)this.iHasFluidDisplay);
        if (cursorStack == null) {
            if (!mteToLock.allowChangingLockedFluid(null)) {
                return;
            }
            mteToLock.lockFluid(false);
            mteToLock.setLockedFluidName(null);
            GT_Utility.sendChatToPlayer(this.getContext().getPlayer(), GT_Utility.trans("300.1", "Fluid Lock Cleared."));
            if (!this.isClient()) {
                mteToLock.onFluidLockPacketReceived(null);
            }
        } else {
            FluidStack fluidStack = GT_Utility.getFluidFromContainerOrFluidDisplay(cursorStack);
            if (fluidStack == null) {
                return;
            }
            Fluid tFluid = fluidStack.getFluid();
            if (tFluid == null) {
                return;
            }
            if (!mteToLock.allowChangingLockedFluid(tFluid.getName())) {
                return;
            }
            mteToLock.lockFluid(true);
            mteToLock.setLockedFluidName(tFluid.getName());
            GT_Utility.sendChatToPlayer(this.getContext().getPlayer(), String.format(GT_Utility.trans("151.4", "Successfully locked Fluid to %s"), new FluidStack(tFluid, 1).getLocalizedName()));
            if (!this.isClient()) {
                mteToLock.onFluidLockPacketReceived(tFluid.getName());
            }
        }
    }

    protected void updateFluidDisplayItem() {
        if (this.iHasFluidDisplay != null) {
            this.iHasFluidDisplay.updateFluidDisplayItem();
        }
    }

    public FluidDisplaySlotWidget setFluidAccessConstructor(Supplier<IFluidAccess> fluidAccessConstructor) {
        this.fluidAccessConstructor = fluidAccessConstructor;
        return this;
    }

    public FluidDisplaySlotWidget setIHasFluidDisplay(IHasFluidDisplayItem iHasFluidDisplay) {
        this.iHasFluidDisplay = iHasFluidDisplay;
        return this;
    }

    public FluidDisplaySlotWidget setCanDrainGetter(Supplier<Boolean> canDrainGetter) {
        this.canDrainGetter = canDrainGetter;
        return this;
    }

    public FluidDisplaySlotWidget setCanDrain(boolean canDrain) {
        return this.setCanDrainGetter(() -> canDrain);
    }

    public FluidDisplaySlotWidget setCanFillGetter(Supplier<Boolean> canFillGetter) {
        this.canFillGetter = canFillGetter;
        return this;
    }

    public FluidDisplaySlotWidget setCanFill(boolean canFill) {
        return this.setCanFillGetter(() -> canFill);
    }

    public FluidDisplaySlotWidget setActionRealClick(Action actionRealClick) {
        this.actionRealClick = actionRealClick;
        return this;
    }

    public FluidDisplaySlotWidget setEmptyCanFillFilter(Predicate<Fluid> canFillFilter) {
        this.canFillFilter = canFillFilter;
        return this;
    }

    public FluidDisplaySlotWidget setActionDragAndDrop(Action actionDragAndDrop) {
        this.actionDragAndDrop = actionDragAndDrop;
        return this;
    }

    public FluidDisplaySlotWidget setBeforeRealClick(BiFunction<Widget.ClickData, FluidDisplaySlotWidget, Boolean> beforeRealClick) {
        this.beforeRealClick = beforeRealClick;
        return this;
    }

    public FluidDisplaySlotWidget setBeforeDragAndDrop(BiFunction<Widget.ClickData, FluidDisplaySlotWidget, Boolean> beforeDragAndDrop) {
        this.beforeDragAndDrop = beforeDragAndDrop;
        return this;
    }

    public FluidDisplaySlotWidget setBeforeClick(BiFunction<Widget.ClickData, FluidDisplaySlotWidget, Boolean> beforeClick) {
        this.setBeforeRealClick(beforeClick);
        this.setBeforeDragAndDrop(beforeClick);
        return this;
    }

    public FluidDisplaySlotWidget setUpdateFluidDisplayItem(Runnable updateFluidDisplayItem) {
        this.updateFluidDisplayItem = updateFluidDisplayItem;
        return this;
    }

    public static enum Action {
        TRANSFER,
        LOCK,
        FILTER,
        NONE;

    }
}

