/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.interfaces.IMultiBlockPart;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.multitileentity.multiblock.casing.InventoryUpgrade;
import gregtech.api.net.GT_Packet_New;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class GT_Packet_MultiTileEntity
extends GT_Packet_New {
    public static final int COVERS = GT_Values.B[0];
    public static final int REDSTONE = GT_Values.B[1];
    public static final int MODES = GT_Values.B[2];
    public static final int CONTROLLER = GT_Values.B[3];
    public static final int INVENTORY_INDEX = GT_Values.B[4];
    public static final int INVENTORY_NAME = GT_Values.B[5];
    private int features = 0;
    private int mX;
    private int mZ;
    private int mC0 = 0;
    private int mC1 = 0;
    private int mC2 = 0;
    private int mC3 = 0;
    private int mC4 = 0;
    private int mC5 = 0;
    private short mY;
    private short mID;
    private short mRID;
    private byte mCommonData;
    private byte mTexturePage;
    private byte mUpdate;
    private byte mRedstone;
    private byte mColor;
    private ChunkCoordinates mTargetPos = null;
    private int mLockedInventoryIndex;
    private String mInventoryName;
    private int mInventoryLength;
    private byte mMode;
    private int mAllowedModes;

    public GT_Packet_MultiTileEntity() {
        super(true);
    }

    public GT_Packet_MultiTileEntity(int aFeatures, int aX, short aY, int aZ, short aRID, short aID, byte aCommonData, byte aColor) {
        super(false);
        this.features = aFeatures;
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mRID = aRID;
        this.mID = aID;
        this.mCommonData = aCommonData;
        this.mColor = aColor;
    }

    public void setCoverData(int aC0, int aC1, int aC2, int aC3, int aC4, int aC5) {
        this.features |= COVERS;
        this.mC0 = aC0;
        this.mC1 = aC1;
        this.mC2 = aC2;
        this.mC3 = aC3;
        this.mC4 = aC4;
        this.mC5 = aC5;
    }

    public void setRedstoneData(byte aRedstoneData) {
        this.features |= REDSTONE;
        this.mRedstone = aRedstoneData;
    }

    public void setModes(byte aMode, int aAllowedModes) {
        this.features |= MODES;
        this.mMode = aMode;
        this.mAllowedModes = aAllowedModes;
    }

    public void setTargetPos(int aX, short aY, int aZ) {
        this.features |= CONTROLLER;
        this.mTargetPos = new ChunkCoordinates(aX, (int)aY, aZ);
    }

    public void setInventoryIndex(int aInventoryIndex) {
        this.features |= INVENTORY_INDEX;
        this.mLockedInventoryIndex = aInventoryIndex;
    }

    public void setInventoryName(String aInventoryName) {
        this.features |= INVENTORY_NAME;
        this.mInventoryName = aInventoryName;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.features);
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeShort((int)this.mRID);
        aOut.writeShort((int)this.mID);
        aOut.writeByte((int)this.mCommonData);
        aOut.writeByte((int)this.mColor);
        if ((this.features & COVERS) == COVERS) {
            aOut.writeInt(this.mC0);
            aOut.writeInt(this.mC1);
            aOut.writeInt(this.mC2);
            aOut.writeInt(this.mC3);
            aOut.writeInt(this.mC4);
            aOut.writeInt(this.mC5);
        }
        if ((this.features & REDSTONE) == REDSTONE) {
            aOut.writeByte((int)this.mRedstone);
        }
        if ((this.features & MODES) == MODES) {
            aOut.writeByte((int)this.mMode);
            aOut.writeInt(this.mAllowedModes);
        }
        if ((this.features & CONTROLLER) == CONTROLLER) {
            aOut.writeInt(this.mTargetPos.field_71574_a);
            aOut.writeShort(this.mTargetPos.field_71572_b);
            aOut.writeInt(this.mTargetPos.field_71573_c);
        }
        if ((this.features & INVENTORY_INDEX) == INVENTORY_INDEX) {
            aOut.writeInt(this.mLockedInventoryIndex);
        }
        if ((this.features & INVENTORY_NAME) == INVENTORY_NAME) {
            if (this.mInventoryName != null && this.mInventoryName.length() > 0) {
                this.mInventoryLength = this.mInventoryName.length();
                aOut.writeInt(this.mInventoryLength);
                for (char tChar : this.mInventoryName.toCharArray()) {
                    aOut.writeChar((int)tChar);
                }
            } else {
                this.mInventoryLength = 0;
                aOut.writeInt(this.mInventoryLength);
            }
        }
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        int packetFeatures = aData.readInt();
        GT_Packet_MultiTileEntity packet = new GT_Packet_MultiTileEntity(packetFeatures, aData.readInt(), aData.readShort(), aData.readInt(), aData.readShort(), aData.readShort(), aData.readByte(), aData.readByte());
        if ((packetFeatures & COVERS) == COVERS) {
            packet.setCoverData(aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
        }
        if ((packetFeatures & REDSTONE) == REDSTONE) {
            packet.setRedstoneData(aData.readByte());
        }
        if ((packetFeatures & MODES) == MODES) {
            packet.setModes(aData.readByte(), aData.readInt());
        }
        if ((packetFeatures & CONTROLLER) == CONTROLLER) {
            packet.setTargetPos(aData.readInt(), aData.readShort(), aData.readInt());
        }
        if ((packetFeatures & INVENTORY_INDEX) == INVENTORY_INDEX) {
            packet.setInventoryIndex(aData.readInt());
        }
        if ((packetFeatures & INVENTORY_NAME) == INVENTORY_NAME) {
            int tLength = aData.readInt();
            String tName = "";
            if (tLength > 0) {
                for (int i = 0; i < tLength; ++i) {
                    tName = tName + aData.readChar();
                }
            } else {
                tName = null;
            }
            packet.setInventoryName(tName);
        }
        return packet;
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (aWorld == null) {
            return;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(this.mX, (int)this.mY, this.mZ);
        try {
            Block tBlock = aWorld.func_147439_a(this.mX, (int)this.mY, this.mZ);
            if (tBlock instanceof MultiTileEntityBlock) {
                IMultiBlockPart mtePart;
                MultiTileEntityBlock mteBlock = (MultiTileEntityBlock)tBlock;
                IMultiTileEntity mte = mteBlock.receiveMultiTileEntityData(aWorld, this.mX, this.mY, this.mZ, this.mRID, this.mID);
                if (mte == null) {
                    return;
                }
                mte.receiveClientEvent(0, this.mCommonData);
                mte.receiveClientEvent(2, this.mColor);
                if ((this.features & COVERS) == COVERS) {
                    mteBlock.receiveCoverData(mte, this.mC0, this.mC1, this.mC2, this.mC3, this.mC4, this.mC5);
                }
                if ((this.features & REDSTONE) == REDSTONE) {
                    mte.receiveClientEvent(3, this.mRedstone);
                }
                if ((this.features & MODES) == MODES && mte instanceof IMultiTileEntity.IMTE_HasModes) {
                    IMultiTileEntity.IMTE_HasModes mteModes = (IMultiTileEntity.IMTE_HasModes)mte;
                    mteModes.setMode(this.mMode);
                    mteModes.setAllowedModes(this.mAllowedModes);
                }
                if ((this.features & CONTROLLER) == CONTROLLER && mte instanceof IMultiBlockPart) {
                    mtePart = (IMultiBlockPart)mte;
                    mtePart.setTargetPos(this.mTargetPos);
                }
                if ((this.features & INVENTORY_INDEX) == INVENTORY_INDEX && mte instanceof IMultiBlockPart) {
                    mtePart = (IMultiBlockPart)mte;
                    mtePart.setLockedInventoryIndex(this.mLockedInventoryIndex);
                }
                if ((this.features & INVENTORY_NAME) == INVENTORY_NAME && mte instanceof InventoryUpgrade) {
                    InventoryUpgrade invUpg = (InventoryUpgrade)mte;
                    invUpg.setInventoryName(this.mInventoryName);
                }
            }
        }
        catch (Exception e) {
            GT_Mod.GT_FML_LOGGER.error("Exception setting tile entity data for tile entity {} at ({}, {}, {})", new Object[]{tTileEntity, this.mX, this.mY, this.mZ});
        }
    }

    @Override
    public byte getPacketID() {
        return 18;
    }
}

