/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.interfaces.IBlockContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.LightingHelper;
import gregtech.common.render.GT_TextureBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_CopiedBlockTexture
extends GT_TextureBase
implements ITexture,
IBlockContainer {
    private final Block mBlock;
    private final byte mSide;
    private final byte mMeta;

    protected GT_CopiedBlockTexture(Block aBlock, int aSide, int aMeta, short[] aRGBa, boolean allowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_CopiedBlockTexture");
        }
        this.mBlock = aBlock;
        this.mSide = (byte)aSide;
        this.mMeta = (byte)aMeta;
    }

    @Override
    public boolean isOldTexture() {
        return false;
    }

    private IIcon getIcon(int aSide) {
        if (this.mSide == 6) {
            return this.mBlock.func_149691_a(aSide, (int)this.mMeta);
        }
        return this.mBlock.func_149691_a((int)this.mSide, (int)this.mMeta);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(ForgeDirection.EAST.ordinal());
        aRenderer.field_152631_f = true;
        this.startDrawingQuads(aRenderer, 1.0f, 0.0f, 0.0f);
        new LightingHelper(aRenderer).setupLightingXPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.EAST.ordinal(), 0xFFFFFF);
        aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
        aRenderer.field_152631_f = false;
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, -1.0f, 0.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.WEST.ordinal());
        new LightingHelper(aRenderer).setupLightingXNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.WEST.ordinal(), 0xFFFFFF);
        aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.UP.ordinal());
        new LightingHelper(aRenderer).setupLightingYPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.UP.ordinal(), 0xFFFFFF);
        aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, -1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.DOWN.ordinal());
        new LightingHelper(aRenderer).setupLightingYNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.DOWN.ordinal(), 0xFFFFFF);
        aRenderer.func_147768_a(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 0.0f, 1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.SOUTH.ordinal());
        new LightingHelper(aRenderer).setupLightingZPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.SOUTH.ordinal(), 0xFFFFFF);
        aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 0.0f, -1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.NORTH.ordinal());
        aRenderer.field_152631_f = true;
        new LightingHelper(aRenderer).setupLightingZNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.NORTH.ordinal(), 0xFFFFFF);
        aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
        aRenderer.field_152631_f = false;
    }

    @Override
    public boolean isValidTexture() {
        return this.mBlock != null;
    }

    @Override
    public Block getBlock() {
        return this.mBlock;
    }

    @Override
    public byte getMeta() {
        return this.mMeta;
    }
}

