/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_None;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Behaviour_Spray_Color
extends Behaviour_None {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final byte mColor;
    private final Collection<Block> mAllowedVanillaBlocks = Arrays.asList(Blocks.field_150359_w, Blocks.field_150410_aZ, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150404_cg, Blocks.field_150405_ch, ItemList.TE_Rockwool.getBlock());
    private final String mTooltip;
    private final String mTooltipUses = GT_LanguageManager.addStringLocalization("gt.behaviour.paintspray.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = GT_LanguageManager.addStringLocalization("gt.behaviour.unstackable", "Not usable when stacked!");

    public Behaviour_Spray_Color(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses, int aColor) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses;
        this.mColor = (byte)aColor;
        this.mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.paintspray." + this.mColor + ".tooltip", "Can Color things in " + Dyes.get((int)this.mColor).mName);
    }

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K || aStack.field_77994_a != 1) {
            return false;
        }
        boolean rOutput = false;
        if (!aPlayer.func_82247_a(aX, aY, aZ, aSide, aStack)) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        long tUses = tNBT.func_74763_f("GT.RemainingPaint");
        if (GT_Utility.areStacksEqual(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(this.mUsed));
            tUses = this.mUses;
        }
        if (GT_Utility.areStacksEqual(aStack, this.mUsed, true) && this.colorize(aWorld, aX, aY, aZ, aSide)) {
            GT_Utility.sendSoundToPlayers(aWorld, SoundResource.IC2_TOOLS_PAINTER, 1.0f, 1.0f, aX, aY, aZ);
            if (!aPlayer.field_71075_bZ.field_75098_d) {
                --tUses;
            }
            rOutput = true;
        }
        tNBT.func_82580_o("GT.RemainingPaint");
        if (tUses > 0L) {
            tNBT.func_74772_a("GT.RemainingPaint", tUses);
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(this.mEmpty));
            }
        }
        return rOutput;
    }

    private boolean colorize(World aWorld, int aX, int aY, int aZ, int aSide) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock != Blocks.field_150350_a && (this.mAllowedVanillaBlocks.contains(aBlock) || aBlock instanceof BlockColored)) {
            if (aBlock == Blocks.field_150405_ch) {
                aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150406_ce, ~this.mColor & 0xF, 3);
                return true;
            }
            if (aBlock == Blocks.field_150410_aZ) {
                aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150397_co, ~this.mColor & 0xF, 3);
                return true;
            }
            if (aBlock == Blocks.field_150359_w) {
                aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150399_cn, ~this.mColor & 0xF, 3);
                return true;
            }
            if (aWorld.func_72805_g(aX, aY, aZ) == (~this.mColor & 0xF)) {
                return false;
            }
            aWorld.func_72921_c(aX, aY, aZ, ~this.mColor & 0xF, 3);
            return true;
        }
        return aBlock.recolourBlock(aWorld, aX, aY, aZ, ForgeDirection.getOrientation((int)aSide), ~this.mColor & 0xF);
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemainingPaint = tNBT == null ? this.mUses : (GT_Utility.areStacksEqual(aStack, this.mFull, true) ? this.mUses : tNBT.func_74763_f("GT.RemainingPaint"));
        aList.add(this.mTooltipUses + " " + tRemainingPaint);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

