/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.fluid;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.FluidState;
import gregtech.api.interfaces.fluid.IGT_Fluid;
import gregtech.api.interfaces.fluid.IGT_FluidBuilder;
import gregtech.api.interfaces.fluid.IGT_RegisteredFluid;
import gregtech.common.fluid.GT_Fluid;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public class GT_FluidBuilder
implements IGT_FluidBuilder {
    final String fluidName;
    String localizedName;
    ResourceLocation stillIconResourceLocation = null;
    ResourceLocation flowingIconResourceLocation = null;
    short[] colorRGBA = Dyes._NULL.getRGBA();
    Block fluidBlock = null;
    FluidState fluidState;
    int temperature;
    IIcon stillIcon;
    IIcon flowingIcon;
    Fluid iconsFrom;

    public GT_FluidBuilder(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public IGT_FluidBuilder withColorRGBA(short[] colorRGBA) {
        this.colorRGBA = colorRGBA;
        return this;
    }

    @Override
    public IGT_FluidBuilder withLocalizedName(String localizedName) {
        this.localizedName = localizedName;
        return this;
    }

    @Override
    public IGT_FluidBuilder withStateAndTemperature(FluidState fluidState, int temperature) {
        this.fluidState = fluidState;
        this.temperature = temperature;
        return this;
    }

    @Override
    public IGT_FluidBuilder withStillIconResourceLocation(ResourceLocation stillIconResourceLocation) {
        this.stillIconResourceLocation = stillIconResourceLocation;
        return this;
    }

    @Override
    public IGT_FluidBuilder withFlowingIconResourceLocation(ResourceLocation flowingIconResourceLocation) {
        this.flowingIconResourceLocation = flowingIconResourceLocation;
        return this;
    }

    @Override
    public IGT_FluidBuilder withTextureName(String textureName) {
        this.stillIconResourceLocation = new ResourceLocation("gregtech", "fluids/fluid." + textureName);
        this.flowingIconResourceLocation = null;
        return this;
    }

    @Override
    public IGT_FluidBuilder withIconsFrom(@Nonnull Fluid fromFluid) {
        this.iconsFrom = fromFluid;
        return this;
    }

    @Override
    public IGT_FluidBuilder withFluidBlock(Block fluidBlock) {
        this.fluidBlock = fluidBlock;
        return this;
    }

    @Override
    public IGT_FluidBuilder withTextures(ResourceLocation stillIconResourceLocation, ResourceLocation flowingIconResourceLocation) {
        this.stillIconResourceLocation = stillIconResourceLocation;
        this.flowingIconResourceLocation = flowingIconResourceLocation;
        return this;
    }

    @Override
    public IGT_Fluid build() {
        if (this.colorRGBA == null) {
            this.colorRGBA = Dyes._NULL.getRGBA();
        }
        if (this.stillIconResourceLocation == null) {
            this.withTextureName(this.fluidName.toLowerCase(Locale.ENGLISH));
        }
        if (this.localizedName == null) {
            this.localizedName = this.fluidName;
        }
        return new GT_Fluid(this);
    }

    @Override
    public IGT_RegisteredFluid buildAndRegister() {
        return this.build().addFluid();
    }
}

