/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_Vent
extends GT_CoverBehavior {
    private final int mEfficiency;
    private final Fluid IC2_HOT_COOLANT = FluidRegistry.getFluid((String)"ic2hotcoolant");
    private final Fluid IC2_COOLANT = FluidRegistry.getFluid((String)"ic2coolant");

    public GT_Cover_Vent(int aEfficiency) {
        this.mEfficiency = aEfficiency;
    }

    @Override
    public boolean isRedstoneSensitive(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aSide == 6) {
            return 0;
        }
        int ret = 0;
        if (aTileEntity instanceof IFluidHandler) {
            ret = this.doCoolFluid(aSide, aTileEntity);
        }
        if (aTileEntity instanceof IMachineProgress) {
            ret = this.doProgressEfficiency(aSide, (IMachineProgress)((Object)aTileEntity), aCoverID);
        }
        return ret;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 100;
    }

    protected int doProgressEfficiency(byte aSide, IMachineProgress aTileEntity, int aCoverVariable) {
        int offsetX = aTileEntity.getOffsetX(aSide, 1);
        short offsetY = aTileEntity.getOffsetY(aSide, 1);
        int offsetZ = aTileEntity.getOffsetZ(aSide, 1);
        World world = aTileEntity.getWorld();
        if (aTileEntity.hasThingsToDo() && aCoverVariable != aTileEntity.getProgress() && !GT_Utility.hasBlockHitBox(world, offsetX, offsetY, offsetZ)) {
            aTileEntity.increaseProgress(this.mEfficiency);
        }
        return aTileEntity.getProgress();
    }

    protected int doCoolFluid(byte aSide, ICoverable aTileEntity) {
        int chances;
        IFluidHandler fluidHandler;
        block12: {
            block13: {
                Block blockAtSide;
                World world;
                int offsetZ;
                short offsetY;
                int offsetX;
                block11: {
                    offsetX = aTileEntity.getOffsetX(aSide, 1);
                    offsetY = aTileEntity.getOffsetY(aSide, 1);
                    offsetZ = aTileEntity.getOffsetZ(aSide, 1);
                    world = aTileEntity.getWorld();
                    fluidHandler = (IFluidHandler)aTileEntity;
                    if (!fluidHandler.canDrain(ForgeDirection.UNKNOWN, this.IC2_HOT_COOLANT)) {
                        return 0;
                    }
                    blockAtSide = aTileEntity.getBlockAtSide(aSide);
                    if (blockAtSide == null) {
                        return 0;
                    }
                    if (blockAtSide != Blocks.field_150355_j && blockAtSide != Blocks.field_150358_i) break block11;
                    switch (this.mEfficiency) {
                        case 2: {
                            chances = 10000;
                            break;
                        }
                        case 1: {
                            chances = 5000;
                            break;
                        }
                        default: {
                            chances = 2500;
                            break;
                        }
                    }
                    break block12;
                }
                if (!blockAtSide.isAir((IBlockAccess)world, offsetX, (int)offsetY, offsetZ)) break block13;
                switch (this.mEfficiency) {
                    case 2: {
                        chances = 2500;
                        break block12;
                    }
                    case 1: {
                        chances = 1250;
                        break block12;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            return 0;
        }
        if (chances > XSTR.XSTR_INSTANCE.nextInt(10000)) {
            FluidStack hotFluidStack = fluidHandler.drain(ForgeDirection.UNKNOWN, Integer.MAX_VALUE, true);
            FluidStack coldFluidStack = new FluidStack(this.IC2_COOLANT, hotFluidStack.amount);
            fluidHandler.fill(ForgeDirection.UNKNOWN, coldFluidStack, true);
            return hotFluidStack.amount;
        }
        return 0;
    }
}

