/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.common.covers.CoverInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GT_Packet_RequestCoverData
extends GT_Packet_New {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected byte side;
    protected int coverID;
    protected EntityPlayerMP mPlayer;

    public GT_Packet_RequestCoverData() {
        super(true);
    }

    public GT_Packet_RequestCoverData(CoverInfo info, ICoverable tile) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = info.getSide();
        this.coverID = info.getCoverID();
    }

    public GT_Packet_RequestCoverData(int mX, short mY, int mZ, byte coverSide, int coverID) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
    }

    public GT_Packet_RequestCoverData(byte coverSide, int coverID, ICoverable tile) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
    }

    @Override
    public byte getPacketID() {
        return 17;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeByte((int)this.side);
        aOut.writeInt(this.coverID);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new GT_Packet_RequestCoverData(aData.readInt(), aData.readShort(), aData.readInt(), aData.readByte(), aData.readInt());
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        if (aHandler instanceof NetHandlerPlayServer) {
            this.mPlayer = ((NetHandlerPlayServer)aHandler).field_147369_b;
        }
    }

    @Override
    public void process(IBlockAccess aWorld) {
        CoverableTileEntity te;
        TileEntity tile;
        if (this.mPlayer == null) {
            return;
        }
        WorldServer world = DimensionManager.getWorld((int)this.mPlayer.field_71093_bK);
        if (world != null && (tile = world.func_147438_o(this.mX, (int)this.mY, this.mZ)) instanceof CoverableTileEntity && !(te = (CoverableTileEntity)tile).isDead() && te.getCoverIDAtSide(this.side) == this.coverID) {
            te.issueCoverUpdate(this.side);
        }
    }
}

