/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.forge.ListItemHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TabButton;
import com.gtnewhorizons.modularui.common.widget.TabContainer;
import cpw.mods.fml.common.network.NetworkRegistry;
import gnu.trove.list.array.TIntArrayList;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.fluid.FluidTankGT;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IDescribable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.multitileentity.MultiTileEntityContainer;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiBlockFluidHandler;
import gregtech.api.multitileentity.interfaces.IMultiBlockInventory;
import gregtech.api.multitileentity.interfaces.IMultiBlockPart;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.multitileentity.machine.MultiTileBasicMachine;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.multitileentity.multiblock.casing.AdvancedCasing;
import gregtech.api.multitileentity.multiblock.casing.InventoryUpgrade;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public abstract class MultiBlockController<T extends MultiBlockController<T>>
extends MultiTileBasicMachine
implements IAlignment,
IConstructable,
IMultiBlockController,
IDescribable,
IMachineProgress,
IMultiBlockFluidHandler,
IMultiBlockInventory,
IMultiTileEntity.IMTE_AddToolTips {
    private static final int TICKS_BETWEEN_RECIPE_CHECKS = 100;
    private static final Map<Integer, GT_Multiblock_Tooltip_Builder> tooltip = new ConcurrentHashMap<Integer, GT_Multiblock_Tooltip_Builder>();
    private final List<AdvancedCasing> mUpgradeCasings = new ArrayList<AdvancedCasing>();
    protected BuildState buildState = new BuildState();
    protected Map<String, String> multiBlockInputInventoryNames = new LinkedHashMap<String, String>();
    protected Map<String, String> multiBlockOutputInventoryNames = new LinkedHashMap<String, String>();
    protected Map<String, IItemHandlerModifiable> multiBlockInputInventory = new LinkedHashMap<String, IItemHandlerModifiable>();
    protected Map<String, IItemHandlerModifiable> multiBlockOutputInventory = new LinkedHashMap<String, IItemHandlerModifiable>();
    protected int mMaxProgressTime = 0;
    private int mProgressTime = 0;
    private boolean mStructureOkay = false;
    private boolean mStructureChanged = false;
    private boolean mWorks = true;
    private boolean mWorkUpdate = false;
    private boolean mWasShutdown = false;
    private boolean mActive = false;
    private boolean mSeparateInputs = true;
    private ExtendedFacing mExtendedFacing = ExtendedFacing.DEFAULT;
    private IAlignmentLimits mLimits = this.getInitialAlignmentLimits();
    private ItemStack[] mItemsToOutput;
    private String mInventory;
    protected List<LinkedList<WeakReference<IMultiBlockPart>>> registeredCoveredParts = Arrays.asList(new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList());

    public abstract short getCasingRegistryID();

    public abstract short getCasingMeta();

    protected abstract GT_Multiblock_Tooltip_Builder createTooltip();

    public abstract Vec3Impl getStartingStructureOffset();

    public abstract IStructureDefinition<T> getStructureDefinition();

    public abstract boolean checkMachine();

    public abstract boolean checkRecipe(ItemStack var1);

    @Override
    public void writeMultiTileNBT(NBTTagCompound aNBT) {
        super.writeMultiTileNBT(aNBT);
        aNBT.func_74757_a("gt.structure.ok", this.mStructureOkay);
        aNBT.func_74774_a("gt.eRotation", (byte)this.mExtendedFacing.getRotation().getIndex());
        aNBT.func_74774_a("gt.eFlip", (byte)this.mExtendedFacing.getFlip().getIndex());
        this.saveUpgradeInventoriesToNBT(aNBT);
        this.saveItemsToOutput(aNBT);
    }

    private void saveUpgradeInventoriesToNBT(NBTTagCompound aNBT) {
        NBTTagList tListInputInvs = new NBTTagList();
        this.multiBlockInputInventory.forEach((tID, tInv) -> {
            if (!tID.equals("controller")) {
                NBTTagCompound tTag = new NBTTagCompound();
                tTag.func_74778_a("gt.invuuid.upg", tID);
                tTag.func_74778_a("gt.invname.upg", this.multiBlockInputInventoryNames.get(tID));
                tTag.func_74768_a("gt.invsize.upg", tInv.getSlots());
                this.writeInventory(tTag, (IItemHandlerModifiable)tInv, "gt.invlist.in");
                tListInputInvs.func_74742_a((NBTBase)tTag);
            }
        });
        NBTTagList tListOutputInvs = new NBTTagList();
        this.multiBlockOutputInventory.forEach((tID, tInv) -> {
            if (!tID.equals("controller")) {
                NBTTagCompound tTag = new NBTTagCompound();
                tTag.func_74778_a("gt.invuuid.upg", tID);
                tTag.func_74778_a("gt.invname.upg", this.multiBlockOutputInventoryNames.get(tID));
                tTag.func_74768_a("gt.invsize.upg", tInv.getSlots());
                this.writeInventory(tTag, (IItemHandlerModifiable)tInv, "gt.invlist.out");
                tListOutputInvs.func_74742_a((NBTBase)tTag);
            }
        });
        aNBT.func_74782_a("gt.invlist.upg.in", (NBTBase)tListInputInvs);
        aNBT.func_74782_a("gt.invlist.upg.out", (NBTBase)tListOutputInvs);
    }

    private void saveItemsToOutput(NBTTagCompound aNBT) {
        NBTTagList tList = new NBTTagList();
        for (int tSlot = 0; tSlot < this.mItemsToOutput.length; ++tSlot) {
            ItemStack tStack = this.mItemsToOutput[tSlot];
            if (tStack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("s", (byte)tSlot);
            tStack.func_77955_b(tag);
            tList.func_74742_a((NBTBase)tag);
        }
        aNBT.func_74782_a("gt,itemout", (NBTBase)tList);
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        super.readMultiTileNBT(aNBT);
        if (this.mInputInventory != null) {
            this.multiBlockInputInventory.put("controller", this.mInputInventory);
        }
        if (this.mOutputInventory != null) {
            this.multiBlockOutputInventory.put("controller", this.mOutputInventory);
        }
        this.mStructureOkay = aNBT.func_74767_n("gt.structure.ok");
        this.mExtendedFacing = ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)this.getFrontFacing()), (Rotation)Rotation.byIndex((int)aNBT.func_74771_c("gt.eRotation")), (Flip)Flip.byIndex((int)aNBT.func_74771_c("gt.eFlip")));
        this.loadUpgradeInventoriesFromNBT(aNBT);
        this.loadItemsToOutput(aNBT);
    }

    private void loadUpgradeInventoriesFromNBT(NBTTagCompound aNBT) {
        NBTTagList tListInput = aNBT.func_150295_c("gt.invlist.upg.in", 10);
        for (int i = 0; i < tListInput.func_74745_c(); ++i) {
            NBTTagCompound tNBT = tListInput.func_150305_b(i);
            String invUUID = tNBT.func_74779_i("gt.invuuid.upg");
            String invName = tNBT.func_74779_i("gt.invname.upg");
            int tInvSize = tNBT.func_74762_e("gt.invsize.upg");
            ItemStackHandler tInv = new ItemStackHandler(tInvSize);
            this.loadInventory(tNBT, (IItemHandlerModifiable)tInv, "gt.invlist.in");
            this.multiBlockInputInventory.put(invUUID, (IItemHandlerModifiable)tInv);
            this.multiBlockInputInventoryNames.put(invUUID, invName);
        }
        NBTTagList tListOutput = aNBT.func_150295_c("gt.invlist.upg.out", 10);
        for (int i = 0; i < tListOutput.func_74745_c(); ++i) {
            NBTTagCompound tNBT = tListOutput.func_150305_b(i);
            String invUUID = tNBT.func_74779_i("gt.invuuid.upg");
            String invName = tNBT.func_74779_i("gt.invname.upg");
            int tInvSize = tNBT.func_74762_e("gt.invsize.upg");
            ItemStackHandler tInv = new ItemStackHandler(tInvSize);
            this.loadInventory(tNBT, (IItemHandlerModifiable)tInv, "gt.invlist.out");
            this.multiBlockOutputInventory.put(invUUID, (IItemHandlerModifiable)tInv);
            this.multiBlockOutputInventoryNames.put(invUUID, invName);
        }
    }

    private void loadItemsToOutput(NBTTagCompound aNBT) {
        NBTTagList tList = aNBT.func_150295_c("gt,itemout", 10);
        this.mItemsToOutput = new ItemStack[tList.func_74745_c()];
        for (int i = 0; i < tList.func_74745_c(); ++i) {
            NBTTagCompound tNBT = tList.func_150305_b(i);
            byte tSlot = tNBT.func_74771_c("s");
            if (tSlot < 0 || tSlot >= this.mItemsToOutput.length) continue;
            this.mItemsToOutput[tSlot] = GT_Utility.loadItem(tNBT);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.addAll(Arrays.asList(this.getDescription()));
    }

    @Override
    public String[] getDescription() {
        if (Keyboard.isKeyDown((int)42)) {
            return this.getTooltip().getStructureInformation();
        }
        return this.getTooltip().getInformation();
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        tList.add("Structure ok: " + this.checkStructure(false));
    }

    protected int getToolTipID() {
        return this.getMultiTileEntityRegistryID() << 16 + this.getMultiTileEntityID();
    }

    protected GT_Multiblock_Tooltip_Builder getTooltip() {
        return this.createTooltip();
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (!this.isServerSide()) {
            return this.mStructureOkay;
        }
        if (this.mStructureChanged || aForceReset) {
            this.mStructureOkay = this.checkMachine();
        }
        this.mStructureChanged = false;
        return this.mStructureOkay;
    }

    @Override
    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    public final boolean checkPiece(String piece, Vec3Impl offset) {
        return this.checkPiece(piece, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean checkPiece(String piece, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().check((Object)this, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, !this.mStructureOkay);
    }

    public final boolean buildPiece(String piece, ItemStack trigger, boolean hintsOnly, Vec3Impl offset) {
        return this.buildPiece(piece, trigger, hintsOnly, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean buildPiece(String piece, ItemStack trigger, boolean hintOnly, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().buildOrHints((Object)this, trigger, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, hintOnly);
    }

    private IStructureDefinition<MultiBlockController<T>> getCastedStructureDefinition() {
        return this.getStructureDefinition();
    }

    public ExtendedFacing getExtendedFacing() {
        return this.mExtendedFacing;
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        if (this.mExtendedFacing != newExtendedFacing) {
            this.onStructureChange();
            if (this.mStructureOkay) {
                this.stopMachine();
            }
            this.mExtendedFacing = newExtendedFacing;
            this.mStructureOkay = false;
            if (this.isServerSide()) {
                StructureLibAPI.sendAlignment((IAlignmentProvider)this, (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.field_76574_g, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord(), 512.0));
            } else {
                this.issueTextureUpdate();
            }
        }
    }

    @Override
    public boolean onWrenchRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        if (wrenchSide != this.getFrontFacing()) {
            return super.onWrenchRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
        }
        if (aPlayer.func_70093_af()) {
            this.toolSetFlip(this.getFlip().isHorizontallyFlipped() ? Flip.NONE : Flip.HORIZONTAL);
        } else {
            this.toolSetRotation(null);
        }
        return true;
    }

    @Override
    public void registerCoveredPartOnSide(int aSide, IMultiBlockPart part) {
        if (aSide < 0 || aSide >= 6) {
            return;
        }
        LinkedList<WeakReference<IMultiBlockPart>> registeredCovers = this.registeredCoveredParts.get(aSide);
        registeredCovers.add(new WeakReference<IMultiBlockPart>(part));
    }

    @Override
    public void unregisterCoveredPartOnSide(int aSide, IMultiBlockPart aPart) {
        if (aSide < 0 || aSide >= 6) {
            return;
        }
        LinkedList<WeakReference<IMultiBlockPart>> coveredParts = this.registeredCoveredParts.get(aSide);
        Iterator it = coveredParts.iterator();
        while (it.hasNext()) {
            IMultiBlockPart part = (IMultiBlockPart)((WeakReference)it.next()).get();
            if (part != null && part != aPart) continue;
            it.remove();
        }
    }

    @Override
    public void onFirstTick(boolean aIsServerSide) {
        super.onFirstTick(aIsServerSide);
        if (aIsServerSide) {
            this.checkStructure(true);
        } else {
            StructureLibAPI.queryAlignment((IAlignmentProvider)this);
        }
    }

    private boolean tickCovers() {
        for (byte side : GT_Values.ALL_VALID_SIDES) {
            LinkedList<WeakReference<IMultiBlockPart>> coveredParts = this.registeredCoveredParts.get(side);
            Iterator it = coveredParts.iterator();
            while (it.hasNext()) {
                IMultiBlockPart part = (IMultiBlockPart)((WeakReference)it.next()).get();
                if (part == null) {
                    it.remove();
                    continue;
                }
                if (part.tickCoverAtSide(side, this.mTickTimer)) continue;
                it.remove();
            }
        }
        return true;
    }

    @Override
    public void onTick(long aTimer, boolean isServerSide) {
        if (!this.tickCovers()) {
            return;
        }
    }

    @Override
    public void onPostTick(long aTick, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (aTick % 600L == 5L) {
                this.clearSpecialLists();
                if (!this.checkStructure(false)) {
                    this.checkStructure(true);
                }
            }
            if (this.mStructureOkay) {
                this.runMachine(aTick);
            } else {
                this.stopMachine();
            }
        }
    }

    protected void runMachine(long aTick) {
        if (this.mMaxProgressTime > 0) {
            this.func_70296_d();
            if (this.mMaxProgressTime > 0 && ++this.mProgressTime >= this.mMaxProgressTime) {
                this.mProgressTime = 0;
                this.mMaxProgressTime = 0;
                this.outputItems();
                if (this.isAllowedToWork()) {
                    this.checkRecipe();
                }
            }
        } else if ((aTick % 100L == 0L || this.hasWorkJustBeenEnabled() || this.hasInventoryBeenModified()) && this.isAllowedToWork() && this.checkRecipe()) {
            this.func_70296_d();
        }
    }

    protected boolean checkRecipe() {
        return this.checkRecipe(null);
    }

    protected void clearSpecialLists() {
        this.mUpgradeCasings.clear();
    }

    @Override
    public final boolean isFacingValid(byte aFacing) {
        return this.canSetToDirectionAny(ForgeDirection.getOrientation((int)aFacing));
    }

    @Override
    public void onFacingChange() {
        this.toolSetDirection(ForgeDirection.getOrientation((int)this.getFrontFacing()));
        this.onStructureChange();
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return aSide != this.mFacing;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }

    public IAlignmentLimits getAlignmentLimits() {
        return this.mLimits;
    }

    protected void setAlignmentLimits(IAlignmentLimits mLimits) {
        this.mLimits = mLimits;
    }

    @Override
    public int getProgress() {
        return this.mProgressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.mMaxProgressTime;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.increaseProgressGetOverflow(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public FluidStack getDrainableFluid(byte aSide) {
        IFluidTank tank = this.getFluidTankDrainable(aSide, null);
        return tank == null ? null : tank.getFluid();
    }

    public int increaseProgressGetOverflow(int aProgress) {
        return 0;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
        this.mWasShutdown = false;
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean isActive() {
        return this.mActive;
    }

    @Override
    public void setActive(boolean aActive) {
        this.mActive = aActive;
    }

    public boolean isSeparateInputs() {
        return this.mSeparateInputs;
    }

    public void setSeparateInputs(boolean aSeparateInputs) {
        this.mSeparateInputs = aSeparateInputs;
    }

    @Override
    public boolean wasShutdown() {
        return this.mWasShutdown;
    }

    public void stopMachine() {
        this.disableWorking();
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !f.isVerticallyFliped();
    }

    public <S> IStructureElement<S> addMultiTileCasing(final int aRegistryID, final int aBlockMeta, final int aModes) {
        return new IStructureElement<S>(){
            private final short[] DEFAULT = new short[]{255, 255, 255, 0};
            private IIcon[] mIcons = null;

            public boolean check(S t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof MultiBlockPart)) {
                    return false;
                }
                MultiBlockPart part = (MultiBlockPart)tileEntity;
                if (aRegistryID != part.getMultiTileEntityRegistryID() || aBlockMeta != part.getMultiTileEntityID()) {
                    return false;
                }
                IMultiBlockController tTarget = part.getTarget(false);
                if (tTarget != null && tTarget != MultiBlockController.this) {
                    return false;
                }
                part.setTarget(MultiBlockController.this, aModes);
                if (part instanceof AdvancedCasing) {
                    MultiBlockController.this.mUpgradeCasings.add((AdvancedCasing)part);
                }
                return true;
            }

            public boolean spawnHint(S t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.mIcons == null) {
                    this.mIcons = new IIcon[6];
                    Arrays.fill(this.mIcons, TextureSet.SET_NONE.mTextures[OrePrefixes.block.mTextureIndex].getIcon());
                }
                short[] RGBA = this.DEFAULT;
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.mIcons, (short[])RGBA);
                return true;
            }

            public boolean placeBlock(S t, World world, int x, int y, int z, ItemStack trigger) {
                MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aRegistryID);
                MultiTileEntityContainer tContainer = tRegistry.getNewTileEntityContainer(world, x, y, z, aBlockMeta, null);
                if (tContainer == null) {
                    GT_Mod.GT_FML_LOGGER.error("NULL CONTAINER");
                    return false;
                }
                IMultiTileEntity te = (IMultiTileEntity)tContainer.mTileEntity;
                if (!(te instanceof MultiBlockPart)) {
                    GT_Mod.GT_FML_LOGGER.error("Not a multiblock part");
                    return false;
                }
                if (world.func_147465_d(x, y, z, (Block)tContainer.mBlock, 15 - tContainer.mBlockMetaData, 2)) {
                    tContainer.setMultiTile(world, x, y, z);
                    ((MultiBlockPart)te).setTarget(MultiBlockController.this, aModes);
                    MultiBlockController.this.registerSpecialCasings((MultiBlockPart)te);
                }
                return false;
            }

            public IIcon getTexture(OrePrefixes aBlock) {
                return TextureSet.SET_NONE.mTextures[OrePrefixes.block.mTextureIndex].getIcon();
            }
        };
    }

    protected void registerSpecialCasings(MultiBlockPart aPart) {
        if (aPart instanceof AdvancedCasing) {
            this.mUpgradeCasings.add((AdvancedCasing)aPart);
        }
    }

    protected IFluidTank getFluidTankFillable(MultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable(aSide, aFluidToFill);
    }

    protected IFluidTank getFluidTankDrainable(MultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable(aSide, aFluidToDrain);
    }

    protected IFluidTank[] getFluidTanks(MultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks(aSide);
    }

    @Override
    public int fill(MultiBlockPart aPart, ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, (byte)aDirection.ordinal(), aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (rFilledAmount > 0 && aDoFill) {
            this.mInventoryChanged = true;
        }
        return rFilledAmount;
    }

    @Override
    public FluidStack drain(MultiBlockPart aPart, ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)aDirection.ordinal(), aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aFluid.amount, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.markInventoryBeenModified();
        }
        return rDrained;
    }

    @Override
    public FluidStack drain(MultiBlockPart aPart, ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)aDirection.ordinal(), null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aAmountToDrain, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.markInventoryBeenModified();
        }
        return rDrained;
    }

    @Override
    public boolean canFill(MultiBlockPart aPart, ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, (byte)aDirection.ordinal(), new FluidStack(aFluid, 0));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    @Override
    public boolean canDrain(MultiBlockPart aPart, ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)aDirection.ordinal(), new FluidStack(aFluid, 0));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    @Override
    public FluidTankInfo[] getTankInfo(MultiBlockPart aPart, ForgeDirection aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(aPart, (byte)aDirection.ordinal());
        if (tTanks == null || tTanks.length <= 0) {
            return GT_Values.emptyFluidTankInfo;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    @Override
    public IFluidTank[] getFluidTanksForGUI(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.FLUID_IN)) {
            return this.mTanksInput;
        }
        if (aPart.modeSelected(MultiBlockPart.FLUID_OUT)) {
            return this.mTanksOutput;
        }
        return GT_Values.emptyFluidTank;
    }

    @Override
    public boolean isUniversalEnergyStored(MultiBlockPart aPart, long aEnergyAmount) {
        return this.getUniversalEnergyStored(aPart) >= aEnergyAmount;
    }

    @Override
    public long getUniversalEnergyStored(MultiBlockPart aPart) {
        return Math.min(this.getUniversalEnergyStored(), this.getUniversalEnergyCapacity());
    }

    @Override
    public long getUniversalEnergyCapacity(MultiBlockPart aPart) {
        return this.getUniversalEnergyCapacity();
    }

    @Override
    public long getOutputAmperage(MultiBlockPart aPart) {
        return this.getOutputAmperage();
    }

    @Override
    public long getOutputVoltage(MultiBlockPart aPart) {
        return this.getOutputVoltage();
    }

    @Override
    public long getInputAmperage(MultiBlockPart aPart) {
        return this.getInputAmperage();
    }

    @Override
    public long getInputVoltage(MultiBlockPart aPart) {
        return this.getInputVoltage();
    }

    @Override
    public boolean decreaseStoredEnergyUnits(MultiBlockPart aPart, long aEnergy, boolean aIgnoreTooLittleEnergy) {
        return this.decreaseStoredEnergyUnits(aEnergy, aIgnoreTooLittleEnergy);
    }

    @Override
    public boolean increaseStoredEnergyUnits(MultiBlockPart aPart, long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return this.increaseStoredEnergyUnits(aEnergy, aIgnoreTooMuchEnergy);
    }

    @Override
    public boolean drainEnergyUnits(MultiBlockPart aPart, byte aSide, long aVoltage, long aAmperage) {
        return this.drainEnergyUnits(aSide, aVoltage, aAmperage);
    }

    @Override
    public long injectEnergyUnits(MultiBlockPart aPart, byte aSide, long aVoltage, long aAmperage) {
        return this.injectEnergyUnits(aSide, aVoltage, aAmperage);
    }

    @Override
    public long getAverageElectricInput(MultiBlockPart aPart) {
        return this.getAverageElectricInput();
    }

    @Override
    public long getAverageElectricOutput(MultiBlockPart aPart) {
        return this.getAverageElectricOutput();
    }

    @Override
    public long getStoredEU(MultiBlockPart aPart) {
        return this.getStoredEU();
    }

    @Override
    public long getEUCapacity(MultiBlockPart aPart) {
        return this.getEUCapacity();
    }

    @Override
    public boolean inputEnergyFrom(MultiBlockPart aPart, byte aSide) {
        if (aSide == 6) {
            return true;
        }
        if (aSide >= 0 && aSide < 6) {
            if (this.func_145837_r()) {
                return false;
            }
            if (this.isEnetInput()) {
                return this.isEnergyInputSide(aSide);
            }
        }
        return false;
    }

    @Override
    public boolean outputsEnergyTo(MultiBlockPart aPart, byte aSide) {
        if (aSide == 6) {
            return true;
        }
        if (aSide >= 0 && aSide < 6) {
            if (this.func_145837_r()) {
                return false;
            }
            if (this.isEnetOutput()) {
                return this.isEnergyOutputSide(aSide);
            }
        }
        return false;
    }

    @Override
    public void registerInventory(String aName, String aID, int aInventorySize, int aType) {
        if (aType == 0 || aType == 2) {
            if (this.multiBlockInputInventory.containsKey(aID)) {
                return;
            }
            this.multiBlockInputInventory.put(aID, (IItemHandlerModifiable)new ItemStackHandler(aInventorySize));
            this.multiBlockInputInventoryNames.put(aID, aName);
        }
        if (aType == 1 || aType == 2) {
            if (this.multiBlockOutputInventory.containsKey(aID)) {
                return;
            }
            this.multiBlockOutputInventory.put(aID, (IItemHandlerModifiable)new ItemStackHandler(aInventorySize));
            this.multiBlockOutputInventoryNames.put(aID, aName);
        }
    }

    @Override
    public void unregisterInventory(String aName, String aID, int aType) {
        if ((aType == 0 || aType == 2) && this.multiBlockInputInventory.containsKey(aID)) {
            this.multiBlockInputInventory.remove(aID, this.multiBlockInputInventory.get(aID));
            this.multiBlockInputInventoryNames.remove(aID, aName);
        }
        if ((aType == 1 || aType == 2) && this.multiBlockOutputInventory.containsKey(aID)) {
            this.multiBlockOutputInventory.remove(aID, this.multiBlockOutputInventory.get(aID));
            this.multiBlockOutputInventoryNames.remove(aID, aName);
        }
    }

    @Override
    public void changeInventoryName(String aName, String aID, int aType) {
        if ((aType == 0 || aType == 2) && this.multiBlockInputInventoryNames.containsKey(aID)) {
            this.multiBlockInputInventoryNames.put(aID, aName);
        }
        if ((aType == 1 || aType == 2) && this.multiBlockOutputInventoryNames.containsKey(aID)) {
            this.multiBlockOutputInventoryNames.put(aID, aName);
        }
    }

    @Override
    public boolean hasInventoryBeenModified(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            return this.hasInventoryBeenModified();
        }
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            return this.hasOutputInventoryBeenModified();
        }
        return false;
    }

    @Override
    public boolean isValidSlot(MultiBlockPart aPart, int aIndex) {
        return false;
    }

    @Override
    public IItemHandlerModifiable getInventoryForGUI(MultiBlockPart aPart) {
        Map<String, IItemHandlerModifiable> multiBlockInventory;
        if (this.isServerSide()) {
            for (AdvancedCasing tPart : this.mUpgradeCasings) {
                if (!(tPart instanceof InventoryUpgrade)) continue;
                tPart.issueClientUpdate();
            }
        }
        if ((multiBlockInventory = this.getMultiBlockInventory(aPart)) == null) {
            return null;
        }
        String lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == null) {
            return new ListItemHandler(multiBlockInventory.values());
        }
        IItemHandlerModifiable inv = multiBlockInventory.get(lockedInventory);
        return inv != null ? inv : null;
    }

    @Override
    public boolean addStackToSlot(MultiBlockPart aPart, int aIndex, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean addStackToSlot(MultiBlockPart aPart, int aIndex, ItemStack aStack, int aAmount) {
        return false;
    }

    protected Map<String, IItemHandlerModifiable> getMultiBlockInventory(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            return this.multiBlockInputInventory;
        }
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            return this.multiBlockOutputInventory;
        }
        return null;
    }

    protected Map<String, String> getMultiBlockInventoryNames(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            return this.multiBlockInputInventoryNames;
        }
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            return this.multiBlockOutputInventoryNames;
        }
        return null;
    }

    protected Pair<IItemHandlerModifiable, Integer> getInventory(MultiBlockPart aPart, int aSlot) {
        Map<String, IItemHandlerModifiable> multiBlockInventory = this.getMultiBlockInventory(aPart);
        if (multiBlockInventory == null) {
            return null;
        }
        String invName = aPart.getLockedInventory();
        if (invName != null && !invName.isEmpty()) {
            return new ImmutablePair((Object)multiBlockInventory.get(invName), (Object)aSlot);
        }
        int start = 0;
        for (IItemHandlerModifiable inv : multiBlockInventory.values()) {
            if (aSlot >= start && aSlot < start + inv.getSlots()) {
                return new ImmutablePair((Object)inv, (Object)(aSlot - start));
            }
            start += inv.getSlots();
        }
        return null;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(MultiBlockPart aPart, byte aSide) {
        TIntArrayList tList = new TIntArrayList();
        Map<String, IItemHandlerModifiable> multiBlockInventory = this.getMultiBlockInventory(aPart);
        if (multiBlockInventory == null) {
            return tList.toArray();
        }
        String lockedInventory = aPart.getLockedInventory();
        int start = 0;
        if (lockedInventory == null) {
            for (IItemHandlerModifiable inv : multiBlockInventory.values()) {
                for (int i = start; i < inv.getSlots() + start; ++i) {
                    tList.add(i);
                }
                start += inv.getSlots();
            }
        } else {
            IItemHandlerModifiable inv = multiBlockInventory.get(lockedInventory);
            int len = inv != null ? inv.getSlots() : 0;
            for (int i = 0; i < len; ++i) {
                tList.add(i);
            }
        }
        return tList.toArray();
    }

    @Override
    public boolean canInsertItem(MultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return false;
        }
        int tSlot = (Integer)tInv.getRight();
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        return inv.getStackInSlot(tSlot) == null || GT_Utility.areStacksEqual(aStack, inv.getStackInSlot(tSlot));
    }

    @Override
    public boolean canExtractItem(MultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return false;
        }
        int tSlot = (Integer)tInv.getRight();
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        return inv.getStackInSlot(tSlot) != null;
    }

    @Override
    public int getSizeInventory(MultiBlockPart aPart) {
        Map<String, IItemHandlerModifiable> multiBlockInventory = this.getMultiBlockInventory(aPart);
        if (multiBlockInventory == null) {
            return 0;
        }
        String lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == null) {
            int len = 0;
            for (IItemHandlerModifiable inv : multiBlockInventory.values()) {
                len += inv.getSlots();
            }
            return len;
        }
        IItemHandlerModifiable inv = multiBlockInventory.get(lockedInventory);
        return inv != null ? inv.getSlots() : 0;
    }

    @Override
    public ItemStack getStackInSlot(MultiBlockPart aPart, int aSlot) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return null;
        }
        int tSlot = (Integer)tInv.getRight();
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        if (inv == null) {
            return null;
        }
        return inv.getStackInSlot(tSlot);
    }

    @Override
    public ItemStack decrStackSize(MultiBlockPart aPart, int aSlot, int aDecrement) {
        ItemStack tStack = this.getStackInSlot(aPart, aSlot);
        ItemStack rStack = GT_Utility.copyOrNull(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= aDecrement) {
                this.setInventorySlotContents(aPart, aSlot, null);
            } else {
                rStack = tStack.func_77979_a(aDecrement);
                if (tStack.field_77994_a == 0) {
                    this.setInventorySlotContents(aPart, aSlot, null);
                }
            }
        }
        return rStack;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(MultiBlockPart aPart, int aSlot) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return null;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        int tSlot = (Integer)tInv.getRight();
        ItemStack rStack = inv.getStackInSlot(tSlot);
        inv.setStackInSlot(tSlot, null);
        return rStack;
    }

    @Override
    public void setInventorySlotContents(MultiBlockPart aPart, int aSlot, ItemStack aStack) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        int tSlot = (Integer)tInv.getRight();
        inv.setStackInSlot(tSlot, aStack);
    }

    @Override
    public List<String> getInventoryNames(MultiBlockPart aPart) {
        ArrayList<String> inventoryNames = new ArrayList<String>();
        inventoryNames.add("all");
        inventoryNames.add("controller");
        inventoryNames.addAll(this.getMultiBlockInventoryNames(aPart).values());
        return inventoryNames;
    }

    @Override
    public List<String> getInventoryIDs(MultiBlockPart aPart) {
        ArrayList<String> tInventoryIDs = new ArrayList<String>();
        tInventoryIDs.add("all");
        tInventoryIDs.addAll(this.getMultiBlockInventory(aPart).keySet());
        return tInventoryIDs;
    }

    @Override
    public String getInventoryName(MultiBlockPart aPart) {
        StringBuilder str = new StringBuilder();
        str.append(this.func_145825_b());
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            str.append(" Input");
        } else if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            str.append(" Output");
        } else {
            str.append(" Unknown");
        }
        String lockedInventory = aPart.getLockedInventory();
        if (lockedInventory != null && !lockedInventory.equals("")) {
            str.append(" [Locked: ").append(lockedInventory).append("]");
        }
        return str.toString();
    }

    @Override
    public boolean hasCustomInventoryName(MultiBlockPart aPart) {
        return this.func_145818_k_();
    }

    @Override
    public int getInventoryStackLimit(MultiBlockPart aPart) {
        return this.func_70297_j_();
    }

    @Override
    public void markDirty(MultiBlockPart aPart) {
        this.func_70296_d();
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            this.markOutputInventoryBeenModified();
        } else {
            this.markInventoryBeenModified();
        }
    }

    @Override
    public boolean isUseableByPlayer(MultiBlockPart aPart, EntityPlayer aPlayer) {
        return this.func_70300_a(aPlayer);
    }

    @Override
    public void openInventory(MultiBlockPart aPart) {
        this.func_70295_k_();
    }

    @Override
    public void closeInventory(MultiBlockPart aPart) {
        this.func_70305_f();
    }

    @Override
    public boolean isItemValidForSlot(MultiBlockPart aPart, int aSlot, ItemStack aStack) {
        return this.func_94041_b(aSlot, aStack);
    }

    protected ItemStack[] getAllItemInputs() {
        return this.getInventoriesForInput().getStacks().toArray(new ItemStack[0]);
    }

    protected Iterable<Pair<ItemStack[], String>> getItemInputsForEachInventory() {
        return this.multiBlockInputInventory.entrySet().stream().map(entry -> Pair.of((Object)((IItemHandlerModifiable)entry.getValue()).getStacks().toArray(new ItemStack[0]), entry.getKey())).collect(Collectors.toList());
    }

    protected void setItemOutputs(ItemStack[] aItemOutputs, String aInventory) {
        this.mItemsToOutput = aItemOutputs;
        this.mInventory = aInventory;
    }

    private void outputItems() {
        int index = 0;
        if (this.mItemsToOutput == null) {
            return;
        }
        if (this.mInventory != null) {
            for (ItemStack tItem : this.mItemsToOutput) {
                this.multiBlockOutputInventory.getOrDefault(this.mInventory, this.getInventoriesForOutput()).insertItem(index++, tItem.func_77946_l(), false);
            }
        } else {
            for (ItemStack tItem : this.mItemsToOutput) {
                this.getInventoriesForOutput().insertItem(index++, tItem.func_77946_l(), false);
            }
        }
        this.mItemsToOutput = null;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(UIBuildContext buildContext) {
        System.out.println("MultiBlockController::createWindow");
        return super.createWindow(buildContext);
    }

    @Override
    public boolean hasGui(byte aSide) {
        return true;
    }

    @Override
    protected void addTitleTextStyle(ModularWindow.Builder builder, String title) {
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(148, 60));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.isServerSide()) {
            for (AdvancedCasing tPart : this.mUpgradeCasings) {
                if (!(tPart instanceof InventoryUpgrade)) continue;
                tPart.issueClientUpdate();
            }
        }
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget((Widget)new TabContainer().setButtonSize(20, 24).addTabButton(new TabButton(0).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f)}).addTooltip(this.getLocalName()).setPos(0, -20)).addTabButton(new TabButton(1).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f)}).setPos(20, -20)).addTabButton(new TabButton(2).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f)}).setPos(40, -20)).addTabButton(new TabButton(3).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f)}).setPos(60, -20)).addTabButton(new TabButton(4).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f)}).setPos(80, -20)).addPage((Widget)new MultiChildWidget().addChild(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 4).setSize(160, 75))).addPage((Widget)new MultiChildWidget().addChild(this.getItemInventoryInputGUI())).addPage((Widget)new MultiChildWidget().addChild(this.getItemInventoryOutputGUI())).addPage((Widget)new MultiChildWidget().addChild(this.getFluidInventoryInputGUI())).addPage((Widget)new MultiChildWidget().addChild(this.getFluidInventoryOutputGUI())))).widget(new ItemDrawable(this.getStackForm(1L)).asWidget().setSize(16, 16).setPos(2, -16))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_ITEM_IN).setSize(16, 16).setPos(22, -16))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_ITEM_OUT).setSize(16, 16).setPos(42, -16))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_FLUID_IN).setSize(16, 16).setPos(62, -16))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_FLUID_OUT).setSize(16, 16).setPos(82, -16));
    }

    protected Widget getItemInventoryInputGUI() {
        IItemHandlerModifiable inv = this.getInventoriesForInput();
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < Math.min(inv.getSlots(), 128)) {
            int columnsToMake = Math.min(Math.min(inv.getSlots(), 128) - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget(inv, rows * 4 + column).setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 72).setPos(52, 7);
    }

    protected Widget getItemInventoryOutputGUI() {
        IItemHandlerModifiable inv = this.getInventoriesForOutput();
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < Math.min(inv.getSlots(), 128)) {
            int columnsToMake = Math.min(Math.min(inv.getSlots(), 128) - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget(inv, rows * 4 + column).setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 72).setPos(52, 7);
    }

    protected IItemHandlerModifiable getInventoriesForInput() {
        return new ListItemHandler(this.multiBlockInputInventory.values());
    }

    protected IItemHandlerModifiable getInventoriesForOutput() {
        return new ListItemHandler(this.multiBlockOutputInventory.values());
    }

    protected Widget getFluidInventoryInputGUI() {
        FluidTankGT[] tanks = this.mTanksInput;
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < tanks.length) {
            int columnsToMake = Math.min(tanks.length - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                FluidSlotWidget fluidSlot = new FluidSlotWidget((IFluidTank)tanks[rows * 4 + column]);
                scrollable.widget(fluidSlot.setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 72).setPos(52, 7);
    }

    protected Widget getFluidInventoryOutputGUI() {
        FluidTankGT[] tanks = this.mTanksOutput;
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < tanks.length) {
            int columnsToMake = Math.min(tanks.length - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                FluidSlotWidget fluidSlot = new FluidSlotWidget((IFluidTank)tanks[rows * 4 + column]);
                fluidSlot.setInteraction(true, false);
                scrollable.widget(fluidSlot.setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 72).setPos(52, 7);
    }

    public static class BuildState {
        boolean building = false;
        Vec3Impl currentOffset;

        public void startBuilding(Vec3Impl structureOffset) {
            if (this.building) {
                throw new IllegalStateException("Already building!");
            }
            this.building = true;
            this.setCurrentOffset(structureOffset);
        }

        public Vec3Impl setCurrentOffset(Vec3Impl structureOffset) {
            this.verifyBuilding();
            this.currentOffset = structureOffset;
            return this.currentOffset;
        }

        private void verifyBuilding() {
            if (!this.building) {
                throw new IllegalStateException("Not building!");
            }
        }

        public boolean failBuilding() {
            this.building = false;
            this.currentOffset = null;
            return false;
        }

        public Vec3Impl stopBuilding() {
            Vec3Impl toReturn = this.getCurrentOffset();
            this.building = false;
            this.currentOffset = null;
            return toReturn;
        }

        public Vec3Impl getCurrentOffset() {
            this.verifyBuilding();
            return this.currentOffset;
        }

        public Vec3Impl addOffset(Vec3Impl offset) {
            this.verifyBuilding();
            return this.setCurrentOffset(this.currentOffset.add(offset));
        }
    }
}

