/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiTabLine;
import gregtech.api.gui.widgets.GT_GuiTooltip;
import gregtech.api.interfaces.IGuiIcon;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GT_GuiTab {
    private static final int SLOT_SIZE = 18;
    public boolean visible = true;
    public boolean mousedOver;
    public boolean enabled = true;
    private Rectangle bounds;
    private GT_GuiTabLine.GT_GuiTabIconSet tabBackground;
    private ItemStack item;
    private GT_GuiTabLine.GT_ITabRenderer gui;
    private GT_GuiTooltip tooltip;
    private IGuiIcon overlay;
    private boolean flipHorizontally;

    public GT_GuiTab(GT_GuiTabLine.GT_ITabRenderer gui, int id, Rectangle bounds, GT_GuiTabLine.GT_GuiTabIconSet tabBackground, ItemStack item, IGuiIcon overlay, String[] tooltipText, boolean flipHorizontally) {
        this.gui = gui;
        this.bounds = bounds;
        this.item = item;
        this.tabBackground = tabBackground;
        this.overlay = overlay;
        if (tooltipText != null) {
            this.setTooltipText(tooltipText);
        }
        this.flipHorizontally = flipHorizontally;
    }

    public GT_GuiTab(GT_GuiTabLine.GT_ITabRenderer gui, int id, Rectangle bounds, GT_GuiTabLine.GT_GuiTabIconSet tabBackground) {
        this(gui, id, bounds, tabBackground, null, null, null, false);
    }

    public GT_GuiTab setTooltipText(String ... text) {
        if (this.tooltip == null) {
            this.tooltip = new GT_GuiTooltip(this.bounds, text);
            this.gui.addToolTip(this.tooltip);
        } else {
            this.tooltip.setToolTipText(text);
        }
        return this;
    }

    public GT_GuiTooltip getTooltip() {
        return this.tooltip;
    }

    public void drawBackground(int mouseX, int mouseY, float parTicks) {
        if (this.visible) {
            GT_GuiIcon.render(this.getBackgroundTexture(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 1.0, true, this.flipHorizontally);
        }
    }

    public void drawOverlays(int mouseX, int mouseY, float parTicks) {
        this.mousedOver = this.bounds.contains(mouseX, mouseY);
        if (this.tooltip != null) {
            this.tooltip.enabled = this.visible;
        }
        if (this.visible) {
            if (this.overlay != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GT_GuiIcon.render(this.overlay, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 1.0, true);
            }
            if (this.item != null) {
                GL11.glPushAttrib((int)8192);
                if (this.item.func_77973_b() instanceof ItemBlock) {
                    GL11.glPushAttrib((int)8192);
                    GL11.glEnable((int)32826);
                }
                int margin = this.bounds.height - 18;
                this.gui.getItemRenderer().func_82406_b(this.gui.getFontRenderer(), Minecraft.func_71410_x().func_110434_K(), this.item, this.bounds.x + (this.flipHorizontally ? 0 : margin), this.bounds.y + margin);
                if (this.item.func_77973_b() instanceof ItemBlock) {
                    GL11.glPopAttrib();
                }
                GL11.glPopAttrib();
            }
        }
    }

    protected IGuiIcon getBackgroundTexture() {
        if (!this.enabled) {
            return this.tabBackground.disabled;
        }
        return this.mousedOver ? this.tabBackground.highlight : this.tabBackground.normal;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setPosition(int xPos, int yPos) {
        this.bounds = new Rectangle(xPos, yPos, this.bounds.width, this.bounds.height);
    }
}

