/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ProcessingArray_Manager;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class GT_MetaTileEntity_ProcessingArray
extends GT_MetaTileEntity_MultiBlockBase {
    private GT_Recipe mLastRecipe;
    private int tTier = 0;
    private int mMult = 0;
    private boolean mSeparate = false;
    private String mMachine = "";

    public GT_MetaTileEntity_ProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ProcessingArray(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ProcessingArray(this.mName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Processing Array").addInfo("Runs supplied machines as if placed in the world").addInfo("Place up to 64 singleblock GT machines into the controller").addInfo("Note that tou still need to supply power to them all").addInfo("Use a screwdriver to enable separate input busses").addInfo("Maximal overclockedness of machines inside: Tier 9").addInfo("Doesn't work on certain machines, deal with it").addInfo("Use it if you hate GT++, or want even more speed later on").addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Robust Tungstensteel Machine Casing", 14).addEnergyHatch("Any casing").addMaintenanceHatch("Any casing").addInputBus("Any casing").addInputHatch("Any casing").addOutputBus("Any casing").addOutputHatch("Any casing").toolTipFinisher("Gregtech");
        if (Keyboard.isKeyDown((int)42)) {
            return tt.getStructureInformation();
        }
        return tt.getInformation();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "ProcessingArray.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.isCorrectMachinePart(this.mInventory[1])) {
            return GT_ProcessingArray_Manager.getRecipeMapForMeta(this.mInventory[1].func_77960_j());
        }
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77977_a().startsWith("gt.blockmachines.basicmachine.");
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!this.isCorrectMachinePart(this.mInventory[1])) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map map = this.getRecipeMap();
        if (map == null) {
            return false;
        }
        if (!this.mMachine.equals(this.mInventory[1].func_77977_a())) {
            this.mLastRecipe = null;
            this.mMachine = this.mInventory[1].func_77977_a();
        }
        int machineTier = 0;
        if (this.mLastRecipe == null) {
            try {
                int length = this.mMachine.length();
                machineTier = Integer.parseInt(this.mMachine.substring(length - 2));
            }
            catch (NumberFormatException length) {
                // empty catch block
            }
            switch (machineTier) {
                default: {
                    this.tTier = 0;
                    this.mMult = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.tTier = machineTier;
                    this.mMult = 0;
                    break;
                }
                case 10: {
                    this.tTier = 9;
                    this.mMult = 2;
                    break;
                }
                case 11: {
                    this.tTier = 9;
                    this.mMult = 4;
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.tTier = 9;
                    this.mMult = 6;
                }
            }
        }
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (this.mSeparate) {
            ArrayList<ItemStack> tInputList = new ArrayList<ItemStack>();
            for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
                IGregTechTileEntity tInputBus = tHatch.getBaseMetaTileEntity();
                for (int i = tInputBus.func_70302_i_() - 1; i >= 0; --i) {
                    if (tInputBus.func_70301_a(i) == null) continue;
                    tInputList.add(tInputBus.func_70301_a(i));
                }
                ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
                if (this.processRecipe(tInputs, tFluids, map)) {
                    return true;
                }
                tInputList.clear();
            }
        } else {
            ArrayList<ItemStack> tInputList = this.getStoredInputs();
            ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
            return this.processRecipe(tInputs, tFluids, map);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processRecipe(ItemStack[] tInputs, FluidStack[] tFluids, GT_Recipe.GT_Recipe_Map map) {
        void var13_19;
        int i;
        if (tInputs.length <= 0 && tFluids.length <= 0) {
            return false;
        }
        GT_Recipe tRecipe = map.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[this.tTier], tFluids, tInputs);
        if (tRecipe == null) {
            return false;
        }
        if (GT_Mod.gregtechproxy.mLowGravProcessing && tRecipe.mSpecialValue == -100 && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(tRecipe, this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
            return false;
        }
        this.mLastRecipe = tRecipe;
        this.mEUt = 0;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        int machines = Math.min(64, this.mInventory[1].field_77994_a << this.mMult);
        for (i = 0; i < machines; ++i) {
            if (tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) continue;
            if (i != 0) break;
            return false;
        }
        this.mMaxProgresstime = tRecipe.mDuration;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, map.mAmperage, GT_Values.V[this.tTier]);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        this.mEUt = GT_Utility.safeInt((long)this.mEUt * (long)i >> this.mMult, 1);
        if (this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        Object[] tOut = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOut[h] = tRecipe.getOutput(h).func_77946_l();
            tOut[h].field_77994_a = 0;
        }
        FluidStack tFOut = null;
        if (tRecipe.getFluidOutput(0) != null) {
            tFOut = tRecipe.getFluidOutput(0).copy();
        }
        for (int f = 0; f < tOut.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOut[f] == null) continue;
            for (int g = 0; g < i; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= tRecipe.getOutputChance(f)) continue;
                tOut[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        if (tFOut != null) {
            int tSize = tFOut.amount;
            tFOut.amount = tSize * i;
        }
        tOut = GT_MetaTileEntity_ProcessingArray.clean((ItemStack[])tOut);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        ArrayList<ItemStack> overStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOut) {
            while (itemStack != null && itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                overStacks.add(tmp);
            }
        }
        if (!overStacks.isEmpty()) {
            Object[] tmp = new ItemStack[overStacks.size()];
            tmp = overStacks.toArray(tmp);
            tOut = (ItemStack[])ArrayUtils.addAll((Object[])tOut, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOut;
        int n = objectArray.length;
        boolean bl = false;
        while (var13_19 < n) {
            Object tS = objectArray[var13_19];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var13_19;
        }
        tOut = tSList.toArray(new ItemStack[0]);
        this.mOutputItems = tOut;
        this.mOutputFluids = new FluidStack[]{tFOut};
        this.updateSlots();
        return true;
    }

    public static ItemStack[] clean(ItemStack[] v) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(Arrays.asList(v));
        list.removeAll(Collections.singleton(null));
        return list.toArray(new ItemStack[0]);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 0, zDir)) {
            return false;
        }
        int tAmount = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int h = -1; h < 2; ++h) {
                    IGregTechTileEntity tTileEntity;
                    if (h == 0 && (xDir + i == 0 && zDir + j == 0 || i == 0 && j == 0) || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j), 48) || this.addInputToMachineList(tTileEntity, 48) || this.addOutputToMachineList(tTileEntity, 48) || this.addEnergyInputToMachineList(tTileEntity, 48)) continue;
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != GregTech_API.sBlockCasings4) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) != 0) {
                        return false;
                    }
                    ++tAmount;
                }
            }
        }
        return tAmount >= 14;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mSeparate", this.mSeparate);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSeparate = aNBT.func_74767_n("mSeparate");
    }

    @Override
    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mSeparate = !this.mSeparate;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.mSeparate);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_ProcessingArray.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + this.mProgresstime / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + storedEnergy + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + -this.mEUt + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + this.getMaxInputVoltage() + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.PA.machinetier") + ": " + EnumChatFormatting.GREEN + this.tTier + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.PA.discount") + ": " + EnumChatFormatting.GREEN + (1 << this.mMult) + EnumChatFormatting.RESET + " x", StatCollector.func_74838_a((String)"GT5U.PA.parallel") + ": " + EnumChatFormatting.GREEN + (this.mInventory[1] != null ? this.mInventory[1].field_77994_a << this.mMult : 0) + EnumChatFormatting.RESET};
    }
}

