/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.ITextureBuilder;
import gregtech.common.render.GT_CopiedBlockTexture;
import gregtech.common.render.GT_MultiTexture;
import gregtech.common.render.GT_RenderedGlowTexture;
import gregtech.common.render.GT_RenderedTexture;
import gregtech.common.render.GT_SidedTexture;
import gregtech.common.render.GT_StdRenderedTexture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_TextureBuilder
implements ITextureBuilder {
    private final List<IIconContainer> iconContainerList;
    private final List<ITexture> textureLayers = new ArrayList<ITexture>();
    private Block fromBlock;
    private int fromMeta;
    private ForgeDirection fromSide;
    private short[] rgba;
    private boolean allowAlpha;
    private boolean stdOrient;
    private boolean glow;

    public GT_TextureBuilder() {
        this.iconContainerList = new ArrayList<IIconContainer>();
        this.rgba = Dyes._NULL.mRGBa;
        this.allowAlpha = true;
        this.stdOrient = false;
        this.glow = false;
    }

    @Override
    public ITextureBuilder setFromBlock(Block block, int meta) {
        this.fromBlock = block;
        this.fromMeta = meta;
        this.fromSide = ForgeDirection.UNKNOWN;
        return this;
    }

    @Override
    public ITextureBuilder setFromSide(ForgeDirection side) {
        this.fromSide = side;
        return this;
    }

    @Override
    public ITextureBuilder addIcon(IIconContainer ... iconContainers) {
        this.iconContainerList.addAll(Arrays.asList(iconContainers));
        return this;
    }

    @Override
    public ITextureBuilder setRGBA(short[] rgba) {
        this.rgba = rgba;
        return this;
    }

    @Override
    public ITextureBuilder addLayer(ITexture ... iTextures) {
        this.textureLayers.addAll(Arrays.asList(iTextures));
        return this;
    }

    @Override
    public ITextureBuilder setAllowAlpha(boolean allowAlpha) {
        this.allowAlpha = allowAlpha;
        return this;
    }

    @Override
    public ITextureBuilder stdOrient() {
        this.stdOrient = true;
        return this;
    }

    @Override
    public ITextureBuilder glow() {
        this.glow = true;
        return this;
    }

    @Override
    public ITexture build() {
        if (this.fromBlock != null) {
            return new GT_CopiedBlockTexture(this.fromBlock, this.fromSide.ordinal(), this.fromMeta, this.rgba, this.allowAlpha);
        }
        if (!this.textureLayers.isEmpty()) {
            return new GT_MultiTexture(this.textureLayers.toArray(new ITexture[0]));
        }
        switch (this.iconContainerList.size()) {
            case 1: {
                if (this.stdOrient) {
                    return new GT_StdRenderedTexture(this.iconContainerList.get(0), this.rgba, this.allowAlpha);
                }
                if (this.glow) {
                    return new GT_RenderedGlowTexture(this.iconContainerList.get(0), this.rgba, this.allowAlpha);
                }
                return new GT_RenderedTexture(this.iconContainerList.get(0), this.rgba, this.allowAlpha);
            }
            case 6: {
                return new GT_SidedTexture(this.iconContainerList.get(ForgeDirection.DOWN.ordinal()), this.iconContainerList.get(ForgeDirection.UP.ordinal()), this.iconContainerList.get(ForgeDirection.NORTH.ordinal()), this.iconContainerList.get(ForgeDirection.SOUTH.ordinal()), this.iconContainerList.get(ForgeDirection.WEST.ordinal()), this.iconContainerList.get(ForgeDirection.EAST.ordinal()), this.rgba, this.allowAlpha);
            }
        }
        throw new IllegalStateException("Invalid sideIconContainer count");
    }
}

