/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicBatteryBuffer;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_EUMeter
extends GT_CoverBehavior {
    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        long tScale = 0L;
        if (aCoverVariable < 2) {
            tScale = aTileEntity.getUniversalEnergyCapacity() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getUniversalEnergyStored() / tScale) : (byte)(15L - aTileEntity.getUniversalEnergyStored() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 4) {
            tScale = aTileEntity.getEUCapacity() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getStoredEU() / tScale) : (byte)(15L - aTileEntity.getStoredEU() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 6) {
            tScale = aTileEntity.getSteamCapacity() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getStoredSteam() / tScale) : (byte)(15L - aTileEntity.getStoredSteam() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 8) {
            tScale = aTileEntity.getInputVoltage() * aTileEntity.getInputAmperage() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getAverageElectricInput() / tScale) : (byte)(15L - aTileEntity.getAverageElectricInput() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 10) {
            tScale = aTileEntity.getOutputVoltage() * aTileEntity.getOutputAmperage() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getAverageElectricOutput() / tScale) : (byte)(15L - aTileEntity.getAverageElectricOutput() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 12) {
            IGregTechTileEntity tTileEntity;
            IMetaTileEntity mTileEntity;
            tScale = aTileEntity.getEUCapacity();
            long tStored = aTileEntity.getStoredEU();
            if (aTileEntity instanceof IGregTechTileEntity && (mTileEntity = (tTileEntity = (IGregTechTileEntity)aTileEntity).getMetaTileEntity()) instanceof GT_MetaTileEntity_BasicBatteryBuffer) {
                GT_MetaTileEntity_BasicBatteryBuffer buffer = (GT_MetaTileEntity_BasicBatteryBuffer)mTileEntity;
                if (buffer.mInventory != null) {
                    for (ItemStack aStack : buffer.mInventory) {
                        if (!GT_ModHandler.isElectricItem(aStack)) continue;
                        if (aStack.func_77973_b() instanceof GT_MetaBase_Item) {
                            Long[] stats = ((GT_MetaBase_Item)aStack.func_77973_b()).getElectricStats(aStack);
                            if (stats == null) continue;
                            tScale += stats[0].longValue();
                            tStored += ((GT_MetaBase_Item)aStack.func_77973_b()).getRealCharge(aStack);
                            continue;
                        }
                        if (!(aStack.func_77973_b() instanceof IElectricItem)) continue;
                        tStored += (long)ElectricItem.manager.getCharge(aStack);
                        tScale += (long)((IElectricItem)aStack.func_77973_b()).getMaxCharge(aStack);
                    }
                }
            }
            if ((tScale /= 15L) > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(tStored / tScale) : (byte)(15L - tStored / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 12) < 0) {
            aCoverVariable = 11;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("031", "Normal Universal Storage"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("032", "Inverted Universal Storage"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("033", "Normal Electricity Storage"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("034", "Inverted Electricity Storage"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("035", "Normal Steam Storage"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("036", "Inverted Steam Storage"));
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("037", "Normal Average Electric Input"));
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("038", "Inverted Average Electric Input"));
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("039", "Normal Average Electric Output"));
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("040", "Inverted Average Electric Output"));
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("041", "Normal Electricity Storage(Including Batteries)"));
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("042", "Inverted Electricity Storage(Including Batteries)"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconCheckButton(this, 0, 10, 43, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_EUMeter.this.trans("256", "Universal Storage"));
            b = new GT_GuiIconCheckButton(this, 1, 10, 25, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_EUMeter.this.trans("257", "Electricity Storage"));
            b = new GT_GuiIconCheckButton(this, 2, 10, 61, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_EUMeter.this.trans("258", "Steam Storage"));
            b = new GT_GuiIconCheckButton(this, 3, 82, 43, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_EUMeter.this.trans("259", "Average Electric Input"));
            b = new GT_GuiIconCheckButton(this, 4, 82, 61, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_EUMeter.this.trans("260", "Average Electric Output"));
            b = new GT_GuiIconCheckButton(this, 5, 82, 25, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_EUMeter.this.trans("261", "Electricity Storage(Including Batteries)"));
            b = new GT_GuiIconCheckButton(this, 6, 10, 83, GT_GuiIcon.REDSTONE_ON, GT_GuiIcon.REDSTONE_OFF);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            String s2 = (this.coverVariable & 1) > 0 ? GT_Cover_EUMeter.this.trans("INVERTED", "Inverted") : GT_Cover_EUMeter.this.trans("NORMAL", "Normal");
            this.field_146289_q.func_78276_b(s2, 28, 87, -11184811);
            this.field_146289_q.func_78276_b("Universal", 28, 47, -11184811);
            this.field_146289_q.func_78276_b("Int. EU", 28, 29, -11184811);
            this.field_146289_q.func_78276_b("Steam", 28, 65, -11184811);
            this.field_146289_q.func_78276_b("Avg. Input", 100, 47, -11184811);
            this.field_146289_q.func_78276_b("Avg. Output", 100, 65, -11184811);
            this.field_146289_q.func_78276_b("EU stored", 100, 29, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (btn.field_146127_k == 6 || !this.isEnabled(btn.field_146127_k)) {
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k, ((GT_GuiIconCheckButton)btn).isChecked());
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                ((GT_GuiIconCheckButton)o).setChecked(this.isEnabled(((GT_GuiIconCheckButton)o).field_146127_k));
            }
        }

        private int getNewCoverVariable(int id, boolean checked) {
            if (id == 6) {
                if (checked) {
                    return this.coverVariable & 0xFFFFFFFE;
                }
                return this.coverVariable | 1;
            }
            return this.coverVariable & 1 | id << 1;
        }

        private boolean isEnabled(int id) {
            if (id == 6) {
                return (this.coverVariable & 1) > 0;
            }
            return this.coverVariable >> 1 == id;
        }
    }
}

